/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.bo.KcPersonExtendedAttributes;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.PersonEditableInterface;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.logging.BufferedLogger;
import org.kuali.kra.logging.FormattedLogger;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonComparator;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonDegree;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonExtendedAttributes;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonUnit;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.hierarchy.service.ProposalHierarchyService;
import org.kuali.kra.proposaldevelopment.printing.service.ProposalDevelopmentPrintingService;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonQuestionnaireHelper;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonQuestionnaireHelperComparator;
import org.kuali.kra.proposaldevelopment.rule.event.AddKeyPersonEvent;
import org.kuali.kra.proposaldevelopment.rule.event.CalculateCreditSplitEvent;
import org.kuali.kra.proposaldevelopment.rule.event.ChangeKeyPersonEvent;
import org.kuali.kra.proposaldevelopment.rule.event.SaveKeyPersonEvent;
import org.kuali.kra.proposaldevelopment.service.ProposalPersonService;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentAction;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentKeyPersonnelAction;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.questionnaire.print.QuestionnairePrintingService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentKeyPersonnelAction
extends ProposalDevelopmentAction {
    private static final String MISSING_PARAM_MSG = "Couldn't find parameter '%s'";
    private static final String ROLE_CHANGED_MSG = "roleChanged for person %s = %s";
    private static final String ADDED_PERSON_MSG = "Added Proposal Person with proposalNumber = %s and proposalPersonNumber = %s";
    private static final String INV_SIZE_MSG = "Number of investigators are ";
    private static final String EMPTY_STRING = "";
    private static final String ROLODEX_PERSON = "Unknown";
    private static final String ERROR_REMOVE_HIERARCHY_PI = "error.hierarchy.personnel.removePrincipleInvestigator";
    private static final String ERROR_FIELD_REMOVE_HIERARCHY_PI = "document.developmentProposalList[0].proposalPersons[%s].delete";

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward retval = super.execute(mapping, form, request, response);
        this.prepare(form, request);
        List keyPersonnel = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons();
        return retval;
    }

    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new SaveKeyPersonEvent(EMPTY_STRING, pdform.getProposalDevelopmentDocument()));
        if (rulePassed) {
            super.preSave(mapping, form, request, response);
        }
    }

    public ActionForward moveDown(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List keyPersonnel = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons();
        this.swapAdjacentPersonnel(keyPersonnel, this.getLineToDelete(request), MoveOperationEnum.MOVING_PERSON_DOWN);
        return mapping.findForward("basic");
    }

    public ActionForward moveUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        List keyPersonnel = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons();
        this.swapAdjacentPersonnel(keyPersonnel, this.getLineToDelete(request), MoveOperationEnum.MOVING_PERSON_UP);
        return mapping.findForward("basic");
    }

    void prepare(ActionForm form, HttpServletRequest request) {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        request.setAttribute("newPersonLookupFlag", (Object)EMPTY_STRING);
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        List proposalpersons = document.getDevelopmentProposal().getProposalPersons();
        for (ProposalPerson person : proposalpersons) {
            if (person.getRole() == null) continue;
            person.getRole().setReadOnly(Boolean.valueOf(this.getKeyPersonnelService().isRoleReadOnly(person.getRole())));
        }
        for (ProposalPersonQuestionnaireHelper helper : pdform.getProposalPersonQuestionnaireHelpers()) {
            for (int i = 0; i < helper.getAnswerHeaders().size(); ++i) {
                helper.updateChildIndicator(i);
            }
        }
        pdform.populatePersonEditableFields();
        this.handleRoleChangeEvents(pdform.getProposalDevelopmentDocument());
        FormattedLogger.debug((String)INV_SIZE_MSG, (Object[])new Object[]{pdform.getProposalDevelopmentDocument().getDevelopmentProposal().getInvestigators().size()});
        try {
            boolean creditSplitEnabled = this.getParameterService().getParameterValueAsBoolean(ProposalDevelopmentDocument.class, "proposaldevelopment.creditsplit.enabled") != false && pdform.getProposalDevelopmentDocument().getDevelopmentProposal().getInvestigators().size() > 0;
            request.setAttribute("creditSplitEnabledFlag", (Object)new Boolean(creditSplitEnabled));
            pdform.setCreditSplitEnabled(creditSplitEnabled);
        }
        catch (Exception e) {
            FormattedLogger.warn((String)MISSING_PARAM_MSG, (Object[])new Object[]{"proposaldevelopment.creditsplit.enabled"});
            FormattedLogger.warn((String)e.getMessage(), (Object[])new Object[0]);
        }
        List keyPersonnel = ((ProposalDevelopmentForm)form).getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons();
    }

    private void handleRoleChangeEvents(ProposalDevelopmentDocument document) {
        int index = 0;
        for (ProposalPerson person : document.getDevelopmentProposal().getProposalPersons()) {
            FormattedLogger.debug((String)ROLE_CHANGED_MSG, (Object[])new Object[]{person.getFullName(), person.isRoleChanged()});
            if (person.isRoleChanged()) {
                if (document.getDevelopmentProposal().isParent()) {
                    GlobalVariables.getMessageMap().putError(String.format(ERROR_FIELD_REMOVE_HIERARCHY_PI, index), "error.hierarchy.unexpected", new String[]{"Personnel Roles cannot be changed in a Hierarchy Parent Proposal"});
                } else {
                    this.changeRole(person, document);
                }
            }
            ++index;
        }
    }

    private void changeRole(ProposalPerson person, ProposalDevelopmentDocument document) {
        this.getKeyPersonnelService().populateProposalPerson(person, document);
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalPerson person = null;
        if (!StringUtils.isBlank((String)pdform.getNewRolodexId())) {
            person = new ProposalPerson();
            person.setRolodexId(Integer.valueOf(Integer.parseInt(pdform.getNewRolodexId())));
            this.getPersonEditableService().populateContactFieldsFromRolodexId((PersonEditableInterface)person);
        } else if (!StringUtils.isBlank((String)pdform.getNewPersonId())) {
            person = new ProposalPerson();
            person.setPersonId(pdform.getNewPersonId());
            this.getPersonEditableService().populateContactFieldsFromPersonId((PersonEditableInterface)person);
        }
        if (person != null) {
            person.setProposalNumber(pdform.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalNumber());
            person.setProposalPersonRoleId(pdform.getNewProposalPerson().getProposalPersonRoleId());
            pdform.setNewProposalPerson(person);
            request.setAttribute("newPersonLookupFlag", (Object)new Boolean(true));
        }
        return mapping.findForward("basic");
    }

    protected KualiRuleService getKualiRuleService() {
        return (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
    }

    public ActionForward insertProposalPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean rulePassed;
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        GlobalVariables.getMessageMap().removeFromErrorPath("document.proposalPersons");
        if (StringUtils.isNotBlank((String)pdform.getNewProposalPerson().getProposalPersonRoleId())) {
            if (pdform.getNewProposalPerson().getProposalPersonRoleId().equals("PI") || pdform.getNewProposalPerson().equals((Object)"COI")) {
                pdform.getNewProposalPerson().setOptInUnitStatus("Y");
                pdform.getNewProposalPerson().setOptInCertificationStatus("Y");
                pdform.setOptInCertificationStatus("Y");
            } else {
                pdform.getNewProposalPerson().setOptInUnitStatus("N");
                pdform.getNewProposalPerson().setOptInCertificationStatus("N");
                pdform.setOptInCertificationStatus("N");
            }
        }
        if (rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddKeyPersonEvent(pdform.getProposalDevelopmentDocument(), pdform.getNewProposalPerson()))) {
            ProposalPersonExtendedAttributes proposalPersonExtendedAttributes;
            ProposalPerson proposalPerson = pdform.getNewProposalPerson();
            HashMap<String, String> keys = new HashMap<String, String>();
            keys.put("personId", proposalPerson.getPersonId());
            KcPersonExtendedAttributes kcPersonExtendedAttributes = (KcPersonExtendedAttributes)this.getBusinessObjectService().findByPrimaryKey(KcPersonExtendedAttributes.class, keys);
            if (kcPersonExtendedAttributes != null) {
                proposalPersonExtendedAttributes = new ProposalPersonExtendedAttributes(proposalPerson, kcPersonExtendedAttributes);
                proposalPerson.setProposalPersonExtendedAttributes(proposalPersonExtendedAttributes);
            } else {
                proposalPersonExtendedAttributes = new ProposalPersonExtendedAttributes(proposalPerson);
                proposalPerson.setProposalPersonExtendedAttributes(proposalPersonExtendedAttributes);
            }
            document.getDevelopmentProposal().addProposalPerson(proposalPerson);
            BufferedLogger.info((Object[])new Object[]{ADDED_PERSON_MSG, pdform.getNewProposalPerson().getProposalNumber(), proposalPerson.getProposalPersonNumber()});
            if (this.getKeyPersonnelService().isPrincipalInvestigator(pdform.getNewProposalPerson())) {
                this.getKeyPersonnelService().assignLeadUnit(proposalPerson, document.getDevelopmentProposal().getOwnedByUnitNumber());
            } else {
                ProposalPersonUnit unit = proposalPerson.getUnit(document.getDevelopmentProposal().getOwnedByUnitNumber());
                if (unit != null) {
                    unit.setLeadUnit(false);
                }
            }
            if (proposalPerson.getHomeUnit() != null) {
                ProposalPersonService proposalPersonService = (ProposalPersonService)KraServiceLocator.getService(ProposalPersonService.class);
                String divisionName = proposalPersonService.getProposalPersonDivisionName(proposalPerson);
                proposalPerson.setDivision(divisionName);
            } else {
                proposalPerson.setDivision(ROLODEX_PERSON);
            }
            if ((proposalPerson.getProposalPersonRoleId().equals("PI") || proposalPerson.getProposalPersonRoleId().equals("COI")) && StringUtils.isNotBlank((String)proposalPerson.getHomeUnit()) && this.isValidHomeUnit(proposalPerson, pdform.getNewProposalPerson().getHomeUnit())) {
                this.getKeyPersonnelService().addUnitToPerson(proposalPerson, this.getKeyPersonnelService().createProposalPersonUnit(proposalPerson.getHomeUnit(), proposalPerson));
            }
            this.getKeyPersonnelService().populateProposalPerson(proposalPerson, document);
            Collections.sort(document.getDevelopmentProposal().getProposalPersons(), new ProposalPersonComparator());
            Collections.sort(document.getDevelopmentProposal().getInvestigators(), new ProposalPersonComparator());
            ProposalPersonQuestionnaireHelper helper = new ProposalPersonQuestionnaireHelper(pdform, proposalPerson);
            pdform.getProposalPersonQuestionnaireHelpers().add(helper);
            Collections.sort(pdform.getProposalPersonQuestionnaireHelpers(), new ProposalPersonQuestionnaireHelperComparator());
            pdform.setNewProposalPerson(new ProposalPerson());
            pdform.setNewRolodexId(EMPTY_STRING);
            pdform.setNewPersonId(EMPTY_STRING);
            List answerHeaders = this.getQuestionnaireAnswerService().getQuestionnaireAnswer(helper.getModuleQnBean());
            helper.setAnswerHeaders(answerHeaders);
        }
        return mapping.findForward("basic");
    }

    protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return (QuestionnaireAnswerService)KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }

    public ActionForward clearProposalPerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        pdform.setNewProposalPerson(new ProposalPerson());
        pdform.setNewRolodexId(EMPTY_STRING);
        pdform.setNewPersonId(EMPTY_STRING);
        return mapping.findForward("basic");
    }

    public ActionForward insertDegree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, document);
        ProposalPerson person = document.getDevelopmentProposal().getProposalPerson(selectedPersonIndex);
        ProposalPersonDegree degree = (ProposalPersonDegree)pdform.getNewProposalPersonDegree().get(selectedPersonIndex);
        degree.setDegreeSequenceNumber(pdform.getProposalDevelopmentDocument().getDocumentNextValue("proposalDevelopment.proposalPerson.degree.degreeSequenceNumber"));
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new ChangeKeyPersonEvent(document, person, (BusinessObject)degree, selectedPersonIndex));
        if (rulePassed) {
            person.addDegree(degree);
            degree.refreshReferenceObject("degreeType");
            pdform.getNewProposalPersonDegree().remove(selectedPersonIndex);
            pdform.getNewProposalPersonDegree().add(selectedPersonIndex, new ProposalPersonDegree());
        }
        return mapping.findForward("basic");
    }

    public ActionForward insertUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, document);
        ProposalPerson person = document.getDevelopmentProposal().getProposalPerson(selectedPersonIndex);
        ProposalPersonUnit unit = this.getKeyPersonnelService().createProposalPersonUnit(((Unit)pdform.getNewProposalPersonUnit().get(selectedPersonIndex)).getUnitNumber(), person);
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new ChangeKeyPersonEvent(document, person, (BusinessObject)unit, selectedPersonIndex));
        if (rulePassed) {
            this.getKeyPersonnelService().addUnitToPerson(person, unit);
            pdform.getNewProposalPersonUnit().remove(selectedPersonIndex);
            pdform.getNewProposalPersonUnit().add(selectedPersonIndex, new Unit());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deletePerson(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        DevelopmentProposal proposal = document.getDevelopmentProposal();
        if (proposal.isParent()) {
            GlobalVariables.getMessageMap().putError("newProposalPerson", "error.hierarchy.unexpected", new String[]{"Cannot remove Personnel from the Parent of a Hierarchy"});
        } else {
            ProposalPerson parentPi = null;
            if (proposal.isChild()) {
                parentPi = ((ProposalHierarchyService)KraServiceLocator.getService(ProposalHierarchyService.class)).getParentDocument(document).getDevelopmentProposal().getPrincipalInvestigator();
            }
            int index = 0;
            Iterator person_it = proposal.getProposalPersons().iterator();
            while (person_it.hasNext()) {
                ProposalPerson person = (ProposalPerson)person_it.next();
                if (person.isDelete()) {
                    pdform.getProposalPersonsToDelete().add(person);
                    if (parentPi != null && parentPi.equals((Object)person)) {
                        GlobalVariables.getMessageMap().putError(String.format(ERROR_FIELD_REMOVE_HIERARCHY_PI, index), ERROR_REMOVE_HIERARCHY_PI, new String[]{person.getFullName()});
                    } else {
                        person_it.remove();
                        proposal.getInvestigators().remove(person);
                        proposal.removePersonnelAttachmentForDeletedPerson(person);
                        ProposalPersonQuestionnaireHelper helper = new ProposalPersonQuestionnaireHelper(pdform, person);
                        pdform.getAnswerHeadersToDelete().addAll(helper.getAnswerHeaders());
                    }
                }
                ++index;
            }
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteUnit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, document);
        ProposalPerson selectedPerson = document.getDevelopmentProposal().getProposalPerson(selectedPersonIndex);
        ProposalPersonUnit unit = selectedPerson.getUnit(this.getSelectedLine(request));
        selectedPerson.getUnits().remove(unit);
        return mapping.findForward("basic");
    }

    public ActionForward deleteDegree(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        ProposalPerson selectedPerson = this.getSelectedPerson(request, document);
        selectedPerson.getProposalPersonDegrees().remove(this.getSelectedLine(request));
        return mapping.findForward("basic");
    }

    public ActionForward recalculateCreditSplit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new CalculateCreditSplitEvent(EMPTY_STRING, document));
        if (rulePassed) {
            this.prepare(form, request);
        }
        return mapping.findForward("basic");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        boolean rulePassed = true;
        this.updateCurrentOrdinalPositions(((ProposalDevelopmentForm)form).getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons());
        if (rulePassed &= this.getKualiRuleService().applyRules((KualiDocumentEvent)new SaveKeyPersonEvent(EMPTY_STRING, pdform.getProposalDevelopmentDocument()))) {
            ArrayList answerHeadersToSave = new ArrayList();
            for (ProposalPersonQuestionnaireHelper helper : pdform.getProposalPersonQuestionnaireHelpers()) {
                if (!pdform.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons().contains(helper.getProposalPerson())) continue;
                helper.preSave();
                answerHeadersToSave.addAll(helper.getAnswerHeaders());
            }
            if (!answerHeadersToSave.isEmpty()) {
                this.getBusinessObjectService().save(answerHeadersToSave);
            }
            if (!pdform.getAnswerHeadersToDelete().isEmpty()) {
                ArrayList<AnswerHeader> freshHeaders = new ArrayList<AnswerHeader>();
                for (AnswerHeader header : pdform.getAnswerHeadersToDelete()) {
                    HashMap<String, Long> primaryKeys = new HashMap<String, Long>();
                    primaryKeys.put("QUESTIONNAIRE_ANSWER_HEADER_ID", header.getAnswerHeaderId());
                    AnswerHeader ah = (AnswerHeader)this.getBusinessObjectService().findByPrimaryKey(AnswerHeader.class, primaryKeys);
                    if (ah == null) continue;
                    freshHeaders.add(ah);
                }
                if (!freshHeaders.isEmpty()) {
                    this.getBusinessObjectService().delete(freshHeaders);
                }
                pdform.getAnswerHeadersToDelete().clear();
            }
            List keyPersonnel = pdform.getProposalDevelopmentDocument().getDevelopmentProposal().getProposalPersons();
            List personsToDelete = pdform.getProposalPersonsToDelete();
            ArrayList<Object> peropleObjectsToSave = new ArrayList<Object>();
            for (ProposalPerson proposalPerson : keyPersonnel) {
                this.getBusinessObjectService().save((PersistableBusinessObject)proposalPerson);
                if (proposalPerson.getProposalPersonExtendedAttributes() == null) continue;
                peropleObjectsToSave.add(proposalPerson);
                peropleObjectsToSave.add(proposalPerson.getProposalPersonExtendedAttributes());
            }
            this.getBusinessObjectService().save(peropleObjectsToSave);
            for (ProposalPerson person : personsToDelete) {
                if (person.getProposalPersonExtendedAttributes() == null) continue;
                this.getBusinessObjectService().delete((PersistableBusinessObject)person.getProposalPersonExtendedAttributes());
            }
            pdform.setPropsoalPersonsToDelete(new ArrayList());
            return super.save(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward addUnitDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        int selectedPersonIndex = this.getSelectedPersonIndex(request, document);
        ProposalPerson person = document.getDevelopmentProposal().getProposalPerson(selectedPersonIndex);
        if (StringUtils.isNotBlank((String)person.getHomeUnit()) && this.isValidHomeUnit(person, person.getHomeUnit())) {
            this.getKeyPersonnelService().addUnitToPerson(person, this.getKeyPersonnelService().createProposalPersonUnit(person.getHomeUnit(), person));
        }
        person.setOptInUnitStatus("Y");
        pdform.setOptInUnitDetails("Y");
        this.getKeyPersonnelService().populateProposalPerson(person, document);
        return mapping.findForward("basic");
    }

    public ActionForward removeUnitDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        ProposalPerson selectedPerson = this.getSelectedPerson(request, document);
        pdform.setOptInUnitDetails("N");
        selectedPerson.setOptInUnitStatus("N");
        selectedPerson.getUnits().clear();
        document.getDevelopmentProposal().getInvestigators().remove(selectedPerson);
        return mapping.findForward("basic");
    }

    public ActionForward addCertificationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        ProposalPerson selectedPerson = this.getSelectedPerson(request, document);
        pdform.setOptInCertificationStatus("Y");
        selectedPerson.setOptInCertificationStatus("Y");
        this.getKeyPersonnelService().populateProposalPerson(selectedPerson, document);
        return mapping.findForward("basic");
    }

    public ActionForward printCertification(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        ProposalPerson selectedPerson = this.getSelectedPerson(request, document);
        ProposalDevelopmentPrintingService printService = (ProposalDevelopmentPrintingService)KraServiceLocator.getService(ProposalDevelopmentPrintingService.class);
        HashMap<String, ProposalPerson> reportParameters = new HashMap<String, ProposalPerson>();
        reportParameters.put("Print Certification Person", selectedPerson);
        AttachmentDataSource dataStream = printService.printProposalDevelopmentReport((KraPersistableBusinessObjectBase)document.getDevelopmentProposal(), "Print Certification", reportParameters);
        this.streamToResponse(dataStream, response);
        return null;
    }

    public ActionForward removeCertificationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        ProposalPerson selectedPerson = this.getSelectedPerson(request, document);
        pdform.setOptInCertificationStatus("N");
        selectedPerson.setOptInCertificationStatus("N");
        selectedPerson.getProposalPersonYnqs().clear();
        return mapping.findForward("basic");
    }

    protected ProposalPerson getSelectedPerson(HttpServletRequest request, ProposalDevelopmentDocument document) {
        ProposalPerson retval = null;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            int lineNumber = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)"proposalPersons[", (String)"]."));
            retval = document.getDevelopmentProposal().getProposalPerson(lineNumber);
        }
        return retval;
    }

    protected int getSelectedPersonIndex(HttpServletRequest request, ProposalDevelopmentDocument document) {
        int selectedPersonIndex = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            selectedPersonIndex = Integer.parseInt(StringUtils.substringBetween((String)parameterName, (String)"proposalPersons[", (String)"]."));
        }
        return selectedPersonIndex;
    }

    protected boolean isValidHomeUnit(ProposalPerson person, String unitId) {
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("unitNumber", unitId);
        Collection units = this.getBusinessObjectService().findMatching(Unit.class, valueMap);
        return CollectionUtils.isNotEmpty((Collection)units);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    private void swapAdjacentPersonnel(List<ProposalPerson> keyPersonnel, int index1, MoveOperationEnum op) {
        ProposalPerson movingPerson = keyPersonnel.get(index1);
        if (op == MoveOperationEnum.MOVING_PERSON_DOWN && movingPerson.isMoveDownAllowed() || op == MoveOperationEnum.MOVING_PERSON_UP && movingPerson.isMoveUpAllowed()) {
            int index2 = index1 + op.getOffset();
            keyPersonnel.set(index1, keyPersonnel.get(index2));
            keyPersonnel.set(index2, movingPerson);
        }
    }

    private void updateCurrentOrdinalPositions(List<ProposalPerson> keyPersonnel) {
        Integer index = 0;
        for (ProposalPerson person : keyPersonnel) {
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
            person.setOrdinalPosition(n);
        }
    }

    public ActionForward reload(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward returnValue = super.reload(mapping, form, request, response);
        this.clearProposalPerson(mapping, form, request, response);
        return returnValue;
    }

    public ActionForward printQuestionnaireAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        int personIndex = this.getSelectedLine(request);
        ProposalPerson person = document.getDevelopmentProposal().getProposalPerson(personIndex);
        ProposalPersonQuestionnaireHelper helper = new ProposalPersonQuestionnaireHelper(pdform, person);
        AnswerHeader header = (AnswerHeader)helper.getAnswerHeaders().get(0);
        reportParameters.put("questionnaireId", header.getQuestionnaire().getQuestionnaireIdAsInteger());
        reportParameters.put("template", header.getQuestionnaire().getTemplate());
        AttachmentDataSource dataStream = this.getQuestionnairePrintingService().printQuestionnaireAnswer((KraPersistableBusinessObjectBase)person, reportParameters);
        if (dataStream.getContent() != null) {
            this.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    protected QuestionnairePrintingService getQuestionnairePrintingService() {
        return (QuestionnairePrintingService)KraServiceLocator.getService(QuestionnairePrintingService.class);
    }

    public ActionForward updateAnswerToNewVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm pdform = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = pdform.getProposalDevelopmentDocument();
        String formProperty = this.getFormProperty(request, "updateAnswerToNewVersion");
        if (StringUtils.contains((String)formProperty, (String)".proposalPersonQuestionnaireHelpers[")) {
            int selectedPersonIndex = Integer.parseInt(formProperty.substring(36, formProperty.length() - 1));
            ProposalPerson person = document.getDevelopmentProposal().getProposalPerson(selectedPersonIndex);
            ProposalPersonQuestionnaireHelper helper = (ProposalPersonQuestionnaireHelper)pdform.getProposalPersonQuestionnaireHelpers().get(selectedPersonIndex);
            helper.updateQuestionnaireAnswer(this.getLineToDelete(request));
            this.getBusinessObjectService().save((PersistableBusinessObject)helper.getAnswerHeaders().get(this.getLineToDelete(request)));
            return mapping.findForward("basic");
        }
        throw new RuntimeException(String.format("Do not know how to process updateAnswerToNewVersion for formProperty %s", formProperty));
    }
}

