/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalRoleState;
import org.kuali.kra.proposaldevelopment.bo.ProposalUser;
import org.kuali.kra.proposaldevelopment.bo.ProposalUserEditRoles;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.event.AddProposalUserEvent;
import org.kuali.kra.proposaldevelopment.rule.event.DeleteProposalUserEvent;
import org.kuali.kra.proposaldevelopment.rule.event.EditUserProposalRolesEvent;
import org.kuali.kra.proposaldevelopment.service.NarrativeService;
import org.kuali.kra.proposaldevelopment.web.bean.ProposalUserRoles;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentAction;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.web.struts.action.StrutsConfirmation;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ProposalDevelopmentPermissionsAction
extends ProposalDevelopmentAction {
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentPermissionsAction.class);

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        List currentProposalUsers = proposalDevelopmentForm.getCurrentProposalUserRoles();
        List proposalUsers = proposalDevelopmentForm.getProposalUserRoles();
        ArrayList proposalUsersToDelete = new ArrayList(currentProposalUsers);
        proposalUsersToDelete.removeAll(proposalUsers);
        for (ProposalUserRoles proposalUser : proposalUsersToDelete) {
            this.deleteProposalUser(proposalUser, doc);
        }
        ArrayList proposalUsersToAdd = new ArrayList(proposalUsers);
        proposalUsersToAdd.removeAll(currentProposalUsers);
        for (ProposalUserRoles proposalUser : proposalUsersToAdd) {
            this.saveProposalUser(proposalUser, doc);
        }
        return super.save(mapping, form, request, response);
    }

    public ActionForward close(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        KualiDocumentFormBase docForm = (KualiDocumentFormBase)form;
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        if (docForm.getDocumentActions().containsKey("canSave")) {
            String question = request.getParameter("questionIndex");
            ConfigurationService kualiConfiguration = KRADServiceLocator.getKualiConfigurationService();
            if (question == null) {
                return this.performQuestionWithoutInput(mapping, form, request, response, "DocSaveBeforeClose", kualiConfiguration.getPropertyValueAsString("document.question.saveBeforeClose.text"), "confirmationQuestion", "close", "");
            }
            String buttonClicked = request.getParameter("buttonClicked");
            if ("DocSaveBeforeClose".equals(question) && "0".equals(buttonClicked)) {
                List proposalUsers = proposalDevelopmentForm.getCurrentProposalUserRoles();
                for (ProposalUserRoles proposalUser : proposalUsers) {
                    this.deleteProposalUser(proposalUser, doc);
                }
                proposalUsers = proposalDevelopmentForm.getProposalUserRoles();
                for (ProposalUserRoles proposalUser : proposalUsers) {
                    this.saveProposalUser(proposalUser, doc);
                }
            }
        }
        return super.close(mapping, form, request, response);
    }

    private void deleteProposalUser(ProposalUserRoles proposalUser, ProposalDevelopmentDocument doc) {
        KraAuthorizationService kraAuthorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        List roleNames = proposalUser.getRoleNames();
        for (String roleName : roleNames) {
            kraAuthorizationService.removeRole(this.getPersonId(proposalUser.getUsername()), roleName, (Permissionable)doc);
        }
    }

    private String getPersonId(String username) {
        PersonService personService = (PersonService)KraServiceLocator.getService(PersonService.class);
        Person person = personService.getPersonByPrincipalName(username);
        return person.getPrincipalId();
    }

    private void saveProposalUser(ProposalUserRoles proposalUser, ProposalDevelopmentDocument doc) {
        KraAuthorizationService kraAuthorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        List roleNames = proposalUser.getRoleNames();
        for (String roleName : roleNames) {
            kraAuthorizationService.addRole(this.getPersonId(proposalUser.getUsername()), roleName, (Permissionable)doc);
        }
    }

    public ActionForward getPermissionsRoleRights(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("permissionsRoleRights");
    }

    public ActionForward addProposalUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalUser proposalUser = proposalDevelopmentForm.getNewProposalUser();
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new AddProposalUserEvent(doc, proposalDevelopmentForm.getProposalUserRoles(), proposalUser));
        if (rulePassed) {
            proposalDevelopmentForm.addProposalUser(proposalUser);
            proposalDevelopmentForm.setNewProposalUser(new ProposalUser());
            NarrativeService narrativeService = (NarrativeService)KraServiceLocator.getService(NarrativeService.class);
            narrativeService.addPerson(proposalUser.getUsername(), doc, proposalUser.getRoleName());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteProposalUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        int lineNum = this.getLineToDelete(request);
        List proposalUserRolesList = proposalDevelopmentForm.getProposalUserRoles();
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new DeleteProposalUserEvent(doc, proposalUserRolesList, lineNum));
        if (rulePassed) {
            return this.confirm(this.buildDeleteProposalUserConfirmationQuestion(mapping, form, request, response), "confirmDeleteProposalUser", "");
        }
        return mapping.findForward("basic");
    }

    public ActionForward confirmDeleteProposalUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if ("confirmDeleteProposalUser".equals(question)) {
            ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
            ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
            int lineNum = this.getLineToDelete(request);
            List proposalUserRolesList = proposalDevelopmentForm.getProposalUserRoles();
            ProposalUserRoles proposalUserRoles = (ProposalUserRoles)proposalUserRolesList.get(lineNum);
            proposalUserRolesList.remove(lineNum);
            NarrativeService narrativeService = (NarrativeService)KraServiceLocator.getService(NarrativeService.class);
            narrativeService.deletePerson(this.getPersonId(proposalUserRoles.getUsername()), doc);
        }
        return mapping.findForward("basic");
    }

    private StrutsConfirmation buildDeleteProposalUserConfirmationQuestion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        String fullname = ((ProposalUserRoles)proposalDevelopmentForm.getProposalUserRoles().get(this.getLineToDelete(request))).getFullname();
        return this.buildParameterizedConfirmationQuestion(mapping, form, request, response, "confirmDeleteProposalUser", "document.question.deleteProposalUser.text", new String[]{fullname});
    }

    public ActionForward editRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        int lineNum = this.getLineNum(request);
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalUserRoles proposalUserRoles = (ProposalUserRoles)proposalDevelopmentForm.getProposalUserRoles().get(lineNum);
        ProposalUserEditRoles editRoles = new ProposalUserEditRoles();
        editRoles.setLineNum(lineNum);
        editRoles.setJavaScriptEnabled(this.isJavaScriptEnabled(request));
        editRoles.setUsername(proposalUserRoles.getUsername());
        ArrayList<ProposalRoleState> roleStates = new ArrayList<ProposalRoleState>();
        Collection proposalRoles = proposalDevelopmentForm.getKimProposalRoles();
        for (Role proposalRole : proposalRoles) {
            if (StringUtils.equals((String)proposalRole.getName(), (String)"unassigned")) continue;
            ProposalRoleState roleState = new ProposalRoleState(proposalRole.getName());
            roleStates.add(roleState);
        }
        editRoles.setRoleStates(roleStates);
        List roleNames = proposalUserRoles.getRoleNames();
        for (String roleName : roleNames) {
            editRoles.setRoleState(roleName, Boolean.TRUE);
        }
        proposalDevelopmentForm.setProposalUserEditRoles(editRoles);
        return mapping.findForward("permissionsEditRoles");
    }

    public ActionForward setEditRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = null;
        KraAuthorizationService kraAuthorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalUserEditRoles editRoles = proposalDevelopmentForm.getProposalUserEditRoles();
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new EditUserProposalRolesEvent(doc, proposalDevelopmentForm.getProposalUserRoles(), editRoles));
        if (!rulePassed) {
            actionForward = mapping.findForward("permissionsEditRoles");
        } else {
            int lineNum = editRoles.getLineNum();
            ProposalUserRoles proposalUserRoles = (ProposalUserRoles)proposalDevelopmentForm.getProposalUserRoles().get(lineNum);
            String username = proposalUserRoles.getUsername();
            ArrayList<String> roleNames = new ArrayList<String>();
            List roleStates = editRoles.getRoleStates();
            for (ProposalRoleState roleState : roleStates) {
                if (!roleState.getState().booleanValue()) continue;
                roleNames.add(roleState.getName());
            }
            if (roleNames.size() == 0) {
                roleNames.add("unassigned");
            }
            proposalUserRoles.setRoleNames(roleNames);
            NarrativeService narrativeService = (NarrativeService)KraServiceLocator.getService(NarrativeService.class);
            narrativeService.readjustRights(this.getPersonId(proposalUserRoles.getUsername()), doc, roleNames);
            actionForward = editRoles.getJavaScriptEnabled() ? mapping.findForward("permissionsCloseEditRoles") : mapping.findForward("basic");
        }
        return actionForward;
    }

    private int getLineNum(HttpServletRequest request) {
        String lineNumStr = request.getParameter("line");
        try {
            return Integer.parseInt(lineNumStr);
        }
        catch (Exception ex) {
            return this.getLineToDelete(request);
        }
    }

    private boolean isJavaScriptEnabled(HttpServletRequest request) {
        String lineNumStr = request.getParameter("line");
        try {
            Integer.parseInt(lineNumStr);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public ActionForward processAuthorizationViolation(String taskName, ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        if (!StringUtils.equals((String)taskName, (String)"setEditRoles")) {
            forward = super.processAuthorizationViolation(taskName, mapping, form, request, response);
        } else {
            MessageMap errorMap = GlobalVariables.getMessageMap();
            errorMap.putError("proposalUserEditRole", "error.authorization.violation", new String[0]);
            forward = mapping.findForward("permissionsEditRoles");
        }
        return forward;
    }

    protected KualiRuleService getKualiRuleService() {
        return (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
    }

    public ActionForward saveViewers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        List currentProposalUsers = proposalDevelopmentForm.getCurrentProposalUserRoles();
        List newProposalUsers = proposalDevelopmentForm.getProposalUserRoles();
        block0: for (ProposalUserRoles proposalUser : newProposalUsers) {
            if (currentProposalUsers.contains(proposalUser)) continue;
            for (String roleName : proposalUser.getRoleNames()) {
                if (StringUtils.equals((String)roleName, (String)"Viewer")) continue;
                continue block0;
            }
            this.saveProposalUser(proposalUser, doc);
        }
        return mapping.findForward("basic");
    }
}

