/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.action;

import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.ProposalCopyCriteria;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.rule.event.CopyProposalEvent;
import org.kuali.kra.proposaldevelopment.service.ProposalCopyService;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentAction;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentActionsAction;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.service.PessimisticLockService;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProposalDevelopmentResubmissionAction
extends ProposalDevelopmentAction {
    private static final Log LOG = LogFactory.getLog(ProposalDevelopmentActionsAction.class);
    private DateTimeService dateTimeService;
    private static final String MAPPING_PROPOSAL = "proposal";

    public ActionForward copyProposalForResubmission(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward nextWebPage = null;
        BusinessObjectService boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument doc = proposalDevelopmentForm.getProposalDevelopmentDocument();
        boolean i = false;
        ProposalCopyCriteria criteria = proposalDevelopmentForm.getCopyCriteria();
        boolean rulePassed = this.getKualiRuleService().applyRules((KualiDocumentEvent)new CopyProposalEvent(doc, criteria));
        if (!rulePassed) {
            nextWebPage = mapping.findForward("basic");
        } else {
            ProposalCopyService proposalCopyService = (ProposalCopyService)KraServiceLocator.getService((String)"proposalCopyService");
            if (proposalCopyService == null) {
                nextWebPage = mapping.findForward("basic");
            } else {
                String originalProposalId = doc.getDevelopmentProposal().getProposalNumber();
                String newDocId = proposalCopyService.copyProposal(doc, criteria);
                WorkflowDocument originalWFDoc = doc.getDocumentHeader().getWorkflowDocument();
                ((PessimisticLockService)KraServiceLocator.getService(PessimisticLockService.class)).releaseAllLocksForUser(doc.getPessimisticLocks(), GlobalVariables.getUserSession().getPerson());
                DocumentService docService = KRADServiceLocatorWeb.getDocumentService();
                proposalDevelopmentForm.setDocId(newDocId);
                this.loadDocument((KualiDocumentFormBase)proposalDevelopmentForm);
                ProposalDevelopmentDocument copiedDocument = proposalDevelopmentForm.getProposalDevelopmentDocument();
                copiedDocument.getDevelopmentProposal().setS2sAppSubmission(new ArrayList());
                copiedDocument.getDevelopmentProposal().setContinuedFrom(originalProposalId);
                copiedDocument.getDevelopmentProposal().setProposalTypeCode("4");
                copiedDocument.getDevelopmentProposal().getS2sOpportunity().setS2sSubmissionType(null);
                WorkflowDocument workflowDocument = copiedDocument.getDocumentHeader().getWorkflowDocument();
                docService.saveDocument((Document)copiedDocument);
                nextWebPage = mapping.findForward(MAPPING_PROPOSAL);
            }
        }
        return nextWebPage;
    }

    protected KualiRuleService getKualiRuleService() {
        return (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
    }
}

