/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment.web.struts.action;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.common.specialreview.bo.SpecialReview;
import org.kuali.kra.common.specialreview.rule.event.AddSpecialReviewEvent;
import org.kuali.kra.common.specialreview.rule.event.SaveSpecialReviewEvent;
import org.kuali.kra.common.specialreview.service.SpecialReviewService;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolProposalDevelopmentProtocolDocumentService;
import org.kuali.kra.iacuc.protocol.funding.IacucProtocolProposalDevelopmentProtocolDocumentServiceImpl;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.protocol.funding.ProposalDevelopmentProtocolDocumentService;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.proposaldevelopment.web.struts.action.ProposalDevelopmentAction;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KualiRuleService;

public class ProposalDevelopmentSpecialReviewAction
extends ProposalDevelopmentAction {
    private static final String SAVE_SPECIAL_REVIEW_FIELD = "document.developmentProposalList[0].propSpecialReviews";
    private static final String CONFIRM_DELETE_SPECIAL_REVIEW_KEY = "confirmDeleteSpecialReview";
    private SpecialReviewService specialReviewService;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        proposalDevelopmentForm.getSpecialReviewHelper().prepareView();
        return forward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.refresh(mapping, form, request, response);
        String prefix = this.getSpecialReviewService().getProtocolSaveLocationPrefix(request.getParameterMap());
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalSpecialReview proposalSpecialReview = null;
        if (StringUtils.startsWith((String)prefix, (String)"specialReviewHelper.newSpecialReview")) {
            proposalSpecialReview = (ProposalSpecialReview)proposalDevelopmentForm.getSpecialReviewHelper().getNewSpecialReview();
        } else {
            int index = this.getSpecialReviewService().getProtocolIndex(prefix);
            if (index != -1) {
                proposalSpecialReview = (ProposalSpecialReview)proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().getPropSpecialReviews().get(index);
            }
        }
        proposalDevelopmentForm.getSpecialReviewHelper().prepareProtocolLinkViewFields((SpecialReview)proposalSpecialReview);
        return forward;
    }

    public ActionForward addSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalSpecialReview specialReview = (ProposalSpecialReview)proposalDevelopmentForm.getSpecialReviewHelper().getNewSpecialReview();
        List specialReviews = document.getDevelopmentProposal().getPropSpecialReviews();
        boolean isProtocolLinkingEnabled = false;
        if ("1".equals(specialReview.getSpecialReviewTypeCode())) {
            isProtocolLinkingEnabled = proposalDevelopmentForm.getSpecialReviewHelper().getIsIrbProtocolLinkingEnabled();
        } else if ("2".equals(specialReview.getSpecialReviewTypeCode())) {
            isProtocolLinkingEnabled = proposalDevelopmentForm.getSpecialReviewHelper().getIsIacucProtocolLinkingEnabled();
        }
        proposalDevelopmentForm.getSpecialReviewHelper().prepareProtocolLinkViewFields((SpecialReview)specialReview);
        KualiRuleService ruleService = (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
        if (ruleService.applyRules((KualiDocumentEvent)new AddSpecialReviewEvent((Document)document, (SpecialReview)specialReview, specialReviews, isProtocolLinkingEnabled))) {
            specialReview.setSpecialReviewNumber(document.getDocumentNextValue("proposalDevelopment.proposalSpecialReview.specialReviewNumber"));
            document.getDevelopmentProposal().getPropSpecialReviews().add(specialReview);
            proposalDevelopmentForm.getSpecialReviewHelper().setNewSpecialReview((SpecialReview)new ProposalSpecialReview());
        }
        return mapping.findForward("basic");
    }

    public ActionForward deleteSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.confirm(this.buildParameterizedConfirmationQuestion(mapping, form, request, response, CONFIRM_DELETE_SPECIAL_REVIEW_KEY, "question.special.review.delete.confirmation", new String[0]), CONFIRM_DELETE_SPECIAL_REVIEW_KEY, "");
    }

    public ActionForward confirmDeleteSpecialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String question = request.getParameter("questionIndex");
        if (CONFIRM_DELETE_SPECIAL_REVIEW_KEY.equals(question)) {
            ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
            ProposalDevelopmentDocument document = proposalDevelopmentForm.getProposalDevelopmentDocument();
            document.getDevelopmentProposal().getPropSpecialReviews().remove(this.getLineToDelete(request));
        }
        return mapping.findForward("basic");
    }

    public ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalSpecialReview specialReview = (ProposalSpecialReview)proposalDevelopmentForm.getSpecialReviewHelper().getNewSpecialReview();
        List specialReviews = document.getDevelopmentProposal().getPropSpecialReviews();
        boolean isPDIrbProtocolLinkingEnabled = proposalDevelopmentForm.getSpecialReviewHelper().getIsIrbProtocolLinkingEnabled();
        boolean isPDIacucProtocolLinkingEnabled = proposalDevelopmentForm.getSpecialReviewHelper().getIsIacucProtocolLinkingEnabled();
        proposalDevelopmentForm.getSpecialReviewHelper().prepareProtocolLinkViewFields((SpecialReview)specialReview);
        if (this.applyRules((KualiDocumentEvent)new SaveSpecialReviewEvent(SAVE_SPECIAL_REVIEW_FIELD, (Document)document, specialReviews, isPDIrbProtocolLinkingEnabled, isPDIacucProtocolLinkingEnabled))) {
            forward = super.save(mapping, form, request, response);
        }
        return forward;
    }

    public ActionForward viewNewSpecialReviewProtocolLink(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewProtocolUrl = "";
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalSpecialReview proposalSpecialReview = (ProposalSpecialReview)proposalDevelopmentForm.getSpecialReviewHelper().getNewSpecialReview();
        viewProtocolUrl = this.getViewProtocolUrl(proposalSpecialReview);
        return new ActionForward(viewProtocolUrl, true);
    }

    public ActionForward viewSpecialReviewProtocolLink(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String viewProtocolUrl = "";
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        String lineNumber = request.getParameter("line");
        if (NumberUtils.isNumber((String)lineNumber)) {
            int index = Integer.parseInt(lineNumber);
            ProposalSpecialReview proposalSpecialReview = (ProposalSpecialReview)proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal().getPropSpecialReviews().get(index);
            viewProtocolUrl = this.getViewProtocolUrl(proposalSpecialReview);
        }
        return new ActionForward(viewProtocolUrl, true);
    }

    private String getViewProtocolUrl(ProposalSpecialReview specialReview) throws Exception {
        String viewProtocolUrl = "";
        String protocolNumber = specialReview.getProtocolNumber();
        String routeHeaderId = this.getSpecialReviewService().getViewSpecialReviewProtocolRouteHeaderId(protocolNumber, specialReview.getSpecialReviewTypeCode());
        if (StringUtils.isNotEmpty((String)routeHeaderId)) {
            viewProtocolUrl = this.buildForwardUrl(routeHeaderId) + "&viewDocument=true";
        }
        return viewProtocolUrl;
    }

    public SpecialReviewService getSpecialReviewService() {
        if (this.specialReviewService == null) {
            this.specialReviewService = (SpecialReviewService)KraServiceLocator.getService(SpecialReviewService.class);
        }
        return this.specialReviewService;
    }

    public void setSpecialReviewService(SpecialReviewService specialReviewService) {
        this.specialReviewService = specialReviewService;
    }

    public ActionForward createProtocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        IacucProtocolProposalDevelopmentProtocolDocumentServiceImpl service;
        ProtocolDocumentBase protocolDocument;
        ProposalDevelopmentForm proposalDevelopmentForm = (ProposalDevelopmentForm)form;
        ProposalDevelopmentDocument document = proposalDevelopmentForm.getProposalDevelopmentDocument();
        ProposalSpecialReview specialReview = (ProposalSpecialReview)proposalDevelopmentForm.getSpecialReviewHelper().getNewSpecialReview();
        List specialReviews = document.getDevelopmentProposal().getPropSpecialReviews();
        boolean protocolLinkingEnabled = false;
        if ("1".equals(specialReview.getSpecialReviewTypeCode())) {
            ProposalDevelopmentProtocolDocumentService service2;
            ProtocolDocument protocolDocument2;
            protocolLinkingEnabled = proposalDevelopmentForm.getSpecialReviewHelper().getIsIrbProtocolLinkingEnabled();
            if (protocolLinkingEnabled && (protocolDocument2 = (service2 = this.getProposalDevelopmentProtocolDocumentService()).createProtocolDocument(proposalDevelopmentForm)) != null) {
                specialReview.setSpecialReviewTypeCode("1");
                Integer specialReviewNumber = document.getDocumentNextValue("proposalDevelopment.proposalSpecialReview.specialReviewNumber");
                specialReview.setSpecialReviewNumber(specialReviewNumber);
                specialReview.setApprovalTypeCode("1");
                specialReview.setProtocolNumber(protocolDocument2.getProtocol().getProtocolNumber());
                specialReview.setProposalNumber(document.getDevelopmentProposal().getProposalNumber());
                specialReview.setProtocolStatus(protocolDocument2.getProtocol().getProtocolStatus().getDescription());
                specialReview.setComments("A Special Review has been inserted.");
                proposalDevelopmentForm.getSpecialReviewHelper().prepareProtocolLinkViewFields((SpecialReview)specialReview);
                KualiRuleService ruleService = (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
                if (ruleService.applyRules((KualiDocumentEvent)new AddSpecialReviewEvent((Document)document, (SpecialReview)specialReview, specialReviews, protocolLinkingEnabled))) {
                    specialReviews.add(specialReview);
                    proposalDevelopmentForm.getSpecialReviewHelper().setNewSpecialReview((SpecialReview)new ProposalSpecialReview());
                }
            }
        } else if ("2".equals(specialReview.getSpecialReviewTypeCode()) && (protocolLinkingEnabled = proposalDevelopmentForm.getSpecialReviewHelper().getIsIacucProtocolLinkingEnabled()) && (protocolDocument = (service = this.getIacucProtocolProposalDevelopmentProtocolDocumentService()).createProtocolDocument(proposalDevelopmentForm)) != null) {
            specialReview.setSpecialReviewTypeCode("2");
            Integer specialReviewNumber = document.getDocumentNextValue("proposalDevelopment.proposalSpecialReview.specialReviewNumber");
            specialReview.setSpecialReviewNumber(specialReviewNumber);
            specialReview.setApprovalTypeCode("1");
            specialReview.setProtocolNumber(protocolDocument.getProtocol().getProtocolNumber());
            specialReview.setProposalNumber(document.getDevelopmentProposal().getProposalNumber());
            specialReview.setProtocolStatus(protocolDocument.getProtocol().getProtocolStatus().getDescription());
            specialReview.setComments("A Special Review has been inserted.");
            proposalDevelopmentForm.getSpecialReviewHelper().prepareProtocolLinkViewFields((SpecialReview)specialReview);
            KualiRuleService ruleService = (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
            if (ruleService.applyRules((KualiDocumentEvent)new AddSpecialReviewEvent((Document)document, (SpecialReview)specialReview, specialReviews, protocolLinkingEnabled))) {
                specialReviews.add(specialReview);
                proposalDevelopmentForm.getSpecialReviewHelper().setNewSpecialReview((SpecialReview)new ProposalSpecialReview());
            }
        }
        return mapping.findForward("basic");
    }

    private ProposalDevelopmentProtocolDocumentService getProposalDevelopmentProtocolDocumentService() {
        return (ProposalDevelopmentProtocolDocumentService)KraServiceLocator.getService(ProposalDevelopmentProtocolDocumentService.class);
    }

    private IacucProtocolProposalDevelopmentProtocolDocumentServiceImpl getIacucProtocolProposalDevelopmentProtocolDocumentService() {
        return (IacucProtocolProposalDevelopmentProtocolDocumentServiceImpl)KraServiceLocator.getService(IacucProtocolProposalDevelopmentProtocolDocumentService.class);
    }
}

