/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.krms.service.KrmsRulesExecutionService;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.protocol.ProtocolActionBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.ProtocolSubmissionBeanBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonTrainingService;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.questionnaire.QuestionnaireHelperBase;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.print.QuestionnairePrintingService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.UnitAclLoadService;
import org.kuali.kra.web.struts.action.AuditActionHelper;
import org.kuali.kra.web.struts.action.KraTransactionalDocumentActionBase;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kns.lookup.LookupResultsService;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiForm;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.KualiRuleService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolActionBase
extends KraTransactionalDocumentActionBase {
    private static final Log LOG = LogFactory.getLog(ProtocolActionBase.class);
    private static final String PROTOCOL_NUMBER = "protocolNumber";
    private static final String SUBMISSION_NUMBER = "submissionNumber";
    private static final String SUFFIX_T = "T";
    private static final String NOT_FOUND_SELECTION = "The attachment was not found for selection ";
    private static final ActionForward RESPONSE_ALREADY_HANDLED = null;

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.execute(mapping, form, request, response);
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        if (protocolForm.isAuditActivated()) {
            protocolForm.setUnitRulesMessages(this.getUnitRulesMessages(protocolForm.getProtocolDocument()));
        }
        if (KNSGlobalVariables.getAuditErrorMap().isEmpty()) {
            new AuditActionHelper().auditConditionally((KualiDocumentFormBase)((ProtocolFormBase)form));
        }
        return forward;
    }

    protected abstract String getProtocolForwardNameHook();

    protected abstract String getQuestionnaireForwardNameHook();

    protected abstract String getPersonnelForwardNameHook();

    protected abstract String getNoteAndAttachmentForwardNameHook();

    protected abstract String getProtocolActionsForwardNameHook();

    protected abstract String getProtocolOnlineReviewForwardNameHook();

    protected abstract String getProtocolPermissionsForwardNameHook();

    protected abstract String getSpecialReviewForwardNameHook();

    protected abstract String getCustomDataForwardNameHook();

    protected abstract ProtocolNotification getProtocolNotificationHook();

    public ActionForward protocol(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getProtocolHelper().prepareView();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getProtocolForwardNameHook());
    }

    public ActionForward permissions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getPermissionsHelper().prepareView();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getProtocolPermissionsForwardNameHook());
    }

    public ActionForward personnel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        this.getProtocolPersonnelService().selectProtocolUnit(protocolForm.getProtocolDocument().getProtocol().getProtocolPersons());
        this.getProtocolPersonTrainingService().updatePersonTrained(protocolForm.getProtocolDocument().getProtocol().getProtocolPersons());
        protocolForm.getPersonnelHelper().prepareView();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getPersonnelForwardNameHook());
    }

    public ActionForward questionnaire(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getQuestionnaireHelper().prepareView();
        protocolForm.getQuestionnaireHelper().populateAnswers();
        protocolForm.getQuestionnaireHelper().setQuestionnaireActiveStatuses();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getQuestionnaireForwardNameHook());
    }

    protected ProtocolSubmissionBeanBase getSubmissionBean(ActionForm form, String submissionActionType) {
        ProtocolSubmissionBeanBase submissionBean = null;
        return submissionBean;
    }

    protected String getSubmitActionType(HttpServletRequest request) {
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        String actionTypeCode = "";
        if (StringUtils.isNotBlank((String)parameterName)) {
            actionTypeCode = StringUtils.substringBetween((String)parameterName, (String)".actionType", (String)".");
        }
        return actionTypeCode;
    }

    public ActionForward noteAndAttachment(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getNotesAttachmentsHelper().prepareView();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getNoteAndAttachmentForwardNameHook());
    }

    public ActionForward specialReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getSpecialReviewHelper().prepareView();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getSpecialReviewForwardNameHook());
    }

    public ActionForward protocolActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        String command = request.getParameter("command");
        if ("displayDocSearchView".equals(command)) {
            String docIdRequestParameter = request.getParameter("docId");
            Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
            protocolForm.setDocument(retrievedDocument);
            request.setAttribute("docId", (Object)docIdRequestParameter);
        }
        protocolForm.getActionHelper().setCurrentSubmissionNumber(-1);
        protocolForm.getActionHelper().prepareView();
        protocolForm.getActionHelper().prepareCommentsView();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getProtocolActionsForwardNameHook());
    }

    public ActionForward customData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        protocolForm.getCustomDataHelper().prepareCustomData();
        return this.branchToPanelOrNotificationEditor(mapping, protocolForm, this.getCustomDataForwardNameHook());
    }

    protected ActionForward branchToPanelOrNotificationEditor(ActionMapping mapping, ProtocolFormBase protocolForm, String ulitmateDestination) {
        if (protocolForm.isShowNotificationEditor()) {
            protocolForm.setShowNotificationEditor(false);
            ((ProtocolNotificationContextBase)protocolForm.getNotificationHelper().getNotificationContext()).setForwardName(ulitmateDestination);
            return mapping.findForward(this.getProtocolNotificationEditorHook());
        }
        return mapping.findForward(ulitmateDestination);
    }

    public final ActionForward save(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward actionForward = mapping.findForward("basic");
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolBase protocol = protocolForm.getProtocolDocument().getProtocol();
        ProtocolTaskBase task = this.createNewModifyProtocolTaskInstanceHook(protocol);
        AuditActionHelper auditActionHelper = new AuditActionHelper();
        if (this.isAuthorized((Task)task) && (!protocol.isCorrectionMode() || auditActionHelper.auditUnconditionally(protocolForm.getDocument()))) {
            protocolForm.setShowNotificationEditor(this.isInitialSave((Document)protocolForm.getProtocolDocument()));
            this.preSave(mapping, form, request, response);
            actionForward = super.save(mapping, form, request, response);
            this.postSave(mapping, form, request, response);
            if ("save".equals(protocolForm.getMethodToCall()) && protocolForm.isAuditActivated() && GlobalVariables.getMessageMap().hasNoErrors()) {
                actionForward = mapping.findForward(this.getProtocolActionsForwardNameHook());
            } else if (protocolForm.isShowNotificationEditor()) {
                ProtocolNotificationContextBase context = this.getProtocolInitialSaveNotificationContextHook(protocol);
                if (protocolForm.getNotificationHelper().getPromptUserForNotificationEditor((NotificationContext)context)) {
                    protocolForm.getNotificationHelper().initializeDefaultValues((NotificationContext)context);
                    if ("save".equals(protocolForm.getMethodToCall())) {
                        return mapping.findForward(this.getProtocolNotificationEditorHook());
                    }
                } else {
                    protocolForm.setShowNotificationEditor(false);
                    this.getNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)this.getProtocolNotificationHook(), (KraPersistableBusinessObjectBase)protocol);
                    return actionForward;
                }
            }
        }
        return actionForward;
    }

    protected abstract ProtocolNotificationContextBase getProtocolInitialSaveNotificationContextHook(ProtocolBase var1);

    protected abstract String getProtocolNotificationEditorHook();

    protected abstract ProtocolTaskBase createNewModifyProtocolTaskInstanceHook(ProtocolBase var1);

    public void preSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    public void postSave(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
    }

    protected void initialDocumentSave(KualiDocumentFormBase form) throws Exception {
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase doc = protocolForm.getProtocolDocument();
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        protocolForm.setShowNotificationEditor(true);
        this.initialDocumentSaveAddRolesHook(userId, doc.getProtocol());
        ProtocolBase permissionable = protocolForm.getProtocolDocument().getProtocol();
        UnitAclLoadService unitAclLoadService = this.getUnitAclLoadService();
        unitAclLoadService.loadUnitAcl((Permissionable)permissionable);
    }

    protected abstract void initialDocumentSaveAddRolesHook(String var1, ProtocolBase var2);

    protected abstract void sendNotification(ProtocolFormBase var1);

    protected ActionForward saveOnClose(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.saveOnClose(mapping, form, request, response);
        if (GlobalVariables.getMessageMap().hasErrors()) {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String lookupResultsSequenceNumber;
        super.refresh(mapping, form, request, response);
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolDocumentBase protocolDocument = protocolForm.getProtocolDocument();
        if ("multipleValues".equals(protocolForm.getRefreshCaller()) && StringUtils.isNotBlank((String)(lookupResultsSequenceNumber = protocolForm.getLookupResultsSequenceNumber()))) {
            Class<?> lookupResultsBOClass = Class.forName(protocolForm.getLookupResultsBOClassName());
            String userName = GlobalVariables.getUserSession().getPerson().getPrincipalId();
            LookupResultsService service = (LookupResultsService)KraServiceLocator.getService(LookupResultsService.class);
            Collection selectedBOs = service.retrieveSelectedResultBOs(lookupResultsSequenceNumber, lookupResultsBOClass, userName);
            this.processMultipleLookupResults(protocolDocument, lookupResultsBOClass, selectedBOs);
        }
        if (StringUtils.isNotBlank((String)protocolForm.getFormKey())) {
            protocolForm.setFormKey("");
        }
        return mapping.findForward("basic");
    }

    protected <T extends BusinessObject> void processMultipleLookupResults(ProtocolDocumentBase protocolDocument, Class<T> lookupResultsBOClass, Collection<T> selectedBOs) {
    }

    public ActionForward docHandler(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = null;
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        String command = protocolForm.getCommand();
        if (command.startsWith("displayDocSearchViewdetailId")) {
            // empty if block
        }
        if (!"displayActionListInlineView".equals(command)) {
            if (this.getProtocolActionsMappingNameHoook().equals(command) || this.getProtocolOnlineReviewMappingNameHoook().equals(command)) {
                String docIdRequestParameter = request.getParameter("docId");
                Document retrievedDocument = KRADServiceLocatorWeb.getDocumentService().getByDocumentHeaderId(docIdRequestParameter);
                protocolForm.setDocument(retrievedDocument);
                request.setAttribute("docId", (Object)docIdRequestParameter);
                this.loadDocument((KualiDocumentFormBase)protocolForm);
            } else {
                forward = super.docHandler(mapping, form, request, response);
            }
        }
        if ("initiate".equals(protocolForm.getCommand())) {
            protocolForm.getProtocolDocument().initialize();
        } else {
            protocolForm.initialize();
        }
        if (this.getProtocolActionsMappingNameHoook().equals(command)) {
            forward = this.protocolActions(mapping, (ActionForm)protocolForm, request, response);
        }
        if (this.getProtocolOnlineReviewMappingNameHoook().equals(command)) {
            forward = this.onlineReview(mapping, (ActionForm)protocolForm, request, response);
        }
        return forward;
    }

    protected abstract String getProtocolOnlineReviewMappingNameHoook();

    protected abstract String getProtocolActionsMappingNameHoook();

    protected KualiRuleService getKualiRuleService() {
        return (KualiRuleService)KraServiceLocator.getService(KualiRuleService.class);
    }

    protected final boolean applyRules(KualiDocumentEvent event) {
        return this.getKualiRuleService().applyRules(event);
    }

    public ActionForward onlineReview(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        return mapping.findForward(this.getProtocolOnlineReviewForwardNameHook());
    }

    private AnswerHeader getAnswerHeader(HttpServletRequest request) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("answerHeaderId", Integer.toString(this.getSelectedLine(request)));
        return (AnswerHeader)this.getBusinessObjectService().findByPrimaryKey(AnswerHeader.class, fieldValues);
    }

    private String getProtocolNumber(AnswerHeader answerHeader) {
        String protocolNumber = answerHeader.getModuleItemKey();
        if (protocolNumber.endsWith(SUFFIX_T)) {
            protocolNumber = protocolNumber.substring(0, protocolNumber.length() - 1);
        }
        return protocolNumber;
    }

    protected KraAuthorizationService getKraAuthorizationService() {
        return (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
    }

    protected UnitAclLoadService getUnitAclLoadService() {
        return (UnitAclLoadService)KraServiceLocator.getService(UnitAclLoadService.class);
    }

    protected abstract ProtocolPersonnelService getProtocolPersonnelService();

    protected abstract ProtocolPersonTrainingService getProtocolPersonTrainingService();

    protected QuestionnairePrintingService getQuestionnairePrintingService() {
        return (QuestionnairePrintingService)KraServiceLocator.getService(QuestionnairePrintingService.class);
    }

    public String buildForwardUrl(String routeHeaderId) {
        return super.buildForwardUrl(routeHeaderId);
    }

    protected List<String> getUnitRulesMessages(ProtocolDocumentBase protocolDoc) {
        KrmsRulesExecutionService rulesService = (KrmsRulesExecutionService)KraServiceLocator.getService(KrmsRulesExecutionService.class);
        return rulesService.processUnitValidations(protocolDoc.getProtocol().getLeadUnitNumber(), (KrmsRulesContext)protocolDoc);
    }

    public ActionForward printQuestionnaireAnswer(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = mapping.findForward("basic");
        HashMap<String, Object> reportParameters = new HashMap<String, Object>();
        ProtocolFormBase protocolForm = (ProtocolFormBase)form;
        ProtocolBase protocol = protocolForm.getActionHelper().getProtocol();
        int answerHeaderIndex = this.getSelectedLine(request);
        String methodToCall = (String)request.getAttribute("methodToCallAttribute");
        String formProperty = StringUtils.substringBetween((String)methodToCall, (String)".printQuestionnaireAnswer.", (String)".line");
        QuestionnaireHelperBase helper = (QuestionnaireHelperBase)BeanUtilsBean.getInstance().getPropertyUtils().getProperty((Object)form, formProperty);
        AnswerHeader answerHeader = (AnswerHeader)helper.getAnswerHeaders().get(answerHeaderIndex);
        reportParameters.put("questionnaireId", answerHeader.getQuestionnaire().getQuestionnaireIdAsInteger());
        reportParameters.put("template", answerHeader.getQuestionnaire().getTemplate());
        reportParameters.put("coeusModuleSubItemCode", answerHeader.getModuleSubItemCode());
        AttachmentDataSource dataStream = this.getQuestionnairePrintingService().printQuestionnaireAnswer((KraPersistableBusinessObjectBase)protocol, reportParameters);
        if (dataStream.getContent() != null) {
            this.streamToResponse(dataStream, response);
            forward = null;
        }
        return forward;
    }

    public ActionForward updateAnswerToNewVersion(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String methodToCallStart = "methodToCall.updateAnswerToNewVersion.";
        String methodToCallEnd = ".line";
        String methodToCall = (String)request.getAttribute("methodToCallAttribute");
        String questionnaireHelperPath = methodToCall.substring(methodToCallStart.length(), methodToCall.indexOf(methodToCallEnd));
        QuestionnaireHelperBase helper = (QuestionnaireHelperBase)PropertyUtils.getNestedProperty((Object)form, (String)questionnaireHelperPath);
        helper.updateQuestionnaireAnswer(this.getLineToDelete(request));
        this.getBusinessObjectService().save(helper.getAnswerHeaders());
        return mapping.findForward("basic");
    }

    public ActionForward recall(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        ReasonPrompt prompt = new ReasonPrompt(this, "DocRecall", "nonCancelling.recall.question.text", "nonCancellingRecallQuestion", "error.document.recall.reasonRequired", "recall", "1", "message.recall.noteTextIntro", null);
        ReasonPrompt.Response resp = prompt.ask(mapping, form, request, response);
        if (resp.forward != null) {
            forward = resp.forward;
        } else if ("DocRecall".equals(resp.question) && "0".equals(resp.button)) {
            KualiDocumentFormBase kualiDocumentFormBase = (KualiDocumentFormBase)form;
            this.doProcessingAfterPost((KualiForm)kualiDocumentFormBase, request);
            this.getDocumentService().recallDocument(kualiDocumentFormBase.getDocument(), resp.reason, false);
            forward = mapping.findForward("portal");
        } else {
            forward = mapping.findForward("basic");
        }
        return forward;
    }

    protected boolean applyRules(ProtocolFormBase protocolForm, KualiDocumentEvent event) {
        return this.applyRules(event) & !protocolForm.isUnitRulesErrorsExist();
    }

    protected boolean isInitialSave(Document document) {
        String status = document.getDocumentHeader().getWorkflowDocument().getStatus().getLabel();
        return GlobalVariables.getMessageMap().hasNoErrors() && StringUtils.equals((String)"INITIATED", (String)status);
    }

    protected KcNotificationService getNotificationService() {
        return (KcNotificationService)KraServiceLocator.getService(KcNotificationService.class);
    }

    static /* synthetic */ ConfigurationService access$000(ProtocolActionBase x0) {
        return x0.getKualiConfigurationService();
    }

    static /* synthetic */ ActionForward access$100(ProtocolActionBase x0, ActionMapping x1, ActionForm x2, HttpServletRequest x3, HttpServletResponse x4, String x5, String x6, String x7, String x8, String x9) throws Exception {
        return x0.performQuestionWithInput(x1, x2, x3, x4, x5, x6, x7, x8, x9);
    }

    static /* synthetic */ ConfigurationService access$200(ProtocolActionBase x0) {
        return x0.getKualiConfigurationService();
    }

    static /* synthetic */ ActionForward access$300(ProtocolActionBase x0, ActionMapping x1, ActionForm x2, HttpServletRequest x3, HttpServletResponse x4, String x5, String x6, String x7, String x8) throws Exception {
        return x0.checkAndWarnAboutSensitiveData(x1, x2, x3, x4, x5, x6, x7, x8);
    }

    static /* synthetic */ ConfigurationService access$400(ProtocolActionBase x0) {
        return x0.getKualiConfigurationService();
    }

    static /* synthetic */ ActionForward access$500(ProtocolActionBase x0, ActionMapping x1, ActionForm x2, HttpServletRequest x3, HttpServletResponse x4, String x5, String x6, String x7, String x8, String x9, String x10, String x11, String x12, String x13) throws Exception {
        return x0.performQuestionWithInputAgainBecauseOfErrors(x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13);
    }

    static /* synthetic */ DataDictionaryService access$600(ProtocolActionBase x0) {
        return x0.getDataDictionaryService();
    }

    static /* synthetic */ ConfigurationService access$700(ProtocolActionBase x0) {
        return x0.getKualiConfigurationService();
    }

    static /* synthetic */ ActionForward access$800(ProtocolActionBase x0, ActionMapping x1, ActionForm x2, HttpServletRequest x3, HttpServletResponse x4, String x5, String x6, String x7, String x8, String x9, String x10, String x11, String x12, String x13) throws Exception {
        return x0.performQuestionWithInputAgainBecauseOfErrors(x1, x2, x3, x4, x5, x6, x7, x8, x9, x10, x11, x12, x13);
    }
}

