/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.UnitAclLoadable;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.bo.CustomAttributeDocument;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.coi.Disclosurable;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.krms.KcKrmsContextBo;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolStatusBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionStatusBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentFilterBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.protocol.protocol.ProtocolTypeBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationService;
import org.kuali.kra.protocol.protocol.reference.ProtocolReferenceBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewBase;
import org.kuali.kra.protocol.summary.AdditionalInfoSummary;
import org.kuali.kra.protocol.summary.AttachmentSummary;
import org.kuali.kra.protocol.summary.FundingSourceSummary;
import org.kuali.kra.protocol.summary.OrganizationSummary;
import org.kuali.kra.protocol.summary.PersonnelSummary;
import org.kuali.kra.protocol.summary.ProtocolSummary;
import org.kuali.kra.protocol.summary.ResearchAreaSummary;
import org.kuali.kra.protocol.summary.SpecialReviewSummary;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class ProtocolBase
extends KraPersistableBusinessObjectBase
implements SequenceOwner<ProtocolBase>,
Permissionable,
UnitAclLoadable,
Disclosurable,
KcKrmsContextBo {
    private static final long serialVersionUID = -5556152547067349988L;
    protected static final CharSequence AMENDMENT_LETTER = "A";
    protected static final CharSequence RENEWAL_LETTER = "R";
    protected static final String NEXT_ACTION_ID_KEY = "actionId";
    private Long protocolId;
    private String protocolNumber;
    private Integer sequenceNumber = new Integer(0);
    private boolean active = true;
    private String protocolTypeCode;
    private String protocolStatusCode;
    private String title;
    private String description;
    private Date initialSubmissionDate;
    private Date approvalDate;
    private Date expirationDate;
    private Date lastApprovalDate;
    private String fdaApplicationNumber;
    private String referenceNumber1;
    private String referenceNumber2;
    private String specialReviewIndicator = "Y";
    private String keyStudyPersonIndicator;
    private String fundingSourceIndicator;
    private String correspondentIndicator;
    private String referenceIndicator;
    private String relatedProjectsIndicator;
    private ProtocolDocumentBase protocolDocument;
    private ProtocolStatusBase protocolStatus;
    private ProtocolTypeBase protocolType;
    private List<ProtocolResearchAreaBase> protocolResearchAreas = new ArrayList();
    private List<ProtocolReferenceBase> protocolReferences = new ArrayList();
    private List<ProtocolLocationBase> protocolLocations;
    private String newDescription = this.getDefaultNewDescription();
    private boolean nonEmployeeFlag;
    private List<ProtocolFundingSourceBase> protocolFundingSources;
    private String leadUnitNumber;
    private String principalInvestigatorId;
    private String keyPerson;
    private String investigator;
    private String fundingSource;
    private String performingOrganizationId;
    private String researchAreaCode;
    private String leadUnitName;
    private List<ProtocolPersonBase> protocolPersons;
    private List<ProtocolSpecialReviewBase> specialReviews;
    private List<ProtocolAttachmentProtocolBase> attachmentProtocols;
    private List<ProtocolNotepadBase> notepads;
    private List<ProtocolActionBase> protocolActions;
    private List<ProtocolSubmissionBase> protocolSubmissions;
    private ProtocolSubmissionBase protocolSubmission;
    private transient List<ProtocolActionBase> sortedActions;
    private List<ProtocolAmendRenewalBase> protocolAmendRenewals;
    private transient boolean correctionMode = false;
    private transient DateTimeService dateTimeService;
    private transient SequenceAccessorService sequenceAccessorService;
    private transient ProtocolAttachmentFilterBase protocolAttachmentFilter;
    private transient Long notifyIrbSubmissionId;
    private transient String initiatorLastUpdated;
    private transient String protocolSubmissionStatus;
    private transient boolean lookupPendingProtocol;
    private transient boolean lookupPendingPIActionProtocol;
    private transient boolean lookupActionAmendRenewProtocol;
    private transient boolean lookupActionRequestProtocol;
    private transient boolean lookupProtocolPersonId;
    private transient boolean mergeAmendment;

    public String getInitiatorLastUpdated() {
        return this.initiatorLastUpdated;
    }

    public String getProtocolSubmissionStatus() {
        return this.protocolSubmissionStatus;
    }

    public ProtocolBase() {
        this.protocolStatus = this.getProtocolStatusNewInstanceHook();
        this.protocolStatusCode = this.protocolStatus.getProtocolStatusCode();
        this.protocolLocations = new ArrayList();
        this.protocolPersons = new ArrayList();
        this.protocolTypeCode = this.getDefaultProtocolTypeCodeHook();
        this.protocolFundingSources = new ArrayList();
        this.specialReviews = new ArrayList();
        this.setProtocolActions(new ArrayList());
        this.setProtocolSubmissions(new ArrayList());
        this.protocolAmendRenewals = new ArrayList();
        this.setProtocolStatusCode(this.getDefaultProtocolStatusCodeHook());
        this.refreshReferenceObject("protocolStatus");
        this.initializeProtocolAttachmentFilter();
    }

    protected abstract ProtocolStatusBase getProtocolStatusNewInstanceHook();

    protected abstract String getDefaultProtocolStatusCodeHook();

    protected abstract String getDefaultProtocolTypeCodeHook();

    public Long getProtocolId() {
        return this.protocolId;
    }

    public void setProtocolId(Long protocolId) {
        this.protocolId = protocolId;
    }

    public String getProtocolNumber() {
        return this.protocolNumber;
    }

    public void setProtocolNumber(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getProtocolTypeCode() {
        return this.protocolTypeCode;
    }

    public void setProtocolTypeCode(String protocolTypeCode) {
        this.protocolTypeCode = protocolTypeCode;
    }

    public String getProtocolStatusCode() {
        return this.protocolStatusCode;
    }

    public void setProtocolStatusCode(String protocolStatusCode) {
        this.protocolStatusCode = protocolStatusCode;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getSubmissionDate() {
        Date submissionDate = null;
        if (this.protocolSubmissions.size() > 0) {
            submissionDate = this.getProtocolSubmission().getSubmissionDate();
        }
        return submissionDate;
    }

    public Date getInitialSubmissionDate() {
        return this.initialSubmissionDate;
    }

    public void setInitialSubmissionDate(Date initialSubmissionDate) {
        this.initialSubmissionDate = initialSubmissionDate;
    }

    public Date getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Date getLastApprovalDate() {
        return this.lastApprovalDate;
    }

    public void setLastApprovalDate(Date lastApprovalDate) {
        this.lastApprovalDate = lastApprovalDate;
    }

    public String getFdaApplicationNumber() {
        return this.fdaApplicationNumber;
    }

    public void setFdaApplicationNumber(String fdaApplicationNumber) {
        this.fdaApplicationNumber = fdaApplicationNumber;
    }

    public String getReferenceNumber1() {
        return this.referenceNumber1;
    }

    public void setReferenceNumber1(String referenceNumber1) {
        this.referenceNumber1 = referenceNumber1;
    }

    public String getReferenceNumber2() {
        return this.referenceNumber2;
    }

    public void setReferenceNumber2(String referenceNumber2) {
        this.referenceNumber2 = referenceNumber2;
    }

    public String getSpecialReviewIndicator() {
        return this.specialReviewIndicator;
    }

    public void setSpecialReviewIndicator(String specialReviewIndicator) {
        this.specialReviewIndicator = specialReviewIndicator;
    }

    public String getKeyStudyPersonIndicator() {
        return this.keyStudyPersonIndicator;
    }

    public void setKeyStudyPersonIndicator(String keyStudyPersonIndicator) {
        this.keyStudyPersonIndicator = keyStudyPersonIndicator;
    }

    public String getFundingSourceIndicator() {
        return this.fundingSourceIndicator;
    }

    public void setFundingSourceIndicator(String fundingSourceIndicator) {
        this.fundingSourceIndicator = fundingSourceIndicator;
    }

    public String getCorrespondentIndicator() {
        return this.correspondentIndicator;
    }

    public void setCorrespondentIndicator(String correspondentIndicator) {
        this.correspondentIndicator = correspondentIndicator;
    }

    public String getReferenceIndicator() {
        return this.referenceIndicator;
    }

    public void setReferenceIndicator(String referenceIndicator) {
        this.referenceIndicator = referenceIndicator;
    }

    public String getRelatedProjectsIndicator() {
        return this.relatedProjectsIndicator;
    }

    public void setRelatedProjectsIndicator(String relatedProjectsIndicator) {
        this.relatedProjectsIndicator = relatedProjectsIndicator;
    }

    public List<ProtocolOnlineReviewBase> getProtocolOnlineReviews() {
        ArrayList<ProtocolOnlineReviewBase> reviews = new ArrayList<ProtocolOnlineReviewBase>();
        for (ProtocolSubmissionBase submission : this.getProtocolSubmissions()) {
            reviews.addAll(submission.getProtocolOnlineReviews());
        }
        return reviews;
    }

    public ProtocolStatusBase getProtocolStatus() {
        return this.protocolStatus;
    }

    public void setProtocolStatus(ProtocolStatusBase protocolStatus) {
        this.protocolStatus = protocolStatus;
    }

    public ProtocolTypeBase getProtocolType() {
        return this.protocolType;
    }

    public void setProtocolType(ProtocolTypeBase protocolType) {
        this.protocolType = protocolType;
    }

    public String getNewDescription() {
        return this.newDescription;
    }

    public void setNewDescription(String newDescription) {
        this.newDescription = newDescription;
    }

    public String getDefaultNewDescription() {
        return "(select)";
    }

    public void setProtocolResearchAreas(List<ProtocolResearchAreaBase> protocolResearchAreas) {
        this.protocolResearchAreas = protocolResearchAreas;
        for (ProtocolResearchAreaBase researchArea : protocolResearchAreas) {
            researchArea.init(this);
        }
    }

    public List<ProtocolResearchAreaBase> getProtocolResearchAreas() {
        return this.protocolResearchAreas;
    }

    public void addProtocolResearchAreas(ProtocolResearchAreaBase protocolResearchArea) {
        this.getProtocolResearchAreas().add(protocolResearchArea);
    }

    public ProtocolResearchAreaBase getProtocolResearchAreas(int index) {
        while (this.getProtocolResearchAreas().size() <= index) {
            this.getProtocolResearchAreas().add(this.getNewProtocolResearchAreaInstance());
        }
        return (ProtocolResearchAreaBase)this.getProtocolResearchAreas().get(index);
    }

    protected abstract ProtocolResearchAreaBase getNewProtocolResearchAreaInstance();

    public void setProtocolReferences(List<ProtocolReferenceBase> protocolReferences) {
        this.protocolReferences = protocolReferences;
        for (ProtocolReferenceBase reference : protocolReferences) {
            reference.init(this);
        }
    }

    public List<ProtocolReferenceBase> getProtocolReferences() {
        return this.protocolReferences;
    }

    public ProtocolDocumentBase getProtocolDocument() {
        return this.protocolDocument;
    }

    public void setProtocolDocument(ProtocolDocumentBase protocolDocument) {
        this.protocolDocument = protocolDocument;
    }

    public void setProtocolLocations(List<ProtocolLocationBase> protocolLocations) {
        this.protocolLocations = protocolLocations;
        for (ProtocolLocationBase location : protocolLocations) {
            location.init(this);
        }
    }

    public List<ProtocolLocationBase> getProtocolLocations() {
        return this.protocolLocations;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        managedLists.add(this.protocolResearchAreas);
        managedLists.add(this.protocolReferences);
        managedLists.add(this.getProtocolFundingSources());
        managedLists.add(this.getProtocolLocations());
        managedLists.add(this.getProtocolAttachmentPersonnel());
        managedLists.add(this.getProtocolUnits());
        managedLists.add(this.getAttachmentProtocols());
        managedLists.add(this.getProtocolPersons());
        managedLists.add(this.getProtocolActions());
        managedLists.add(this.getProtocolSubmissions());
        if (this.getProtocolAmendRenewal() != null) {
            managedLists.add(this.getProtocolAmendRenewal().getModules());
        } else {
            managedLists.add(new ArrayList());
        }
        managedLists.add(this.getProtocolAmendRenewals());
        ArrayList specialReviewExemptions = new ArrayList();
        for (ProtocolSpecialReviewBase specialReview : this.getSpecialReviews()) {
            specialReviewExemptions.addAll(specialReview.getSpecialReviewExemptions());
        }
        managedLists.add(specialReviewExemptions);
        managedLists.add(this.getSpecialReviews());
        managedLists.add(this.getNotepads());
        return managedLists;
    }

    private List<ProtocolAttachmentPersonnelBase> getProtocolAttachmentPersonnel() {
        ArrayList<ProtocolAttachmentPersonnelBase> protocolAttachmentPersonnel = new ArrayList<ProtocolAttachmentPersonnelBase>();
        for (ProtocolPersonBase protocolPerson : this.getProtocolPersons()) {
            protocolAttachmentPersonnel.addAll(protocolPerson.getAttachmentPersonnels());
        }
        return protocolAttachmentPersonnel;
    }

    private List<ProtocolUnitBase> getProtocolUnits() {
        ArrayList<ProtocolUnitBase> protocolUnits = new ArrayList<ProtocolUnitBase>();
        for (ProtocolPersonBase protocolPerson : this.getProtocolPersons()) {
            protocolUnits.addAll(protocolPerson.getProtocolUnits());
        }
        return protocolUnits;
    }

    public ProtocolPersonBase getPrincipalInvestigator() {
        return this.getProtocolPersonnelService().getPrincipalInvestigator(this.getProtocolPersons());
    }

    public String getPrincipalInvestigatorName() {
        ProtocolPersonBase pi = this.getPrincipalInvestigator();
        return pi != null ? pi.getFullName() : null;
    }

    public ProtocolUnitBase getLeadUnit() {
        ProtocolUnitBase leadUnit = null;
        if (this.getPrincipalInvestigator() != null) {
            for (ProtocolUnitBase unit : this.getPrincipalInvestigator().getProtocolUnits()) {
                if (!unit.getLeadUnitFlag()) continue;
                leadUnit = unit;
            }
        }
        return leadUnit;
    }

    public String getLeadUnitNumber() {
        if (StringUtils.isBlank((String)this.leadUnitNumber) && this.getLeadUnit() != null) {
            this.setLeadUnitNumber(this.getLeadUnit().getUnitNumber());
        }
        return this.leadUnitNumber;
    }

    public void setLeadUnitNumber(String leadUnitNumber) {
        this.leadUnitNumber = leadUnitNumber;
    }

    public String getPrincipalInvestigatorId() {
        if (StringUtils.isBlank((String)this.principalInvestigatorId) && this.getPrincipalInvestigator() != null) {
            ProtocolPersonBase principalInvestigator = this.getPrincipalInvestigator();
            if (StringUtils.isNotBlank((String)principalInvestigator.getPersonId())) {
                this.setPrincipalInvestigatorId(principalInvestigator.getPersonId());
            } else if (principalInvestigator.getRolodexId() != null) {
                this.setPrincipalInvestigatorId(principalInvestigator.getRolodexId().toString());
            }
        }
        return this.principalInvestigatorId;
    }

    public void setPrincipalInvestigatorId(String principalInvestigatorId) {
        this.principalInvestigatorId = principalInvestigatorId;
    }

    public boolean isNonEmployeeFlag() {
        return this.nonEmployeeFlag;
    }

    public void setNonEmployeeFlag(boolean nonEmployeeFlag) {
        this.nonEmployeeFlag = nonEmployeeFlag;
    }

    protected ProtocolLocationService getProtocolLocationService() {
        ProtocolLocationService protocolLocationService = (ProtocolLocationService)KraServiceLocator.getService((String)"protocolLocationService");
        return protocolLocationService;
    }

    private void initializeProtocolLocation() {
        this.getProtocolLocationService().addDefaultProtocolLocation(this);
    }

    public List<ProtocolPersonBase> getProtocolPersons() {
        return this.protocolPersons;
    }

    public void setProtocolPersons(List<ProtocolPersonBase> protocolPersons) {
        this.protocolPersons = protocolPersons;
        for (ProtocolPersonBase person : protocolPersons) {
            person.init(this);
        }
    }

    public ProtocolPersonBase getProtocolPerson(int index) {
        return (ProtocolPersonBase)this.getProtocolPersons().get(index);
    }

    protected abstract ProtocolPersonnelService getProtocolPersonnelService();

    public List<ProtocolFundingSourceBase> getProtocolFundingSources() {
        return this.protocolFundingSources;
    }

    public void setProtocolFundingSources(List<ProtocolFundingSourceBase> protocolFundingSources) {
        this.protocolFundingSources = protocolFundingSources;
        for (ProtocolFundingSourceBase fundingSource : protocolFundingSources) {
            fundingSource.init(this);
        }
    }

    public String getResearchAreaCode() {
        return this.researchAreaCode;
    }

    public void setResearchAreaCode(String researchAreaCode) {
        this.researchAreaCode = researchAreaCode;
    }

    public String getFundingSource() {
        return this.fundingSource;
    }

    public void setFundingSource(String fundingSource) {
        this.fundingSource = fundingSource;
    }

    public String getPerformingOrganizationId() {
        return this.performingOrganizationId;
    }

    public void setPerformingOrganizationId(String performingOrganizationId) {
        this.performingOrganizationId = performingOrganizationId;
    }

    public String getLeadUnitName() {
        if (StringUtils.isBlank((String)this.leadUnitName) && this.getLeadUnit() != null) {
            this.setLeadUnitName(this.getLeadUnit().getUnitName());
        }
        return this.leadUnitName;
    }

    public void setLeadUnitName(String leadUnitName) {
        this.leadUnitName = leadUnitName;
    }

    public void setSpecialReviews(List<ProtocolSpecialReviewBase> specialReviews) {
        this.specialReviews = specialReviews;
    }

    public void addSpecialReview(ProtocolSpecialReviewBase specialReview) {
        specialReview.setSequenceOwner(this);
        this.getSpecialReviews().add(specialReview);
    }

    public ProtocolSpecialReviewBase getSpecialReview(int index) {
        return (ProtocolSpecialReviewBase)this.getSpecialReviews().get(index);
    }

    public List<ProtocolSpecialReviewBase> getSpecialReviews() {
        return this.specialReviews;
    }

    public List<ProtocolAttachmentProtocolBase> getAttachmentProtocols() {
        if (this.attachmentProtocols == null) {
            this.attachmentProtocols = new ArrayList();
        }
        return this.attachmentProtocols;
    }

    public ProtocolAttachmentProtocolBase getAttachmentProtocol(int index) {
        return (ProtocolAttachmentProtocolBase)this.attachmentProtocols.get(index);
    }

    public List<ProtocolNotepadBase> getNotepads() {
        if (this.notepads == null) {
            this.notepads = new ArrayList();
        }
        Collections.sort(this.notepads, Collections.reverseOrder());
        return this.notepads;
    }

    public ProtocolNotepadBase getNotepad(int index) {
        return (ProtocolNotepadBase)this.notepads.get(index);
    }

    private void addAttachmentProtocol(ProtocolAttachmentProtocolBase attachmentProtocol) {
        ProtocolAttachmentBase.addAttachmentToCollection((ProtocolAttachmentBase)attachmentProtocol, (Collection)this.getAttachmentProtocols());
    }

    private void removeAttachmentProtocol(ProtocolAttachmentProtocolBase attachmentProtocol) {
        ProtocolAttachmentBase.removeAttachmentFromCollection((ProtocolAttachmentBase)attachmentProtocol, (Collection)this.getAttachmentProtocols());
    }

    @Deprecated
    public List<ProtocolAttachmentPersonnelBase> getAttachmentPersonnels() {
        return this.getProtocolAttachmentPersonnel();
    }

    private void updateUserFields(KraPersistableBusinessObjectBase bo) {
        bo.setUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
        bo.setUpdateTimestamp(this.getDateTimeService().getCurrentTimestamp());
    }

    public <T extends ProtocolAttachmentBase> void addAttachmentsByType(T attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("the attachment is null");
        }
        this.updateUserFields(attachment);
        attachment.setProtocolId(this.getProtocolId());
        if (!(attachment instanceof ProtocolAttachmentProtocolBase)) {
            throw new IllegalArgumentException("unsupported type: " + attachment.getClass().getName());
        }
        this.addAttachmentProtocol((ProtocolAttachmentProtocolBase)attachment);
    }

    public <T extends ProtocolAttachmentBase> void removeAttachmentsByType(T attachment) {
        if (attachment == null) {
            throw new IllegalArgumentException("the attachment is null");
        }
        if (!(attachment instanceof ProtocolAttachmentProtocolBase)) {
            throw new IllegalArgumentException("unsupported type: " + attachment.getClass().getName());
        }
        this.removeAttachmentProtocol((ProtocolAttachmentProtocolBase)attachment);
    }

    public String getKeyPerson() {
        return this.keyPerson;
    }

    public void setKeyPerson(String keyPerson) {
        this.keyPerson = keyPerson;
    }

    public String getInvestigator() {
        if (StringUtils.isBlank((String)this.principalInvestigatorId) && this.getPrincipalInvestigator() != null) {
            this.investigator = this.getPrincipalInvestigator().getPersonName();
        }
        return this.investigator;
    }

    public void setInvestigator(String investigator) {
        this.investigator = investigator;
    }

    public ProtocolSubmissionBase getProtocolSubmission() {
        if (!this.protocolSubmissions.isEmpty()) {
            if (this.protocolSubmission == null || this.protocolSubmission.getSubmissionNumber() == null || ((ProtocolSubmissionBase)this.protocolSubmissions.get(this.protocolSubmissions.size() - 1)).getSubmissionNumber() > this.protocolSubmission.getSubmissionNumber()) {
                this.protocolSubmission = (ProtocolSubmissionBase)this.protocolSubmissions.get(this.protocolSubmissions.size() - 1);
            }
        } else {
            this.protocolSubmission = this.getProtocolSubmissionNewInstanceHook();
            this.protocolSubmission.setProtocolSubmissionType(this.getProtocolSubmissionTypeNewInstanceHook());
            this.protocolSubmission.setSubmissionStatus(this.getProtocolSubmissionStatusNewInstanceHook());
        }
        this.refreshReferenceObject(this.protocolSubmission);
        return this.protocolSubmission;
    }

    protected abstract ProtocolSubmissionStatusBase getProtocolSubmissionStatusNewInstanceHook();

    protected abstract ProtocolSubmissionTypeBase getProtocolSubmissionTypeNewInstanceHook();

    protected abstract ProtocolSubmissionBase getProtocolSubmissionNewInstanceHook();

    private void refreshReferenceObject(ProtocolSubmissionBase submission) {
        if (StringUtils.isNotBlank((String)submission.getProtocolReviewTypeCode()) && submission.getProtocolReviewType() == null) {
            submission.refreshReferenceObject("protocolReviewType");
        }
        if (StringUtils.isNotBlank((String)submission.getSubmissionStatusCode()) && submission.getSubmissionStatus() == null) {
            submission.refreshReferenceObject("submissionStatus");
        }
        if (StringUtils.isNotBlank((String)submission.getSubmissionTypeCode()) && submission.getProtocolSubmissionType() == null) {
            submission.refreshReferenceObject("protocolSubmissionType");
        }
        if (StringUtils.isNotBlank((String)submission.getSubmissionTypeQualifierCode()) && submission.getProtocolSubmissionQualifierType() == null) {
            submission.refreshReferenceObject("protocolSubmissionQualifierType");
        }
    }

    public void setProtocolSubmission(ProtocolSubmissionBase protocolSubmission) {
        this.protocolSubmission = protocolSubmission;
    }

    public void setProtocolActions(List<ProtocolActionBase> protocolActions) {
        this.protocolActions = protocolActions;
    }

    public List<ProtocolActionBase> getProtocolActions() {
        return this.protocolActions;
    }

    public ProtocolActionBase getLastProtocolAction() {
        if (this.protocolActions.size() == 0) {
            return null;
        }
        Collections.sort(this.protocolActions, new /* Unavailable Anonymous Inner Class!! */);
        return (ProtocolActionBase)this.protocolActions.get(0);
    }

    public void setProtocolSubmissions(List<ProtocolSubmissionBase> protocolSubmissions) {
        this.protocolSubmissions = protocolSubmissions;
    }

    public List<ProtocolSubmissionBase> getProtocolSubmissions() {
        return this.protocolSubmissions;
    }

    public Integer getNextValue(String key) {
        return this.protocolDocument.getDocumentNextValue(key);
    }

    public void setAttachmentProtocols(List<ProtocolAttachmentProtocolBase> attachmentProtocols) {
        this.attachmentProtocols = attachmentProtocols;
        for (ProtocolAttachmentProtocolBase attachment : attachmentProtocols) {
            attachment.resetPersistenceState();
            attachment.setSequenceNumber(Integer.valueOf(0));
        }
    }

    public void setNotepads(List<ProtocolNotepadBase> notepads) {
        this.notepads = notepads;
    }

    public void setProtocolAmendRenewal(ProtocolAmendRenewalBase amendRenewal) {
        this.protocolAmendRenewals.add(amendRenewal);
    }

    public ProtocolAmendRenewalBase getProtocolAmendRenewal() {
        if (this.protocolAmendRenewals.size() == 0) {
            return null;
        }
        return (ProtocolAmendRenewalBase)this.protocolAmendRenewals.get(0);
    }

    public List<ProtocolAmendRenewalBase> getProtocolAmendRenewals() {
        return this.protocolAmendRenewals;
    }

    public void setProtocolAmendRenewals(List<ProtocolAmendRenewalBase> protocolAmendRenewals) {
        this.protocolAmendRenewals = protocolAmendRenewals;
    }

    public Integer getOwnerSequenceNumber() {
        return null;
    }

    public String getVersionNameField() {
        return "protocolNumber";
    }

    public void incrementSequenceNumber() {
        ProtocolBase protocolBase = this;
        Integer n = protocolBase.sequenceNumber;
        Integer n2 = protocolBase.sequenceNumber = Integer.valueOf(protocolBase.sequenceNumber + 1);
    }

    public ProtocolBase getSequenceOwner() {
        return this;
    }

    public void setSequenceOwner(ProtocolBase newOwner) {
    }

    public void resetPersistenceState() {
        this.protocolId = null;
    }

    public void merge(ProtocolBase amendment) {
        this.merge(amendment, true);
    }

    public void merge(ProtocolBase amendment, boolean mergeActions) {
        this.lastApprovalDate = amendment.getLastApprovalDate();
        List modules = amendment.getProtocolAmendRenewal().getModules();
        for (ProtocolAmendRenewModuleBase module : modules) {
            this.merge(amendment, module.getProtocolModuleTypeCode());
        }
        if (amendment.isRenewalWithoutAmendment() && this.isRenewalWithNewAttachment(amendment)) {
            this.merge(amendment, this.getProtocolModuleAddModifyAttachmentCodeHook());
        }
        if (mergeActions) {
            this.mergeProtocolSubmission(amendment);
            this.mergeProtocolAction(amendment);
        }
        if (amendment.isRenewal()) {
            this.setExpirationDate(amendment.getExpirationDate());
        }
    }

    protected abstract String getProtocolModuleAddModifyAttachmentCodeHook();

    private boolean isRenewalWithNewAttachment(ProtocolBase renewal) {
        boolean hasNewAttachment = false;
        for (ProtocolAttachmentProtocolBase attachment : renewal.getAttachmentProtocols()) {
            if (!attachment.isDraft()) continue;
            hasNewAttachment = true;
            break;
        }
        return hasNewAttachment;
    }

    public abstract void merge(ProtocolBase var1, String var2);

    protected void mergeProtocolQuestionnaire(ProtocolBase amendment) {
        this.removeOldQuestionnaire();
        this.amendQuestionnaire(amendment);
    }

    protected void removeOldQuestionnaire() {
        List answerHeaders = this.getAnswerHeaderForProtocol(this);
        if (!answerHeaders.isEmpty() && ((AnswerHeader)answerHeaders.get(0)).getAnswerHeaderId() != null) {
            this.getBusinessObjectService().delete(answerHeaders);
        }
    }

    protected void amendQuestionnaire(ProtocolBase amendment) {
        List answerHeaders = this.getAnswerHeaderForProtocol(amendment);
        if (!answerHeaders.isEmpty()) {
            for (AnswerHeader answerHeader : answerHeaders) {
                for (Answer answer : answerHeader.getAnswers()) {
                    answer.setAnswerHeaderIdFk(null);
                    answer.setId(null);
                }
                answerHeader.setAnswerHeaderId(null);
                answerHeader.setModuleItemKey(this.getProtocolNumber());
                answerHeader.setModuleSubItemKey(this.getSequenceNumber().toString());
            }
            this.getBusinessObjectService().save(answerHeaders);
        }
    }

    protected abstract List<AnswerHeader> getAnswerHeaderForProtocol(ProtocolBase var1);

    protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return (QuestionnaireAnswerService)KraServiceLocator.getService(QuestionnaireAnswerService.class);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    protected void mergeProtocolSubmission(ProtocolBase amendment) {
        List submissions = (List)this.deepCopy((Object)amendment.getProtocolSubmissions());
        for (ProtocolSubmissionBase submission : submissions) {
            submission.setProtocolNumber(this.getProtocolNumber());
            submission.setSubmissionId(null);
            submission.setSequenceNumber(this.sequenceNumber);
            submission.setProtocolId(this.getProtocolId());
            this.getProtocolSubmissions().add(submission);
        }
    }

    protected abstract void mergeProtocolAction(ProtocolBase var1);

    protected void mergeGeneralInfo(ProtocolBase amendment) {
        this.protocolTypeCode = amendment.getProtocolTypeCode();
        this.title = amendment.getTitle();
        this.initialSubmissionDate = amendment.getInitialSubmissionDate();
        this.approvalDate = amendment.getApprovalDate();
        this.expirationDate = amendment.getExpirationDate();
        this.description = amendment.getDescription();
        this.fdaApplicationNumber = amendment.getFdaApplicationNumber();
        this.referenceNumber1 = amendment.getReferenceNumber1();
        this.referenceNumber2 = amendment.getReferenceNumber2();
    }

    protected void mergeResearchAreas(ProtocolBase amendment) {
        this.setProtocolResearchAreas((List)this.deepCopy((Object)amendment.getProtocolResearchAreas()));
    }

    protected void mergeFundingSources(ProtocolBase amendment) {
        this.setProtocolFundingSources((List)this.deepCopy((Object)amendment.getProtocolFundingSources()));
    }

    protected void mergeReferences(ProtocolBase amendment) {
        this.setProtocolReferences((List)this.deepCopy((Object)amendment.getProtocolReferences()));
        this.fdaApplicationNumber = amendment.getFdaApplicationNumber();
        this.referenceNumber1 = amendment.getReferenceNumber1();
        this.referenceNumber2 = amendment.getReferenceNumber2();
        this.description = amendment.getDescription();
    }

    protected void mergeOrganizations(ProtocolBase amendment) {
        this.setProtocolLocations((List)this.deepCopy((Object)amendment.getProtocolLocations()));
    }

    protected void mergeAttachments(ProtocolBase amendment) {
        ArrayList<ProtocolAttachmentProtocolBase> attachmentProtocols = new ArrayList<ProtocolAttachmentProtocolBase>();
        for (ProtocolAttachmentProtocolBase attachment : (List)this.deepCopy((Object)amendment.getAttachmentProtocols())) {
            attachment.setProtocolNumber(this.getProtocolNumber());
            attachment.setSequenceNumber(this.getSequenceNumber());
            attachment.setProtocolId(this.getProtocolId());
            attachment.setId(null);
            if (attachment.getFile() != null) {
                attachment.getFile().setId(null);
            }
            if (attachment.isDraft()) {
                attachment.setDocumentStatusCode("2");
                attachmentProtocols.add(attachment);
                attachment.setProtocol(this);
            }
            if (!attachment.isDeleted() || !((ProtocolAttachmentService)KraServiceLocator.getService(ProtocolAttachmentService.class)).isNewAttachmentVersion(attachment)) continue;
            attachmentProtocols.add(attachment);
            attachment.setProtocol(this);
        }
        this.getAttachmentProtocols().addAll(attachmentProtocols);
        this.removeDeletedAttachment();
        this.mergeNotepads(amendment);
    }

    private void removeDeletedAttachment() {
        ArrayList<Integer> documentIds = new ArrayList<Integer>();
        ArrayList<ProtocolAttachmentProtocolBase> attachments = new ArrayList<ProtocolAttachmentProtocolBase>();
        for (ProtocolAttachmentProtocolBase attachment : this.getAttachmentProtocols()) {
            attachment.setProtocol(this);
            if (!attachment.isDeleted()) continue;
            documentIds.add(attachment.getDocumentId());
        }
        if (!documentIds.isEmpty()) {
            for (ProtocolAttachmentProtocolBase attachment : this.getAttachmentProtocols()) {
                attachment.setProtocol(this);
                if (documentIds.contains(attachment.getDocumentId())) continue;
                attachments.add(attachment);
            }
            this.setAttachmentProtocols(new ArrayList());
            this.getAttachmentProtocols().addAll(attachments);
        }
    }

    protected void restoreAttachments(ProtocolBase protocol) {
        ArrayList<ProtocolAttachmentProtocolBase> attachmentProtocols = new ArrayList<ProtocolAttachmentProtocolBase>();
        ArrayList<ProtocolAttachmentProtocolBase> deleteAttachments = new ArrayList<ProtocolAttachmentProtocolBase>();
        ArrayList<AttachmentFile> deleteFiles = new ArrayList<AttachmentFile>();
        for (ProtocolAttachmentProtocolBase attachment : this.getAttachmentProtocols()) {
            if (attachment.isFinal()) {
                attachmentProtocols.add(attachment);
                continue;
            }
            deleteAttachments.add(attachment);
            if (!this.fileIsReferencedByOther(attachment.getFileId())) {
                deleteFiles.add(attachment.getFile());
            }
            attachment.setFileId(null);
        }
        if (!deleteAttachments.isEmpty()) {
            this.getBusinessObjectService().save(deleteAttachments);
            if (!deleteFiles.isEmpty()) {
                this.getBusinessObjectService().delete(deleteFiles);
            }
            this.getBusinessObjectService().delete(deleteAttachments);
        }
        this.getAttachmentProtocols().clear();
        this.getAttachmentProtocols().addAll(attachmentProtocols);
        this.mergeNotepads(protocol);
    }

    private boolean fileIsReferencedByOther(Long fileId) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("fileId", fileId.toString());
        return this.getBusinessObjectService().countMatching(this.getProtocolAttachmentProtocolClassHook(), fieldValues) > 1;
    }

    protected abstract Class<? extends ProtocolAttachmentProtocolBase> getProtocolAttachmentProtocolClassHook();

    protected void mergeNotepads(ProtocolBase amendment) {
        ArrayList<ProtocolNotepadBase> notepads = new ArrayList<ProtocolNotepadBase>();
        if (amendment.getNotepads() != null) {
            for (ProtocolNotepadBase notepad : (List)this.deepCopy((Object)amendment.getNotepads())) {
                notepad.setProtocolNumber(this.getProtocolNumber());
                notepad.setSequenceNumber(this.getSequenceNumber());
                notepad.setProtocolId(this.getProtocolId());
                notepad.setId(null);
                notepad.setProtocol(this);
                notepads.add(notepad);
            }
        }
        this.setNotepads(notepads);
    }

    private ProtocolPersonBase findMatchingPerson(ProtocolPersonBase person) {
        ProtocolPersonBase matchingPerson = null;
        for (ProtocolPersonBase newPerson : this.getProtocolPersons()) {
            if (!newPerson.getProtocolPersonRoleId().equals(person.getProtocolPersonRoleId()) || (!StringUtils.isNotBlank((String)newPerson.getPersonId()) || !StringUtils.isNotBlank((String)person.getPersonId()) || !newPerson.getPersonId().equals(person.getPersonId())) && (newPerson.getRolodexId() == null || person.getRolodexId() == null || !newPerson.getRolodexId().equals(person.getRolodexId()))) continue;
            matchingPerson = newPerson;
            break;
        }
        return matchingPerson;
    }

    protected void mergeSpecialReview(ProtocolBase amendment) {
        this.setSpecialReviews((List)this.deepCopy((Object)amendment.getSpecialReviews()));
        this.cleanupSpecialReviews(amendment);
    }

    protected void mergePersonnel(ProtocolBase amendment) {
        this.setProtocolPersons((List)this.deepCopy((Object)amendment.getProtocolPersons()));
        for (ProtocolPersonBase person : this.protocolPersons) {
            Integer nextPersonId = this.getSequenceAccessorService().getNextAvailableSequenceNumber("SEQ_PROTOCOL_ID").intValue();
            person.setProtocolPersonId(nextPersonId);
            for (ProtocolAttachmentPersonnelBase protocolAttachmentPersonnel : person.getAttachmentPersonnels()) {
                protocolAttachmentPersonnel.setId(null);
                protocolAttachmentPersonnel.setPersonId(person.getProtocolPersonId());
                protocolAttachmentPersonnel.setProtocolId(this.getProtocolId());
                protocolAttachmentPersonnel.setProtocolNumber(this.getProtocolNumber());
            }
        }
    }

    protected void mergeOthers(ProtocolBase amendment) {
        if (this.protocolDocument.getCustomAttributeDocuments() == null || this.protocolDocument.getCustomAttributeDocuments().isEmpty()) {
            this.protocolDocument.initialize();
        }
        if (amendment.getProtocolDocument().getCustomAttributeDocuments() == null || amendment.getProtocolDocument().getCustomAttributeDocuments().isEmpty()) {
            amendment.getProtocolDocument().initialize();
        }
        for (Map.Entry entry : this.protocolDocument.getCustomAttributeDocuments().entrySet()) {
            CustomAttributeDocument cad = (CustomAttributeDocument)amendment.getProtocolDocument().getCustomAttributeDocuments().get(entry.getKey());
            ((CustomAttributeDocument)entry.getValue()).getCustomAttribute().setValue(cad.getCustomAttribute().getValue());
        }
    }

    protected void mergeProtocolPermissions(ProtocolBase amendment) {
    }

    protected Object deepCopy(Object obj) {
        return ObjectUtils.deepCopy((Serializable)((Serializable)obj));
    }

    public abstract ProtocolSummary getProtocolSummary();

    protected void addAdditionalInfoSummary(ProtocolSummary protocolSummary) {
        AdditionalInfoSummary additionalInfoSummary = new AdditionalInfoSummary();
        additionalInfoSummary.setFdaApplicationNumber(this.getFdaApplicationNumber());
        additionalInfoSummary.setReferenceId1(this.getReferenceNumber1());
        additionalInfoSummary.setReferenceId2(this.getReferenceNumber2());
        additionalInfoSummary.setDescription(this.getDescription());
        protocolSummary.setAdditionalInfo(additionalInfoSummary);
    }

    protected void addSpecialReviewSummaries(ProtocolSummary protocolSummary) {
        for (ProtocolSpecialReviewBase specialReview : this.getSpecialReviews()) {
            SpecialReviewSummary specialReviewSummary = new SpecialReviewSummary();
            if (specialReview.getSpecialReviewType() == null) {
                specialReview.refreshReferenceObject("specialReviewType");
            }
            specialReviewSummary.setType(specialReview.getSpecialReviewType().getDescription());
            if (specialReview.getApprovalType() == null) {
                specialReview.refreshReferenceObject("approvalType");
            }
            specialReviewSummary.setApprovalStatus(specialReview.getApprovalType().getDescription());
            specialReviewSummary.setProtocolNumber(specialReview.getProtocolNumber());
            specialReviewSummary.setApplicationDate(specialReview.getApplicationDate());
            specialReviewSummary.setApprovalDate(specialReview.getApprovalDate());
            specialReviewSummary.setExpirationDate(specialReview.getExpirationDate());
            if (specialReview.getSpecialReviewExemptions() == null) {
                specialReview.refreshReferenceObject("specialReviewExemptions");
            }
            specialReviewSummary.setExemptionNumbers(specialReview.getSpecialReviewExemptions());
            specialReviewSummary.setComment(specialReview.getComments());
            protocolSummary.add(specialReviewSummary);
        }
    }

    protected void addOrganizationSummaries(ProtocolSummary protocolSummary) {
        for (ProtocolLocationBase organization : this.getProtocolLocations()) {
            OrganizationSummary organizationSummary = new OrganizationSummary();
            organizationSummary.setId(organization.getOrganizationId());
            organizationSummary.setOrganizationId(organization.getOrganizationId());
            organizationSummary.setName(organization.getOrganization().getOrganizationName());
            organizationSummary.setType(organization.getProtocolOrganizationType().getDescription());
            organizationSummary.setContactId(organization.getRolodexId());
            organizationSummary.setContact(organization.getRolodex());
            organizationSummary.setFwaNumber(organization.getOrganization().getHumanSubAssurance());
            protocolSummary.add(organizationSummary);
        }
    }

    protected void addFundingSourceSummaries(ProtocolSummary protocolSummary) {
        for (ProtocolFundingSourceBase source : this.getProtocolFundingSources()) {
            FundingSourceSummary fundingSourceSummary = new FundingSourceSummary();
            fundingSourceSummary.setFundingSourceType(source.getFundingSourceType().getDescription());
            fundingSourceSummary.setFundingSource(source.getFundingSourceNumber());
            fundingSourceSummary.setFundingSourceNumber(source.getFundingSourceNumber());
            fundingSourceSummary.setFundingSourceName(source.getFundingSourceName());
            fundingSourceSummary.setFundingSourceTitle(source.getFundingSourceTitle());
            protocolSummary.add(fundingSourceSummary);
        }
    }

    protected void addAttachmentSummaries(ProtocolSummary protocolSummary) {
        for (ProtocolAttachmentProtocolBase attachment : this.getActiveAttachmentProtocols()) {
            if (attachment.isDeleted()) continue;
            AttachmentSummary attachmentSummary = new AttachmentSummary();
            attachmentSummary.setAttachmentId(attachment.getId());
            attachmentSummary.setFileType(attachment.getFile().getType());
            attachmentSummary.setFileName(attachment.getFile().getName());
            attachmentSummary.setAttachmentType("Protocol: " + attachment.getType().getDescription());
            attachmentSummary.setDescription(attachment.getDescription());
            attachmentSummary.setDataLength(attachment.getFile().getData() == null ? 0L : (long)attachment.getFile().getData().length);
            attachmentSummary.setUpdateTimestamp(attachment.getUpdateTimestamp());
            attachmentSummary.setUpdateUser(attachment.getUpdateUser());
            protocolSummary.add(attachmentSummary);
        }
        for (ProtocolPersonBase person : this.getProtocolPersons()) {
            for (ProtocolAttachmentPersonnelBase attachment : person.getAttachmentPersonnels()) {
                AttachmentSummary attachmentSummary = new AttachmentSummary();
                attachmentSummary.setAttachmentId(attachment.getId());
                attachmentSummary.setFileType(attachment.getFile().getType());
                attachmentSummary.setFileName(attachment.getFile().getName());
                attachmentSummary.setAttachmentType(person.getPersonName() + ": " + attachment.getType().getDescription());
                attachmentSummary.setDescription(attachment.getDescription());
                attachmentSummary.setDataLength(attachment.getFile().getData() == null ? 0L : (long)attachment.getFile().getData().length);
                attachmentSummary.setUpdateTimestamp(attachment.getUpdateTimestamp());
                attachmentSummary.setUpdateUser(attachment.getUpdateUser());
                protocolSummary.add(attachmentSummary);
            }
        }
    }

    protected void addResearchAreaSummaries(ProtocolSummary protocolSummary) {
        for (ProtocolResearchAreaBase researchArea : this.getProtocolResearchAreas()) {
            ResearchAreaSummary researchAreaSummary = new ResearchAreaSummary();
            researchAreaSummary.setResearchAreaCode(researchArea.getResearchAreaCode());
            researchAreaSummary.setDescription(researchArea.getResearchAreas().getDescription());
            protocolSummary.add(researchAreaSummary);
        }
    }

    protected void addPersonnelSummaries(ProtocolSummary protocolSummary) {
        for (ProtocolPersonBase person : this.getProtocolPersons()) {
            PersonnelSummary personnelSummary = new PersonnelSummary();
            personnelSummary.setPersonId(person.getPersonId());
            personnelSummary.setName(person.getPersonName());
            personnelSummary.setRoleName(person.getProtocolPersonRole().getDescription());
            if (person.getAffiliationTypeCode() == null) {
                personnelSummary.setAffiliation("");
            } else {
                if (person.getAffiliationType() == null) {
                    person.refreshReferenceObject("affiliationType");
                }
                personnelSummary.setAffiliation(person.getAffiliationType().getDescription());
            }
            for (ProtocolUnitBase unit : person.getProtocolUnits()) {
                personnelSummary.addUnit(unit.getUnitNumber(), unit.getUnitName());
            }
            protocolSummary.add(personnelSummary);
        }
    }

    protected abstract ProtocolSummary createProtocolSummary();

    public abstract String getDocumentKey();

    public String getDocumentNumberForPermission() {
        return this.protocolNumber;
    }

    public abstract List<String> getRoleNames();

    public void resetForeignKeys() {
        for (ProtocolActionBase action : this.protocolActions) {
            action.resetForeignKeys();
        }
    }

    public void resetPersistenceStateForNotifications() {
        for (ProtocolActionBase action : this.protocolActions) {
            for (KcNotification notification : action.getProtocolNotifications()) {
                notification.resetPersistenceState();
            }
        }
    }

    public abstract String getNamespace();

    public String getDocumentUnitNumber() {
        return this.getLeadUnitNumber();
    }

    public abstract String getDocumentRoleTypeCode();

    public void populateAdditionalQualifiedRoleAttributes(Map<String, String> qualifiedRoleAttributes) {
    }

    public boolean isNew() {
        return !this.isAmendment() && !this.isRenewal();
    }

    public boolean isAmendment() {
        return this.protocolNumber != null && this.protocolNumber.contains(AMENDMENT_LETTER);
    }

    public boolean isRenewal() {
        return this.protocolNumber.contains(RENEWAL_LETTER);
    }

    public boolean isRenewalWithoutAmendment() {
        return this.isRenewal() && CollectionUtils.isEmpty((Collection)this.getProtocolAmendRenewal().getModules());
    }

    public String getAmendedProtocolNumber() {
        if (this.isAmendment()) {
            return StringUtils.substringBefore((String)this.getProtocolNumber(), (String)AMENDMENT_LETTER.toString());
        }
        if (this.isRenewal()) {
            return StringUtils.substringBefore((String)this.getProtocolNumber(), (String)RENEWAL_LETTER.toString());
        }
        return null;
    }

    public boolean isVersioningRequired() {
        return true;
    }

    public List<ProtocolAttachmentProtocolBase> getActiveAttachmentProtocols() {
        ArrayList<ProtocolAttachmentProtocolBase> activeAttachments = new ArrayList<ProtocolAttachmentProtocolBase>();
        for (ProtocolAttachmentProtocolBase attachment1 : this.getAttachmentProtocols()) {
            if (attachment1.isDraft()) {
                activeAttachments.add(attachment1);
                continue;
            }
            if (attachment1.isFinal() || attachment1.isDeleted()) {
                boolean isActive = true;
                for (ProtocolAttachmentProtocolBase attachment2 : this.getAttachmentProtocols()) {
                    if (!attachment1.getDocumentId().equals(attachment2.getDocumentId()) || attachment1.getAttachmentVersion() >= attachment2.getAttachmentVersion()) continue;
                    isActive = false;
                    break;
                }
                if (isActive) {
                    activeAttachments.add(attachment1);
                    continue;
                }
                attachment1.setActive(isActive);
                continue;
            }
            attachment1.setActive(false);
        }
        return activeAttachments;
    }

    public List<ProtocolAttachmentProtocolBase> getActiveAttachmentProtocolsNoDelete() {
        ArrayList<Integer> documentIds = new ArrayList<Integer>();
        ArrayList<ProtocolAttachmentProtocolBase> activeAttachments = new ArrayList<ProtocolAttachmentProtocolBase>();
        for (ProtocolAttachmentProtocolBase attachment : this.getActiveAttachmentProtocols()) {
            if (!attachment.isDeleted()) continue;
            documentIds.add(attachment.getDocumentId());
        }
        for (ProtocolAttachmentProtocolBase attachment : this.getActiveAttachmentProtocols()) {
            if (documentIds.isEmpty() || !documentIds.contains(attachment.getDocumentId())) {
                activeAttachments.add(attachment);
                continue;
            }
            attachment.setActive(false);
        }
        return activeAttachments;
    }

    public boolean isCorrectionMode() {
        return this.correctionMode;
    }

    public void setCorrectionMode(boolean correctionMode) {
        this.correctionMode = correctionMode;
    }

    protected DateTimeService getDateTimeService() {
        if (this.dateTimeService == null) {
            this.dateTimeService = (DateTimeService)KraServiceLocator.getService(DateTimeService.class);
        }
        return this.dateTimeService;
    }

    protected SequenceAccessorService getSequenceAccessorService() {
        if (this.sequenceAccessorService == null) {
            this.sequenceAccessorService = (SequenceAccessorService)KraServiceLocator.getService(SequenceAccessorService.class);
        }
        return this.sequenceAccessorService;
    }

    public Long getNotifyIrbSubmissionId() {
        return this.notifyIrbSubmissionId;
    }

    public void setNotifyIrbSubmissionId(Long notifyIrbSubmissionId) {
        this.notifyIrbSubmissionId = notifyIrbSubmissionId;
    }

    public boolean isLookupPendingProtocol() {
        return this.lookupPendingProtocol;
    }

    public void setLookupPendingProtocol(boolean lookupPendingProtocol) {
        this.lookupPendingProtocol = lookupPendingProtocol;
    }

    public boolean isLookupPendingPIActionProtocol() {
        return this.lookupPendingPIActionProtocol;
    }

    public void setLookupPendingPIActionProtocol(boolean lookupPendingPIActionProtocol) {
        this.lookupPendingPIActionProtocol = lookupPendingPIActionProtocol;
    }

    public boolean isLookupActionAmendRenewProtocol() {
        return this.lookupActionAmendRenewProtocol;
    }

    public void setLookupActionAmendRenewProtocol(boolean lookupActionAmendRenewProtocol) {
        this.lookupActionAmendRenewProtocol = lookupActionAmendRenewProtocol;
    }

    public boolean isLookupActionRequestProtocol() {
        return this.lookupActionRequestProtocol;
    }

    public void setLookupActionRequestProtocol(boolean lookupActionRequestProtocol) {
        this.lookupActionRequestProtocol = lookupActionRequestProtocol;
    }

    public boolean isLookupProtocolPersonId() {
        return this.lookupProtocolPersonId;
    }

    public void setLookupProtocolPersonId(boolean lookupProtocolPersonId) {
        this.lookupProtocolPersonId = lookupProtocolPersonId;
    }

    public boolean isFollowupAction(String actionTypeCode) {
        return this.getLastProtocolAction() == null || StringUtils.isBlank((String)this.getLastProtocolAction().getFollowupActionCode()) ? false : actionTypeCode.equals(this.getLastProtocolAction().getFollowupActionCode());
    }

    public boolean isMergeAmendment() {
        return this.mergeAmendment;
    }

    public void setMergeAmendment(boolean mergeAmendment) {
        this.mergeAmendment = mergeAmendment;
    }

    public ProtocolAttachmentFilterBase getProtocolAttachmentFilter() {
        return this.protocolAttachmentFilter;
    }

    public void setProtocolAttachmentFilter(ProtocolAttachmentFilterBase protocolAttachmentFilter) {
        this.protocolAttachmentFilter = protocolAttachmentFilter;
    }

    public List<ProtocolAttachmentProtocolBase> getFilteredAttachmentProtocols() {
        ArrayList<ProtocolAttachmentProtocolBase> filteredAttachments = new ArrayList();
        ProtocolAttachmentFilterBase attachmentFilter = this.getProtocolAttachmentFilter();
        if (attachmentFilter != null && StringUtils.isNotBlank((String)attachmentFilter.getFilterBy())) {
            for (ProtocolAttachmentProtocolBase attachment1 : this.getAttachmentProtocols()) {
                if (!attachment1.getTypeCode().equals(attachmentFilter.getFilterBy())) continue;
                filteredAttachments.add(attachment1);
            }
        } else {
            filteredAttachments = this.getAttachmentProtocols();
        }
        if (attachmentFilter != null && StringUtils.isNotBlank((String)attachmentFilter.getSortBy())) {
            Collections.sort(filteredAttachments, attachmentFilter.getProtocolAttachmentComparator());
        }
        return filteredAttachments;
    }

    public abstract void initializeProtocolAttachmentFilter();

    public ParameterService getParameterService() {
        return (ParameterService)KraServiceLocator.getService(ParameterService.class);
    }

    public void cleanupSpecialReviews(ProtocolBase srcProtocol) {
        List srcSpecialReviews = srcProtocol.getSpecialReviews();
        List dstSpecialReviews = this.getSpecialReviews();
        for (int i = 0; i < srcSpecialReviews.size(); ++i) {
            ProtocolSpecialReviewBase srcSpecialReview = (ProtocolSpecialReviewBase)srcSpecialReviews.get(i);
            ProtocolSpecialReviewBase dstSpecialReview = (ProtocolSpecialReviewBase)dstSpecialReviews.get(i);
            if (srcSpecialReview.getExemptionTypeCodes() != null) {
                ArrayList<String> exemptionCodeCopy = new ArrayList<String>();
                for (String s : srcSpecialReview.getExemptionTypeCodes()) {
                    exemptionCodeCopy.add(new String(s));
                }
                dstSpecialReview.setExemptionTypeCodes(exemptionCodeCopy);
            }
            dstSpecialReview.resetPersistenceState();
        }
    }

    public boolean isMemberInProtocolPersonnel(CommitteeMembershipBase member) {
        boolean retValue = false;
        for (ProtocolPersonBase protocolPerson : this.protocolPersons) {
            if (StringUtils.isNotBlank((String)member.getPersonId()) && StringUtils.isNotBlank((String)protocolPerson.getPersonId())) {
                if (!member.getPersonId().equals(protocolPerson.getPersonId())) continue;
                retValue = true;
                break;
            }
            if (!StringUtils.isBlank((String)member.getPersonId()) || !StringUtils.isBlank((String)protocolPerson.getPersonId()) || null == member.getRolodexId() || null == protocolPerson.getRolodexId() || !member.getRolodexId().equals(protocolPerson.getRolodexId())) continue;
            retValue = true;
            break;
        }
        return retValue;
    }

    public List<CommitteeMembershipBase> filterOutProtocolPersonnel(List<CommitteeMembershipBase> members) {
        ArrayList<CommitteeMembershipBase> filteredMemebers = new ArrayList<CommitteeMembershipBase>();
        for (CommitteeMembershipBase member : members) {
            if (this.isMemberInProtocolPersonnel(member)) continue;
            filteredMemebers.add(member);
        }
        return filteredMemebers;
    }

    public Date getApplicationDate() {
        if (CollectionUtils.isNotEmpty((Collection)this.protocolSubmissions)) {
            return ((ProtocolSubmissionBase)this.protocolSubmissions.get(0)).getSubmissionDate();
        }
        return null;
    }

    public String getProjectName() {
        return this.getTitle();
    }

    public String getProjectId() {
        return this.getProtocolNumber();
    }

    public List<ProtocolActionBase> getSortedActions() {
        if (this.sortedActions == null) {
            this.sortedActions = new ArrayList();
            for (ProtocolActionBase action : this.getProtocolActions()) {
                this.sortedActions.add((ProtocolActionBase)ObjectUtils.deepCopy((Serializable)action));
            }
            Collections.sort(this.sortedActions, new /* Unavailable Anonymous Inner Class!! */);
        }
        return this.sortedActions;
    }

    public boolean isEmptyProtocolResearchAreas() {
        return CollectionUtils.isEmpty((Collection)this.getProtocolResearchAreas());
    }

    public boolean isUserNamedInProtocol(String principalName) {
        boolean result = false;
        for (ProtocolPersonBase protocolPerson : this.getProtocolPersons()) {
            if (!principalName.equals(protocolPerson.getUserName())) continue;
            result = true;
        }
        return result;
    }
}

