/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.bo.RolePersons;
import org.kuali.kra.common.notification.NotificationContext;
import org.kuali.kra.common.notification.bo.KcNotification;
import org.kuali.kra.common.notification.service.KcNotificationService;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.document.ResearchDocumentBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.genericactions.ProtocolGenericActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolNotification;
import org.kuali.kra.protocol.notification.ProtocolNotificationContextBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationService;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.kew.actiontaken.ActionTakenValue;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Copyable;
import org.kuali.rice.krad.document.SessionDocument;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;
import org.kuali.rice.krad.workflow.KualiDocumentXmlMaterializer;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

public abstract class ProtocolDocumentBase
extends ResearchDocumentBase
implements Copyable,
SessionDocument,
KrmsRulesContext {
    private static final String AMENDMENT_KEY = "A";
    private static final String RENEWAL_KEY = "R";
    private static final String OLR_DOC_ID_PARAM = "&olrDocId=";
    private static final long serialVersionUID = 6493566444038807312L;
    private List<ProtocolBase> protocolList = new ArrayList();
    private String protocolWorkflowType;
    private boolean reRouted = false;

    public ProtocolDocumentBase() {
        ProtocolBase newProtocol = this.createNewProtocolInstanceHook();
        newProtocol.setProtocolDocument(this);
        this.protocolList.add(newProtocol);
        this.setProtocolWorkflowType(ProtocolWorkflowType.NORMAL);
        this.initializeProtocolLocation();
    }

    protected abstract ProtocolBase createNewProtocolInstanceHook();

    public void initialize() {
        super.initialize();
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("RESEARCH_AREA_CODE", "000001");
        ResearchAreaBase ra = (ResearchAreaBase)this.getBusinessObjectService().findByPrimaryKey(this.getResearchAreaBoClassHook(), primaryKeys);
        ArrayList<ResearchAreaBase> selectedBOs = new ArrayList<ResearchAreaBase>();
        selectedBOs.add(ra);
        ((ProtocolResearchAreaService)KraServiceLocator.getService((Class)this.getProtocolResearchAreaServiceClassHook())).addProtocolResearchArea(this.getProtocol(), selectedBOs);
    }

    protected abstract Class<? extends ProtocolResearchAreaService> getProtocolResearchAreaServiceClassHook();

    protected abstract Class<? extends ResearchAreaBase> getResearchAreaBoClassHook();

    public ProtocolBase getProtocol() {
        if (this.protocolList.size() == 0) {
            return null;
        }
        return (ProtocolBase)this.protocolList.get(0);
    }

    public void setProtocol(ProtocolBase protocol) {
        this.protocolList.set(0, protocol);
    }

    public List<ProtocolBase> getProtocolList() {
        return this.protocolList;
    }

    public void setProtocolList(List<ProtocolBase> protocolList) {
        this.protocolList = protocolList;
    }

    public List buildListOfDeletionAwareLists() {
        List managedLists = super.buildListOfDeletionAwareLists();
        if (this.getProtocol() != null) {
            managedLists.addAll(this.getProtocol().buildListOfDeletionAwareLists());
        }
        managedLists.add(this.protocolList);
        return managedLists;
    }

    protected List<RolePersons> getAllRolePersons() {
        KraAuthorizationService kraAuthService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        return kraAuthService.getAllRolePersons((Permissionable)this.getProtocol());
    }

    public abstract String getDocumentTypeCode();

    public String getProtocolWorkflowType() {
        return this.protocolWorkflowType;
    }

    public void setProtocolWorkflowType(ProtocolWorkflowType protocolWorkflowType) {
        this.protocolWorkflowType = protocolWorkflowType.getName();
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        if (this.isFinal(statusChangeEvent)) {
            try {
                DocumentRouteHeaderValue document = ((RouteHeaderService)KraServiceLocator.getService(RouteHeaderService.class)).getRouteHeader(this.getDocumentHeader().getWorkflowDocument().getDocumentId());
                String principalId = ((ActionTakenValue)document.getActionsTaken().get(document.getActionsTaken().size() - 1)).getPrincipalId();
                String asyncPrincipalId = GlobalVariables.getUserSession().getPrincipalId();
                String asyncPrincipalName = GlobalVariables.getUserSession().getPrincipalName();
                if (!principalId.equals(asyncPrincipalId)) {
                    KcPerson person = ((KcPersonService)KraServiceLocator.getService(KcPersonService.class)).getKcPersonByPersonId(principalId);
                    GlobalVariables.setUserSession((UserSession)new UserSession(person.getUserName()));
                }
                this.mergeProtocolAmendment();
                if (!principalId.equals(asyncPrincipalId)) {
                    GlobalVariables.setUserSession((UserSession)new UserSession(asyncPrincipalName));
                }
            }
            catch (Exception e) {}
        } else if (this.isDisapproved(statusChangeEvent)) {
            if (!this.isNormal()) {
                this.getProtocol().setActive(false);
                this.getBusinessObjectService().save((PersistableBusinessObject)this);
            }
            try {
                this.performVersioningOperationsOnProtocolAfterDisapproval();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.isRecall(statusChangeEvent)) {
            this.getProtocolGenericActionService().recall(this.getProtocol());
        }
    }

    protected void performVersioningOperationsOnProtocolAfterDisapproval() throws Exception {
        ProtocolBase protocol = this.getProtocol();
        if (!StringUtils.equals((String)this.getCommitteeDisapprovedStatusCodeHook(), (String)protocol.getProtocolStatusCode())) {
            this.getProtocolGenericActionService().recordDisapprovedInRoutingActionAndUpdateStatuses(protocol, this.getLatestCurrentActionTakenValue());
            ProtocolDocumentBase newDocument = this.getProtocolGenericActionService().versionAfterDisapprovalInRouting(protocol);
            protocol = newDocument.getProtocol();
            ProtocolNotificationContextBase context = this.getDisapproveNotificationContextHook(protocol);
            ProtocolNotification notification = this.getNewProtocolNotificationInstanceHook();
            this.getNotificationService().sendNotificationAndPersist((NotificationContext)context, (KcNotification)notification, (KraPersistableBusinessObjectBase)protocol);
        }
    }

    protected abstract String getCommitteeDisapprovedStatusCodeHook();

    protected abstract ProtocolNotification getNewProtocolNotificationInstanceHook();

    protected abstract ProtocolNotificationContextBase getDisapproveNotificationContextHook(ProtocolBase var1);

    protected final ActionTakenValue getLatestCurrentActionTakenValue() {
        ActionTakenValue latestCurrentActionTakenVal = null;
        DocumentRouteHeaderValue routeHeaderValue = this.getRouteHeaderService().getRouteHeader(this.getDocumentHeader().getWorkflowDocument().getDocumentId());
        List actionsTakenList = routeHeaderValue.getActionsTaken();
        for (ActionTakenValue actionTakenVal : actionsTakenList) {
            if (!actionTakenVal.getCurrentIndicator().booleanValue() || latestCurrentActionTakenVal != null && !actionTakenVal.getActionDate().after(latestCurrentActionTakenVal.getActionDate())) continue;
            latestCurrentActionTakenVal = actionTakenVal;
        }
        return latestCurrentActionTakenVal;
    }

    protected RouteHeaderService getRouteHeaderService() {
        return (RouteHeaderService)KraServiceLocator.getService(RouteHeaderService.class);
    }

    protected KcNotificationService getNotificationService() {
        return (KcNotificationService)KraServiceLocator.getService(KcNotificationService.class);
    }

    protected ProtocolGenericActionService getProtocolGenericActionService() {
        return (ProtocolGenericActionService)KraServiceLocator.getService((Class)this.getProtocolGenericActionServiceClassHook());
    }

    protected abstract Class<? extends ProtocolGenericActionService> getProtocolGenericActionServiceClassHook();

    protected abstract void mergeProtocolAmendment();

    public void updateProtocolStatus(String actionTypeCode, String comments) {
        ProtocolActionBase protocolAction = this.getNewProtocolActionInstanceHook(this.getProtocol(), null, actionTypeCode);
        protocolAction.setComments(comments);
        this.getProtocol().getProtocolActions().add(protocolAction);
        this.getProtocolActionService().updateProtocolStatus(protocolAction, this.getProtocol());
    }

    protected abstract ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase var1, ProtocolSubmissionBase var2, String var3);

    protected ProtocolActionService getProtocolActionService() {
        return (ProtocolActionService)KraServiceLocator.getService((Class)this.getProtocolActionServiceClassHook());
    }

    protected abstract Class<? extends ProtocolActionService> getProtocolActionServiceClassHook();

    protected void finalizeAttachmentProtocol(ProtocolBase protocol) {
        for (ProtocolAttachmentProtocolBase attachment : protocol.getAttachmentProtocols()) {
            attachment.setProtocol(protocol);
            if (!attachment.isDraft()) continue;
            attachment.setDocumentStatusCode("2");
        }
    }

    protected String getProtocolNumberIndex() {
        return this.getProtocol().getProtocolNumber().substring(11);
    }

    protected DocumentService getDocumentService() {
        return (DocumentService)KraServiceLocator.getService(DocumentService.class);
    }

    protected BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    protected String getOriginalProtocolNumber() {
        return this.getProtocol().getProtocolNumber().substring(0, 10);
    }

    protected boolean isFinal(DocumentRouteStatusChange statusChangeEvent) {
        return StringUtils.equals((String)"F", (String)statusChangeEvent.getNewRouteStatus());
    }

    protected boolean isDisapproved(DocumentRouteStatusChange statusChangeEvent) {
        return StringUtils.equals((String)"D", (String)statusChangeEvent.getNewRouteStatus());
    }

    protected boolean isRecall(DocumentRouteStatusChange statusChangeEvent) {
        return !StringUtils.equals((String)"I", (String)statusChangeEvent.getOldRouteStatus()) && StringUtils.equals((String)"S", (String)statusChangeEvent.getNewRouteStatus());
    }

    public boolean isRenewal() {
        return this.getProtocol().getProtocolNumber().contains(RENEWAL_KEY);
    }

    public boolean isAmendment() {
        return this.getProtocol().getProtocolNumber().contains(AMENDMENT_KEY);
    }

    public boolean isNormal() {
        return !this.isAmendment() && !this.isRenewal();
    }

    private boolean isComplete(DocumentRouteStatusChange statusChangeEvent) {
        return StringUtils.equals((String)RENEWAL_KEY, (String)statusChangeEvent.getNewRouteStatus()) && StringUtils.equals((String)"S", (String)statusChangeEvent.getOldRouteStatus());
    }

    public void prepareForSave() {
        super.prepareForSave();
        if (ObjectUtils.isNull((Object)this.getVersionNumber())) {
            this.setVersionNumber(new Long(0L));
        }
    }

    private void initializeProtocolLocation() {
        ((ProtocolLocationService)KraServiceLocator.getService((Class)this.getProtocolLocationServiceClassHook())).addDefaultProtocolLocation(this.getProtocol());
    }

    protected abstract Class<? extends ProtocolLocationService> getProtocolLocationServiceClassHook();

    public KualiDocumentXmlMaterializer wrapDocumentWithMetadataForXmlSerialization() {
        this.getProtocol().getLeadUnitNumber();
        return super.wrapDocumentWithMetadataForXmlSerialization();
    }

    public boolean useCustomLockDescriptors() {
        return true;
    }

    public String getCustomLockDescriptor(Person user) {
        String activeLockRegion = (String)GlobalVariables.getUserSession().retrieveObject("ACTIVE_LOCK_REGION");
        String updatedTimestamp = "";
        if (this.getUpdateTimestamp() != null) {
            updatedTimestamp = new SimpleDateFormat("MM/dd/yyyy KK:mm a").format(this.getUpdateTimestamp());
        }
        if (StringUtils.isNotEmpty((String)activeLockRegion)) {
            return this.getProtocol().getProtocolNumber() + "-" + activeLockRegion + "-" + GlobalVariables.getUserSession().getPrincipalName() + "-" + updatedTimestamp;
        }
        return null;
    }

    public boolean getReRouted() {
        return this.reRouted;
    }

    public void setReRouted(boolean reRouted) {
        this.reRouted = reRouted;
    }

    protected WorkflowDocumentService getWorkflowDocumentService() {
        return KRADServiceLocatorWeb.getWorkflowDocumentService();
    }

    protected String getNewProtocolDocId() {
        HashMap<String, String> keyMap = new HashMap<String, String>();
        keyMap.put("protocolNumber", this.getProtocol().getAmendedProtocolNumber());
        keyMap.put("active", "Y");
        BusinessObjectService boService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        List protocols = (List)boService.findMatchingOrderBy(this.getProtocolBOClassHook(), keyMap, "sequenceNumber", false);
        return protocols.size() == 0 ? null : ((ProtocolBase)protocols.get(0)).getProtocolDocument().getDocumentNumber();
    }

    protected abstract Class<? extends ProtocolBase> getProtocolBOClassHook();

    public void populateAgendaQualifiers(Map<String, String> qualifiers) {
        qualifiers.put("Unit Number", this.getProtocol().getLeadUnitNumber());
    }
}

