/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.util.List;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.krms.service.impl.KcKrmsJavaFunctionTermServiceBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolJavaFunctionKrmsTermService;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.ProtocolActionTypeBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolModuleBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.service.KcPersonService;

public abstract class ProtocolJavaFunctionKrmsTermServiceBase
extends KcKrmsJavaFunctionTermServiceBase
implements ProtocolJavaFunctionKrmsTermService {
    private static final int NON_FACULTY = 2;
    private KcPersonService kcPersonService;

    public abstract String getRenewalActionTypeCode();

    public abstract String getProtocolPersonnelModuleTypeCode();

    public abstract String getProtocolOrganizationModuleTypeCode();

    public abstract String getNotifySubmissionTypeCode();

    public Boolean allProtocols() {
        return Boolean.TRUE;
    }

    public Boolean isProtocolAmendment(ProtocolBase protocol) {
        return protocol.isAmendment();
    }

    public Boolean isProtocolRenewal(ProtocolBase protocol) {
        boolean result = false;
        if (protocol.isRenewal()) {
            List actions = protocol.getProtocolActions();
            for (ProtocolActionBase protocolActionBase : actions) {
                ProtocolActionTypeBase protocolActionType = protocolActionBase.getProtocolActionType();
                if (!protocolActionType.getProtocolActionTypeCode().equals(this.getRenewalActionTypeCode())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public Boolean isProtocolLeadUnitBelow(ProtocolBase protocol, String unitNumber) {
        boolean result = false;
        String leadUnit = protocol.getLeadUnitNumber();
        List unitHierachy = this.getUnitService().getUnitHierarchyForUnit(unitNumber);
        for (Unit unit : unitHierachy) {
            if (!unit.getUnitNumber().equals(leadUnit)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Boolean isPINotFaculty(ProtocolBase protocol) {
        return new Integer(2).equals(protocol.getPrincipalInvestigator().getAffiliationTypeCode());
    }

    public Boolean isSpecialReviewExists(ProtocolBase protocol) {
        return !protocol.getSpecialReviews().isEmpty();
    }

    public Boolean hasProtocolContainsOrganization(ProtocolBase protocol, String organizationId) {
        boolean result = false;
        List locations = protocol.getProtocolLocations();
        for (ProtocolLocationBase protocolLocation : locations) {
            if (organizationId == null || !organizationId.equals(protocolLocation.getOrganizationId())) continue;
            result = true;
            break;
        }
        return result;
    }

    public Boolean hasAllPersonsCompletedTraining(ProtocolBase protocol) {
        throw new RuntimeException("Not implemented");
    }

    public Boolean hasFundingSourceContainsSponsor(ProtocolBase protocol, String sponsor) {
        boolean result = false;
        List fundingSources = protocol.getProtocolFundingSources();
        for (ProtocolFundingSourceBase protocolFundingSource : fundingSources) {
            if (!protocolFundingSource.getFundingSourceTypeCode().equals("1") || !protocolFundingSource.getFundingSourceNumber().equals(sponsor)) continue;
            result = true;
        }
        return result;
    }

    public Boolean hasFundingSourceContainsUnit(ProtocolBase protocol, String unitNumber) {
        boolean result = false;
        List fundingSources = protocol.getProtocolFundingSources();
        for (ProtocolFundingSourceBase protocolFundingSource : fundingSources) {
            if (!protocolFundingSource.getFundingSourceTypeCode().equals("2") || !protocolFundingSource.getFundingSourceNumber().equals(unitNumber)) continue;
            result = true;
        }
        return result;
    }

    public Boolean hasProtocolContainsAreaOfResearch(ProtocolBase protocol, String areaOfResearchCode) {
        boolean result = false;
        List researchAreas = protocol.getProtocolResearchAreas();
        for (ProtocolResearchAreaBase protocolResearchArea : researchAreas) {
            if (!protocolResearchArea.getResearchAreaCode().equals(areaOfResearchCode)) continue;
            result = true;
            break;
        }
        return result;
    }

    protected abstract ProtocolBase getActiveProtocol(String var1);

    public Boolean isPiChangedInAmendmentOrRenewal(ProtocolBase protocol) {
        boolean result = false;
        if (protocol.isAmendment() || protocol.isRenewal()) {
            List amendmentRenewalModules = protocol.getProtocolAmendRenewals();
            block0: for (ProtocolAmendRenewalBase protocolAmendRenewalBase : amendmentRenewalModules) {
                List modules = protocolAmendRenewalBase.getModules();
                for (ProtocolAmendRenewModuleBase protocolAmendRenewModule : modules) {
                    ProtocolModuleBase protocolModule = protocolAmendRenewModule.getProtocolModule();
                    if (!protocolAmendRenewModule.getProtocolModuleTypeCode().equals(this.getProtocolPersonnelModuleTypeCode())) continue;
                    String originalProtocolNumber = protocol.getAmendedProtocolNumber();
                    ProtocolBase originalProtocol = this.getActiveProtocol(originalProtocolNumber);
                    if (protocol.getPrincipalInvestigator().getPersonId().equals(originalProtocol.getPrincipalInvestigator().getPersonId())) continue;
                    result = true;
                    continue block0;
                }
            }
        }
        return result;
    }

    public Boolean isOrganizationChangedInAmendmentOrRenewal(ProtocolBase protocol) {
        boolean result = false;
        if (protocol.isAmendment() || protocol.isRenewal()) {
            String originalProtocolNumber = protocol.getAmendedProtocolNumber();
            ProtocolBase originalProtocol = this.getActiveProtocol(originalProtocolNumber);
            List amendmentRenewalModules = protocol.getProtocolAmendRenewals();
            block0: for (ProtocolAmendRenewalBase protocolAmendRenewalBase : amendmentRenewalModules) {
                List modules = protocolAmendRenewalBase.getModules();
                for (ProtocolAmendRenewModuleBase protocolAmendRenewModule : modules) {
                    List locations;
                    ProtocolModuleBase protocolModule = protocolAmendRenewModule.getProtocolModule();
                    if (!protocolAmendRenewModule.getProtocolModuleTypeCode().equals(this.getProtocolOrganizationModuleTypeCode()) || !this.hasLocaltionsChanged(locations = protocol.getProtocolLocations(), originalProtocol.getProtocolLocations())) continue;
                    result = true;
                    continue block0;
                }
            }
        }
        return result;
    }

    private boolean hasLocaltionsChanged(List<ProtocolLocationBase> amendedLocations, List<ProtocolLocationBase> originalLocations) {
        boolean result = false;
        if (amendedLocations.size() == originalLocations.size()) {
            for (ProtocolLocationBase amendedLocation : amendedLocations) {
                boolean exists = false;
                String amendedOrgId = amendedLocation.getOrganizationId();
                String amdededOrgTypeCode = amendedLocation.getProtocolOrganizationTypeCode();
                for (ProtocolLocationBase originalLocation : originalLocations) {
                    if (!originalLocation.getOrganizationId().equals(amendedOrgId) || !originalLocation.getProtocolOrganizationTypeCode().equals(amdededOrgTypeCode)) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                result = true;
                break;
            }
        } else {
            result = true;
        }
        return result;
    }

    public Boolean isSubmitUserProtocolPi(ProtocolBase protocol, String submitUserId) {
        boolean result = false;
        ProtocolPersonBase pi = protocol.getPrincipalInvestigator();
        if (pi.getUserName() != null && pi.getUserName().equals(submitUserId)) {
            result = true;
        }
        return result;
    }

    public Boolean isLeadUnitProtocolCampus(ProtocolBase protocol, String campusCode) {
        String leadUnit = protocol.getLeadUnitNumber();
        boolean result = false;
        if (leadUnit != null && leadUnit.length() > 3 && leadUnit.indexOf(campusCode) != -1) {
            result = true;
        }
        return result;
    }

    public Boolean isProtocolRenewalWithAmendment(ProtocolBase protocol) {
        boolean result = !protocol.isRenewalWithoutAmendment();
        return result;
    }

    public Boolean hasProtocolContainsDocumentType(ProtocolBase protocol, String documentTypeCode) {
        boolean result = false;
        List attachments = protocol.getAttachmentProtocols();
        for (ProtocolAttachmentProtocolBase protocolAttachmentProtocol : attachments) {
            if (!protocolAttachmentProtocol.getTypeCode().equals(documentTypeCode)) continue;
            result = true;
            break;
        }
        return result;
    }

    public Boolean isProtocolInSubmission(ProtocolBase protocol, String submissionTypeCode) {
        ProtocolSubmissionBase submission = protocol.getProtocolSubmission();
        boolean result = submission.getSubmissionTypeCode().equals(submissionTypeCode);
        return result;
    }

    public Boolean hasProtocolContainsNotifySubmissionQualifierType(ProtocolBase protocol, Integer submissionNumber, String submissionQualifierTypeCode) {
        boolean result = false;
        List submissions = protocol.getProtocolSubmissions();
        for (ProtocolSubmissionBase protocolSubmission : submissions) {
            ProtocolSubmissionTypeBase submissionType = protocolSubmission.getProtocolSubmissionType();
            if (!submissionType.getSubmissionTypeCode().equals(this.getNotifySubmissionTypeCode()) || !protocolSubmission.getSubmissionTypeQualifierCode().equals(submissionQualifierTypeCode)) continue;
            result = true;
        }
        return result;
    }

    public Boolean hasSubmissionType(ProtocolBase protocol, Integer submissionNumber, String submissionTypeCode) {
        boolean result = false;
        List submissions = protocol.getProtocolSubmissions();
        for (ProtocolSubmissionBase protocolSubmission : submissions) {
            ProtocolSubmissionTypeBase submissionType = protocolSubmission.getProtocolSubmissionType();
            if (submissionType == null || !submissionType.getSubmissionTypeCode().equals(submissionTypeCode)) continue;
            result = true;
        }
        return result;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

