/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Rolodex;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.lookup.KraLookupableHelperServiceImpl;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDao;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.core.api.CoreApiServiceLocator;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.LookupUtils;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.lookup.CollectionIncomplete;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.UrlFactory;

public abstract class ProtocolLookupableHelperServiceImplBase<GenericProtocol extends ProtocolBase>
extends KraLookupableHelperServiceImpl {
    private static final long serialVersionUID = 273532318463507554L;
    protected static final String AMEND_RENEW_PROTOCOL_LOOKUP_ACTION = "lookupActionAmendRenewProtocol";
    protected static final String REQUEST_PROTOCOL_ACTION = "lookupActionRequestProtocol";
    protected static final String PENDING_PROTOCOL_LOOKUP = "lookupPendingProtocol";
    protected static final String PENDING_PI_ACTION_PROTOCOL_LOOKUP = "lookupPendingPIActionProtocol";
    protected static final String PROTOCOL_PERSON_ID_LOOKUP = "lookupProtocolPersonId";
    private static final String PROTOCOL_LOOKUP_KEY_FIELD = "protocolNumber";
    private static final String RESEARCH_AREA_CLASS_PATH = ResearchArea.class.getName();
    private static final String ORGANIZATION_CLASS_PATH = Organization.class.getName();
    private static final Log LOG = LogFactory.getLog(ProtocolLookupableHelperServiceImplBase.class);
    private DictionaryValidationService dictionaryValidationService;
    protected KcPersonService kcPersonService;
    protected KraAuthorizationService kraAuthorizationService;
    protected TaskAuthorizationService taskAuthorizationService;
    protected DocumentService documentService;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.validateSearchParameters(fieldValues);
        super.setBackLocationDocFormKey(fieldValues);
        return this.getSearchResultsFilteredByTask(fieldValues);
    }

    protected List<? extends BusinessObject> filterProtocolsByTask(Map<String, String> fieldValues, String ... taskNames) {
        ArrayList<ProtocolBase> filteredProtocols = new ArrayList<ProtocolBase>();
        block0: for (ProtocolBase protocol : this.getProtocolDaoHook().getProtocols(this.filterFieldValues(fieldValues))) {
            for (String taskName : taskNames) {
                ProtocolTaskBase task = this.createNewProtocolTaskInstanceHook(taskName, protocol);
                if (!this.taskAuthorizationService.isAuthorized(this.getUserIdentifier(), (Task)task)) continue;
                filteredProtocols.add(protocol);
                continue block0;
            }
        }
        return this.getPagedResults(filteredProtocols);
    }

    protected abstract ProtocolTaskBase createNewProtocolTaskInstanceHook(String var1, ProtocolBase var2);

    protected List<? extends BusinessObject> filterProtocolsByStatus(Map<String, String> fieldValues, String ... protocolStatusCodes) {
        ArrayList<ProtocolBase> filteredProtocols = new ArrayList<ProtocolBase>();
        List<String> protocolStatusCodeList = Arrays.asList(protocolStatusCodes);
        for (ProtocolBase protocol : this.getProtocolDaoHook().getProtocols(this.filterFieldValues(fieldValues))) {
            String statusCode = protocol.getProtocolStatusCode();
            if (!protocolStatusCodeList.contains(statusCode)) continue;
            filteredProtocols.add(protocol);
        }
        return this.getPagedResults(filteredProtocols);
    }

    protected List<? extends BusinessObject> filterProtocolsByPrincipal(Map<String, String> fieldValues, String principalKey) {
        ArrayList<ProtocolBase> filteredProtocols = new ArrayList<ProtocolBase>();
        String principalId = fieldValues.get(principalKey);
        for (ProtocolBase protocol : this.getProtocolDaoHook().getProtocols(this.filterFieldValues(fieldValues))) {
            try {
                String principalInvestigatorId = protocol.getPrincipalInvestigator().getPersonId();
                ProtocolDocumentBase document = (ProtocolDocumentBase)this.documentService.getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber());
                String initiatorId = document.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId();
                if (!StringUtils.equals((String)principalId, (String)principalInvestigatorId) && !StringUtils.equals((String)principalId, (String)initiatorId)) continue;
                filteredProtocols.add(protocol);
            }
            catch (WorkflowException we) {
                LOG.warn((Object)("Cannot find Document with header id " + protocol.getProtocolDocument().getDocumentNumber() + ", removing from search results."));
            }
        }
        return this.getPagedResults(filteredProtocols);
    }

    protected List<? extends BusinessObject> filterProtocols(Map<String, String> fieldValues) {
        List protocols = this.getProtocolDaoHook().getProtocols(this.filterFieldValues(fieldValues));
        return this.getPagedResults(protocols);
    }

    private Map<String, String> filterFieldValues(Map<String, String> fieldValues) {
        return this.removeExtraFilterParameters(fieldValues);
    }

    private CollectionIncomplete<GenericProtocol> getPagedResults(List<GenericProtocol> protocols) {
        Long matchingResultsCount = new Long(protocols.size());
        Integer searchResultsLimit = LookupUtils.getSearchResultsLimit((Class)this.getProtocolClassHook());
        if (matchingResultsCount == null || matchingResultsCount.intValue() <= searchResultsLimit) {
            return new CollectionIncomplete(protocols, new Long(0L));
        }
        return new CollectionIncomplete((Collection)this.trimResult(protocols, searchResultsLimit), matchingResultsCount);
    }

    protected List<GenericProtocol> trimResult(List<GenericProtocol> result, Integer trimSize) {
        ArrayList<ProtocolBase> trimedResult = new ArrayList<ProtocolBase>();
        for (ProtocolBase protocol : result) {
            if (trimedResult.size() >= trimSize) continue;
            trimedResult.add(protocol);
        }
        return trimedResult;
    }

    public void validateSearchParameters(Map fieldValues) {
        super.validateSearchParameters(fieldValues);
        Set keys = fieldValues.keySet();
        for (String key : keys) {
            String value = fieldValues.get(key).toString();
            if (key.toUpperCase().indexOf("DATE") <= 0 || value.indexOf("..") != -1 || value.indexOf(">=") != -1 || value.indexOf("<=") != -1) continue;
            boolean valid = this.validateDate(key, value);
        }
    }

    protected boolean validateDate(String dateFieldName, String dateFieldValue) {
        try {
            CoreApiServiceLocator.getDateTimeService().convertToSqlTimestamp(dateFieldValue);
            return true;
        }
        catch (ParseException e) {
            GlobalVariables.getMessageMap().putError(dateFieldName, "error.search.invalid.date", new String[0]);
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            GlobalVariables.getMessageMap().putError(dateFieldName, "error.search.invalid.date", new String[0]);
            return false;
        }
    }

    public DictionaryValidationService getDictionaryValidationService() {
        if (this.dictionaryValidationService == null) {
            this.dictionaryValidationService = KNSServiceLocator.getKNSDictionaryValidationService();
        }
        return this.dictionaryValidationService;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        return this.getCustomActions(businessObject, pkNames);
    }

    protected boolean isParameterTrue(String parameterKey) {
        Object parameterObject;
        boolean parameterTrue = false;
        if (this.getParameters() != null && this.getParameters().containsKey(parameterKey) && (parameterObject = this.getParameters().get(parameterKey)) != null) {
            if (parameterObject instanceof Boolean) {
                parameterTrue = (Boolean)parameterObject;
            }
            if (parameterObject instanceof String) {
                parameterTrue = Boolean.parseBoolean(parameterObject.toString());
            }
            if (parameterObject instanceof String[]) {
                String[] parameterObjectStringArray;
                for (String parameterObjectString : parameterObjectStringArray = (String[])parameterObject) {
                    if (!Boolean.parseBoolean(parameterObjectString)) continue;
                    parameterTrue = true;
                    break;
                }
            }
        }
        return parameterTrue;
    }

    protected HtmlData.AnchorHtmlData getPerformActionLink(BusinessObject businessObject, String actionKey) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        htmlData.setDisplayText("perform action");
        Properties parameters = new Properties();
        parameters.put("methodToCall", "performProtocolAction");
        parameters.put("command", "displayDocSearchView");
        parameters.put("docTypeName", this.getDocumentTypeName());
        parameters.put("viewDocument", "false");
        parameters.put("docId", ((ProtocolBase)businessObject).getProtocolDocument().getDocumentNumber());
        parameters.put(actionKey, "true");
        String href = UrlFactory.parameterizeUrl((String)("../" + this.getHtmlAction()), (Properties)parameters);
        htmlData.setHref(href);
        return htmlData;
    }

    protected List<HtmlData> getEditCopyViewLinks(BusinessObject businessObject, List pkNames) {
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        if (this.kraAuthorizationService.hasPermission(this.getUserIdentifier(), (Permissionable)((ProtocolBase)businessObject), "Modify Protocol")) {
            HtmlData.AnchorHtmlData editHtmlData = this.getViewLink((Document)((ProtocolBase)businessObject).getProtocolDocument());
            String href = editHtmlData.getHref();
            href = href.replace("viewDocument=true", "viewDocument=false");
            editHtmlData.setHref(href);
            editHtmlData.setDisplayText("edit");
            htmlDataList.add((HtmlData)editHtmlData);
            HtmlData.AnchorHtmlData htmlData = this.getUrlData(businessObject, "copy", pkNames);
            ProtocolDocumentBase document = ((ProtocolBase)businessObject).getProtocolDocument();
            htmlData.setHref("../DocCopyHandler.do?docId=" + document.getDocumentNumber() + "&command=displayDocSearchView&documentTypeName=" + this.getDocumentTypeName());
            htmlDataList.add((HtmlData)htmlData);
        }
        if (this.kraAuthorizationService.hasPermission(this.getUserIdentifier(), (Permissionable)((ProtocolBase)businessObject), "View Protocol")) {
            htmlDataList.add((HtmlData)this.getViewLink((Document)((ProtocolBase)businessObject).getProtocolDocument()));
        }
        return htmlDataList;
    }

    public List<Row> getRows() {
        List rows = super.getRows();
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (field.getPropertyName().equals("researchAreaCode")) {
                    super.updateLookupField(field, "researchAreaCode", RESEARCH_AREA_CLASS_PATH);
                    continue;
                }
                if (field.getPropertyName().equals("performingOrganizationId")) {
                    super.updateLookupField(field, "organizationId", ORGANIZATION_CLASS_PATH);
                    continue;
                }
                if (field.getPropertyName().equals("protocolStatusCode") || field.getPropertyName().equals("protocolTypeCode")) {
                    field.setQuickFinderClassNameImpl("");
                    continue;
                }
                if (!field.getPropertyName().startsWith("leadUnit")) continue;
                if (field.getPropertyName().equals("leadUnitNumber")) {
                    field.setFieldLabel("Unit Number");
                    continue;
                }
                field.setFieldLabel("Unit Name");
            }
        }
        return rows;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public HtmlData getInquiryUrl(BusinessObject bo, String propertyName) {
        ProtocolBase protocol;
        ProtocolPersonBase principalInvestigator;
        BusinessObject inqBo = bo;
        String inqPropertyName = propertyName;
        if (propertyName.equals("leadUnitNumber")) {
            inqBo = new Unit();
            ((Unit)inqBo).setUnitNumber(((ProtocolBase)bo).getLeadUnitNumber());
            inqPropertyName = "unitNumber";
        } else if (propertyName.equals("investigator") && (principalInvestigator = (protocol = (ProtocolBase)bo).getPrincipalInvestigator()) != null) {
            if (StringUtils.isNotBlank((String)principalInvestigator.getPersonId())) {
                inqBo = this.kcPersonService.getKcPersonByPersonId(principalInvestigator.getPersonId());
                inqPropertyName = "personId";
            } else if (principalInvestigator.getRolodexId() != null) {
                inqBo = new Rolodex();
                ((Rolodex)inqBo).setRolodexId(principalInvestigator.getRolodexId());
                inqPropertyName = "rolodexId";
            }
        }
        return super.getInquiryUrl(inqBo, inqPropertyName);
    }

    protected String getHtmlAction() {
        return this.getHtmlActionHook();
    }

    protected String getDocumentTypeName() {
        return this.getDocumentTypeNameHook();
    }

    protected String getKeyFieldName() {
        return PROTOCOL_LOOKUP_KEY_FIELD;
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public void setTaskAuthorizationService(TaskAuthorizationService taskAuthorizationService) {
        this.taskAuthorizationService = taskAuthorizationService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    protected abstract List<? extends BusinessObject> getSearchResultsFilteredByTask(Map<String, String> var1);

    protected abstract Map<String, String> removeExtraFilterParameters(Map<String, String> var1);

    protected abstract List<HtmlData> getCustomActions(BusinessObject var1, List var2);

    protected abstract ProtocolDao<GenericProtocol> getProtocolDaoHook();

    protected abstract String getDocumentTypeNameHook();

    protected abstract String getHtmlActionHook();

    protected abstract Class<? extends ProtocolBase> getProtocolClassHook();
}

