/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.amendrenew;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.kuali.kra.dao.KraLookupDao;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewModuleBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendmentBean;
import org.kuali.kra.protocol.actions.copy.ProtocolCopyService;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolAmendRenewServiceImplBase
implements ProtocolAmendRenewService {
    protected static final String AMEND_ID = "A";
    protected static final String RENEW_ID = "R";
    protected static final int DIGIT_COUNT = 3;
    protected static final String AMEND_NEXT_VALUE = "nextAmendValue";
    protected static final String RENEW_NEXT_VALUE = "nextRenewValue";
    protected static final String AMENDMENT = "Amendment";
    protected static final String RENEWAL = "Renewal";
    protected static final String CREATED = "Created";
    protected static final String PROTOCOL_NUMBER = "protocolNumber";
    protected static final String PROTOCOL_STATUS = "protocolStatus";
    protected DocumentService documentService;
    protected ProtocolCopyService protocolCopyService;
    protected KraLookupDao kraLookupDao;
    protected ProtocolFinderDao protocolFinderDao;
    protected SequenceAccessorService sequenceAccessorService;
    protected QuestionnaireAnswerService questionnaireAnswerService;
    protected BusinessObjectService businessObjectService;

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setProtocolCopyService(ProtocolCopyService protocolCopyService) {
        this.protocolCopyService = protocolCopyService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public void setKraLookupDao(KraLookupDao kraLookupDao) {
        this.kraLookupDao = kraLookupDao;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createAmendment(ProtocolDocumentBase protocolDocument, ProtocolAmendmentBean amendmentBean) throws Exception {
        ProtocolDocumentBase amendProtocolDocument = null;
        try {
            GlobalVariables.getUserSession().addObject("onAmendAndRenewAllowNewProtocolDocument", (Object)Boolean.TRUE);
            amendProtocolDocument = this.protocolCopyService.copyProtocol(protocolDocument, this.generateProtocolAmendmentNumber(protocolDocument), true);
        }
        finally {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
        }
        amendProtocolDocument.getProtocol().setInitialSubmissionDate(protocolDocument.getProtocol().getInitialSubmissionDate());
        amendProtocolDocument.getProtocol().setApprovalDate(protocolDocument.getProtocol().getApprovalDate());
        amendProtocolDocument.getProtocol().setExpirationDate(protocolDocument.getProtocol().getExpirationDate());
        amendProtocolDocument.getProtocol().setLastApprovalDate(protocolDocument.getProtocol().getLastApprovalDate());
        amendProtocolDocument.getProtocol().setProtocolStatusCode(this.getAmendmentInProgressStatusHook());
        amendProtocolDocument.getProtocol().refreshReferenceObject(PROTOCOL_STATUS);
        this.markProtocolAttachmentsAsFinalized(amendProtocolDocument.getProtocol().getAttachmentProtocols());
        ProtocolActionBase protocolAction = this.createCreateAmendmentProtocolAction(protocolDocument.getProtocol(), amendProtocolDocument.getProtocol().getProtocolNumber());
        protocolDocument.getProtocol().getProtocolActions().add(protocolAction);
        return this.createAmendment(protocolDocument, amendProtocolDocument, amendmentBean);
    }

    protected void markProtocolAttachmentsAsFinalized(List<ProtocolAttachmentProtocolBase> attachmentProtocols) {
        for (ProtocolAttachmentProtocolBase protocolAttachment : attachmentProtocols) {
            if (!"1".equals(protocolAttachment.getDocumentStatusCode())) continue;
            protocolAttachment.setDocumentStatusCode("2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRenewal(ProtocolDocumentBase protocolDocument, String renewalSummary) throws Exception {
        ProtocolDocumentBase renewProtocolDocument = null;
        try {
            GlobalVariables.getUserSession().addObject("onAmendAndRenewAllowNewProtocolDocument", (Object)Boolean.TRUE);
            renewProtocolDocument = this.protocolCopyService.copyProtocol(protocolDocument, this.generateProtocolRenewalNumber(protocolDocument), true);
        }
        finally {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
        }
        renewProtocolDocument.getProtocol().setInitialSubmissionDate(protocolDocument.getProtocol().getInitialSubmissionDate());
        renewProtocolDocument.getProtocol().setApprovalDate(protocolDocument.getProtocol().getApprovalDate());
        renewProtocolDocument.getProtocol().setExpirationDate(protocolDocument.getProtocol().getExpirationDate());
        renewProtocolDocument.getProtocol().setLastApprovalDate(protocolDocument.getProtocol().getLastApprovalDate());
        renewProtocolDocument.getProtocol().setProtocolStatusCode(this.getRenewalInProgressStatusHook());
        renewProtocolDocument.getProtocol().refreshReferenceObject(PROTOCOL_STATUS);
        this.markProtocolAttachmentsAsFinalized(renewProtocolDocument.getProtocol().getAttachmentProtocols());
        ProtocolActionBase protocolAction = this.createCreateRenewalProtocolAction(protocolDocument.getProtocol(), renewProtocolDocument.getProtocol().getProtocolNumber());
        protocolDocument.getProtocol().getProtocolActions().add(protocolAction);
        ProtocolAmendRenewalBase protocolAmendRenewal = this.createAmendmentRenewal(protocolDocument, renewProtocolDocument, renewalSummary);
        renewProtocolDocument.getProtocol().setProtocolAmendRenewal(protocolAmendRenewal);
        this.documentService.saveDocument((Document)protocolDocument);
        this.documentService.saveDocument((Document)renewProtocolDocument);
        return renewProtocolDocument.getDocumentNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createRenewalWithAmendment(ProtocolDocumentBase protocolDocument, ProtocolAmendmentBean amendmentBean) throws Exception {
        ProtocolDocumentBase renewProtocolDocument = null;
        try {
            GlobalVariables.getUserSession().addObject("onAmendAndRenewAllowNewProtocolDocument", (Object)Boolean.TRUE);
            renewProtocolDocument = this.protocolCopyService.copyProtocol(protocolDocument, this.generateProtocolRenewalNumber(protocolDocument), true);
        }
        finally {
            GlobalVariables.getUserSession().removeObject("onAmendAndRenewAllowNewProtocolDocument");
        }
        renewProtocolDocument.getProtocol().setInitialSubmissionDate(protocolDocument.getProtocol().getInitialSubmissionDate());
        renewProtocolDocument.getProtocol().setApprovalDate(protocolDocument.getProtocol().getApprovalDate());
        renewProtocolDocument.getProtocol().setExpirationDate(protocolDocument.getProtocol().getExpirationDate());
        renewProtocolDocument.getProtocol().setLastApprovalDate(protocolDocument.getProtocol().getLastApprovalDate());
        renewProtocolDocument.getProtocol().setProtocolStatusCode(this.getRenewalInProgressStatusHook());
        renewProtocolDocument.getProtocol().refreshReferenceObject(PROTOCOL_STATUS);
        this.markProtocolAttachmentsAsFinalized(renewProtocolDocument.getProtocol().getAttachmentProtocols());
        ProtocolActionBase protocolAction = this.createCreateRenewalProtocolAction(protocolDocument.getProtocol(), renewProtocolDocument.getProtocol().getProtocolNumber());
        protocolDocument.getProtocol().getProtocolActions().add(protocolAction);
        return this.createAmendment(protocolDocument, renewProtocolDocument, amendmentBean);
    }

    public void updateAmendmentRenewal(ProtocolDocumentBase protocolDocument, ProtocolAmendmentBean amendmentBean) throws WorkflowException {
        protocolDocument.getProtocol().getProtocolAmendRenewal().setSummary(amendmentBean.getSummary());
        protocolDocument.getProtocol().getProtocolAmendRenewal().setModules(new ArrayList());
        this.addModules(protocolDocument.getProtocol(), amendmentBean);
    }

    protected String createAmendment(ProtocolDocumentBase protocolDocument, ProtocolDocumentBase amendProtocolDocument, ProtocolAmendmentBean amendmentBean) throws WorkflowException {
        ProtocolAmendRenewalBase protocolAmendRenewal = this.createAmendmentRenewal(protocolDocument, amendProtocolDocument, amendmentBean.getSummary());
        amendProtocolDocument.getProtocol().setProtocolAmendRenewal(protocolAmendRenewal);
        this.addModules(amendProtocolDocument.getProtocol(), amendmentBean);
        this.documentService.saveDocument((Document)protocolDocument);
        this.documentService.saveDocument((Document)amendProtocolDocument);
        return amendProtocolDocument.getDocumentNumber();
    }

    protected String generateProtocolAmendmentNumber(ProtocolDocumentBase protocolDocument) {
        return this.generateProtocolNumber(protocolDocument, AMEND_ID, AMEND_NEXT_VALUE);
    }

    protected String generateProtocolRenewalNumber(ProtocolDocumentBase protocolDocument) {
        return this.generateProtocolNumber(protocolDocument, RENEW_ID, RENEW_NEXT_VALUE);
    }

    protected String generateProtocolNumber(ProtocolDocumentBase protocolDocument, String letter, String nextValueKey) {
        String protocolNumber = protocolDocument.getProtocol().getProtocolNumber();
        Integer nextValue = protocolDocument.getDocumentNextValue(nextValueKey);
        String s = nextValue.toString();
        int length = s.length();
        for (int i = 0; i < 3 - length; ++i) {
            s = "0" + s;
        }
        return protocolNumber + letter + s;
    }

    protected ProtocolAmendRenewalBase createAmendmentRenewal(ProtocolDocumentBase protocolDocument, ProtocolDocumentBase amendProtocolDocument, String summary) {
        ProtocolAmendRenewalBase protocolAmendRenewal = this.getNewProtocolAmendRenewalInstanceHook();
        protocolAmendRenewal.setProtoAmendRenNumber(amendProtocolDocument.getProtocol().getProtocolNumber());
        protocolAmendRenewal.setDateCreated(new Date(System.currentTimeMillis()));
        protocolAmendRenewal.setSummary(summary);
        protocolAmendRenewal.setProtocolNumber(protocolDocument.getProtocol().getProtocolNumber());
        protocolAmendRenewal.setProtocolId(amendProtocolDocument.getProtocol().getProtocolId());
        protocolAmendRenewal.setProtocol(amendProtocolDocument.getProtocol());
        protocolAmendRenewal.setSequenceNumber(Integer.valueOf(0));
        return protocolAmendRenewal;
    }

    protected void removeEditedQuestionaire(ProtocolBase protocol) {
        ModuleQuestionnaireBean moduleQuestionnaireBean = this.getNewProtocolModuleQuestionnaireBeanInstanceHook(protocol);
        moduleQuestionnaireBean.setModuleSubItemCode("0");
        List answerHeaders = new ArrayList();
        answerHeaders = this.questionnaireAnswerService.getQuestionnaireAnswer(moduleQuestionnaireBean);
        if (!answerHeaders.isEmpty() && ((AnswerHeader)answerHeaders.get(0)).getAnswerHeaderId() != null) {
            this.businessObjectService.delete(answerHeaders);
        }
    }

    protected ProtocolAmendRenewModuleBase createModule(ProtocolAmendRenewalBase amendmentEntry, String moduleTypeCode) {
        ProtocolAmendRenewModuleBase module = this.getNewProtocolAmendRenewModuleInstanceHook();
        module.setProtocolAmendRenewalNumber(amendmentEntry.getProtoAmendRenNumber());
        module.setProtocolAmendRenewal(amendmentEntry);
        module.setProtocolAmendRenewalId(amendmentEntry.getId());
        module.setProtocolNumber(amendmentEntry.getProtocolNumber());
        module.setProtocolModuleTypeCode(moduleTypeCode);
        return module;
    }

    protected ProtocolActionBase createCreateAmendmentProtocolAction(ProtocolBase protocol, String protocolNumber) {
        ProtocolActionBase protocolAction = this.getNewAmendmentProtocolActionInstanceHook(protocol);
        protocolAction.setComments("Amendment-" + protocolNumber.substring(11) + ": " + CREATED);
        return protocolAction;
    }

    protected ProtocolActionBase createCreateRenewalProtocolAction(ProtocolBase protocol, String protocolNumber) {
        ProtocolActionBase protocolAction = this.getNewRenewalProtocolActionInstanceHook(protocol);
        protocolAction.setComments("Renewal-" + protocolNumber.substring(11) + ": " + CREATED);
        return protocolAction;
    }

    public List<ProtocolBase> getAmendmentAndRenewals(String protocolNumber) throws Exception {
        ArrayList<ProtocolBase> protocols = new ArrayList<ProtocolBase>();
        protocols.addAll(this.getAmendments(protocolNumber));
        protocols.addAll(this.getRenewals(protocolNumber));
        return protocols;
    }

    public Collection<ProtocolBase> getAmendments(String protocolNumber) throws Exception {
        ArrayList<ProtocolBase> amendments = new ArrayList<ProtocolBase>();
        Collection protocols = this.kraLookupDao.findCollectionUsingWildCard(this.getProtocolBOClassHook(), PROTOCOL_NUMBER, protocolNumber + AMEND_ID + "%", true);
        for (ProtocolBase protocol : protocols) {
            ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)this.documentService.getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber());
            amendments.add(protocolDocument.getProtocol());
        }
        return amendments;
    }

    public Collection<ProtocolBase> getRenewals(String protocolNumber) throws Exception {
        ArrayList<ProtocolBase> renewals = new ArrayList<ProtocolBase>();
        Collection protocols = this.kraLookupDao.findCollectionUsingWildCard(this.getProtocolBOClassHook(), PROTOCOL_NUMBER, protocolNumber + RENEW_ID + "%", true);
        for (ProtocolBase protocol : protocols) {
            ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)this.documentService.getByDocumentHeaderId(protocol.getProtocolDocument().getDocumentNumber());
            renewals.add(protocolDocument.getProtocol());
        }
        return renewals;
    }

    public List<String> getAvailableModules(String protocolNumber) throws Exception {
        List moduleTypeCodes = this.getAllModuleTypeCodes();
        List protocols = this.getAmendmentAndRenewals(protocolNumber);
        for (ProtocolBase protocol : protocols) {
            ProtocolAmendRenewalBase amendRenewal;
            if (this.isAmendmentCompleted(protocol) || (amendRenewal = protocol.getProtocolAmendRenewal()) == null) continue;
            List modules = amendRenewal.getModules();
            for (ProtocolAmendRenewModuleBase module : modules) {
                moduleTypeCodes.remove(module.getProtocolModuleTypeCode());
            }
        }
        return moduleTypeCodes;
    }

    protected boolean isAmendmentCompleted(ProtocolBase protocol) {
        WorkflowDocument workflowDocument = this.getWorkflowDocument((Document)protocol.getProtocolDocument());
        if (workflowDocument != null) {
            return workflowDocument.isApproved() || workflowDocument.isFinal() || workflowDocument.isDisapproved() || workflowDocument.isCanceled() || workflowDocument.isException();
        }
        return false;
    }

    protected WorkflowDocument getWorkflowDocument(Document doc) {
        DocumentHeader header;
        WorkflowDocument workflowDocument = null;
        if (doc != null && (header = doc.getDocumentHeader()) != null) {
            try {
                workflowDocument = header.getWorkflowDocument();
            }
            catch (RuntimeException ex) {
                // empty catch block
            }
        }
        return workflowDocument;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected abstract ProtocolActionBase getNewAmendmentProtocolActionInstanceHook(ProtocolBase var1);

    protected abstract ProtocolActionBase getNewRenewalProtocolActionInstanceHook(ProtocolBase var1);

    protected abstract ModuleQuestionnaireBean getNewProtocolModuleQuestionnaireBeanInstanceHook(ProtocolBase var1);

    protected abstract String getAmendmentInProgressStatusHook();

    protected abstract String getRenewalInProgressStatusHook();

    protected abstract List<String> getAllModuleTypeCodes();

    protected abstract void addModules(ProtocolBase var1, ProtocolAmendmentBean var2);

    protected abstract Class<? extends ProtocolBase> getProtocolBOClassHook();

    protected abstract ProtocolAmendRenewalBase getNewProtocolAmendRenewalInstanceHook();

    protected abstract ProtocolAmendRenewModuleBase getNewProtocolAmendRenewModuleInstanceHook();

    public ProtocolCopyService<ProtocolDocumentBase> getProtocolCopyService() {
        return this.protocolCopyService;
    }
}

