/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.approve;

import java.sql.Timestamp;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.approve.ProtocolApproveBean;
import org.kuali.kra.protocol.actions.approve.ProtocolApproveService;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionCorrespondenceGenerationService;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionsCorrespondenceBase;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public abstract class ProtocolApproveServiceImplBase
implements ProtocolApproveService {
    protected static final String RESPONSE_APPROVAL_FINALIZE_OLR_ANNOTATION = "Online Review finalized as part of response approval action on protocol.";
    private static final String ADMIN_APPROVAL_FINALIZE_OLR_ANNOTATION = "Online Review finalized as part of administrative approval action on protocol.";
    private DocumentService documentService;
    private ProtocolActionService protocolActionService;
    private ProtocolActionCorrespondenceGenerationService protocolActionCorrespondenceGenerationService;
    protected ProtocolOnlineReviewService protocolOnlineReviewService;

    public void grantResponseApproval(ProtocolBase protocol, ProtocolApproveBean actionBean) throws Exception {
        this.generateProtocolActionAndAttach(protocol, actionBean, this.getProtocolActionTypeCodeForResponseApprovalHook());
        if (protocol.getApprovalDate() == null) {
            protocol.setApprovalDate(actionBean.getApprovalDate());
        }
        if (protocol.isRenewal() || protocol.isAmendment()) {
            protocol.setLastApprovalDate(actionBean.getApprovalDate());
        }
        protocol.setExpirationDate(actionBean.getExpirationDate());
        this.finalizeReviewsAndSave(protocol, this.getProtocolActionTypeCodeForResponseApprovalHook(), RESPONSE_APPROVAL_FINALIZE_OLR_ANNOTATION);
        protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument().approve(actionBean.getComments());
    }

    protected abstract String getProtocolActionTypeCodeForResponseApprovalHook();

    public void grantAdminApproval(ProtocolBase protocol, ProtocolApproveBean actionBean) throws Exception {
        this.generateProtocolActionAndAttach(protocol, actionBean, this.getProtocolActionTypeCodeForAdminApprovalHook());
        if (protocol.getApprovalDate() == null) {
            protocol.setApprovalDate(actionBean.getApprovalDate());
        }
        if (protocol.isRenewal() || protocol.isAmendment()) {
            protocol.setLastApprovalDate(actionBean.getApprovalDate());
        }
        protocol.setExpirationDate(actionBean.getExpirationDate());
        this.finalizeReviewsAndSave(protocol, this.getProtocolActionTypeCodeForAdminApprovalHook(), ADMIN_APPROVAL_FINALIZE_OLR_ANNOTATION);
        protocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument().approve(actionBean.getComments());
    }

    protected abstract String getProtocolActionTypeCodeForAdminApprovalHook();

    protected void generateProtocolActionAndAttach(ProtocolBase protocol, ProtocolApproveBean actionBean, String protocolActionTypeCode) {
        ProtocolActionBase protocolAction = this.getNewProtocolActionInstanceHook(protocol, null, protocolActionTypeCode);
        protocolAction.setComments(actionBean.getComments());
        protocolAction.setActionDate(new Timestamp(actionBean.getActionDate().getTime()));
        protocolAction.setSubmissionIdFk(protocol.getLastProtocolAction().getSubmissionIdFk());
        protocolAction.setSubmissionNumber(protocol.getLastProtocolAction().getSubmissionNumber());
        protocol.getProtocolActions().add(protocolAction);
        this.protocolActionService.updateProtocolStatus(protocolAction, protocol);
    }

    protected abstract ProtocolActionBase getNewProtocolActionInstanceHook(ProtocolBase var1, Object var2, String var3);

    protected abstract ProtocolActionsCorrespondenceBase getNewProtocolActionsCorrespondence(String var1);

    protected void finalizeReviewsAndSave(ProtocolBase protocol, String protocolActionTypeCode, String reviewAnnotation) throws Exception {
        protocol.refreshReferenceObject("protocolStatus");
        this.protocolOnlineReviewService.finalizeOnlineReviews(protocol.getProtocolSubmission(), reviewAnnotation);
        this.documentService.saveDocument((Document)protocol.getProtocolDocument());
        ProtocolActionsCorrespondenceBase correspondence = this.getNewProtocolActionsCorrespondence(protocolActionTypeCode);
        correspondence.setPrintableBusinessObject((KraPersistableBusinessObjectBase)protocol);
        correspondence.setProtocol(protocol);
        this.protocolActionCorrespondenceGenerationService.generateCorrespondenceDocumentAndAttach(correspondence);
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public void setProtocolActionCorrespondenceGenerationService(ProtocolActionCorrespondenceGenerationService protocolActionCorrespondenceGenerationService) {
        this.protocolActionCorrespondenceGenerationService = protocolActionCorrespondenceGenerationService;
    }

    public ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        return this.protocolOnlineReviewService;
    }

    public void setProtocolOnlineReviewService(ProtocolOnlineReviewService protocolOnlineReviewService) {
        this.protocolOnlineReviewService = protocolOnlineReviewService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    protected ProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }

    protected ProtocolActionCorrespondenceGenerationService getProtocolActionCorrespondenceGenerationService() {
        return this.protocolActionCorrespondenceGenerationService;
    }
}

