/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.assignagenda;

import java.sql.Timestamp;
import java.util.Iterator;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.assignagenda.ProtocolAssignToAgendaBean;
import org.kuali.kra.protocol.actions.assignagenda.ProtocolAssignToAgendaService;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;

public abstract class ProtocolAssignToAgendaServiceImplBase
implements ProtocolAssignToAgendaService {
    private static final long serialVersionUID = 986748376L;
    private DocumentService documentService;
    private ProtocolActionService protocolActionService;
    private CommitteeServiceBase committeeService;

    public CommitteeServiceBase getCommitteeService() {
        return this.committeeService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public ProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }

    public void setCommitteeService(CommitteeServiceBase committeeService) {
        this.committeeService = committeeService;
    }

    protected ProtocolSubmissionBase findSubmission(ProtocolBase protocol) {
        ProtocolSubmissionBase returnSubmission = null;
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (!StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)this.getProtocolSubmissionStatusPendingCodeHook()) && !StringUtils.equals((String)submission.getSubmissionStatusCode(), (String)this.getProtocolSubmissionStatusSubmittedToCommitteeCodeHook()) || returnSubmission != null && returnSubmission.getSequenceNumber() >= submission.getSequenceNumber()) continue;
            returnSubmission = submission;
        }
        return returnSubmission;
    }

    protected abstract String getProtocolSubmissionStatusSubmittedToCommitteeCodeHook();

    protected abstract String getProtocolSubmissionStatusPendingCodeHook();

    public void assignToAgenda(ProtocolBase protocol, ProtocolAssignToAgendaBean actionBean) throws Exception {
        ProtocolSubmissionBase submission = this.findSubmission(protocol);
        ProtocolActionBase protocolAction = this.getNewProtocolAssignToAgendaActionInstanceHook(protocol, submission);
        protocolAction.setComments(actionBean.getComments());
        protocolAction.setActionDate(new Timestamp(actionBean.getActionDate().getTime()));
        protocol.getProtocolActions().add(protocolAction);
        this.protocolActionService.updateProtocolStatus(protocolAction, protocol);
        this.documentService.saveDocument((Document)protocol.getProtocolDocument());
    }

    protected abstract ProtocolActionBase getNewProtocolAssignToAgendaActionInstanceHook(ProtocolBase var1, ProtocolSubmissionBase var2);

    public boolean isAssignedToAgenda(ProtocolBase protocol) {
        String protocolSubmissionStatusCode = protocol.getProtocolSubmission().getSubmissionStatusCode();
        return this.getProtocolSubmissionStatusInAgendaCodeHook().equals(protocolSubmissionStatusCode);
    }

    protected abstract String getProtocolSubmissionStatusInAgendaCodeHook();

    public String getAssignToAgendaComments(ProtocolBase protocol) {
        ProtocolActionBase pa = this.getAssignedToAgendaProtocolAction(protocol);
        if (pa == null) {
            return "";
        }
        return pa.getComments();
    }

    public ProtocolActionBase getAssignedToAgendaProtocolAction(ProtocolBase protocol) {
        Iterator i = protocol.getProtocolActions().iterator();
        ProtocolActionBase returnAction = null;
        while (i.hasNext()) {
            ProtocolActionBase pa = (ProtocolActionBase)i.next();
            if (!pa.getProtocolActionType().getProtocolActionTypeCode().equals(this.getProtocolActionTypeAssignToAgendaCodeHook()) || returnAction != null && returnAction.getSequenceNumber() >= pa.getSequenceNumber() || !pa.getProtocolId().equals(protocol.getProtocolId())) continue;
            returnAction = pa;
        }
        return returnAction;
    }

    protected abstract String getProtocolActionTypeAssignToAgendaCodeHook();

    public String getAssignedCommitteeName(ProtocolBase protocol) {
        CommitteeBase com;
        String committeeID = this.getAssignedCommitteeId(protocol);
        if (committeeID != null && (com = this.committeeService.getCommitteeById(committeeID)) != null) {
            String committeeName = com.getCommitteeName();
            return committeeName;
        }
        return null;
    }
}

