/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.correction;

import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.correction.AdminCorrectionBean;
import org.kuali.kra.protocol.actions.correction.AdminCorrectionService;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.rice.core.api.util.xml.XmlJotter;
import org.kuali.rice.ken.api.service.SendNotificationService;
import org.kuali.rice.ken.util.Util;
import org.kuali.rice.krad.util.GlobalVariables;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public abstract class AdminCorrectionServiceImplBase
implements AdminCorrectionService {
    private SendNotificationService sendNotificationService;
    private List<String> notificationTemplates;
    private static final String DOC_LINK = "<a title=\"\" target=\"_self\" href=\"../kew/DocHandler.do?command=displayDocSearchView&amp;docId=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendCorrectionNotification(ProtocolBase protocol, AdminCorrectionBean adminCorrectionBean) throws Exception {
        Document notificationRequestDocument;
        String adminCorrectionNotificationTemplate = (String)this.notificationTemplates.get(0);
        InputStream is = this.getClass().getResourceAsStream(adminCorrectionNotificationTemplate);
        try {
            notificationRequestDocument = Util.parse((InputSource)new InputSource(is), (boolean)false, (boolean)false, null);
            Element recipientUser = (Element)notificationRequestDocument.getElementsByTagName("user").item(0);
            ProtocolPersonBase principalInvestigator = protocol.getPrincipalInvestigator();
            if (!principalInvestigator.isNonEmployee()) {
                recipientUser.setTextContent(principalInvestigator.getPerson().getUserName());
            } else {
                recipientUser.setTextContent(principalInvestigator.getRolodex().getFullName());
            }
            Element sender = (Element)notificationRequestDocument.getElementsByTagName("sender").item(0);
            sender.setTextContent(GlobalVariables.getUserSession().getPrincipalName());
            Element message = (Element)notificationRequestDocument.getElementsByTagName("message").item(0);
            message.setTextContent("The IRB ProtocolBase <a title=\"\" target=\"_self\" href=\"../kew/DocHandler.do?command=displayDocSearchView&amp;docId=" + protocol.getProtocolDocument().getDocumentNumber() + "\">" + protocol.getProtocolNumber() + "</a> has administrative correction made to it. <br/>" + " Comments : " + adminCorrectionBean.getComments());
            Element title = (Element)notificationRequestDocument.getElementsByTagName("title").item(0);
            title.setTextContent("Administrative Correction has been made to ProtocolBase " + protocol.getProtocolNumber());
            Element sendDateTime = (Element)notificationRequestDocument.getElementsByTagName("sendDateTime").item(0);
            sendDateTime.setTextContent(Util.toXSDDateTimeString((Date)Calendar.getInstance().getTime()));
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        String XML = XmlJotter.jotNode((Node)notificationRequestDocument, (boolean)true);
        this.sendNotificationService.invoke(XML);
    }

    public void setSendNotificationService(SendNotificationService sendNotificationService) {
        this.sendNotificationService = sendNotificationService;
    }

    public void setNotificationTemplates(List<String> notificationTemplates) {
        this.notificationTemplates = notificationTemplates;
    }
}

