/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.correspondence;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.xmlstream.XmlStream;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.correspondence.ProtocolActionTypeToCorrespondenceTemplateService;
import org.kuali.kra.protocol.actions.print.CorrespondenceXmlStreamBase;
import org.kuali.kra.protocol.actions.print.ProtocolPrintWatermarkBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondenceTemplateBase;
import org.kuali.kra.util.watermark.Watermarkable;

public abstract class ProtocolActionsCorrespondenceBase
extends AbstractPrint {
    private ProtocolBase protocol;

    public void setProtocol(ProtocolBase protcol) {
        this.protocol = protcol;
    }

    public ProtocolBase getProtocol() {
        return this.protocol;
    }

    public KraPersistableBusinessObjectBase getPrintableBusinessObject() {
        return this.getProtocol();
    }

    protected abstract ProtocolActionTypeToCorrespondenceTemplateService getProtocolActionTypeToCorrespondenceTemplateService();

    public abstract String getProtocolActionType();

    private List<ProtocolCorrespondenceTemplateBase> getCorrespondenceTemplates() {
        List templates = this.getProtocolActionTypeToCorrespondenceTemplateService().getTemplatesByProtocolAction(this.getProtocolActionType());
        return templates;
    }

    public List<Source> getXSLTemplates() {
        ArrayList<Source> sourceList = new ArrayList<Source>();
        List templates = this.getCorrespondenceTemplates();
        for (ProtocolCorrespondenceTemplateBase template : templates) {
            ByteArrayInputStream iputStream = new ByteArrayInputStream(template.getCorrespondenceTemplate());
            StreamSource stream = new StreamSource(iputStream);
            sourceList.add(stream);
        }
        return sourceList;
    }

    public String getProtoCorrespTypeCode() {
        List templates = this.getCorrespondenceTemplates();
        Iterator i$ = templates.iterator();
        if (i$.hasNext()) {
            ProtocolCorrespondenceTemplateBase template = (ProtocolCorrespondenceTemplateBase)i$.next();
            return template.getProtoCorrespTypeCode();
        }
        return "";
    }

    public Map<String, byte[]> renderXML() throws PrintingException {
        this.setXmlStream((XmlStream)this.getCorrespondenceXmlStream());
        return super.renderXML();
    }

    public abstract CorrespondenceXmlStreamBase getCorrespondenceXmlStream();

    public boolean isWatermarkEnabled() {
        return true;
    }

    public Watermarkable getWatermarkable() {
        ProtocolPrintWatermarkBase prtocolPrintWatermark = this.getNewProtocolPrintWatermarkInstanceHook();
        prtocolPrintWatermark.setPersistableBusinessObject(this.getPrintableBusinessObject());
        return prtocolPrintWatermark;
    }

    protected abstract ProtocolPrintWatermarkBase getNewProtocolPrintWatermarkInstanceHook();

    public String getLeadUnitNumber() {
        return this.getProtocol().getLeadUnitNumber();
    }

    protected abstract String getAdministratorType();

    protected abstract String getModuleNameSpace();
}

