/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.decision;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.service.CommitteeScheduleAttendanceServiceBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.decision.CommitteeDecision;
import org.kuali.kra.protocol.actions.decision.ExecuteCommitteeDecisionRule;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsBeanBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.rules.ResearchDocumentRuleBase;

public abstract class CommitteeDecisionRuleBase<CD extends CommitteeDecision<?>>
extends ResearchDocumentRuleBase
implements ExecuteCommitteeDecisionRule<CD> {
    private static final String DOT = ".";
    private static final String MOTION_FIELD = "motionTypeCode";
    private static final String YES_COUNT_FIELD = "yesCount";
    private static final String NO_COUNT_FIELD = "noCount";
    private CommitteeScheduleAttendanceServiceBase attendanceService;

    protected final CommitteeScheduleAttendanceServiceBase getAttendanceService() {
        if (this.attendanceService == null) {
            this.attendanceService = (CommitteeScheduleAttendanceServiceBase)KraServiceLocator.getService((Class)this.getCommitteeScheduleAttendanceServiceClassHook());
        }
        return this.attendanceService;
    }

    protected abstract Class<? extends CommitteeScheduleAttendanceServiceBase> getCommitteeScheduleAttendanceServiceClassHook();

    public void setAttendanceService(CommitteeScheduleAttendanceServiceBase attendanceService) {
        this.attendanceService = attendanceService;
    }

    public boolean proccessCommitteeDecisionRule(ProtocolDocumentBase document, CD committeeDecision) {
        boolean isValid = true;
        isValid &= this.processMotion(committeeDecision);
        return isValid &= this.processCounts(document.getProtocol().getProtocolSubmission(), committeeDecision);
    }

    private boolean processMotion(CD committeeDecision) {
        boolean retVal = true;
        if (StringUtils.isBlank((String)committeeDecision.getMotionTypeCode())) {
            this.reportError("actionHelper.committeeDecision.motionTypeCode", "error.protocol.recordcommittee.motion.not.selected", new String[0]);
            retVal = false;
        } else {
            String motionTypeCode = committeeDecision.getMotionTypeCode();
            ReviewCommentsBeanBase reviewerCommentsBean = committeeDecision.getReviewCommentsBean();
            List reviewComments = reviewerCommentsBean.getReviewComments();
            ProtocolBase protocol = committeeDecision.getProtocol();
            if (("3".equals(motionTypeCode) || "4".equals(motionTypeCode) || "2".equals(motionTypeCode)) && CollectionUtils.isEmpty((Collection)this.filterReviewComments(reviewComments, protocol))) {
                this.reportError("actionHelper.committeeDecision.motionTypeCode", this.getNoCommentsForRevisionsErrorMessageHook(), new String[0]);
                retVal = false;
            }
        }
        return retVal;
    }

    protected String getNoCommentsForRevisionsErrorMessageHook() {
        return "error.protocol.recordcommittee.no.smrsrrdisapprove.reviewer.comments";
    }

    private List<CommitteeScheduleMinuteBase> filterReviewComments(List<CommitteeScheduleMinuteBase> reviewComments, ProtocolBase protocol) {
        ArrayList<CommitteeScheduleMinuteBase> filteredComments = new ArrayList<CommitteeScheduleMinuteBase>();
        for (CommitteeScheduleMinuteBase comment : reviewComments) {
            if (!protocol.getProtocolId().equals(comment.getProtocolId())) continue;
            filteredComments.add(comment);
        }
        return filteredComments;
    }

    protected boolean processCounts(ProtocolSubmissionBase submission, CD committeeDecision) {
        boolean retVal = true;
        String committeeId = submission.getCommittee() != null ? submission.getCommittee().getCommitteeId() : null;
        String scheduleId = submission.getScheduleId();
        int membersPresent = this.getAttendanceService().getActualVotingMembersCount(committeeId, scheduleId);
        if (membersPresent < committeeDecision.getTotalVoteCount()) {
            this.reportError("actionHelper.committeeDecision", "error.protocol.recordcommittee.votecount.invalid", new String[0]);
            retVal = false;
        }
        if (committeeDecision.getYesCount() == null) {
            this.reportError("actionHelper.committeeDecision.yesCount", "error.protocol.recordcommittee.no.yescount", new String[0]);
            retVal = false;
        } else if (committeeDecision.getYesCountValue() <= 0) {
            this.reportError("actionHelper.committeeDecision.yesCount", "error.protocol.recordcommittee.vote.count.yesCount.notPositive", new String[0]);
            retVal = false;
        } else if (committeeDecision.getYesCountValue() <= committeeDecision.getNoCountValue()) {
            this.reportError("actionHelper.committeeDecision", "error.protocol.recordcommittee.vote.count.yesCount.notGreater", new String[0]);
            retVal = false;
        }
        if (committeeDecision.getNoCountValue() < 0) {
            this.reportError("actionHelper.committeeDecision.noCount", "error.protocol.recordcommittee.vote.count.noCount.notNonNegative", new String[0]);
            retVal = false;
        }
        return retVal;
    }
}

