/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.followup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.followup.FollowupActionService;
import org.kuali.kra.protocol.actions.submit.ValidProtocolActionActionBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class FollowupActionServiceImplBase<T extends ValidProtocolActionActionBase>
implements FollowupActionService<T> {
    BusinessObjectService businessObjectService;
    private static final String PROTOCOL_ACTION_TYPE_CODE = "protocolActionTypeCode";
    private static final String COMMITTEE_MOTION_TYPE_CODE = "motionTypeCode";

    public List<T> getFollowupsForActionTypeAndMotionType(String protocolActionTypeCode, String committeeMotionTypeCode) {
        HashMap<String, String> fieldSet = new HashMap<String, String>();
        if (!StringUtils.isEmpty((String)protocolActionTypeCode)) {
            fieldSet.put(PROTOCOL_ACTION_TYPE_CODE, protocolActionTypeCode);
        }
        fieldSet.put(COMMITTEE_MOTION_TYPE_CODE, committeeMotionTypeCode);
        List resultSet = (List)this.businessObjectService.findMatching(this.getValidProtocolActionActionClassHook(), fieldSet);
        return resultSet;
    }

    protected abstract Class<T> getValidProtocolActionActionClassHook();

    public List<T> getFollowupsForActionTypeCode(String protocolActionTypeCode) {
        List resultSet = new ArrayList();
        if (!StringUtils.isEmpty((String)protocolActionTypeCode)) {
            HashMap<String, String> fieldSet = new HashMap<String, String>();
            fieldSet.put(PROTOCOL_ACTION_TYPE_CODE, protocolActionTypeCode);
            resultSet = (List)this.businessObjectService.findMatching(this.getValidProtocolActionActionClassHook(), fieldSet);
        }
        return resultSet;
    }

    public List<T> getFollowupsForProtocol(ProtocolBase protocol) {
        if (protocol.getLastProtocolAction() == null) {
            return new ArrayList();
        }
        List resultList = StringUtils.equals((String)protocol.getLastProtocolAction().getProtocolActionTypeCode(), (String)this.getProtocolActionTypeCodeForRecordCommitteeDecisionHook()) ? this.getFollowupsForActionTypeAndMotionType(this.getProtocolActionTypeCodeForRecordCommitteeDecisionHook(), protocol.getProtocolSubmission().getCommitteeDecisionMotionTypeCode()) : this.getFollowupsForActionTypeCode(protocol.getLastProtocolAction().getProtocolActionTypeCode());
        return resultList;
    }

    protected abstract String getProtocolActionTypeCodeForRecordCommitteeDecisionHook();

    public boolean isActionOpenForFollowup(String protocolActionTypeCode, ProtocolBase protocol) {
        if (this.getLogHook().isDebugEnabled()) {
            this.getLogHook().debug((Object)"**********************************");
            this.getLogHook().debug((Object)String.format("isActionOpenForFollowup called for action type code %s, on protocol %s", protocolActionTypeCode, protocol.getProtocolNumber()));
            this.getLogHook().debug((Object)String.format("Last protocol action was %s", protocol.getLastProtocolAction().getProtocolActionTypeCode()));
        }
        boolean result = false;
        List valids = this.getFollowupsForActionTypeCode(protocol.getLastProtocolAction().getProtocolActionTypeCode());
        for (ValidProtocolActionActionBase protocolActionAction : valids) {
            if (!StringUtils.equals((String)protocolActionAction.getFollowupActionCode(), (String)protocolActionTypeCode)) continue;
            if (!StringUtils.isEmpty((String)protocolActionAction.getMotionTypeCode())) {
                if (this.getLogHook().isDebugEnabled()) {
                    this.getLogHook().debug((Object)String.format("%s %s has defined MotionTypeCode %s, checking motion on protocol.", this.getValidProtocolActionActionClassHook().getName(), protocolActionAction.getValidProtocolActionActionId(), protocolActionAction.getMotionTypeCode()));
                }
                if (!StringUtils.equals((String)protocol.getProtocolSubmission().getCommitteeDecisionMotionTypeCode(), (String)protocolActionAction.getMotionTypeCode())) continue;
                if (this.getLogHook().isDebugEnabled()) {
                    this.getLogHook().debug((Object)"MotionType matches last motion on protocol.");
                }
                result = true;
                break;
            }
            result = true;
            break;
        }
        if (this.getLogHook().isDebugEnabled()) {
            this.getLogHook().debug((Object)String.format("isActionOpenForFollowup returning %s for type code %s", result, protocolActionTypeCode));
            this.getLogHook().debug((Object)"**********************************");
        }
        return result;
    }

    protected abstract Log getLogHook();

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

