/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.print;

import com.lowagie.text.Image;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.bo.Watermark;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.notification.ProtocolNotificationRendererBase;
import org.kuali.kra.util.watermark.Font;
import org.kuali.kra.util.watermark.WatermarkBean;
import org.kuali.kra.util.watermark.WatermarkConstants;
import org.kuali.kra.util.watermark.Watermarkable;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class ProtocolPrintWatermarkBase
implements Watermarkable {
    private KraPersistableBusinessObjectBase persistableBusinessObject;
    private static final Log LOG = LogFactory.getLog(ProtocolPrintWatermarkBase.class);
    private static final String INVALID_WATERMARK_CODE = "-1";
    private WatermarkBean watermarkBean;

    private BusinessObjectService getBusinessObjectService() {
        return (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    public WatermarkBean getWatermark() {
        ProtocolBase protocol = (ProtocolBase)this.getPersistableBusinessObject();
        String protocolStatusCode = protocol.getProtocolStatusCode();
        if (protocolStatusCode != null) {
            WatermarkBean waterMarkBean = null;
            try {
                waterMarkBean = this.getProtocolWatermarkBeanObject(protocolStatusCode);
            }
            catch (Exception e) {
                LOG.error((Object)"Exception Occured in (ProtocolPrintWatermarkBase) :", (Throwable)e);
            }
            return waterMarkBean;
        }
        return null;
    }

    public WatermarkBean getInvalidWatermark() {
        String watermarkStatusCode = INVALID_WATERMARK_CODE;
        WatermarkBean waterMarkBean = null;
        try {
            waterMarkBean = this.getProtocolWatermarkBeanObject(watermarkStatusCode);
        }
        catch (Exception e) {
            LOG.error((Object)"Exception Occured in (ProtocolPrintWatermarkBase) :", (Throwable)e);
        }
        return waterMarkBean;
    }

    public WatermarkBean getProtocolWatermarkBeanObject(String protocolStatusCode) {
        WatermarkBean watermarkBean = new WatermarkBean();
        Watermark watermark = null;
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("statusCode", protocolStatusCode);
        Collection watermarks = this.getBusinessObjectService().findMatching(Watermark.class, fields);
        if (watermarks != null && watermarks.size() > 0) {
            watermark = (Watermark)watermarks.iterator().next();
        }
        if (watermark != null && watermark.isWatermarkStatus()) {
            try {
                String watermarkFontSize = watermark.getFontSize() == null ? "25" : watermark.getFontSize();
                String watermarkFontColour = watermark.getFontColor() == null ? "FONT-COLOR" : watermark.getFontColor();
                watermarkBean.setType(watermark.getWatermarkType() == null ? "TEXT" : watermark.getWatermarkType());
                watermarkBean.setPosition(watermark.getWatermarkPosition() == null ? "HEADER" : watermark.getWatermarkPosition());
                String watermarkPositionFontSize = watermark.getPositionFontSize() == null ? "25" : watermark.getPositionFontSize();
                watermarkBean.setAlignment(watermark.getWatermarkAlignment() == null ? "CENTER" : watermark.getWatermarkAlignment());
                watermarkBean.setFont(this.getWatermarkFont("FONT", watermarkFontSize, watermarkFontColour));
                watermarkBean.setPositionFont(this.getWatermarkPositionFont("FONT", watermarkPositionFontSize, watermarkFontColour));
                ProtocolNotificationRendererBase renderer = this.getNewProtocolNotificationRendererInstanceHook((ProtocolBase)this.getPersistableBusinessObject());
                if (watermark.getWatermarkText() != null) {
                    watermarkBean.setText(renderer.render(watermark.getWatermarkText()));
                }
                if (watermarkBean.getType().equals("IMAGE")) {
                    watermarkBean.setText(watermark.getFileName());
                    byte[] imageData = watermark.getAttachmentContent();
                    if (imageData != null) {
                        Image imageFile = Image.getInstance((byte[])imageData);
                        watermarkBean.setFileImage(imageFile);
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Exception Occured in (ProtocolPrintWatermarkBase) :", (Throwable)e);
            }
            return watermarkBean;
        }
        return null;
    }

    protected abstract ProtocolNotificationRendererBase getNewProtocolNotificationRendererInstanceHook(ProtocolBase var1);

    private Font getWatermarkFont(String watermarkFontName, String watermarkSize, String watermarkColour) {
        Font watermarkFont = new Font(25);
        watermarkFont.setFont(watermarkFontName);
        if (StringUtils.isNotBlank((String)watermarkSize)) {
            try {
                watermarkFont.setSize(Integer.parseInt(watermarkSize));
            }
            catch (NumberFormatException numberFormatException) {
                watermarkFont.setSize(50);
                LOG.error((Object)"Exception Occuring in ProtocolPrintWatermarkBase:(getFont:numberFormatException)");
            }
        } else {
            watermarkFont.setSize(50);
        }
        if (StringUtils.isNotBlank((String)watermarkColour)) {
            watermarkFont.setColor(watermarkColour);
        } else {
            watermarkFont.setColor(WatermarkConstants.DEFAULT_WATERMARK_COLOR);
        }
        return watermarkFont;
    }

    private Font getWatermarkPositionFont(String watermarkFontName, String watermarkSize, String watermarkColour) {
        Font watermarkFont = new Font(25);
        watermarkFont.setFont(watermarkFontName);
        if (StringUtils.isNotBlank((String)watermarkSize)) {
            try {
                watermarkFont.setSize(Integer.parseInt(watermarkSize));
            }
            catch (NumberFormatException numberFormatException) {
                watermarkFont.setSize(50);
                LOG.error((Object)"Exception Occuring in ProtocolPrintWatermarkBase:(getFont:numberFormatException)");
            }
        } else {
            watermarkFont.setSize(50);
        }
        if (StringUtils.isNotBlank((String)watermarkColour)) {
            watermarkFont.setColor(watermarkColour);
        } else {
            watermarkFont.setColor(WatermarkConstants.DEFAULT_WATERMARK_COLOR);
        }
        return watermarkFont;
    }

    public WatermarkBean getWatermarkBean() {
        return this.watermarkBean;
    }

    public void setWatermarkBean(WatermarkBean watermarkBean) {
        this.watermarkBean = watermarkBean;
    }

    public KraPersistableBusinessObjectBase getPersistableBusinessObject() {
        return this.persistableBusinessObject;
    }

    public void setPersistableBusinessObject(KraPersistableBusinessObjectBase persistableBusinessObject) {
        this.persistableBusinessObject = persistableBusinessObject;
    }
}

