/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.printing.Printable;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.print.AbstractPrint;
import org.kuali.kra.printing.service.impl.PrintingServiceImpl;
import org.kuali.kra.proposaldevelopment.bo.AttachmentDataSource;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.actions.print.ProtocolFullProtocolPrintBase;
import org.kuali.kra.protocol.actions.print.ProtocolHistoryPrintBase;
import org.kuali.kra.protocol.actions.print.ProtocolPrintHelper;
import org.kuali.kra.protocol.actions.print.ProtocolPrintType;
import org.kuali.kra.protocol.actions.print.ProtocolPrintingService;
import org.kuali.kra.protocol.actions.print.ProtocolPrintingServiceImplBase;
import org.kuali.kra.protocol.actions.print.ProtocolReviewCommentsPrintBase;
import org.kuali.kra.protocol.actions.print.ProtocolSummaryPrintOptions;
import org.kuali.kra.protocol.actions.print.ProtocolSummaryViewPrintBase;

public abstract class ProtocolPrintingServiceImplBase
extends PrintingServiceImpl
implements ProtocolPrintingService {
    protected static final String ERROR_MESSAGE = "Unknown report type specified";
    private ProtocolFullProtocolPrintBase protocolFullProtocolPrint;
    private ProtocolHistoryPrintBase protocolHistoryPrint;
    private ProtocolReviewCommentsPrintBase protocolReviewCommentsPrint;
    private ProtocolSummaryViewPrintBase protocolSummaryViewPrint;
    private static final String FILE_NAME_EXTENSION = "report.pdf";
    private static final String REPORT_PREFIX = "ProtocolBase-";
    private static final Map<String, String> PRINTTAG_MAP = new /* Unavailable Anonymous Inner Class!! */;
    private String reportName;

    public Printable getProtocolPrintable(ProtocolPrintType reportType) {
        ProtocolFullProtocolPrintBase printable = null;
        ProtocolPrintHelper printHelper = this.getProtocolPrintHelper(reportType);
        switch (2.$SwitchMap$org$kuali$kra$protocol$actions$print$ProtocolPrintType[reportType.ordinal()]) {
            case 1: {
                this.getProtocolFullProtocolPrint().setPrintHelper(printHelper);
                printable = this.getProtocolFullProtocolPrint();
                break;
            }
            case 2: {
                this.getProtocolHistoryPrint().setPrintHelper(printHelper);
                printable = this.getProtocolHistoryPrint();
                break;
            }
            case 3: {
                this.getProtocolReviewCommentsPrint().setPrintHelper(printHelper);
                printable = this.getProtocolReviewCommentsPrint();
                break;
            }
            case 4: {
                this.getProtocolSummaryViewPrint().setPrintHelper(printHelper);
                printable = this.getProtocolSummaryViewPrint();
                break;
            }
            default: {
                throw new IllegalArgumentException(ERROR_MESSAGE);
            }
        }
        return printable;
    }

    public Printable getProtocolPrintArtifacts(ProtocolBase protocol) {
        ProtocolPrintType printType = ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT;
        AbstractPrint printable = (AbstractPrint)this.getProtocolPrintable(printType);
        printable.setPrintableBusinessObject((KraPersistableBusinessObjectBase)protocol);
        return printable;
    }

    public ProtocolFullProtocolPrintBase getProtocolFullProtocolPrint() {
        return this.protocolFullProtocolPrint;
    }

    public void setProtocolFullProtocolPrint(ProtocolFullProtocolPrintBase protocolFullProtocolPrint) {
        this.protocolFullProtocolPrint = protocolFullProtocolPrint;
    }

    public ProtocolHistoryPrintBase getProtocolHistoryPrint() {
        return this.protocolHistoryPrint;
    }

    public void setProtocolHistoryPrint(ProtocolHistoryPrintBase protocolHistoryPrint) {
        this.protocolHistoryPrint = protocolHistoryPrint;
    }

    public ProtocolReviewCommentsPrintBase getProtocolReviewCommentsPrint() {
        return this.protocolReviewCommentsPrint;
    }

    public void setProtocolReviewCommentsPrint(ProtocolReviewCommentsPrintBase protocolReviewCommentsPrint) {
        this.protocolReviewCommentsPrint = protocolReviewCommentsPrint;
    }

    public ProtocolSummaryViewPrintBase getProtocolSummaryViewPrint() {
        return this.protocolSummaryViewPrint;
    }

    public void setProtocolSummaryViewPrint(ProtocolSummaryViewPrintBase protocolSummaryViewPrint) {
        this.protocolSummaryViewPrint = protocolSummaryViewPrint;
    }

    public String getReportName() {
        return this.reportName;
    }

    public void setReportName(String reportName) {
        this.reportName = reportName;
    }

    public AttachmentDataSource print(String reportName, List<Printable> printableArtifactList) throws PrintingException {
        this.setReportName(reportName);
        return super.print(printableArtifactList);
    }

    protected List<Printable> getPrintReportArtifacts(ProtocolFormBase protocolForm, StringBuffer fileName) {
        Map reportParameters;
        Boolean printSummary = protocolForm.getActionHelper().getSummaryReport();
        Boolean printFull = protocolForm.getActionHelper().getFullReport();
        Boolean printHistory = protocolForm.getActionHelper().getHistoryReport();
        Boolean printReviewComments = protocolForm.getActionHelper().getReviewCommentsReport();
        ProtocolBase protocol = protocolForm.getProtocolDocument().getProtocol();
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        if (printSummary.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_SUMMARY_VIEW_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocol, "summary", fileName, reportParameters));
            protocolForm.getActionHelper().setSummaryReport(Boolean.valueOf(false));
        }
        if (printFull.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocol, "full", fileName, reportParameters));
            protocolForm.getActionHelper().setFullReport(Boolean.valueOf(false));
        }
        if (printHistory.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_PROTOCOL_HISTORY_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocol, "history", fileName, reportParameters));
            protocolForm.getActionHelper().setHistoryReport(Boolean.valueOf(false));
        }
        if (printReviewComments.booleanValue()) {
            reportParameters = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_REVIEW_COMMENTS_REPORT);
            printableArtifactList.add(this.getPrintableArtifacts(protocol, "comments", fileName, reportParameters));
            protocolForm.getActionHelper().setReviewCommentsReport(Boolean.valueOf(false));
        }
        fileName.append(FILE_NAME_EXTENSION);
        return printableArtifactList;
    }

    protected Map<Class, Object> getReportOptions(ProtocolFormBase protocolForm, ProtocolPrintType printType) {
        HashMap<Class, Object> reportParameters = new HashMap<Class, Object>();
        ProtocolSummaryPrintOptions summaryOptions = protocolForm.getActionHelper().getProtocolPrintOption();
        if (printType.equals((Object)ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT)) {
            summaryOptions.setActions(true);
            summaryOptions.setAmendmentRenewalHistory(true);
            summaryOptions.setAmmendmentRenewalSummary(true);
            summaryOptions.setAreaOfResearch(true);
            summaryOptions.setAttachments(true);
            summaryOptions.setCorrespondents(true);
            summaryOptions.setDocuments(true);
            summaryOptions.setFundingSource(true);
            summaryOptions.setInvestigator(true);
            summaryOptions.setNotes(true);
            summaryOptions.setOrganizaition(true);
            summaryOptions.setProtocolDetails(true);
            summaryOptions.setReferences(true);
            summaryOptions.setRiskLevel(true);
            summaryOptions.setRoles(true);
            summaryOptions.setSpecialReview(true);
            summaryOptions.setStudyPersonnels(true);
            summaryOptions.setSubjects(true);
        }
        reportParameters.put(ProtocolSummaryPrintOptions.class, summaryOptions);
        return reportParameters;
    }

    protected Printable getPrintableArtifacts(ProtocolBase protocol, String reportType, StringBuffer fileName, Map reportParameters) {
        ProtocolPrintType printType = ProtocolPrintType.valueOf((String)((String)PRINTTAG_MAP.get(reportType)));
        AbstractPrint printable = (AbstractPrint)this.getProtocolPrintable(printType);
        printable.setPrintableBusinessObject((KraPersistableBusinessObjectBase)protocol);
        printable.setReportParameters(reportParameters);
        fileName.append(reportType).append("-");
        return printable;
    }

    protected List<Printable> getPrintArtifacts(ProtocolFormBase protocolForm) {
        ArrayList<Printable> printableArtifactList = new ArrayList<Printable>();
        ProtocolPrintType printType = ProtocolPrintType.valueOf((String)((String)PRINTTAG_MAP.get("full")));
        AbstractPrint printable = (AbstractPrint)this.getProtocolPrintable(printType);
        printable.setPrintableBusinessObject((KraPersistableBusinessObjectBase)protocolForm.getProtocolDocument().getProtocol());
        HashMap<Class<ProtocolSummaryPrintOptions>, ProtocolSummaryPrintOptions> reportParameters = new HashMap<Class<ProtocolSummaryPrintOptions>, ProtocolSummaryPrintOptions>();
        ProtocolSummaryPrintOptions summaryOptions = protocolForm.getActionHelper().getProtocolPrintOption();
        reportParameters.put(ProtocolSummaryPrintOptions.class, summaryOptions);
        printable.setReportParameters(reportParameters);
        printableArtifactList.add((Printable)printable);
        if (summaryOptions.isReviewComments()) {
            Map reportParameters1 = this.getReportOptions(protocolForm, ProtocolPrintType.PROTOCOL_REVIEW_COMMENTS_REPORT);
            AbstractPrint printable1 = (AbstractPrint)this.getProtocolPrintable(ProtocolPrintType.valueOf((String)((String)PRINTTAG_MAP.get("comments"))));
            printable1.setPrintableBusinessObject((KraPersistableBusinessObjectBase)protocolForm.getProtocolDocument().getProtocol());
            printable1.setReportParameters(reportParameters1);
            printableArtifactList.add((Printable)printable1);
        }
        return printableArtifactList;
    }

    public AttachmentDataSource printProtocolDocument(ProtocolFormBase protocolForm) throws PrintingException {
        ProtocolBase protocol = protocolForm.getProtocolDocument().getProtocol();
        StringBuffer fileName = new StringBuffer().append(REPORT_PREFIX);
        String protocolNumber = protocol.getProtocolNumber();
        ProtocolPrintHelper printHelper = this.getProtocolPrintHelper(ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT);
        String reportPrintName = printHelper.getReportName();
        String reportName = protocolNumber + "-" + reportPrintName;
        return this.print(reportName, this.getPrintReportArtifacts(protocolForm, fileName));
    }

    public AttachmentDataSource printProtocolSelectedItems(ProtocolFormBase protocolForm) throws PrintingException {
        ProtocolBase protocol = protocolForm.getProtocolDocument().getProtocol();
        ProtocolPrintHelper printHelper = this.getProtocolPrintHelper(ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT);
        String reportName = protocol.getProtocolNumber() + "-" + printHelper.getReportName();
        AttachmentDataSource dataSource = this.print(reportName, this.getPrintArtifacts(protocolForm));
        dataSource.setFileName(this.getProtocolPrintHelper(ProtocolPrintType.PROTOCOL_FULL_PROTOCOL_REPORT).getFileName());
        return dataSource;
    }

    private ProtocolPrintHelper getProtocolPrintHelper(ProtocolPrintType printType) {
        return (ProtocolPrintHelper)this.getProtocolPrintParameterHook().get(printType);
    }

    protected abstract HashMap<ProtocolPrintType, ProtocolPrintHelper> getProtocolPrintParameterHook();
}

