/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.print;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.print.ProtocolQuestionnairePrintingService;
import org.kuali.kra.protocol.actions.print.QuestionnairePrintOption;
import org.kuali.kra.protocol.actions.print.QuestionnairePrintOptionComparator;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class ProtocolQuestionnairePrintingServiceImplBase
implements ProtocolQuestionnairePrintingService {
    private ProtocolBase protocol;
    private BusinessObjectService businessObjectService;
    private QuestionnaireAnswerService questionnaireAnswerService;

    public void setupQnPrintOption(List<AnswerHeader> answerHeaders, ProtocolBase protocol, List<QuestionnairePrintOption> questionnairesToPrints) {
        this.setProtocol(protocol);
        int maxSubmissionNumber = this.getMaxSubmissionNumber();
        for (AnswerHeader answerHeader : answerHeaders) {
            if ((!"2".equals(answerHeader.getModuleSubItemCode()) || Integer.parseInt(answerHeader.getModuleSubItemKey()) > maxSubmissionNumber) && !this.isCurrentAmendRenewalQn(answerHeader)) continue;
            QuestionnairePrintOption printOption = new QuestionnairePrintOption();
            printOption.setQuestionnaireRefId(answerHeader.getQuestionnaire().getQuestionnaireRefIdAsLong());
            printOption.setQuestionnaireId(answerHeader.getQuestionnaire().getQuestionnaireIdAsInteger());
            printOption.setSelected(true);
            printOption.setQuestionnaireName(answerHeader.getQuestionnaire().getName());
            printOption.setLabel(this.getQuestionnaireLabel(answerHeader));
            printOption.setItemKey(answerHeader.getModuleItemKey());
            printOption.setSubItemKey(answerHeader.getModuleSubItemKey());
            printOption.setSubItemCode(answerHeader.getModuleSubItemCode());
            printOption.setQuestionnaireActive(this.isQuestionnaireActive(answerHeader));
            questionnairesToPrints.add(printOption);
        }
        Collections.sort(questionnairesToPrints, new QuestionnairePrintOptionComparator());
    }

    private boolean isQuestionnaireActive(AnswerHeader answerHeader) {
        Integer questionnaireId = answerHeader.getQuestionnaire().getQuestionnaireIdAsInteger();
        String coeusModuleCode = answerHeader.getModuleItemCode();
        String coeusSubModuleCode = answerHeader.getModuleSubItemCode();
        return this.getQuestionnaireAnswerService().checkIfQuestionnaireIsActiveForModule(questionnaireId, coeusModuleCode, coeusSubModuleCode);
    }

    private int getMaxSubmissionNumber() {
        int maxSubmissionNumber = 0;
        for (Integer submissionNumber : this.getAvailableSubmissionNumbers()) {
            if (submissionNumber <= maxSubmissionNumber) continue;
            maxSubmissionNumber = submissionNumber;
        }
        return maxSubmissionNumber;
    }

    private List<Integer> getAvailableSubmissionNumbers() {
        ArrayList<Integer> submissionNumbers = new ArrayList<Integer>();
        for (ProtocolSubmissionBase submission : this.getProtocol().getProtocolSubmissions()) {
            submissionNumbers.add(submission.getSubmissionNumber());
        }
        return submissionNumbers;
    }

    private boolean isCurrentAmendRenewalQn(AnswerHeader answerHeader) {
        boolean isCurrentQn;
        boolean bl = isCurrentQn = "1".equals(answerHeader.getModuleSubItemCode()) || "0".equals(answerHeader.getModuleSubItemCode());
        if (isCurrentQn) {
            if ("0".equals(answerHeader.getModuleSubItemCode())) {
                isCurrentQn = this.isCurrentRegularQn(answerHeader);
            } else if ("1".equals(answerHeader.getModuleSubItemCode())) {
                isCurrentQn = this.isCurrentAorRQn(answerHeader);
            }
        }
        return isCurrentQn;
    }

    private String getQuestionnaireLabel(AnswerHeader answerHeader) {
        String label = null;
        List usages = answerHeader.getQuestionnaire().getQuestionnaireUsages();
        if (CollectionUtils.isNotEmpty((Collection)usages) && usages.size() > 1) {
            Collections.sort(usages);
        }
        for (QuestionnaireUsage usage : usages) {
            if (!this.getCoeusModuleCode().equals(usage.getModuleItemCode()) || !answerHeader.getModuleSubItemCode().equals(usage.getModuleSubItemCode())) continue;
            if ("0".equals(answerHeader.getModuleSubItemCode())) {
                label = usage.getQuestionnaireLabel();
                continue;
            }
            if ("2".equals(answerHeader.getModuleSubItemCode())) {
                HashMap<String, Object> keyValues = new HashMap<String, Object>();
                keyValues.put("protocolNumber", answerHeader.getModuleItemKey());
                keyValues.put("submissionNumber", answerHeader.getModuleSubItemKey());
                List submissions = (List)this.getBusinessObjectService().findMatchingOrderBy(this.getProtocolSubmissionBOClassHook(), keyValues, "submissionId", false);
                if (submissions.isEmpty()) {
                    label = usage.getQuestionnaireLabel();
                    continue;
                }
                keyValues.clear();
                keyValues.put("protocolId", ((ProtocolSubmissionBase)submissions.get(0)).getProtocolId());
                keyValues.put("submissionNumber", answerHeader.getModuleSubItemKey());
                ProtocolActionBase protocolAction = (ProtocolActionBase)((List)this.getBusinessObjectService().findMatching(this.getProtocolActionBOClassHook(), keyValues)).get(0);
                label = usage.getQuestionnaireLabel() + " - " + protocolAction.getProtocolActionType().getDescription() + " - " + protocolAction.getActionDateString();
                continue;
            }
            if (!"1".equals(answerHeader.getModuleSubItemCode())) continue;
            if (answerHeader.getModuleItemKey().contains("A")) {
                label = usage.getQuestionnaireLabel() + " - Amendment " + answerHeader.getModuleItemKey().substring(10);
                continue;
            }
            label = usage.getQuestionnaireLabel() + " - Renewal " + answerHeader.getModuleItemKey().substring(10);
        }
        return label;
    }

    protected abstract Class<? extends ProtocolActionBase> getProtocolActionBOClassHook();

    protected abstract Class<? extends ProtocolSubmissionBase> getProtocolSubmissionBOClassHook();

    private boolean isCurrentRegularQn(AnswerHeader answerHeader) {
        boolean isCurrentQn = false;
        if ((this.getProtocol().isAmendment() || this.getProtocol().isRenewal()) && !answerHeader.getModuleItemKey().equals(this.getProtocol().getProtocolNumber())) {
            HashMap<String, String> keyValues = new HashMap<String, String>();
            keyValues.put("protocolNumber", answerHeader.getModuleItemKey());
            ProtocolBase prevProtocol = null;
            for (ProtocolBase protocol : (List)this.getBusinessObjectService().findMatchingOrderBy(this.getProtocolBOClassHook(), keyValues, "sequenceNumber", true)) {
                boolean bl = isCurrentQn = answerHeader.getModuleSubItemKey().equals(protocol.getSequenceNumber().toString()) && !CollectionUtils.isEmpty((Collection)this.getProtocol().getProtocolSubmissions()) && this.isMergedToProtocol(protocol, this.getProtocol());
                if (isCurrentQn) {
                    if (prevProtocol == null || !this.isMergedToProtocol(prevProtocol, this.getProtocol())) break;
                    isCurrentQn = false;
                }
                prevProtocol = protocol;
            }
        } else {
            isCurrentQn = answerHeader.getModuleSubItemKey().equals(this.getProtocol().getSequenceNumber().toString());
        }
        return isCurrentQn;
    }

    protected abstract Class<? extends ProtocolBase> getProtocolBOClassHook();

    private boolean isMergedToProtocol(ProtocolBase protocol, ProtocolBase amendment) {
        boolean merged = false;
        int submissionNumber = ((ProtocolSubmissionBase)amendment.getProtocolSubmissions().get(amendment.getProtocolSubmissions().size() - 1)).getSubmissionNumber();
        for (ProtocolSubmissionBase submission : protocol.getProtocolSubmissions()) {
            if (submissionNumber != submission.getSubmissionNumber()) continue;
            merged = true;
            break;
        }
        return merged;
    }

    private boolean isCurrentAorRQn(AnswerHeader answerHeader) {
        boolean isCurrentQn = false;
        if (this.getProtocol().isAmendment() || this.getProtocol().isRenewal()) {
            isCurrentQn = answerHeader.getModuleSubItemKey().equals(this.getProtocol().getSequenceNumber().toString());
        } else {
            HashMap<String, String> keyValues = new HashMap<String, String>();
            keyValues.put("protocolNumber", answerHeader.getModuleItemKey());
            ProtocolBase protocol = (ProtocolBase)((List)this.getBusinessObjectService().findMatchingOrderBy(this.getProtocolBOClassHook(), keyValues, "sequenceNumber", false)).get(0);
            isCurrentQn = answerHeader.getModuleSubItemKey().equals(protocol.getSequenceNumber().toString()) && !CollectionUtils.isEmpty((Collection)protocol.getProtocolSubmissions()) && this.isMergedToProtocol(this.getProtocol(), protocol);
        }
        return isCurrentQn;
    }

    public ProtocolBase getProtocol() {
        return this.protocol;
    }

    public void setProtocol(ProtocolBase protocol) {
        this.protocol = protocol;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    protected abstract String getCoeusModuleCode();
}

