/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.reviewcomments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.upload.FormFile;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.common.committee.bo.CommitteeMembershipBase;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.service.CommitteeScheduleServiceBase;
import org.kuali.kra.common.committee.service.CommitteeServiceBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewAttachmentBase;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewableBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.role.RoleService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ReviewCommentsServiceImplBase<PRA extends ProtocolReviewAttachmentBase>
implements ReviewCommentsService<PRA> {
    private static final String HIDE = "0";
    private static final String DISPLAY = "1";
    protected BusinessObjectService businessObjectService;
    private CommitteeScheduleServiceBase committeeScheduleService;
    private CommitteeServiceBase committeeService;
    private ProtocolFinderDao protocolFinderDao;
    private RoleService roleService;
    private DateTimeService dateTimeService;
    private ParameterService parameterService;
    private KcPersonService kcPersonService;
    private Set<String> adminIds;
    private List<String> adminUserNames;
    private List<String> reviewerIds;
    private Set<String> viewerIds;
    private Set<String> aggregatorIds;
    private boolean displayReviewerNameToPersonnel;
    private boolean displayReviewerNameToReviewers;
    private boolean displayReviewerNameToActiveMembers;

    public boolean canViewOnlineReviewerComments(String principalId, ProtocolSubmissionBase protocolSubmission) {
        return this.isAdminOrOnlineReviewer(principalId, protocolSubmission) || this.hasSubmissionCompleteStatus(protocolSubmission) || this.isActiveCommitteeMember(protocolSubmission, principalId);
    }

    public boolean canViewOnlineReviewers(String principalId, ProtocolSubmissionBase protocolSubmission) {
        return this.isAdminOrOnlineReviewer(principalId, protocolSubmission);
    }

    private boolean isAdminOrOnlineReviewer(String principalId, ProtocolSubmissionBase submission) {
        boolean isAdmin = false;
        boolean isReviewer = false;
        Collection ids = this.roleService.getRoleMemberPrincipalIds("KC-UNT", this.getAdministratorRoleHook(), null);
        isAdmin = ids.contains(principalId);
        if (principalId != null) {
            List reviewers = submission.getProtocolReviewers();
            for (ProtocolReviewer reviewer : reviewers) {
                if (!StringUtils.equals((String)principalId, (String)reviewer.getPersonId())) continue;
                isReviewer = true;
                break;
            }
        }
        return isAdmin || isReviewer;
    }

    private boolean hasSubmissionCompleteStatus(ProtocolSubmissionBase submission) {
        boolean validSubmissionStatus = Arrays.asList(this.getProtocolSubmissionCompleteStatusCodeArrayHook()).contains(submission.getSubmissionStatusCode());
        return validSubmissionStatus;
    }

    protected abstract String[] getProtocolSubmissionCompleteStatusCodeArrayHook();

    public List<CommitteeScheduleMinuteBase> getReviewerComments(String protocolNumber, int submissionNumber) {
        ArrayList<CommitteeScheduleMinuteBase> reviewComments = new ArrayList<CommitteeScheduleMinuteBase>();
        List protocolSubmissions = this.protocolFinderDao.findProtocolSubmissions(protocolNumber, submissionNumber);
        for (ProtocolSubmissionBase protocolSubmission : protocolSubmissions) {
            if (protocolSubmission.getCommitteeScheduleMinutes() == null) continue;
            HashMap<String, Long> fieldValues = new HashMap<String, Long>();
            fieldValues.put("protocolIdFk", protocolSubmission.getProtocolId());
            fieldValues.put("submissionIdFk", protocolSubmission.getSubmissionId());
            List reviewComments1 = (List)this.businessObjectService.findMatchingOrderBy(this.getCommitteeScheduleMinuteBOClassHook(), fieldValues, "commScheduleMinutesId", false);
            for (CommitteeScheduleMinuteBase minute : reviewComments1) {
                String minuteEntryTypeCode = minute.getMinuteEntryTypeCode();
                if (!"3".equals(minuteEntryTypeCode) && !"6".equals(minuteEntryTypeCode) || !this.isCurrentMinuteEntry(minute) || !this.getReviewerCommentsView((ProtocolReviewableBase)minute)) continue;
                reviewComments.add(minute);
            }
        }
        return reviewComments;
    }

    protected abstract Class<? extends CommitteeScheduleMinuteBase> getCommitteeScheduleMinuteBOClassHook();

    public List<PRA> getReviewerAttachments(String protocolNumber, int submissionNumber) {
        ArrayList<ProtocolReviewAttachmentBase> reviewAttachments = new ArrayList<ProtocolReviewAttachmentBase>();
        List protocolSubmissions = this.protocolFinderDao.findProtocolSubmissions(protocolNumber, submissionNumber);
        for (ProtocolSubmissionBase protocolSubmission : protocolSubmissions) {
            if (!CollectionUtils.isNotEmpty((Collection)protocolSubmission.getReviewAttachments()) && protocolSubmissions.size() != 1) continue;
            HashMap<String, Long> fieldValues = new HashMap<String, Long>();
            fieldValues.put("protocolIdFk", protocolSubmission.getProtocolId());
            fieldValues.put("submissionIdFk", protocolSubmission.getSubmissionId());
            List reviewAttachments1 = (List)this.businessObjectService.findMatchingOrderBy(this.getProtocolReviewAttachmentClassHook(), fieldValues, "attachmentId", false);
            for (ProtocolReviewAttachmentBase reviewAttachment : reviewAttachments1) {
                if (!this.getReviewerCommentsView((ProtocolReviewableBase)reviewAttachment)) continue;
                reviewAttachments.add(reviewAttachment);
            }
        }
        return reviewAttachments;
    }

    public List<ProtocolReviewer> getProtocolReviewers(String protocolNumber, int submissionNumber) {
        ArrayList<ProtocolReviewer> reviewers = new ArrayList<ProtocolReviewer>();
        List protocolSubmissions = this.protocolFinderDao.findProtocolSubmissions(protocolNumber, submissionNumber);
        for (ProtocolSubmissionBase protocolSubmission : protocolSubmissions) {
            reviewers.addAll(protocolSubmission.getProtocolReviewers());
        }
        return reviewers;
    }

    public List<ProtocolOnlineReviewBase> getProtocolOnlineReviews(String protocolNumber, int submissionNumber) {
        ArrayList<ProtocolOnlineReviewBase> activeReviews = new ArrayList<ProtocolOnlineReviewBase>();
        List protocolSubmissions = this.protocolFinderDao.findProtocolSubmissions(protocolNumber, submissionNumber);
        for (ProtocolSubmissionBase protocolSubmission : protocolSubmissions) {
            activeReviews.addAll(protocolSubmission.getActiveProtocolOnlineReviews());
        }
        return activeReviews;
    }

    protected boolean isCurrentMinuteEntry(CommitteeScheduleMinuteBase minute) {
        minute.refreshReferenceObject("committeeSchedule");
        if (minute.getCommitteeSchedule() != null) {
            CommitteeBase committee = this.committeeService.getCommitteeById(minute.getCommitteeSchedule().getParentCommittee().getCommitteeId());
            return committee.getId().equals(minute.getCommitteeSchedule().getParentCommittee().getId());
        }
        return true;
    }

    public void addReviewComment(CommitteeScheduleMinuteBase newReviewComment, List<CommitteeScheduleMinuteBase> reviewComments, ProtocolBase protocol) {
        ProtocolSubmissionBase protocolSubmission = this.getSubmission(protocol);
        if (protocolSubmission.getScheduleIdFk() != null) {
            newReviewComment.setScheduleIdFk(protocolSubmission.getScheduleIdFk());
        } else {
            newReviewComment.setScheduleIdFk(CommitteeScheduleBase.DEFAULT_SCHEDULE_ID);
        }
        newReviewComment.setEntryNumber(Integer.valueOf(reviewComments.size()));
        newReviewComment.setProtocolIdFk(protocol.getProtocolId());
        newReviewComment.setProtocol(protocol);
        newReviewComment.setSubmissionIdFk(protocolSubmission.getSubmissionId());
        newReviewComment.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
        newReviewComment.setCreateTimestamp(this.dateTimeService.getCurrentTimestamp());
        newReviewComment.setUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
        newReviewComment.setUpdateTimestamp(this.dateTimeService.getCurrentTimestamp());
        reviewComments.add(newReviewComment);
    }

    public void addReviewComment(CommitteeScheduleMinuteBase newReviewComment, List<CommitteeScheduleMinuteBase> reviewComments, ProtocolOnlineReviewBase protocolOnlineReview) {
        newReviewComment.setProtocolOnlineReview(protocolOnlineReview);
        newReviewComment.setProtocolOnlineReviewIdFk(protocolOnlineReview.getProtocolOnlineReviewId());
        newReviewComment.setProtocolReviewer(protocolOnlineReview.getProtocolReviewer());
        newReviewComment.setProtocolReviewerIdFk(protocolOnlineReview.getProtocolReviewerId());
        this.addReviewComment(newReviewComment, reviewComments, protocolOnlineReview.getProtocol());
    }

    public void moveUpReviewComment(List<CommitteeScheduleMinuteBase> reviewComments, ProtocolBase protocol, int fromIndex) {
        int toIndex;
        if (fromIndex > 0 && (toIndex = this.indexOfPreviousProtocolReviewComment(reviewComments, protocol, fromIndex)) < fromIndex) {
            CommitteeScheduleMinuteBase movingReviewComment = reviewComments.remove(fromIndex);
            reviewComments.add(toIndex, movingReviewComment);
            for (int i = toIndex; i <= fromIndex; ++i) {
                reviewComments.get(i).setEntryNumber(Integer.valueOf(i));
            }
        }
    }

    private int indexOfPreviousProtocolReviewComment(List<CommitteeScheduleMinuteBase> reviewComments, ProtocolBase protocol, int currentIndex) {
        int previousIndex = currentIndex;
        ListIterator<CommitteeScheduleMinuteBase> iterator = reviewComments.listIterator(currentIndex);
        while (iterator.hasPrevious()) {
            int iteratorIndex = iterator.previousIndex();
            CommitteeScheduleMinuteBase currentReviewComment = iterator.previous();
            if (!ObjectUtils.equals((Object)currentReviewComment.getProtocolId(), (Object)protocol.getProtocolId())) continue;
            previousIndex = iteratorIndex;
            break;
        }
        return previousIndex;
    }

    public void moveDownReviewComment(List<CommitteeScheduleMinuteBase> reviewComments, ProtocolBase protocol, int fromIndex) {
        int toIndex;
        if (fromIndex < reviewComments.size() - 1 && (toIndex = this.indexOfNextProtocolReviewComment(reviewComments, protocol, fromIndex)) > fromIndex) {
            CommitteeScheduleMinuteBase movingReviewComment = reviewComments.remove(fromIndex);
            reviewComments.add(toIndex, movingReviewComment);
            for (int i = fromIndex; i <= toIndex; ++i) {
                reviewComments.get(i).setEntryNumber(Integer.valueOf(i));
            }
        }
    }

    public boolean getReviewerCommentsView(ProtocolReviewableBase minute) {
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        String principalName = GlobalVariables.getUserSession().getPrincipalName();
        if (this.isAdministrator(principalId)) {
            return true;
        }
        if (minute.getProtocolOnlineReviewIdFk() != null) {
            if (minute.isAccepted()) {
                return StringUtils.equals((String)principalName, (String)minute.getCreateUser()) || this.isViewable(minute);
            }
            return false;
        }
        return this.isViewable(minute);
    }

    private boolean isViewable(ProtocolReviewableBase reviewable) {
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        return reviewable.isFinal() && (!reviewable.isPrivate() || (this.isReviewer(reviewable, principalId) || this.isActiveCommitteeMember(reviewable, principalId)) && !this.isProtocolPersonnel(reviewable, principalId) && !this.hasProtocolPermission(reviewable, principalId));
    }

    private boolean isAdministrator(String principalId) {
        RoleService roleService = (RoleService)KraServiceLocator.getService(RoleService.class);
        Collection ids = roleService.getRoleMemberPrincipalIds("KC-UNT", this.getAdministratorRoleHook(), null);
        return ids.contains(principalId);
    }

    protected abstract String getAdministratorRoleHook();

    private int indexOfNextProtocolReviewComment(List<CommitteeScheduleMinuteBase> reviewComments, ProtocolBase protocol, int currentIndex) {
        int nextIndex = currentIndex;
        ListIterator<CommitteeScheduleMinuteBase> iterator = reviewComments.listIterator(currentIndex + 1);
        while (iterator.hasNext()) {
            int iteratorIndex = iterator.nextIndex();
            CommitteeScheduleMinuteBase currentReviewComment = iterator.next();
            if (!ObjectUtils.equals((Object)currentReviewComment.getProtocolId(), (Object)protocol.getProtocolId())) continue;
            nextIndex = iteratorIndex;
            break;
        }
        return nextIndex;
    }

    public void deleteReviewComment(List<CommitteeScheduleMinuteBase> reviewComments, int index, List<CommitteeScheduleMinuteBase> deletedReviewComments) {
        if (index >= 0 && index < reviewComments.size()) {
            CommitteeScheduleMinuteBase reviewComment = reviewComments.get(index);
            if (reviewComment.getCommScheduleMinutesId() != null) {
                deletedReviewComments.add(reviewComment);
            }
            reviewComments.remove(index);
            for (int i = index; i < reviewComments.size(); ++i) {
                reviewComments.get(i).setEntryNumber(Integer.valueOf(i));
            }
        }
    }

    public void deleteAllReviewComments(List<CommitteeScheduleMinuteBase> reviewComments, List<CommitteeScheduleMinuteBase> deletedReviewComments) {
        for (CommitteeScheduleMinuteBase reviewerComment : reviewComments) {
            if (reviewerComment.getCommScheduleMinutesId() == null) continue;
            deletedReviewComments.add(reviewerComment);
        }
        reviewComments.clear();
    }

    public void saveReviewComments(List<CommitteeScheduleMinuteBase> reviewComments, List<CommitteeScheduleMinuteBase> deletedReviewComments) {
        for (CommitteeScheduleMinuteBase reviewComment : reviewComments) {
            boolean doUpdate = true;
            if (reviewComment.getCommScheduleMinutesId() != null) {
                CommitteeScheduleMinuteBase pristineInstance = reviewComment.getPristineInstance();
                if (pristineInstance != null && !reviewComment.equals((Object)pristineInstance)) {
                    doUpdate = true;
                    if (reviewComment.isUpdateUserToBeRecorded(pristineInstance)) {
                        KcPerson kcPerson = ((KcPersonService)KraServiceLocator.getService(KcPersonService.class)).getKcPersonByPersonId(GlobalVariables.getUserSession().getPerson().getPrincipalId());
                        reviewComment.setUpdateUserFullName(kcPerson.getFullName());
                    }
                } else {
                    doUpdate = false;
                }
            }
            if (!doUpdate) continue;
            this.businessObjectService.save((PersistableBusinessObject)reviewComment);
        }
        if (!deletedReviewComments.isEmpty()) {
            this.businessObjectService.delete(deletedReviewComments);
        }
    }

    protected abstract ProtocolSubmissionBase getSubmission(ProtocolBase var1);

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setCommitteeScheduleService(CommitteeScheduleServiceBase committeeScheduleService) {
        this.committeeScheduleService = committeeScheduleService;
    }

    public void setCommitteeService(CommitteeServiceBase committeeService) {
        this.committeeService = committeeService;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    public void setRoleService(RoleService roleService) {
        this.roleService = roleService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    private void getReviewerNameParams() {
        this.displayReviewerNameToActiveMembers = this.isDisplayReviewerName(this.getDisplayRevNameToActiveCmtMembersHook());
        this.displayReviewerNameToPersonnel = this.isDisplayReviewerName(this.getDisplayRevNameToProtocolPersonnelHook());
        this.displayReviewerNameToReviewers = this.isDisplayReviewerName(this.getDisplayRevNameToReviewersHook());
    }

    protected abstract String getDisplayRevNameToActiveCmtMembersHook();

    protected abstract String getDisplayRevNameToProtocolPersonnelHook();

    protected abstract String getDisplayRevNameToReviewersHook();

    private boolean isDisplayReviewerName(String paramName) {
        String param = this.parameterService.getParameterValueAsString(this.getProtocolDocumentBOClassHook(), paramName);
        return !StringUtils.equals((String)HIDE, (String)param);
    }

    protected abstract Class<? extends ProtocolDocumentBase> getProtocolDocumentBOClassHook();

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public boolean setHideReviewerName(ProtocolBase protocol, int submissionNumber) {
        return this.setHideReviewerName(this.getReviewerComments(protocol.getProtocolNumber(), submissionNumber));
    }

    public boolean setHideReviewerName(List<? extends ProtocolReviewableBase> reviewComments) {
        boolean isHide = true;
        this.setReviewerIds(this.reviewerIds);
        this.getReviewerNameParams();
        for (ProtocolReviewableBase protocolReviewableBase : reviewComments) {
            if (!this.canViewName(protocolReviewableBase)) continue;
            protocolReviewableBase.setDisplayReviewerName(true);
            isHide = false;
        }
        return isHide;
    }

    public boolean setHideViewButton(List<PRA> reviewAttachments) {
        boolean isHide = true;
        this.getReviewerNameParams();
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        for (ProtocolReviewAttachmentBase reviewAttachment : reviewAttachments) {
            if (reviewAttachment.isPrivateFlag() && this.isProtocolPersonnel((ProtocolReviewableBase)reviewAttachment, principalId)) continue;
            reviewAttachment.setDisplayViewButton(true);
            isHide = false;
        }
        return isHide;
    }

    private boolean canViewName(ProtocolReviewableBase reviewComment) {
        boolean canViewName = false;
        Person person = GlobalVariables.getUserSession().getPerson();
        if (this.isAdmin(person.getPrincipalId()) || this.isCreator(reviewComment, person.getPrincipalName())) {
            canViewName = true;
        } else if (this.isProtocolPersonnelOrHasProtocolRole(reviewComment)) {
            if (this.isDisplayReviewerNameToPersonnel()) {
                canViewName = true;
            }
        } else if (this.isDisplayReviewerNameToReviewers() && this.isReviewer(reviewComment, person.getPrincipalId()) || this.isDisplayReviewerNameToActiveMembers() && this.getActiveMemberId(reviewComment).contains(person.getPrincipalId())) {
            canViewName = true;
        }
        return canViewName;
    }

    private boolean hasProtocolPermission(ProtocolReviewableBase reviewComment, String principalId) {
        return this.getProtocolAggregators(reviewComment).contains(principalId) || this.getProtocolViewers(reviewComment).contains(principalId);
    }

    private boolean isProtocolPersonnel(ProtocolReviewableBase reviewComment, String principalId) {
        return this.getPersonnelIds(reviewComment).contains(principalId);
    }

    private boolean isProtocolPersonnelOrHasProtocolRole(ProtocolReviewableBase reviewComment) {
        Person person = GlobalVariables.getUserSession().getPerson();
        return this.getPersonnelIds(reviewComment).contains(person.getPrincipalId()) || this.getProtocolAggregators().contains(person.getPrincipalId()) || this.getProtocolViewers().contains(person.getPrincipalId());
    }

    private List<String> getActiveMemberId(ProtocolReviewableBase reviewComment) {
        ArrayList<String> activeMemberIds = new ArrayList<String>();
        List members = new ArrayList();
        members = reviewComment.isReviewComment() ? ((CommitteeScheduleMinuteBase)reviewComment).getCommitteeSchedule().getParentCommittee().getCommitteeMemberships() : ((ProtocolReviewAttachmentBase)reviewComment).getProtocol().getProtocolSubmission().getCommittee().getCommitteeMemberships();
        for (CommitteeMembershipBase member : members) {
            if (!member.isActive()) continue;
            if (StringUtils.isNotBlank((String)member.getPersonId())) {
                activeMemberIds.add(member.getPersonId());
                continue;
            }
            activeMemberIds.add(member.getRolodexId().toString());
        }
        return activeMemberIds;
    }

    private List<String> getPersonnelIds(ProtocolReviewableBase reviewComment) {
        ArrayList<String> PersonnelIds = new ArrayList<String>();
        if (reviewComment.getProtocol() != null) {
            for (ProtocolPersonBase person : reviewComment.getProtocol().getProtocolPersons()) {
                if (StringUtils.isNotBlank((String)person.getPersonId())) {
                    PersonnelIds.add(person.getPersonId());
                    continue;
                }
                PersonnelIds.add(person.getRolodexId().toString());
            }
        }
        return PersonnelIds;
    }

    public boolean getReviewerMinuteCommentsView(CommitteeScheduleMinuteBase minute) {
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        String principalName = GlobalVariables.getUserSession().getPrincipalName();
        return StringUtils.equals((String)principalName, (String)minute.getCreateUser()) && minute.isFinalFlag() || this.isReviewer((ProtocolReviewableBase)minute, principalId) && minute.isFinalFlag() || !minute.getPrivateCommentFlag() && minute.isFinalFlag();
    }

    private boolean isAdmin(String principalId) {
        return !CollectionUtils.isEmpty((Collection)this.getAdminIds()) && this.getAdminIds().contains(principalId);
    }

    private boolean isPrincipalInvestigator(CommitteeScheduleMinuteBase reviewComment, String principalId) {
        boolean isPi = false;
        if (reviewComment.getProtocolId() != null) {
            isPi = principalId.equals(reviewComment.getProtocol().getPrincipalInvestigatorId());
        }
        return isPi;
    }

    private boolean isReviewer(ProtocolReviewableBase reviewComment, String principalId) {
        List reviewerIds = this.getProtocolReviewerIds(reviewComment);
        return !reviewerIds.isEmpty() && reviewerIds.contains(principalId);
    }

    private boolean isCreator(ProtocolReviewableBase reviewComment, String userName) {
        return reviewComment.getCreateUser().equals(userName);
    }

    private List<String> getProtocolReviewerIds(ProtocolReviewableBase reviewComment) {
        List<String> reviewerIds = new ArrayList<String>();
        if (reviewComment.getProtocolId() != null) {
            reviewerIds = this.getProtocolReviewerIds(reviewComment.getProtocolId(), reviewComment.getProtocol().getProtocolSubmission().getSubmissionNumber().intValue());
        }
        return reviewerIds;
    }

    private List<String> getProtocolReviewerIds(Long protocolId, int submissionNumber) {
        HashMap<String, Number> fieldValues = new HashMap<String, Number>();
        fieldValues.put("protocolIdFk", protocolId);
        fieldValues.put("submissionNumber", submissionNumber);
        ArrayList<String> reviewerPersonIds = new ArrayList<String>();
        for (ProtocolReviewer reviewer : (List)this.businessObjectService.findMatching(this.getProtocolReviewClassHook(), fieldValues)) {
            reviewerPersonIds.add(reviewer.getPersonId());
        }
        return reviewerPersonIds;
    }

    protected abstract Class<? extends ProtocolReviewer> getProtocolReviewClassHook();

    private void populateAdmins() {
        this.adminIds = (Set)this.roleService.getRoleMemberPrincipalIds("KC-UNT", this.getAdministratorRoleHook(), null);
        this.adminUserNames = new ArrayList();
        for (String id : this.adminIds) {
            KcPerson kcPerson = this.kcPersonService.getKcPersonByPersonId(id);
            this.adminUserNames.add(kcPerson.getUserName());
        }
    }

    private Set<String> getProtocolAggregators() {
        if (CollectionUtils.isEmpty((Collection)this.aggregatorIds)) {
            this.aggregatorIds = (Set)this.roleService.getRoleMemberPrincipalIds(this.getNamespaceHook(), this.getAggregatorRoleNameHook(), null);
        }
        return this.aggregatorIds;
    }

    protected abstract String getNamespaceHook();

    protected abstract String getAggregatorRoleNameHook();

    private Set<String> getProtocolAggregators(ProtocolReviewableBase minute) {
        if (CollectionUtils.isEmpty((Collection)this.aggregatorIds) && minute != null) {
            this.aggregatorIds = new HashSet();
            if (StringUtils.isNotBlank((String)minute.getProtocol().getProtocolNumber())) {
                HashMap<String, String> protocolAttr = new HashMap<String, String>();
                protocolAttr.put("protocol", minute.getProtocol().getProtocolNumber());
                Set protoResults = (Set)this.roleService.getRoleMemberPrincipalIds(this.getNamespaceHook(), this.getAggregatorRoleNameHook(), new HashMap(protocolAttr));
                if (CollectionUtils.isNotEmpty((Collection)protoResults)) {
                    this.aggregatorIds.addAll(protoResults);
                }
            }
            if (StringUtils.isNotBlank((String)minute.getProtocol().getLeadUnitNumber())) {
                HashMap<String, String> leadUnitAttr = new HashMap<String, String>();
                leadUnitAttr.put("unitNumber", minute.getProtocol().getLeadUnitNumber());
                Set leadUnitResults = (Set)this.roleService.getRoleMemberPrincipalIds(this.getNamespaceHook(), this.getAggregatorRoleNameHook(), new HashMap(leadUnitAttr));
                if (CollectionUtils.isNotEmpty((Collection)leadUnitResults)) {
                    this.aggregatorIds.addAll(leadUnitResults);
                }
            }
        }
        return this.aggregatorIds;
    }

    private Set<String> getProtocolViewers() {
        if (CollectionUtils.isEmpty((Collection)this.viewerIds)) {
            this.viewerIds = (Set)this.roleService.getRoleMemberPrincipalIds(this.getNamespaceHook(), this.getProtocolViewerRoleNameHook(), null);
        }
        return this.viewerIds;
    }

    protected abstract String getProtocolViewerRoleNameHook();

    private Set<String> getProtocolViewers(ProtocolReviewableBase minute) {
        if (CollectionUtils.isEmpty((Collection)this.viewerIds) && minute != null) {
            this.viewerIds = new HashSet();
            if (StringUtils.isNotBlank((String)minute.getProtocol().getProtocolNumber())) {
                HashMap<String, String> protocolAttr = new HashMap<String, String>();
                protocolAttr.put("protocol", minute.getProtocol().getProtocolNumber());
                Set protoResults = (Set)this.roleService.getRoleMemberPrincipalIds(this.getNamespaceHook(), this.getProtocolViewerRoleNameHook(), new HashMap(protocolAttr));
                if (CollectionUtils.isNotEmpty((Collection)protoResults)) {
                    this.viewerIds.addAll(protoResults);
                }
            }
            if (StringUtils.isNotBlank((String)minute.getProtocol().getLeadUnitNumber())) {
                HashMap<String, String> leadUnitAttr = new HashMap<String, String>();
                leadUnitAttr.put("unitNumber", minute.getProtocol().getLeadUnitNumber());
                Set leadUnitResults = (Set)this.roleService.getRoleMemberPrincipalIds(this.getNamespaceHook(), this.getProtocolViewerRoleNameHook(), new HashMap(leadUnitAttr));
                if (CollectionUtils.isNotEmpty((Collection)leadUnitResults)) {
                    this.viewerIds.addAll(leadUnitResults);
                }
            }
        }
        return this.viewerIds;
    }

    public void setKimRoleManagementService(RoleService kimRoleManagementService) {
        this.roleService = kimRoleManagementService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }

    public Set<String> getAdminIds() {
        if (CollectionUtils.isEmpty((Collection)this.adminIds)) {
            this.populateAdmins();
        }
        return this.adminIds;
    }

    public void setAdminIds(Set<String> adminIds) {
        this.adminIds = adminIds;
    }

    public List<String> getAdminUserNames() {
        if (CollectionUtils.isEmpty((Collection)this.adminUserNames)) {
            this.populateAdmins();
        }
        return this.adminUserNames;
    }

    public void setAdminUserNames(List<String> adminUserNames) {
        this.adminUserNames = adminUserNames;
    }

    public List<String> getReviewerIds() {
        return this.reviewerIds;
    }

    public void setReviewerIds(List<String> reviewerIds) {
        this.reviewerIds = reviewerIds;
    }

    public boolean isDisplayReviewerNameToPersonnel() {
        return this.displayReviewerNameToPersonnel;
    }

    public void setDisplayReviewerNameToPersonnel(boolean displayReviewerNameToPersonnel) {
        this.displayReviewerNameToPersonnel = displayReviewerNameToPersonnel;
    }

    public boolean isDisplayReviewerNameToReviewers() {
        return this.displayReviewerNameToReviewers;
    }

    public void setDisplayReviewerNameToReviewers(boolean displayReviewerNameToReviewers) {
        this.displayReviewerNameToReviewers = displayReviewerNameToReviewers;
    }

    public boolean isDisplayReviewerNameToActiveMembers() {
        return this.displayReviewerNameToActiveMembers;
    }

    public void setDisplayReviewerNameToActiveMembers(boolean displayReviewerNameToActiveMembers) {
        this.displayReviewerNameToActiveMembers = displayReviewerNameToActiveMembers;
    }

    protected boolean isActiveCommitteeMember(ProtocolReviewableBase minute, String principalId) {
        String committeeId = "";
        String scheduleId = "";
        CommitteeScheduleBase committeeSchedule = minute.getCommitteeSchedule();
        if (committeeSchedule != null) {
            committeeId = minute.getCommitteeSchedule().getParentCommittee().getCommitteeId();
            scheduleId = minute.getCommitteeSchedule().getScheduleId();
        }
        return this.isActiveCommitteeMember(committeeId, scheduleId, principalId);
    }

    protected boolean isActiveCommitteeMember(String committeeId, String scheduleId, String principalId) {
        boolean result = false;
        List committeeMembers = this.committeeService.getAvailableMembers(committeeId, scheduleId);
        if (CollectionUtils.isNotEmpty((Collection)committeeMembers)) {
            for (CommitteeMembershipBase member : committeeMembers) {
                if (!StringUtils.equals((String)principalId, (String)member.getPersonId())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isActiveCommitteeMember(ProtocolSubmissionBase submission, String principalId) {
        String committeeId = submission.getCommitteeId();
        String scheduleId = submission.getScheduleId();
        return this.isActiveCommitteeMember(committeeId, scheduleId, principalId);
    }

    public boolean getReviewerAcceptedCommentsView(CommitteeScheduleMinuteBase minute) {
        boolean viewAcceptedMinute = false;
        String principalId = GlobalVariables.getUserSession().getPrincipalId();
        String principalName = GlobalVariables.getUserSession().getPrincipalName();
        if (minute.getProtocolOnlineReviewIdFk() != null) {
            ProtocolOnlineReviewBase protocolOnlineReview = (ProtocolOnlineReviewBase)this.businessObjectService.findBySinglePrimaryKey(this.getProtocolOnlineReviewClassHook(), (Object)minute.getProtocolOnlineReviewIdFk());
            if (protocolOnlineReview.isAdminAccepted()) {
                viewAcceptedMinute = true;
            }
        } else {
            viewAcceptedMinute = true;
        }
        return StringUtils.equals((String)principalName, (String)minute.getCreateUser()) && viewAcceptedMinute || this.isReviewer((ProtocolReviewableBase)minute, principalId) && minute.isFinalFlag() && viewAcceptedMinute || !minute.getPrivateCommentFlag() && minute.isFinalFlag() && viewAcceptedMinute;
    }

    protected abstract Class<? extends ProtocolOnlineReviewBase> getProtocolOnlineReviewClassHook();

    public void deleteReviewAttachment(List<PRA> reviewAttachments, int index, List<PRA> deletedReviewAttachments) {
        if (index >= 0 && index < reviewAttachments.size()) {
            ProtocolReviewAttachmentBase reviewAttachment = (ProtocolReviewAttachmentBase)reviewAttachments.get(index);
            if (reviewAttachment.getReviewerAttachmentId() != null) {
                deletedReviewAttachments.add(reviewAttachment);
            }
            reviewAttachments.remove(index);
        }
    }

    public abstract void saveReviewAttachments(List<PRA> var1, List<PRA> var2);

    public void addReviewAttachment(PRA newReviewAttachment, List<PRA> reviewAttachments, ProtocolBase protocol) {
        ProtocolSubmissionBase protocolSubmission = this.getSubmission(protocol);
        newReviewAttachment.setAttachmentId(Integer.valueOf(this.getNextAttachmentId(protocol)));
        newReviewAttachment.setProtocolIdFk(protocol.getProtocolId());
        newReviewAttachment.setProtocol(protocol);
        newReviewAttachment.setSubmissionIdFk(protocolSubmission.getSubmissionId());
        newReviewAttachment.setCreateUser(GlobalVariables.getUserSession().getPrincipalName());
        newReviewAttachment.setCreateTimestamp(this.dateTimeService.getCurrentTimestamp());
        newReviewAttachment.setUpdateUser(GlobalVariables.getUserSession().getPrincipalName());
        newReviewAttachment.setPersonId(GlobalVariables.getUserSession().getPrincipalId());
        newReviewAttachment.setPrivateFlag(!newReviewAttachment.isProtocolPersonCanView());
        newReviewAttachment.setUpdateTimestamp(this.dateTimeService.getCurrentTimestamp());
        AttachmentFile newFile = AttachmentFile.createFromFormFile((FormFile)newReviewAttachment.getNewFile());
        newReviewAttachment.setFile(newFile);
        newReviewAttachment.setNewFile(null);
        reviewAttachments.add(newReviewAttachment);
    }

    private int getNextAttachmentId(ProtocolBase protocol) {
        HashMap<String, Long> fieldValues = new HashMap<String, Long>();
        fieldValues.put("protocolIdFk", protocol.getProtocolId());
        List reviewAttachments = (List)this.businessObjectService.findMatchingOrderBy(this.getProtocolReviewAttachmentClassHook(), fieldValues, "attachmentId", false);
        if (CollectionUtils.isEmpty((Collection)reviewAttachments)) {
            return 1;
        }
        return ((ProtocolReviewAttachmentBase)reviewAttachments.get(0)).getAttachmentId() + 1;
    }

    protected abstract Class<PRA> getProtocolReviewAttachmentClassHook();

    public void deleteAllReviewAttachments(List<PRA> reviewAttachments, List<PRA> deletedReviewAttachments) {
        for (ProtocolReviewAttachmentBase reviewerAttachment : reviewAttachments) {
            if (reviewerAttachment.getReviewerAttachmentId() == null) continue;
            deletedReviewAttachments.add(reviewerAttachment);
        }
        reviewAttachments.clear();
    }

    public ProtocolFinderDao getProtocolFinderDao() {
        return this.protocolFinderDao;
    }
}

