/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.submit;

import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.committee.service.CommitteeService;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.submit.ExecuteProtocolSubmitActionRule;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewTypeBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionTypeBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmitAction;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolSubmitActionRuleBase
extends ResearchDocumentRuleBase
implements ExecuteProtocolSubmitActionRule {
    private static final String MANDATORY = "M";
    private ParameterService parameterService;
    private CommitteeService committeeService;

    public boolean processSubmitAction(ProtocolDocumentBase document, ProtocolSubmitAction submitAction) {
        boolean isValid = this.validateSubmissionType(document, submitAction);
        isValid &= this.validateProtocolReviewType(submitAction);
        if (StringUtils.isNotBlank((String)submitAction.getSubmissionTypeCode()) && StringUtils.isNotBlank((String)submitAction.getProtocolReviewTypeCode())) {
            isValid &= this.isValidSubmReviewType(submitAction);
        }
        if (this.isMandatory()) {
            isValid &= this.validateCommittee(submitAction);
            isValid &= this.validateSchedule(submitAction);
        }
        isValid &= this.validateReviewers(submitAction);
        return isValid &= this.checkNoSpoofing(submitAction);
    }

    private boolean validateCommittee(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (StringUtils.isBlank((String)submitAction.getNewCommitteeId())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.committeeId", "error.protocol.submission.committee.required", new String[0]);
        }
        return valid;
    }

    private boolean validateSchedule(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (StringUtils.isBlank((String)submitAction.getNewScheduleId())) {
            valid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.scheduleId", "error.protocol.submission.schedule.required", new String[0]);
        }
        return valid;
    }

    private boolean validateSubmissionType(ProtocolDocumentBase document, ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        String submissionTypeCode = submitAction.getSubmissionTypeCode();
        if (StringUtils.isBlank((String)submissionTypeCode)) {
            isValid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.submissionTypeCode", "error.protocol.submissionTypeCode.notFound", new String[0]);
        } else {
            isValid = this.isValidSubmTypeQual(submitAction);
        }
        return isValid;
    }

    private boolean validateProtocolReviewType(ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        String protocolReviewTypeCode = submitAction.getProtocolReviewTypeCode();
        if (StringUtils.isBlank((String)protocolReviewTypeCode)) {
            isValid = false;
            GlobalVariables.getMessageMap().putError("actionHelper.protocolSubmitAction.protocolReviewTypeCode", "error.protocol.reviewTypeCode.notFound", new String[0]);
        } else if (this.isReviewTypeInvalid(protocolReviewTypeCode)) {
            isValid = false;
            this.reportError("actionHelper.protocolSubmitAction.protocolReviewTypeCode", "error.protocol.reviewTypeCode.invalid", new String[]{protocolReviewTypeCode});
        }
        return isValid;
    }

    private boolean validateReviewers(ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        return isValid;
    }

    public boolean checkNoSpoofing(ProtocolSubmitAction submitAction) {
        boolean isValid = true;
        return isValid;
    }

    private boolean isValidSubmReviewType(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (!StringUtils.isNotBlank((String)submitAction.getSubmissionTypeCode()) || StringUtils.isNotBlank((String)submitAction.getProtocolReviewTypeCode())) {
            // empty if block
        }
        return valid;
    }

    private boolean isValidSubmTypeQual(ProtocolSubmitAction submitAction) {
        boolean valid = true;
        if (StringUtils.isNotBlank((String)submitAction.getSubmissionTypeCode())) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put("submissionTypeCode", submitAction.getSubmissionTypeCode());
        }
        return valid;
    }

    private boolean isSubmissionTypeInvalid(String submissionTypeCode) {
        return !this.existsUnique(this.getProtocolSubmissionTypeClassHook(), "submissionTypeCode", submissionTypeCode);
    }

    protected abstract Class<? extends ProtocolSubmissionTypeBase> getProtocolSubmissionTypeClassHook();

    private boolean isReviewTypeInvalid(String reviewTypeCode) {
        return !this.existsUnique(this.getProtocolReviewTypeClassHook(), "reviewTypeCode", reviewTypeCode);
    }

    protected abstract Class<? extends ProtocolReviewTypeBase> getProtocolReviewTypeClassHook();

    private boolean existsUnique(Class<? extends BusinessObject> boType, String propertyName, String keyField) {
        if (keyField != null) {
            BusinessObjectService businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(propertyName, keyField);
            if (businessObjectService.countMatching(boType, fieldValues) == 1) {
                return true;
            }
        }
        return false;
    }

    private BusinessObject getBo(Class<? extends BusinessObject> boType, String propertyName, String keyField) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(propertyName, keyField);
        List results = (List)this.getBusinessObjectService().findMatching(boType, fieldValues);
        if (results.isEmpty()) {
            return null;
        }
        return (BusinessObject)results.get(0);
    }

    private boolean isMandatory() {
        String param = this.getParameterService().getParameterValueAsString(this.getProtocolDocumentClassHook(), "IRB_COMM_SELECTION_DURING_SUBMISSION");
        return StringUtils.equalsIgnoreCase((String)MANDATORY, (String)param);
    }

    protected abstract Class<? extends ProtocolDocumentBase> getProtocolDocumentClassHook();

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    private CommitteeService getCommitteeService() {
        if (null == this.committeeService) {
            this.committeeService = (CommitteeService)KraServiceLocator.getService(CommitteeService.class);
        }
        return this.committeeService;
    }

    public void setCommitteeService(CommitteeService committeeService) {
        this.committeeService = committeeService;
    }
}

