/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.actions.undo;

import java.io.Serializable;
import java.sql.Date;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.ProtocolVersionService;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.copy.ProtocolCopyService;
import org.kuali.kra.protocol.actions.reviewcomments.ReviewCommentsService;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.actions.submit.ProtocolReviewer;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.actions.undo.UndoLastActionBean;
import org.kuali.kra.protocol.actions.undo.UndoLastActionService;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewBase;
import org.kuali.kra.protocol.onlinereview.ProtocolOnlineReviewService;
import org.kuali.kra.protocol.onlinereview.ProtocolReviewAttachmentBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.WorkflowDocumentFactory;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class UndoLastActionServiceImplBase
implements UndoLastActionService {
    protected static final String AMEND = "A";
    protected static final String RENEW = "R";
    private ProtocolActionService protocolActionService;
    private DocumentService documentService;
    private BusinessObjectService businessObjectService;
    private ProtocolVersionService protocolVersionService;
    private ReviewCommentsService reviewCommentsService;
    private ProtocolOnlineReviewService protocolOnlineReviewService;
    private RouteHeaderService routeHeaderService;
    private IdentityService identityManagementService;
    private ProtocolCopyService protocolCopyService;

    public void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setProtocolVersionService(ProtocolVersionService protocolVersionService) {
        this.protocolVersionService = protocolVersionService;
    }

    protected abstract void removeAttachedCorrespondences(ProtocolActionBase var1);

    public ProtocolDocumentBase undoLastAction(ProtocolDocumentBase protocolDocument, UndoLastActionBean undoLastActionBean) throws Exception {
        ProtocolBase protocol = protocolDocument.getProtocol();
        ProtocolDocumentBase updatedDocument = null;
        ProtocolActionBase lastActionPerformed = undoLastActionBean.getLastAction();
        if (lastActionPerformed != null) {
            this.protocolActionService.resetProtocolStatus(lastActionPerformed, protocol);
            protocolDocument.setProtocol(protocol);
            this.removeAttachedCorrespondences(lastActionPerformed);
            if (!protocolDocument.getDocumentHeader().getWorkflowDocument().isCanceled()) {
                protocol.getProtocolActions().remove(undoLastActionBean.getLastAction());
            }
            updatedDocument = this.undoWorkflowRouting(protocolDocument, lastActionPerformed);
            this.documentService.saveDocument((Document)updatedDocument);
        }
        return updatedDocument != null ? updatedDocument : protocolDocument;
    }

    protected abstract String getAmendmentInProgressStatusHook();

    protected abstract String getRenewalInProgressStatusHook();

    protected abstract String getInProgressStatusHook();

    protected abstract boolean isApprovedActionTypeCode(String var1);

    protected abstract boolean isRevisionsRequiredActionTypeCode(String var1);

    protected void resetProtocolStatus(ProtocolBase protocol) {
        String protocolNumberUpper = protocol.getProtocolNumber().toUpperCase();
        String prevProtocolStatusCode = this.getInProgressStatusHook();
        if (protocol.isAmendment()) {
            prevProtocolStatusCode = this.getAmendmentInProgressStatusHook();
        } else if (protocol.isRenewal()) {
            prevProtocolStatusCode = this.getRenewalInProgressStatusHook();
        }
        protocol.setProtocolStatusCode(prevProtocolStatusCode);
        protocol.setActive(true);
    }

    protected ProtocolDocumentBase undoWorkflowRouting(ProtocolDocumentBase protocolDocument, ProtocolActionBase lastPerformedAction) throws Exception {
        WorkflowDocument currentWorkflowDocument = protocolDocument.getDocumentHeader().getWorkflowDocument();
        if (currentWorkflowDocument.isCanceled()) {
            protocolDocument = this.protocolCopyService.copyProtocol(protocolDocument);
            this.resetProtocolStatus(protocolDocument.getProtocol());
        } else if (currentWorkflowDocument != null && currentWorkflowDocument.isFinal() && lastPerformedAction != null && this.isApprovedActionTypeCode(lastPerformedAction.getProtocolActionTypeCode())) {
            ProtocolSubmissionBase oldSubmission = protocolDocument.getProtocol().getProtocolSubmission();
            protocolDocument = this.protocolVersionService.versionProtocolDocument(protocolDocument);
            protocolDocument.getProtocol().refreshReferenceObject("protocolStatus");
            protocolDocument.getProtocol().setProtocolSubmission(null);
            protocolDocument.getProtocol().setApprovalDate(null);
            protocolDocument.getProtocol().setLastApprovalDate(null);
            protocolDocument.getProtocol().setExpirationDate(null);
            protocolDocument.setReRouted(true);
            this.documentService.saveDocument((Document)protocolDocument);
            this.convertReviewComments(protocolDocument.getProtocol());
            this.documentService.routeDocument((Document)protocolDocument, "Undoing Approve Action", null);
            this.updateProtocolReviews(protocolDocument.getProtocol());
        } else if (currentWorkflowDocument != null && currentWorkflowDocument.isSaved() && lastPerformedAction != null && this.isRevisionsRequiredActionTypeCode(lastPerformedAction.getProtocolActionTypeCode())) {
            this.convertReviewComments(protocolDocument.getProtocol());
            this.documentService.routeDocument((Document)protocolDocument, "Undoing Approve Action", null);
            this.updateProtocolReviews(protocolDocument.getProtocol());
        }
        return protocolDocument;
    }

    protected void updateProtocolReviews(ProtocolBase protocol) throws Exception {
        ProtocolBase oldProtocol = this.getOldProtocol(protocol);
        if (CollectionUtils.isNotEmpty((Collection)oldProtocol.getProtocolSubmission().getProtocolOnlineReviews())) {
            this.createOnlnReviews(protocol, oldProtocol);
        }
    }

    protected abstract ProtocolBase getOldProtocol(ProtocolBase var1);

    protected void createOnlnReviews(ProtocolBase protocol, ProtocolBase oldProtocol) throws Exception {
        String routeAnnotation = "Recreate Online Review for undo action.";
        boolean initialApproval = false;
        Date dateRequested = null;
        Date dateDue = null;
        String sessionPrincipalId = GlobalVariables.getUserSession().getPrincipalId();
        ProtocolSubmissionBase protocolSubmission = protocol.getProtocolSubmission();
        for (ProtocolOnlineReviewBase onlineReview : oldProtocol.getProtocolSubmission().getProtocolOnlineReviews()) {
            ProtocolOnlineReviewDocumentBase oldDoc = (ProtocolOnlineReviewDocumentBase)this.documentService.getByDocumentHeaderId(onlineReview.getProtocolOnlineReviewDocument().getDocumentNumber());
            if ("D".equals(oldDoc.getDocumentHeader().getWorkflowDocument().getStatus().getCode())) continue;
            ProtocolOnlineReviewBase copiedReview = (ProtocolOnlineReviewBase)ObjectUtils.deepCopy((Serializable)onlineReview);
            ProtocolReviewer reviewer = this.getReviewer(onlineReview, protocol);
            this.setNewOnlnReview(copiedReview, reviewer, protocol);
            ProtocolOnlineReviewDocumentBase document = this.protocolOnlineReviewService.createAndRouteProtocolOnlineReviewDocument(protocolSubmission, reviewer, oldDoc.getDocumentHeader().getDocumentDescription(), oldDoc.getDocumentHeader().getExplanation(), oldDoc.getDocumentHeader().getOrganizationDocumentNumber(), routeAnnotation, initialApproval, dateRequested, dateDue, sessionPrincipalId);
            copiedReview.setProtocolOnlineReviewDocument(document);
            document.setProtocolOnlineReview(copiedReview);
            if (this.isAsyncComplete(document.getDocumentNumber())) {
                this.documentService.saveDocument((Document)document);
            }
            this.resetOnlineReviewStatus(oldDoc, document);
            protocolSubmission.getProtocolOnlineReviews().add(document.getProtocolOnlineReview());
        }
    }

    protected void resetOnlineReviewStatus(ProtocolOnlineReviewDocumentBase oldDocument, ProtocolOnlineReviewDocumentBase document) throws Exception {
        List actionsTaken = oldDocument.getDocumentHeader().getWorkflowDocument().getActionsTaken();
        for (int i = 0; i < actionsTaken.size(); ++i) {
            if (!this.isAsyncComplete(document.getDocumentNumber())) continue;
            ActionTaken action = (ActionTaken)actionsTaken.get(i);
            WorkflowDocument workflowDocument = WorkflowDocumentFactory.loadDocument((String)action.getPrincipalId(), (String)document.getDocumentNumber());
            if (action.getActionTaken() == ActionType.APPROVE) {
                workflowDocument.approve("approve for undo");
                continue;
            }
            if (action.getActionTaken() == ActionType.BLANKET_APPROVE && actionsTaken.indexOf(action) != actionsTaken.size() - 1) {
                workflowDocument.superUserBlanketApprove("Finalize for undo");
                continue;
            }
            if (action.getActionTaken() != ActionType.RETURN_TO_PREVIOUS) continue;
            this.getProtocolOnlineReviewService().returnProtocolOnlineReviewDocumentToReviewer(document, "Reject for Undo", action.getPrincipalId());
        }
        document.getProtocolOnlineReview().removeLastAction();
    }

    protected boolean isAsyncComplete(String docId) {
        boolean isComplete = false;
        int numberOfWaits = 0;
        while (numberOfWaits++ < 20 && !isComplete) {
            try {
                DocumentRouteHeaderValue document = this.routeHeaderService.getRouteHeader(docId);
                if (!document.isFinal() && document.getActionRequests().isEmpty()) {
                    Thread.sleep(1000L);
                    continue;
                }
                isComplete = true;
            }
            catch (Exception e) {}
        }
        return isComplete;
    }

    protected ProtocolReviewer getReviewer(ProtocolOnlineReviewBase onlineReview, ProtocolBase protocol) {
        ProtocolSubmissionBase protocolSubmission = protocol.getProtocolSubmission();
        ProtocolReviewer reviewer = onlineReview.getProtocolReviewer();
        reviewer.setProtocolIdFk(protocol.getProtocolId());
        reviewer.setProtocolReviewerId(null);
        reviewer.setProtocol(protocol);
        reviewer.setSubmissionIdFk(protocolSubmission.getSubmissionId());
        reviewer.setSequenceNumber(protocolSubmission.getSequenceNumber());
        this.businessObjectService.save((PersistableBusinessObject)reviewer);
        return reviewer;
    }

    protected void setNewOnlnReview(ProtocolOnlineReviewBase copiedReview, ProtocolReviewer reviewer, ProtocolBase protocol) {
        ProtocolSubmissionBase protocolSubmission = protocol.getProtocolSubmission();
        copiedReview.setProtocolReviewer(reviewer);
        copiedReview.setProtocolReviewerId(reviewer.getProtocolReviewerId());
        copiedReview.setProtocolOnlineReviewId(null);
        copiedReview.setSubmissionIdFk(protocolSubmission.getSubmissionId());
        copiedReview.setProtocolId(protocol.getProtocolId());
        if (CollectionUtils.isNotEmpty((Collection)copiedReview.getCommitteeScheduleMinutes())) {
            for (CommitteeScheduleMinuteBase comment : copiedReview.getCommitteeScheduleMinutes()) {
                comment.setProtocolIdFk(protocol.getProtocolId());
                comment.setProtocolOnlineReviewIdFk(null);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)copiedReview.getReviewAttachments())) {
            for (ProtocolReviewAttachmentBase reviewAttachment : copiedReview.getReviewAttachments()) {
                reviewAttachment.setProtocolIdFk(protocol.getProtocolId());
                reviewAttachment.setProtocolOnlineReviewIdFk(null);
                reviewAttachment.setSubmissionIdFk(protocolSubmission.getSubmissionId());
            }
        }
    }

    protected void convertReviewComments(ProtocolBase protocol) {
        ProtocolBase oldProtocol = this.getOldProtocol(protocol);
        List comments = this.reviewCommentsService.getReviewerComments(protocol.getProtocolNumber(), protocol.getProtocolSubmission().getSubmissionNumber().intValue());
        for (CommitteeScheduleMinuteBase comment : comments) {
            if (!comment.getProtocolIdFk().equals(oldProtocol.getProtocolId())) continue;
            comment.setProtocolIdFk(protocol.getProtocolId());
        }
        this.businessObjectService.save(comments);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setReviewCommentsService(ReviewCommentsService reviewCommentsService) {
        this.reviewCommentsService = reviewCommentsService;
    }

    public void setProtocolOnlineReviewService(ProtocolOnlineReviewService protocolOnlineReviewService) {
        this.protocolOnlineReviewService = protocolOnlineReviewService;
    }

    public void setRouteHeaderService(RouteHeaderService routeHeaderService) {
        this.routeHeaderService = routeHeaderService;
    }

    public void setIdentityManagementService(IdentityService identityManagementService) {
        this.identityManagementService = identityManagementService;
    }

    protected ProtocolCopyService getProtocolCopyService() {
        return this.protocolCopyService;
    }

    public void setProtocolCopyService(ProtocolCopyService protocolCopyService) {
        this.protocolCopyService = protocolCopyService;
    }

    protected ProtocolActionService getProtocolActionService() {
        return this.protocolActionService;
    }

    protected DocumentService getDocumentService() {
        return this.documentService;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    protected ProtocolVersionService getProtocolVersionService() {
        return this.protocolVersionService;
    }

    protected ReviewCommentsService getReviewCommentsService() {
        return this.reviewCommentsService;
    }

    protected ProtocolOnlineReviewService getProtocolOnlineReviewService() {
        return this.protocolOnlineReviewService;
    }

    protected RouteHeaderService getRouteHeaderService() {
        return this.routeHeaderService;
    }

    protected IdentityService getIdentityManagementService() {
        return this.identityManagementService;
    }
}

