/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.auth;

import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.auth.ModifyProtocolAuthorizer;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;

public abstract class ModifyAmendmentAuthorizerBase
extends ModifyProtocolAuthorizer {
    private String moduleTypeCode;
    private ProtocolAmendRenewService protocolAmendRenewService;

    protected ModifyAmendmentAuthorizerBase(String moduleTypeCode) {
        this.moduleTypeCode = moduleTypeCode;
    }

    public boolean isAuthorized(String userId, ProtocolTaskBase task) {
        ProtocolBase protocol = task.getProtocol();
        boolean hasPermission = super.isAuthorized(userId, task);
        if (hasPermission && this.isAmendmentOrRenewal(protocol) && !protocol.isRenewalWithoutAmendment()) {
            hasPermission = this.canModifyModule(protocol, this.moduleTypeCode);
        }
        if (hasPermission && protocol.isCorrectionMode()) {
            hasPermission = this.canCorrectModule(protocol, this.moduleTypeCode);
        }
        return hasPermission;
    }

    private boolean canCorrectModule(ProtocolBase protocol, String moduleTypeCode) {
        List availableModules = new ArrayList();
        try {
            availableModules = this.protocolAmendRenewService.getAvailableModules(protocol.getProtocolNumber());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        return availableModules.contains(moduleTypeCode);
    }

    private boolean canModifyModule(ProtocolBase protocol, String moduleTypeCode) {
        return protocol.getProtocolAmendRenewal().hasModule(moduleTypeCode);
    }

    public void setProtocolAmendRenewService(ProtocolAmendRenewService protocolAmendRenewService) {
        this.protocolAmendRenewService = protocolAmendRenewService;
    }
}

