/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.auth;

import org.kuali.kra.authorization.Task;
import org.kuali.kra.authorization.TaskAuthorizerImpl;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.actions.submit.ProtocolActionService;
import org.kuali.kra.protocol.auth.ProtocolTaskBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.document.authorization.PessimisticLock;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolAuthorizerBase
extends TaskAuthorizerImpl {
    protected KraAuthorizationService kraAuthorizationService;
    private ProtocolActionService protocolActionService;

    public final void setProtocolActionService(ProtocolActionService protocolActionService) {
        this.protocolActionService = protocolActionService;
    }

    public final boolean isAuthorized(String userId, Task task) {
        return this.isAuthorized(userId, (ProtocolTaskBase)task);
    }

    public abstract boolean isAuthorized(String var1, ProtocolTaskBase var2);

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    protected final boolean hasPermission(String userId, ProtocolBase protocol, String permissionName) {
        return this.kraAuthorizationService.hasPermission(userId, (Permissionable)protocol, permissionName);
    }

    protected final boolean isAmendment(ProtocolBase protocol) {
        return protocol.getProtocolNumber() != null && protocol.getProtocolNumber().contains("A");
    }

    protected final boolean isAmendmentOrRenewal(ProtocolBase protocol) {
        return protocol.getProtocolNumber() != null && (protocol.getProtocolNumber().contains("A") || protocol.getProtocolNumber().contains("R") || protocol.getProtocolNumber().contains("C"));
    }

    protected final boolean isAdminCorrection(ProtocolTaskBase task) {
        return "protocolAdminCorrection".equals(task.getTaskName());
    }

    protected final boolean canExecuteAction(ProtocolBase protocol, String protocolActionTypeCode) {
        return protocol.isActive() && !protocol.getProtocolDocument().isViewOnly() && this.protocolActionService.isActionAllowed(protocolActionTypeCode, protocol);
    }

    protected boolean isPessimisticLocked(Document document) {
        boolean isLocked = false;
        for (PessimisticLock lock : document.getPessimisticLocks()) {
            if (lock.isOwnedByUser(GlobalVariables.getUserSession().getPerson())) continue;
            isLocked = true;
        }
        return isLocked;
    }
}

