/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentTypeBase;
import org.kuali.kra.protocol.noteattachment.TypedAttachment;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.krad.bo.BusinessObject;

public abstract class ProtocolAttachmentBaseRuleHelper {
    private static final String OTHER_TYPE_CODE = "9";
    private final ProtocolAttachmentService attachmentService;
    private final DictionaryValidationService validationService;
    private final ErrorReporter errorReporter = new ErrorReporter();
    private String propertyPrefix;

    protected ProtocolAttachmentBaseRuleHelper(ProtocolAttachmentService attachmentService, DictionaryValidationService validationService) {
        if (attachmentService == null) {
            throw new IllegalArgumentException("the attachmentService is null");
        }
        if (validationService == null) {
            throw new IllegalArgumentException("the validationService is null");
        }
        this.attachmentService = attachmentService;
        this.validationService = validationService;
    }

    protected ProtocolAttachmentBaseRuleHelper(String aPropertyPrefix, ProtocolAttachmentService attachmentService, DictionaryValidationService validationService) {
        if (attachmentService == null) {
            throw new IllegalArgumentException("the attachmentService is null");
        }
        if (validationService == null) {
            throw new IllegalArgumentException("the validationService is null");
        }
        this.attachmentService = attachmentService;
        this.validationService = validationService;
        this.resetPropertyPrefix(aPropertyPrefix);
    }

    public void resetPropertyPrefix(String aPropertyPrefix) {
        if (aPropertyPrefix == null) {
            throw new IllegalArgumentException("propertyPrefix is null");
        }
        this.propertyPrefix = aPropertyPrefix;
    }

    public <T extends ProtocolAttachmentBase> boolean validDescriptionWhenRequired(T attachment) {
        if (attachment.getType() == null || attachment.getType().getCode() == null) {
            return true;
        }
        if (StringUtils.isBlank((String)attachment.getDescription()) && OTHER_TYPE_CODE.equals(attachment.getType().getCode())) {
            ProtocolAttachmentTypeBase type = this.attachmentService.getTypeFromCode(attachment.getType().getCode());
            this.errorReporter.reportError(this.propertyPrefix + "." + TypedAttachment.PropertyName.DESCRIPTION, "error.protocolAttachment.description.required", new String[]{type != null ? type.getDescription() : ""});
            return false;
        }
        return true;
    }

    public <T extends ProtocolAttachmentBase> boolean validTypeForGroup(T attachment) {
        if (attachment.getType() == null || attachment.getType().getCode() == null) {
            return true;
        }
        for (ProtocolAttachmentTypeBase type : this.attachmentService.getTypesForGroup(attachment.getGroupCode())) {
            if (type == null || !attachment.getType().getCode().equals(type.getCode())) continue;
            return true;
        }
        ProtocolAttachmentTypeBase type = this.attachmentService.getTypeFromCode(attachment.getType().getCode());
        this.errorReporter.reportError(this.propertyPrefix + "." + TypedAttachment.PropertyName.TYPE_CODE, "error.protocolAttachment.invalid.type", new String[]{type != null ? type.getDescription() : ""});
        return false;
    }

    <T extends ProtocolAttachmentBase> boolean validType(T attachment) {
        if (attachment.getType() == null || StringUtils.isBlank((String)attachment.getType().getCode())) {
            this.errorReporter.reportError(this.propertyPrefix + "." + TypedAttachment.PropertyName.TYPE_CODE, "error.protocolAttachment.missing.type", new String[0]);
            return false;
        }
        return true;
    }

    boolean validFile(ProtocolAttachmentBase attachmentBase) {
        boolean valid;
        if (attachmentBase.getFile() == null) {
            valid = false;
            this.errorReporter.reportError(this.propertyPrefix + ".newFile", "error.protocolAttachment.missing.file", new String[0]);
        } else {
            valid = this.validationService.isBusinessObjectValid((BusinessObject)attachmentBase.getFile(), this.propertyPrefix);
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validPrimitiveFields(ProtocolAttachmentBase attachmentBase) {
        Long oldFileId = attachmentBase.getFileId();
        try {
            attachmentBase.setFileId(Long.valueOf(0L));
            boolean bl = this.validationService.isBusinessObjectValid((BusinessObject)attachmentBase, this.propertyPrefix);
            return bl;
        }
        finally {
            attachmentBase.setFileId(oldFileId);
        }
    }
}

