/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.rules.ErrorReporter;
import org.kuali.rice.kns.util.AuditError;

public abstract class ProtocolAttachmentProtocolRuleHelperBase {
    protected static final String NOTES_ATTACHMENTS_CLUSTER_LABEL = "Notes & Attachments";
    protected static final String NOTES_AND_ATTACHMENT_AUDIT_ERRORS_KEY = "NoteAndAttachmentAuditErrors";
    protected static final String NOTE_AND_ATTACHMENT_LINK = "noteAndAttachment";
    protected final ProtocolAttachmentService attachmentService;
    protected final ErrorReporter errorReporter = new ErrorReporter();
    protected String propertyPrefix;

    protected ProtocolAttachmentProtocolRuleHelperBase(ProtocolAttachmentService attachmentService) {
        if (attachmentService == null) {
            throw new IllegalArgumentException("the attachmentService is null");
        }
        this.attachmentService = attachmentService;
    }

    protected ProtocolAttachmentProtocolRuleHelperBase(String aPropertyPrefix, ProtocolAttachmentService attachmentService) {
        if (attachmentService == null) {
            throw new IllegalArgumentException("the attachmentService is null");
        }
        this.attachmentService = attachmentService;
        this.resetPropertyPrefix(aPropertyPrefix);
    }

    public void resetPropertyPrefix(String aPropertyPrefix) {
        if (aPropertyPrefix == null) {
            throw new IllegalArgumentException("propertyPrefix is null");
        }
        this.propertyPrefix = aPropertyPrefix;
    }

    protected boolean validStatusForSubmission(ProtocolAttachmentProtocolBase attachmentProtocol) {
        if (!StringUtils.equals((String)attachmentProtocol.getDocumentStatusCode(), (String)"3") && !"1".equals(attachmentProtocol.getStatusCode())) {
            AuditError error = new AuditError(this.propertyPrefix + "." + ProtocolAttachmentProtocolBase.PropertyName.STATUS_CODE, "error.protocolAttachment.not.complete", NOTE_AND_ATTACHMENT_LINK);
            this.errorReporter.reportAuditError(error, NOTES_AND_ATTACHMENT_AUDIT_ERRORS_KEY, NOTES_ATTACHMENTS_CLUSTER_LABEL, "Validation Errors");
            return false;
        }
        return true;
    }

    public boolean validStatus(ProtocolAttachmentProtocolBase attachment) {
        if (attachment.getStatus() == null || StringUtils.isBlank((String)attachment.getStatus().getCode())) {
            return true;
        }
        return true;
    }
}

