/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.kuali.kra.SeparatelySequenceableAssociate;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentService;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentVersioningUtilityBase;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.VersioningService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.ObjectUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class ProtocolAttachmentVersioningUtilityBase {
    protected final ProtocolAttachmentService notesService;
    protected final VersioningService versionService;
    protected final DocumentService docService;
    protected final ProtocolFormBase form;
    protected static final String ATTACHMENT_DELETED = "3";
    protected static final String ATTACHMENT_DRAFTED = "1";
    protected ProtocolDocumentBase newDocumentVersion;

    protected ProtocolAttachmentVersioningUtilityBase(ProtocolFormBase form, ProtocolAttachmentService notesService, VersioningService versionService, DocumentService docService) {
        if (form == null) {
            throw new IllegalArgumentException("the form was null");
        }
        if (notesService == null) {
            throw new IllegalArgumentException("the notesService was null");
        }
        if (versionService == null) {
            throw new IllegalArgumentException("the versionService was null");
        }
        if (docService == null) {
            throw new IllegalArgumentException("the docService was null");
        }
        this.form = form;
        this.versionService = versionService;
        this.docService = docService;
        this.notesService = notesService;
    }

    void versionNewAttachment(ProtocolAttachmentBase toVersion) {
        if (toVersion == null) {
            throw new IllegalArgumentException("the attachment to version was null");
        }
        if (!toVersion.isNew()) {
            throw new IllegalArgumentException("the attachment to version is not new " + toVersion);
        }
        this.addAttachment(toVersion);
    }

    void versionDeletedAttachment(ProtocolAttachmentBase toVersion) {
        if (toVersion == null) {
            throw new IllegalArgumentException("the attachment to version was null");
        }
        if (toVersion.isNew()) {
            throw new IllegalArgumentException("the attachment to version is new " + toVersion);
        }
        ProtocolAttachmentProtocolBase newAttachment = (ProtocolAttachmentProtocolBase)this.deleteAttachment(toVersion);
        newAttachment.setDocumentStatusCode("3");
        this.form.getProtocolDocument().getProtocol().getAttachmentProtocols().add(newAttachment);
    }

    void versionExstingAttachments() {
        boolean createVersion = this.versionExstingAttachments((Collection)this.form.getProtocolDocument().getProtocol().getAttachmentProtocols(), this.getProtocolAttachmentProtocolClassHook());
    }

    protected <T extends ProtocolAttachmentBase> boolean versionExstingAttachments(Collection<ProtocolAttachmentProtocolBase> attachments, Class<? extends ProtocolAttachmentProtocolBase> class1) {
        assert (attachments != null) : "the attachments was null";
        assert (class1 != null) : "the type was null";
        ArrayList<ProtocolAttachmentBase> attachmentProtocols = new ArrayList<ProtocolAttachmentBase>();
        boolean createVersion = false;
        for (ProtocolAttachmentProtocolBase attachment : ProtocolAttachmentBase.filterExistingAttachments(attachments)) {
            ProtocolAttachmentProtocolBase persistedAttachment = (ProtocolAttachmentProtocolBase)this.notesService.getAttachment(class1, attachment.getId());
            boolean isReplaceFile = ProtocolAttachmentVersioningUtilityBase.hasChanged((AttachmentFile)attachment.getFile(), (AttachmentFile)persistedAttachment.getFile());
            if (attachment instanceof ProtocolAttachmentProtocolBase && ("2".equals(attachment.getDocumentStatusCode()) || "3".equals(attachment.getDocumentStatusCode())) && (isReplaceFile || !attachment.equals((Object)persistedAttachment))) {
                createVersion = true;
                if ("3".equals(attachment.getDocumentStatusCode()) && this.notesService.isNewAttachmentVersion(attachment)) {
                    attachment.setDocumentStatusCode("1");
                    attachment.setChanged(true);
                    continue;
                }
                if (!this.isChangeDeletedAtt((List)attachments, attachment.getDocumentId())) {
                    attachmentProtocols.add(this.createFileVersionOnAttachment((ProtocolAttachmentBase)attachment, isReplaceFile));
                }
                this.restoreAttachment(persistedAttachment, attachment);
                continue;
            }
            if (!"1".equals(attachment.getDocumentStatusCode()) || !isReplaceFile && attachment.equals((Object)persistedAttachment)) continue;
            attachment.setChanged(true);
        }
        attachments.addAll(attachmentProtocols);
        return createVersion;
    }

    private boolean isChangeDeletedAtt(List<ProtocolAttachmentProtocolBase> attachments, Integer documentId) {
        boolean isChangedDelete = false;
        for (ProtocolAttachmentProtocolBase attachment : attachments) {
            if (!documentId.equals(attachment.getDocumentId()) || !"3".equals(attachment.getDocumentStatusCode())) continue;
            isChangedDelete = true;
            break;
        }
        return isChangedDelete;
    }

    private void restoreAttachment(ProtocolAttachmentProtocolBase persistedAttachment, ProtocolAttachmentProtocolBase attachment) {
        attachment.setStatusCode(persistedAttachment.getStatusCode());
        attachment.setComments(persistedAttachment.getComments());
        attachment.setContactEmailAddress(persistedAttachment.getContactEmailAddress());
        attachment.setContactName(persistedAttachment.getContactName());
        attachment.setContactPhoneNumber(persistedAttachment.getContactPhoneNumber());
        attachment.setFileId(persistedAttachment.getFileId());
        attachment.setFile(persistedAttachment.getFile());
        attachment.setDescription(persistedAttachment.getDescription());
    }

    private void addAttachment(ProtocolAttachmentBase attachment) {
        assert (attachment != null) : "the attachment is null";
        if (attachment instanceof ProtocolAttachmentProtocolBase) {
            ((ProtocolAttachmentProtocolBase)attachment).setDocumentStatusCode("1");
            attachment.setDocumentId(Integer.valueOf(this.getNextDOcumentId(this.form.getProtocolDocument().getProtocol().getAttachmentProtocols())));
        }
        this.form.getProtocolDocument().getProtocol().addAttachmentsByType(attachment);
    }

    private int getNextDOcumentId(List<? extends ProtocolAttachmentBase> attachments) {
        int nextDocumentId = 0;
        for (ProtocolAttachmentBase protocolAttachmentBase : attachments) {
            if (protocolAttachmentBase.getDocumentId() <= nextDocumentId) continue;
            nextDocumentId = protocolAttachmentBase.getDocumentId();
        }
        return ++nextDocumentId;
    }

    private ProtocolAttachmentBase deleteAttachment(ProtocolAttachmentBase attachment) {
        assert (attachment != null) : "the attachment is null";
        ProtocolAttachmentBase newAttachment = this.createFileVersionOnAttachment(attachment, false);
        return newAttachment;
    }

    private static boolean hasChanged(AttachmentFile localFile, AttachmentFile persistedFile) {
        if (persistedFile == null || localFile == null) {
            return false;
        }
        return !ProtocolAttachmentVersioningUtilityBase.isSameFile((AttachmentFile)persistedFile, (AttachmentFile)localFile);
    }

    private static boolean isSameFile(AttachmentFile obj, AttachmentFile other) {
        if (!Arrays.equals(obj.getData(), other.getData())) {
            return false;
        }
        if (obj.getId() != null && other.getId() != null && !obj.getId().equals(other.getId())) {
            return false;
        }
        if (other.getId() == null) {
            return false;
        }
        if (obj.getName() == null ? other.getName() != null : !obj.getName().equals(other.getName())) {
            return false;
        }
        return !(obj.getType() == null ? other.getType() != null : !obj.getType().equals(other.getType()));
    }

    private <T extends ProtocolAttachmentBase> T createFileVersionOnAttachment(T attachment, boolean isReplaceFile) {
        ProtocolAttachmentProtocolBase newAttachment;
        AttachmentFile newVersion;
        assert (attachment != null) : "the attachment was null";
        try {
            newVersion = isReplaceFile ? (AttachmentFile)this.versionService.versionAssociate((SeparatelySequenceableAssociate)attachment.getFile()) : null;
            newAttachment = (ProtocolAttachmentProtocolBase)ObjectUtils.deepCopy(attachment);
        }
        catch (VersionException e) {
            throw new VersionCreationExeption((Throwable)e);
        }
        if (isReplaceFile) {
            newAttachment.setFile(newVersion);
            newAttachment.setFileId(null);
        }
        newAttachment.setUpdateTimestamp(null);
        newAttachment.setCreateTimestamp(null);
        newAttachment.setUpdateUser(null);
        newAttachment.setDocumentStatusCode("1");
        newAttachment.setId(null);
        newAttachment.setAttachmentVersion(Integer.valueOf(((ProtocolAttachmentProtocolBase)attachment).getAttachmentVersion() + 1));
        return (T)newAttachment;
    }

    boolean versioningRequired() {
        return this.form.getProtocolDocument().getProtocol().isVersioningRequired();
    }

    protected abstract Class<? extends ProtocolAttachmentProtocolBase> getProtocolAttachmentProtocolClassHook();
}

