/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.noteattachment;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadBase;
import org.kuali.kra.protocol.noteattachment.ProtocolNotepadService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;

public class ProtocolNotepadServiceImpl
implements ProtocolNotepadService {
    private PersonService personService;
    protected final Log LOG = LogFactory.getLog(this.getClass());
    private static final String PERSON_NOT_FOUND_FORMAT_STRING = "%s (not found)";

    public void setProtocolNotepadUpdateUsersName(List<ProtocolNotepadBase> protocolNotepads) {
        for (ProtocolNotepadBase pnp : protocolNotepads) {
            Person person;
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)String.format("Looking up person for update user %s.", pnp.getUpdateUser()));
            }
            pnp.setUpdateUserFullName((person = this.personService.getPersonByPrincipalName(pnp.getUpdateUser())) == null ? String.format(PERSON_NOT_FOUND_FORMAT_STRING, pnp.getUpdateUser()) : person.getName());
            if (StringUtils.isNotBlank((String)pnp.getCreateUser())) {
                Person creator = this.personService.getPersonByPrincipalName(pnp.getCreateUser());
                pnp.setCreateUserFullName(creator == null ? String.format(PERSON_NOT_FOUND_FORMAT_STRING, pnp.getCreateUser()) : creator.getName());
                continue;
            }
            pnp.setCreateUserFullName("");
        }
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

