/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.onlinereview.event;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.protocol.ProtocolOnlineReviewDocumentBase;
import org.kuali.kra.protocol.onlinereview.rules.DeleteOnlineReviewRule;
import org.kuali.kra.rule.event.KraDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.BusinessRule;

public class DeleteProtocolOnlineReviewEvent
extends KraDocumentEventBase {
    private static final Log LOG = LogFactory.getLog(DeleteProtocolOnlineReviewEvent.class);
    private String reason = null;
    private String noteText = null;
    private int maxLength;

    public DeleteProtocolOnlineReviewEvent(ProtocolOnlineReviewDocumentBase document, String deleteReason, String deleteNoteText, int reasonMaxLength) {
        super("delete protocol online review", "Are you sure you want to delete this document?", (Document)document);
        this.reason = deleteReason;
        this.noteText = deleteNoteText;
        this.maxLength = reasonMaxLength;
    }

    protected void logEvent() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("disapprove protocol online review comment event reason=" + this.reason));
        }
    }

    public Class<DeleteOnlineReviewRule> getRuleInterfaceClass() {
        return DeleteOnlineReviewRule.class;
    }

    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((DeleteOnlineReviewRule)this.getRuleInterfaceClass().cast(rule)).processDeleteOnlineReview(this);
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String getNoteText() {
        return this.noteText;
    }

    public void setNoteText(String noteText) {
        this.noteText = noteText;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }
}

