/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.permission;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.common.permissions.bo.PermissionsRoleState;
import org.kuali.kra.common.permissions.bo.PermissionsUserEditRoles;
import org.kuali.kra.common.permissions.web.bean.Role;
import org.kuali.kra.common.permissions.web.bean.User;
import org.kuali.kra.common.permissions.web.struts.action.PermissionsActionHelperBase;
import org.kuali.kra.common.permissions.web.struts.form.PermissionsForm;
import org.kuali.kra.common.permissions.web.struts.form.PermissionsHelperBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolActionBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.web.struts.action.KraTransactionalDocumentActionBase;
import org.kuali.rice.krad.document.Document;

public class ProtocolPermissionsActionHelper
extends PermissionsActionHelperBase {
    private static final long serialVersionUID = -4490013895383993701L;

    public ProtocolPermissionsActionHelper(ProtocolActionBase parentAction) {
        super((KraTransactionalDocumentActionBase)parentAction);
    }

    protected void addUserToRoleInDatabase(Document document, String userId, String roleName) {
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        this.getKraAuthorizationService().addRole(userId, roleName, (Permissionable)protocolDocument.getProtocol());
    }

    protected void removeUserFromRoleInDatabase(Document document, String userId, String roleName) {
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        this.getKraAuthorizationService().removeRole(userId, roleName, (Permissionable)protocolDocument.getProtocol());
    }

    private KraAuthorizationService getKraAuthorizationService() {
        return (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
    }

    public ActionForward editRoles(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PermissionsForm permissionsForm = (PermissionsForm)form;
        PermissionsHelperBase permissionsHelper = permissionsForm.getPermissionsHelper();
        int lineNum = this.getLineNum(request);
        User user = (User)permissionsHelper.getUsers().get(lineNum);
        PermissionsUserEditRoles editRoles = new PermissionsUserEditRoles();
        editRoles.setLineNum(lineNum);
        editRoles.setJavaScriptEnabled(this.isJavaScriptEnabled(request));
        editRoles.setUserName(user.getPerson().getUserName());
        editRoles.setPrinipalInvestigator(this.isPrincipalInvestigator((ProtocolDocumentBase)permissionsForm.getDocument(), user.getPerson().getPersonId()));
        ArrayList<PermissionsRoleState> roleStates = new ArrayList<PermissionsRoleState>();
        List roles = permissionsHelper.getNormalRoles();
        for (Role role : roles) {
            PermissionsRoleState roleState = new PermissionsRoleState(role);
            roleStates.add(roleState);
        }
        editRoles.setRoleStates(roleStates);
        List userRoles = user.getRoles();
        for (Role userRole : userRoles) {
            editRoles.setRoleState(userRole.getName(), Boolean.TRUE);
        }
        permissionsHelper.setUserEditRoles(editRoles);
        return mapping.findForward("permissionsEditRoles");
    }

    private int getLineNum(HttpServletRequest request) {
        String lineNumStr = request.getParameter("line");
        try {
            return Integer.parseInt(lineNumStr);
        }
        catch (Exception ex) {
            return this.getLineToDelete(request);
        }
    }

    private int getLineToDelete(HttpServletRequest request) {
        return this.getSelectedLine(request);
    }

    private int getSelectedLine(HttpServletRequest request) {
        int selectedLine = -1;
        String parameterName = (String)request.getAttribute("methodToCallAttribute");
        if (StringUtils.isNotBlank((String)parameterName)) {
            String lineNumber = StringUtils.substringBetween((String)parameterName, (String)".line", (String)".");
            selectedLine = Integer.parseInt(lineNumber);
        }
        return selectedLine;
    }

    private boolean isJavaScriptEnabled(HttpServletRequest request) {
        String lineNumStr = request.getParameter("line");
        try {
            Integer.parseInt(lineNumStr);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean isPrincipalInvestigator(ProtocolDocumentBase protocolDocument, String personId) {
        return StringUtils.equals((String)personId, (String)protocolDocument.getProtocol().getPrincipalInvestigatorId());
    }
}

