/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class PersonnelHelperBase
implements Serializable {
    private static final long serialVersionUID = -411537473714173061L;
    protected ProtocolFormBase form;
    protected boolean modifyPersonnel;
    protected ProtocolPersonBase newProtocolPerson;
    protected List<ProtocolUnitBase> newProtocolPersonUnits;
    protected List<ProtocolAttachmentPersonnelBase> newProtocolAttachmentPersonnels;
    protected boolean personTrainingSectionRequired;
    protected transient ParameterService parameterService;

    public PersonnelHelperBase(ProtocolFormBase form) {
        this.setForm(form);
        this.setNewProtocolPersonUnits(new ArrayList());
        this.setNewProtocolAttachmentPersonnels(new ArrayList());
    }

    public void prepareView() {
        this.initializePermissions(this.getProtocol());
        this.initializeTrainingSection();
        this.getForm().populatePersonEditableFields();
    }

    protected ProtocolBase getProtocol() {
        ProtocolDocumentBase document = this.form.getProtocolDocument();
        if (document == null || document.getProtocol() == null) {
            throw new IllegalArgumentException("invalid (null) ProtocolDocumentBase in ProtocolFormBase");
        }
        return document.getProtocol();
    }

    public boolean isProtocolFinal() {
        return this.form.getDocument().getDocumentHeader().getWorkflowDocument().isFinal();
    }

    protected void initializePermissions(ProtocolBase protocol) {
        this.initializeModifyProtocolPermission(protocol);
    }

    protected abstract void initializeModifyProtocolPermission(ProtocolBase var1);

    protected TaskAuthorizationService getTaskAuthorizationService() {
        return (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
    }

    protected String getUserIdentifier() {
        return GlobalVariables.getUserSession().getPrincipalId();
    }

    public boolean getModifyPersonnel() {
        return this.modifyPersonnel;
    }

    public void setNewProtocolPerson(ProtocolPersonBase newProtocolPerson) {
        this.newProtocolPerson = newProtocolPerson;
    }

    public ProtocolPersonBase getNewProtocolPerson() {
        return this.newProtocolPerson;
    }

    public List<ProtocolUnitBase> getNewProtocolPersonUnits() {
        if (this.getForm().getProtocolDocument().getProtocol().getProtocolPersons().size() > this.newProtocolPersonUnits.size()) {
            this.newProtocolPersonUnits.add(this.newProtocolPersonUnits.size(), this.createNewProtocolUnitInstanceHook());
        }
        return this.newProtocolPersonUnits;
    }

    public void setNewProtocolPersonUnits(List<ProtocolUnitBase> newProtocolPersonUnits) {
        this.newProtocolPersonUnits = newProtocolPersonUnits;
    }

    public List<ProtocolAttachmentPersonnelBase> getNewProtocolAttachmentPersonnels() {
        if (this.getForm().getProtocolDocument().getProtocol().getProtocolPersons().size() > this.newProtocolAttachmentPersonnels.size()) {
            this.newProtocolAttachmentPersonnels.add(this.newProtocolAttachmentPersonnels.size(), this.createNewProtocolAttachmentPersonnelInstanceHook());
        }
        return this.newProtocolAttachmentPersonnels;
    }

    public void setNewProtocolAttachmentPersonnels(List<ProtocolAttachmentPersonnelBase> newProtocolAttachmentPersonnels) {
        this.newProtocolAttachmentPersonnels = newProtocolAttachmentPersonnels;
    }

    public ProtocolFormBase getForm() {
        return this.form;
    }

    public void setForm(ProtocolFormBase form) {
        this.form = form;
    }

    protected abstract void initializeTrainingSection();

    protected String getParameterValue(String parameterName) {
        return this.getParameterService().getParameterValueAsString(this.getProtocolDocumentBOClassHook(), parameterName);
    }

    protected abstract Class<? extends ProtocolDocumentBase> getProtocolDocumentBOClassHook();

    public boolean isPersonTrainingSectionRequired() {
        return this.personTrainingSectionRequired;
    }

    public void setPersonTrainingSectionRequired(boolean personTrainingSectionRequired) {
        this.personTrainingSectionRequired = personTrainingSectionRequired;
    }

    protected ParameterService getParameterService() {
        if (this.parameterService == null) {
            this.parameterService = (ParameterService)KraServiceLocator.getService(ParameterService.class);
        }
        return this.parameterService;
    }

    public abstract ProtocolUnitBase createNewProtocolUnitInstanceHook();

    public abstract ProtocolAttachmentPersonnelBase createNewProtocolAttachmentPersonnelInstanceHook();
}

