/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.AbstractProjectPerson;
import org.kuali.kra.bo.AffiliationType;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.PersonEditableInterface;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRoleBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonRolodexBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.service.KcPersonService;

public abstract class ProtocolPersonBase
extends ProtocolAssociateBase
implements PersonEditableInterface,
AbstractProjectPerson {
    private static final long serialVersionUID = -1140730616386093202L;
    private Integer protocolPersonId;
    private String personId;
    private String personName;
    private String protocolPersonRoleId;
    private Integer rolodexId;
    private Integer affiliationTypeCode;
    private String comments;
    private AffiliationType affiliationType;
    private ProtocolPersonRoleBase protocolPersonRole;
    private ProtocolPersonRolodexBase rolodex;
    private boolean delete;
    private boolean trained;
    private List<ProtocolUnitBase> protocolUnits = new ArrayList();
    private List<ProtocolAttachmentPersonnelBase> attachmentPersonnels = new ArrayList();
    private int selectedUnit;
    private String previousPersonRoleId;
    private transient KcPersonService kcPersonService;
    private transient KcPerson kcPerson;
    private String socialSecurityNumber;
    private String lastName;
    private String firstName;
    private String middleName;
    private String fullName;
    private String priorName;
    private String userName;
    private String emailAddress;
    private Date dateOfBirth;
    private Integer age;
    private Integer ageByFiscalYear;
    private String gender;
    private String race;
    private String educationLevel;
    private String degree;
    private String major;
    private Boolean handicappedFlag;
    private String handicapType;
    private Boolean veteranFlag;
    private String veteranType;
    private String visaCode;
    private String visaType;
    private Date visaRenewalDate;
    private Boolean hasVisa;
    private String officeLocation;
    private String officePhone;
    private String secondaryOfficeLocation;
    private String secondaryOfficePhone;
    private String school;
    private String yearGraduated;
    private String directoryDepartment;
    private String saluation;
    private String countryOfCitizenship;
    private String primaryTitle;
    private String directoryTitle;
    private String homeUnit;
    private Boolean facultyFlag;
    private Boolean graduateStudentStaffFlag;
    private Boolean researchStaffFlag;
    private Boolean serviceStaffFlag;
    private Boolean supportStaffFlag;
    private Boolean otherAcademicGroupFlag;
    private Boolean medicalStaffFlag;
    private Boolean vacationAccrualFlag;
    private Boolean onSabbaticalFlag;
    private String idProvided;
    private String idVerified;
    private String addressLine1;
    private String addressLine2;
    private String addressLine3;
    private String city;
    private String county;
    private String state;
    private String postalCode;
    private String countryCode;
    private String faxNumber;
    private String pagerNumber;
    private String mobilePhoneNumber;
    private String eraCommonsUserName;
    private transient boolean affiliationTypeCodeChanged = false;

    public Integer getProtocolPersonId() {
        return this.protocolPersonId;
    }

    public void setProtocolPersonId(Integer protocolPersonId) {
        this.protocolPersonId = protocolPersonId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public void setPersonId(String personId) {
        this.personId = personId;
    }

    public String getPersonName() {
        return this.personName;
    }

    public void setPersonName(String personName) {
        this.personName = personName;
    }

    public String getProtocolPersonRoleId() {
        return this.protocolPersonRoleId;
    }

    public void setProtocolPersonRoleId(String protocolPersonRoleId) {
        this.setPreviousPersonRoleId(this.protocolPersonRoleId);
        this.protocolPersonRoleId = protocolPersonRoleId;
    }

    public Integer getRolodexId() {
        return this.rolodexId;
    }

    public void setRolodexId(Integer rolodexId) {
        this.rolodexId = rolodexId;
    }

    public Integer getAffiliationTypeCode() {
        return this.affiliationTypeCode;
    }

    public void setAffiliationTypeCode(Integer newAffiliationTypeCode) {
        boolean changed = true;
        if (ObjectUtils.equals((Object)this.affiliationTypeCode, (Object)newAffiliationTypeCode)) {
            changed = false;
        }
        this.affiliationTypeCode = newAffiliationTypeCode;
        if (changed) {
            this.refreshReferenceObject("affiliationType");
            this.setAffiliationTypeCodeChanged(true);
        }
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public AffiliationType getAffiliationType() {
        if (this.affiliationTypeCode != null && this.affiliationType == null) {
            this.refreshReferenceObject("affiliationType");
        }
        return this.affiliationType;
    }

    public void setAffiliationType(AffiliationType affiliationType) {
        this.affiliationType = affiliationType;
    }

    public ProtocolPersonRoleBase getProtocolPersonRole() {
        return this.protocolPersonRole;
    }

    public void setProtocolPersonRoles(ProtocolPersonRoleBase protocolPersonRole) {
        this.protocolPersonRole = protocolPersonRole;
    }

    public KcPerson getPerson() {
        if (this.kcPerson == null && this.personId != null) {
            this.kcPerson = this.getKcPersonService().getKcPersonByPersonId(this.personId);
        }
        return this.kcPerson;
    }

    protected KcPersonService getKcPersonService() {
        if (this.kcPersonService == null) {
            this.kcPersonService = (KcPersonService)KraServiceLocator.getService(KcPersonService.class);
        }
        return this.kcPersonService;
    }

    public ProtocolPersonRolodexBase getRolodex() {
        return this.rolodex;
    }

    public void setRolodex(ProtocolPersonRolodexBase rolodex) {
        this.rolodex = rolodex;
    }

    public boolean isDelete() {
        return this.delete;
    }

    public void setDelete(boolean delete) {
        this.delete = delete;
    }

    public boolean isTrained() {
        return this.trained;
    }

    public boolean isUnitRequired() {
        return this.getProtocolPersonRole().isUnitDetailsRequired();
    }

    public void setTrained(boolean trained) {
        this.trained = trained;
    }

    public List<ProtocolUnitBase> getProtocolUnits() {
        return this.protocolUnits;
    }

    public void setProtocolUnits(List<ProtocolUnitBase> protocolUnits) {
        this.protocolUnits = protocolUnits;
    }

    public void addProtocolUnit(ProtocolUnitBase protocolUnit) {
        this.getProtocolUnits().add(protocolUnit);
    }

    public ProtocolUnitBase getProtocolUnit(int index) {
        return (ProtocolUnitBase)this.getProtocolUnits().get(index);
    }

    public int getSelectedUnit() {
        return this.selectedUnit;
    }

    public void setSelectedUnit(int selectedUnit) {
        this.selectedUnit = selectedUnit;
    }

    public void resetAllProtocolLeadUnits() {
        for (ProtocolUnitBase protocolUnit : this.getProtocolUnits()) {
            protocolUnit.setLeadUnitFlag(false);
        }
    }

    public String getPersonKey() {
        return this.getPersonId() == null ? this.getRolodexId().toString() : this.getPersonId();
    }

    public String getPersonUniqueKey() {
        return this.getPersonId() == null ? this.getRolodexId().toString() : this.getPersonId();
    }

    public String getPreviousPersonRoleId() {
        return this.previousPersonRoleId;
    }

    public void setPreviousPersonRoleId(String previousPersonRoleId) {
        this.previousPersonRoleId = previousPersonRoleId;
    }

    public boolean isNonEmployee() {
        return this.rolodex != null || this.rolodexId != null && StringUtils.isNotBlank((String)this.rolodexId.toString());
    }

    public ProtocolUnitBase getLeadUnit() {
        ProtocolUnitBase leadUnit = null;
        for (ProtocolUnitBase unit : this.getProtocolUnits()) {
            if (!unit.getLeadUnitFlag()) continue;
            leadUnit = unit;
            break;
        }
        return leadUnit;
    }

    public List<ProtocolAttachmentPersonnelBase> getAttachmentPersonnels() {
        if (this.attachmentPersonnels == null) {
            this.attachmentPersonnels = new ArrayList();
        }
        return this.attachmentPersonnels;
    }

    public void setAttachmentPersonnels(List<ProtocolAttachmentPersonnelBase> attachmentPersonnels) {
        this.attachmentPersonnels = attachmentPersonnels;
    }

    public void postInitHook(ProtocolBase protocol) {
        for (ProtocolAttachmentPersonnelBase attachment : this.attachmentPersonnels) {
            attachment.init(this);
        }
        for (ProtocolUnitBase unit : this.protocolUnits) {
            unit.init(this);
        }
    }

    public void resetPersistenceState() {
        this.setProtocolPersonId(null);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.affiliationTypeCode == null ? 0 : this.affiliationTypeCode.hashCode());
        result = 31 * result + (this.delete ? 1231 : 1237);
        result = 31 * result + (this.personId == null ? 0 : this.personId.hashCode());
        result = 31 * result + (this.personName == null ? 0 : this.personName.hashCode());
        result = 31 * result + (this.previousPersonRoleId == null ? 0 : this.previousPersonRoleId.hashCode());
        result = 31 * result + (this.protocolPersonId == null ? 0 : this.protocolPersonId.hashCode());
        result = 31 * result + (this.protocolPersonRoleId == null ? 0 : this.protocolPersonRoleId.hashCode());
        result = 31 * result + (this.protocolUnits == null ? 0 : this.protocolUnits.hashCode());
        result = 31 * result + (this.rolodexId == null ? 0 : this.rolodexId.hashCode());
        result = 31 * result + this.selectedUnit;
        result = 31 * result + (this.trained ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolPersonBase other = (ProtocolPersonBase)obj;
        if (this.affiliationTypeCode == null ? other.affiliationTypeCode != null : !this.affiliationTypeCode.equals(other.affiliationTypeCode)) {
            return false;
        }
        if (this.delete != other.delete) {
            return false;
        }
        if (this.personId == null ? other.personId != null : !this.personId.equals(other.personId)) {
            return false;
        }
        if (this.personName == null ? other.personName != null : !this.personName.equals(other.personName)) {
            return false;
        }
        if (this.previousPersonRoleId == null ? other.previousPersonRoleId != null : !this.previousPersonRoleId.equals(other.previousPersonRoleId)) {
            return false;
        }
        if (this.protocolPersonId == null ? other.protocolPersonId != null : !this.protocolPersonId.equals(other.protocolPersonId)) {
            return false;
        }
        if (this.protocolPersonRoleId == null ? other.protocolPersonRoleId != null : !this.protocolPersonRoleId.equals(other.protocolPersonRoleId)) {
            return false;
        }
        if (this.protocolUnits == null ? other.protocolUnits != null : !this.protocolUnits.equals(other.protocolUnits)) {
            return false;
        }
        if (this.rolodexId == null ? other.rolodexId != null : !this.rolodexId.equals(other.rolodexId)) {
            return false;
        }
        if (this.selectedUnit != other.selectedUnit) {
            return false;
        }
        return this.trained == other.trained;
    }

    public boolean isPrincipalInvestigator() {
        return StringUtils.equals((String)this.protocolPersonRoleId, (String)"PI");
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getSocialSecurityNumber() {
        return this.socialSecurityNumber;
    }

    public void setSocialSecurityNumber(String socialSecurityNumber) {
        this.socialSecurityNumber = socialSecurityNumber;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getPriorName() {
        return this.priorName;
    }

    public void setPriorName(String priorName) {
        this.priorName = priorName;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public Integer getAge() {
        return this.age;
    }

    public void setAge(Integer age) {
        this.age = age;
    }

    public Integer getAgeByFiscalYear() {
        return this.ageByFiscalYear;
    }

    public void setAgeByFiscalYear(Integer ageByFiscalYear) {
        this.ageByFiscalYear = ageByFiscalYear;
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getRace() {
        return this.race;
    }

    public void setRace(String race) {
        this.race = race;
    }

    public String getEducationLevel() {
        return this.educationLevel;
    }

    public void setEducationLevel(String educationLevel) {
        this.educationLevel = educationLevel;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        this.degree = degree;
    }

    public String getMajor() {
        return this.major;
    }

    public void setMajor(String major) {
        this.major = major;
    }

    public Boolean getHandicappedFlag() {
        return this.handicappedFlag;
    }

    public void setHandicappedFlag(Boolean handicappedFlag) {
        this.handicappedFlag = handicappedFlag;
    }

    public String getHandicapType() {
        return this.handicapType;
    }

    public void setHandicapType(String handicapType) {
        this.handicapType = handicapType;
    }

    public Boolean getVeteranFlag() {
        return this.veteranFlag;
    }

    public void setVeteranFlag(Boolean veteranFlag) {
        this.veteranFlag = veteranFlag;
    }

    public String getVeteranType() {
        return this.veteranType;
    }

    public void setVeteranType(String veteranType) {
        this.veteranType = veteranType;
    }

    public String getVisaCode() {
        return this.visaCode;
    }

    public void setVisaCode(String visaCode) {
        this.visaCode = visaCode;
    }

    public String getVisaType() {
        return this.visaType;
    }

    public void setVisaType(String visaType) {
        this.visaType = visaType;
    }

    public Date getVisaRenewalDate() {
        return this.visaRenewalDate;
    }

    public void setVisaRenewalDate(Date visaRenewalDate) {
        this.visaRenewalDate = visaRenewalDate;
    }

    public Boolean getHasVisa() {
        return this.hasVisa;
    }

    public void setHasVisa(Boolean hasVisa) {
        this.hasVisa = hasVisa;
    }

    public String getOfficeLocation() {
        return this.officeLocation;
    }

    public void setOfficeLocation(String officeLocation) {
        this.officeLocation = officeLocation;
    }

    public String getOfficePhone() {
        return this.officePhone;
    }

    public void setOfficePhone(String officePhone) {
        this.officePhone = officePhone;
    }

    public String getSecondaryOfficeLocation() {
        return this.secondaryOfficeLocation;
    }

    public void setSecondaryOfficeLocation(String secondaryOfficeLocation) {
        this.secondaryOfficeLocation = secondaryOfficeLocation;
    }

    public String getSecondaryOfficePhone() {
        return this.secondaryOfficePhone;
    }

    public void setSecondaryOfficePhone(String secondaryOfficePhone) {
        this.secondaryOfficePhone = secondaryOfficePhone;
    }

    public String getSchool() {
        return this.school;
    }

    public void setSchool(String school) {
        this.school = school;
    }

    public String getYearGraduated() {
        return this.yearGraduated;
    }

    public void setYearGraduated(String yearGraduated) {
        this.yearGraduated = yearGraduated;
    }

    public String getDirectoryDepartment() {
        return this.directoryDepartment;
    }

    public void setDirectoryDepartment(String directoryDepartment) {
        this.directoryDepartment = directoryDepartment;
    }

    public String getSaluation() {
        return this.saluation;
    }

    public void setSaluation(String saluation) {
        this.saluation = saluation;
    }

    public String getCountryOfCitizenship() {
        return this.countryOfCitizenship;
    }

    public void setCountryOfCitizenship(String countryOfCitizenship) {
        this.countryOfCitizenship = countryOfCitizenship;
    }

    public String getPrimaryTitle() {
        return this.primaryTitle;
    }

    public void setPrimaryTitle(String primaryTitle) {
        this.primaryTitle = primaryTitle;
    }

    public String getDirectoryTitle() {
        return this.directoryTitle;
    }

    public void setDirectoryTitle(String directoryTitle) {
        this.directoryTitle = directoryTitle;
    }

    public String getHomeUnit() {
        return this.homeUnit;
    }

    public void setHomeUnit(String homeUnit) {
        this.homeUnit = homeUnit;
    }

    public Boolean getFacultyFlag() {
        return this.facultyFlag;
    }

    public void setFacultyFlag(Boolean facultyFlag) {
        this.facultyFlag = facultyFlag;
    }

    public Boolean getGraduateStudentStaffFlag() {
        return this.graduateStudentStaffFlag;
    }

    public void setGraduateStudentStaffFlag(Boolean graduateStudentStaffFlag) {
        this.graduateStudentStaffFlag = graduateStudentStaffFlag;
    }

    public Boolean getResearchStaffFlag() {
        return this.researchStaffFlag;
    }

    public void setResearchStaffFlag(Boolean researchStaffFlag) {
        this.researchStaffFlag = researchStaffFlag;
    }

    public Boolean getServiceStaffFlag() {
        return this.serviceStaffFlag;
    }

    public void setServiceStaffFlag(Boolean serviceStaffFlag) {
        this.serviceStaffFlag = serviceStaffFlag;
    }

    public Boolean getSupportStaffFlag() {
        return this.supportStaffFlag;
    }

    public void setSupportStaffFlag(Boolean supportStaffFlag) {
        this.supportStaffFlag = supportStaffFlag;
    }

    public Boolean getOtherAcademicGroupFlag() {
        return this.otherAcademicGroupFlag;
    }

    public void setOtherAcademicGroupFlag(Boolean otherAcademicGroupFlag) {
        this.otherAcademicGroupFlag = otherAcademicGroupFlag;
    }

    public Boolean getMedicalStaffFlag() {
        return this.medicalStaffFlag;
    }

    public void setMedicalStaffFlag(Boolean medicalStaffFlag) {
        this.medicalStaffFlag = medicalStaffFlag;
    }

    public Boolean getVacationAccrualFlag() {
        return this.vacationAccrualFlag;
    }

    public void setVacationAccrualFlag(Boolean vacationAccrualFlag) {
        this.vacationAccrualFlag = vacationAccrualFlag;
    }

    public Boolean getOnSabbaticalFlag() {
        return this.onSabbaticalFlag;
    }

    public void setOnSabbaticalFlag(Boolean onSabbaticalFlag) {
        this.onSabbaticalFlag = onSabbaticalFlag;
    }

    public String getIdProvided() {
        return this.idProvided;
    }

    public void setIdProvided(String idProvided) {
        this.idProvided = idProvided;
    }

    public String getIdVerified() {
        return this.idVerified;
    }

    public void setIdVerified(String idVerified) {
        this.idVerified = idVerified;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getAddressLine3() {
        return this.addressLine3;
    }

    public void setAddressLine3(String addressLine3) {
        this.addressLine3 = addressLine3;
    }

    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCounty() {
        return this.county;
    }

    public void setCounty(String county) {
        this.county = county;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getCountryCode() {
        return this.countryCode != null ? this.countryCode.trim() : null;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String faxNumber) {
        this.faxNumber = faxNumber;
    }

    public String getPagerNumber() {
        return this.pagerNumber;
    }

    public void setPagerNumber(String pagerNumber) {
        this.pagerNumber = pagerNumber;
    }

    public String getMobilePhoneNumber() {
        return this.mobilePhoneNumber;
    }

    public void setMobilePhoneNumber(String mobilePhoneNumber) {
        this.mobilePhoneNumber = mobilePhoneNumber;
    }

    public String getEraCommonsUserName() {
        return this.eraCommonsUserName;
    }

    public void setEraCommonsUserName(String eraCommonsUserName) {
        this.eraCommonsUserName = eraCommonsUserName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public ProtocolBase getParent() {
        return this.getProtocol();
    }

    public String getRoleCode() {
        return this.getProtocolPersonRoleId();
    }

    public void setAffiliationTypeCodeChanged(boolean affiliationTypeCodeChanged) {
        this.affiliationTypeCodeChanged = affiliationTypeCodeChanged;
    }

    public boolean isAffiliationTypeCodeChanged() {
        return this.affiliationTypeCodeChanged;
    }
}

