/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.personnel;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitBase;
import org.kuali.kra.protocol.personnel.ProtocolUnitEvent;
import org.kuali.kra.rule.event.KraDocumentEventBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.util.ObjectUtils;

public abstract class ProtocolUnitEventBase
extends KraDocumentEventBase
implements ProtocolUnitEvent {
    private static final Log LOG = LogFactory.getLog(ProtocolUnitEventBase.class);
    private ProtocolUnitBase protocolUnit;
    private int personIndex;

    protected ProtocolUnitEventBase(String description, String errorPathPrefix, ProtocolDocumentBase document, ProtocolUnitBase protocolUnit, int personIndex) {
        super(description, errorPathPrefix, (Document)document);
        this.setProtocolUnit(protocolUnit);
        this.personIndex = personIndex;
        this.logEvent();
    }

    public ProtocolUnitBase getProtocolUnit() {
        return this.protocolUnit;
    }

    public int getPersonIndex() {
        return this.personIndex;
    }

    private void setProtocolUnit(ProtocolUnitBase protocolUnit) {
        this.protocolUnit = (ProtocolUnitBase)ObjectUtils.deepCopy((Serializable)protocolUnit);
    }

    protected void logEvent() {
        StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)this.getClass().getName(), (String)"."));
        logMessage.append(" with ");
        if (this.getProtocolUnit() == null) {
            logMessage.append("null protocolUnit");
        } else {
            logMessage.append(this.getProtocolUnit().toString());
        }
        LOG.debug((Object)logMessage);
    }
}

