/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol;

import java.util.Calendar;
import org.kuali.kra.protocol.protocol.ProtocolNumberServiceBase;
import org.kuali.rice.krad.service.SequenceAccessorService;

public abstract class ProtocolNumberServiceImplBase
implements ProtocolNumberServiceBase {
    private static final String ZERO = "0";
    private static final int MAX_NUMBER = 1000000;
    private SequenceAccessorService sequenceAccessorService;

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public String generateProtocolNumber() {
        Calendar calendar = Calendar.getInstance();
        return this.getYear(calendar) + this.getMonth(calendar) + this.getNextNumber();
    }

    protected String getYear(Calendar calendar) {
        int year = calendar.get(1);
        String s = Integer.toString(year).substring(2);
        if (s.length() == 1) {
            s = ZERO + s;
        }
        return s;
    }

    protected String getMonth(Calendar calendar) {
        int month = calendar.get(2) + 1;
        String s = Integer.toString(month);
        if (s.length() == 1) {
            s = ZERO + s;
        }
        return s;
    }

    protected String getNextNumber() {
        Long nextNumber = this.getSequenceNumber() % 1000000L;
        String s = nextNumber.toString();
        int length = s.length();
        for (int i = 0; i < 6 - length; ++i) {
            s = ZERO + s;
        }
        return s;
    }

    protected synchronized Long getSequenceNumber() {
        return this.sequenceAccessorService.getNextAvailableSequenceNumber(this.getSequenceNameHook());
    }

    protected abstract String getSequenceNameHook();
}

