/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.funding;

import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.FundingSourceType;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public abstract class ProtocolFundingSourceAuditRuleBase
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final String FUNDING_SOURCE_AUDIT_ERRORS = "requiredFieldsAuditErrors";
    private static final String FUNDING_SOURCE_AUDIT_LINK = "protocol.Funding Source";

    public boolean processRunAuditBusinessRules(Document document) {
        boolean isValid = true;
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        isValid = this.processRequiredProtocolFundingSources(protocolDocument.getProtocol());
        return isValid;
    }

    private boolean processRequiredProtocolFundingSources(ProtocolBase protocol) {
        boolean isValid = true;
        Collection fundingSourceTypes = this.getBusinessObjectService().findAll(FundingSourceType.class);
        for (FundingSourceType fundingSourceType : fundingSourceTypes) {
            if (!fundingSourceType.getFundingSourceTypeFlag() || this.getProtocolContainsFundingSource(protocol, fundingSourceType.getFundingSourceTypeCode())) continue;
            AuditError auditError = new AuditError("document.title", "error.protocol.fundingSource.required", FUNDING_SOURCE_AUDIT_LINK, new String[]{fundingSourceType.getDescription()});
            this.addAuditError(auditError, FUNDING_SOURCE_AUDIT_ERRORS, "Protocol", "Validation Errors");
            isValid = false;
        }
        return isValid;
    }

    private boolean getProtocolContainsFundingSource(ProtocolBase protocol, String fundingSourceTypeCode) {
        boolean contains = false;
        for (ProtocolFundingSourceBase protocolFundingSource : protocol.getProtocolFundingSources()) {
            if (!StringUtils.equals((String)fundingSourceTypeCode, (String)protocolFundingSource.getFundingSourceTypeCode())) continue;
            contains = true;
            break;
        }
        return contains;
    }
}

