/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.funding;

import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.FundingSourceType;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.protocol.ProtocolAssociateBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService;

public abstract class ProtocolFundingSourceBase
extends ProtocolAssociateBase {
    private static final long serialVersionUID = 2732312377082408995L;
    private Long protocolFundingSourceId;
    private String fundingSourceTypeCode;
    private String fundingSourceNumber;
    private FundingSourceType fundingSourceType;
    private String fundingSourceName;
    private String fundingSourceTitle;

    public ProtocolFundingSourceBase() {
    }

    public ProtocolFundingSourceBase(String fundingSourceNumber, String fundingSourceTypeCode, String fundingSourceName, String fundingSourceTitle) {
        this.setFundingSourceNumber(fundingSourceNumber);
        this.setFundingSourceTypeCode(fundingSourceTypeCode);
        this.setFundingSourceName(fundingSourceName);
        this.setFundingSourceTitle(fundingSourceTitle);
    }

    public String getFundingSourceTitle() {
        return this.fundingSourceTitle;
    }

    public void setFundingSourceTitle(String fundingSourceTitle) {
        this.fundingSourceTitle = fundingSourceTitle;
    }

    public String getFundingSourceName() {
        return this.fundingSourceName;
    }

    public void setFundingSourceName(String fundingSourceName) {
        this.fundingSourceName = fundingSourceName;
    }

    public Long getProtocolFundingSourceId() {
        return this.protocolFundingSourceId;
    }

    public void setProtocolFundingSourceId(Long protocolFundingSourceId) {
        this.protocolFundingSourceId = protocolFundingSourceId;
    }

    public String getFundingSourceTypeCode() {
        return this.fundingSourceTypeCode;
    }

    public void setFundingSourceTypeCode(String fundingSourceTypeCode) {
        this.fundingSourceTypeCode = fundingSourceTypeCode;
        if (StringUtils.isNotBlank((String)fundingSourceTypeCode)) {
            this.refreshReferenceObject("fundingSourceType");
        }
    }

    public String getFundingSourceNumber() {
        return this.fundingSourceNumber;
    }

    public void setFundingSourceNumber(String fundingSourceNumber) {
        this.fundingSourceNumber = fundingSourceNumber;
    }

    public FundingSourceType getFundingSourceType() {
        return this.fundingSourceType;
    }

    public void setFundingSourceType(FundingSourceType fundingSourceType) {
        this.fundingSourceType = fundingSourceType;
    }

    public boolean isFundingSourceLookupable() {
        return this.getProtocolFundingSourceService().isLookupable(this.fundingSourceTypeCode);
    }

    protected ProtocolFundingSourceService getProtocolFundingSourceService() {
        return (ProtocolFundingSourceService)KraServiceLocator.getService((Class)this.getProtocolFundingSourceServiceClassHook());
    }

    protected abstract Class<? extends ProtocolFundingSourceService> getProtocolFundingSourceServiceClassHook();

    public void resetPersistenceState() {
        this.setProtocolFundingSourceId(null);
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fundingSourceNumber == null ? 0 : this.fundingSourceNumber.hashCode());
        result = 31 * result + (this.fundingSourceTypeCode == null ? 0 : this.fundingSourceTypeCode.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtocolFundingSourceBase other = (ProtocolFundingSourceBase)obj;
        if (this.fundingSourceNumber == null ? other.fundingSourceNumber != null : !this.fundingSourceNumber.equalsIgnoreCase(other.fundingSourceNumber)) {
            return false;
        }
        return !(this.fundingSourceTypeCode == null ? other.fundingSourceTypeCode != null : !this.fundingSourceTypeCode.equals(other.fundingSourceTypeCode));
    }

    public boolean isSponsorFunding() {
        return StringUtils.equals((String)this.fundingSourceTypeCode, (String)"1");
    }
}

