/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.funding.impl;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.common.specialreview.bo.SpecialReview;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.specialreview.SpecialReviewHelper;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolActionBase;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.protocol.ProtocolNumberServiceBase;
import org.kuali.kra.protocol.protocol.funding.ProposalDevelopmentProtocolDocumentService;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.SystemAuthorizationService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.role.Role;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.service.SequenceAccessorService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProposalDevelopmentProtocolDocumentServiceImplBase<GenericProtocolDocument extends ProtocolDocumentBase>
implements ProposalDevelopmentProtocolDocumentService<GenericProtocolDocument> {
    private SystemAuthorizationService systemAuthorizationService;
    private KraAuthorizationService kraAuthorizationService;
    private SequenceAccessorService sequenceAccessorService;

    public GenericProtocolDocument createProtocolDocument(ProposalDevelopmentForm proposalDevelopmentForm) throws Exception {
        ProtocolDocumentBase protocolDocument = null;
        DevelopmentProposal developmentProposal = proposalDevelopmentForm.getProposalDevelopmentDocument().getDevelopmentProposal();
        if (this.isAuthorizedCreateProtocol(proposalDevelopmentForm.getSpecialReviewHelper())) {
            DocumentService documentService = KRADServiceLocatorWeb.getDocumentService();
            protocolDocument = this.getProtocolDocumentNewInstanceHook(documentService);
            this.populateDocumentOverview(developmentProposal, protocolDocument);
            this.populateRequiredFields(developmentProposal, protocolDocument);
            this.populateProtocolPerson_Investigator(developmentProposal, protocolDocument);
            this.populateProtocolFundingSource(developmentProposal, protocolDocument);
            documentService.saveDocument((Document)protocolDocument);
            this.initializeAuthorization(protocolDocument);
        }
        return (GenericProtocolDocument)protocolDocument;
    }

    public void setSystemAuthorizationService(SystemAuthorizationService systemAuthorizationService) {
        this.systemAuthorizationService = systemAuthorizationService;
    }

    public void setKraAuthorizationService(KraAuthorizationService kraAuthorizationService) {
        this.kraAuthorizationService = kraAuthorizationService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public void populateDocumentOverview(DevelopmentProposal developmentProposal, ProtocolDocumentBase protocolDocument) {
        ProposalDevelopmentDocument proposalDocument = developmentProposal.getProposalDocument();
        DocumentHeader proposalDocumentHeader = proposalDocument.getDocumentHeader();
        DocumentHeader protocolDocumentHeader = protocolDocument.getDocumentHeader();
        protocolDocumentHeader.setDocumentDescription(this.getProtocolNameSpaceHook() + " " + proposalDocumentHeader.getDocumentDescription());
        protocolDocumentHeader.setExplanation("Document created from Proposal - " + proposalDocumentHeader.getDocumentNumber());
        protocolDocumentHeader.setOrganizationDocumentNumber(proposalDocumentHeader.getOrganizationDocumentNumber());
    }

    public void populateRequiredFields(DevelopmentProposal developmentProposal, ProtocolDocumentBase protocolDocument) throws Exception {
        ProtocolBase protocol = protocolDocument.getProtocol();
        protocol.setProtocolNumber(this.getProtocolNumberServiceHook().generateProtocolNumber());
        protocol.setSequenceNumber(Integer.valueOf(0));
        Long nextProtocolId = this.sequenceAccessorService.getNextAvailableSequenceNumber(this.getSequenceNumberNameHook());
        protocol.setProtocolId(nextProtocolId);
        protocol.setTitle(developmentProposal.getTitle());
        protocol.setLeadUnitNumber(developmentProposal.getOwnedByUnitNumber());
        protocol.setPrincipalInvestigatorId(developmentProposal.getPrincipalInvestigator().getPersonId());
        protocol.setProtocolTypeCode(this.getProtocolTypeCodeHook());
        this.populateProtocolSpecificFieldsHook(protocol);
        ProtocolActionBase protocolAction = this.getProtocolActionNewInstanceHook(protocolDocument.getProtocol(), null, this.getProtocolActionProtocolCreatedCodeHook());
        protocolAction.setComments(this.getProtocolCreatedHook());
        protocolDocument.getProtocol().getProtocolActions().add(protocolAction);
    }

    public void initializeAuthorization(ProtocolDocumentBase protocolDocument) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        this.kraAuthorizationService.addRole(userId, this.getProtocolAggregatorHook(), (Permissionable)protocolDocument.getProtocol());
        this.kraAuthorizationService.addRole(userId, this.getProtocolApproverHook(), (Permissionable)protocolDocument.getProtocol());
        List roles = this.systemAuthorizationService.getRoles(this.getProtocolRoleTypeHook());
        for (Role role : roles) {
            List persons = this.kraAuthorizationService.getPersonsInRole((Permissionable)protocolDocument.getProtocol(), role.getName());
            for (KcPerson person : persons) {
                if (StringUtils.equals((String)person.getPersonId(), (String)userId)) continue;
                this.kraAuthorizationService.addRole(person.getPersonId(), role.getName(), (Permissionable)protocolDocument.getProtocol());
            }
        }
    }

    public void populateProtocolPerson_Investigator(DevelopmentProposal developmentProposal, ProtocolDocumentBase protocolDocument) {
        ProtocolPersonBase protocolPerson = this.getProtocolPersonNewInstanceHook();
        ProtocolBase protocol = protocolDocument.getProtocol();
        protocolPerson.setPersonId(protocol.getPrincipalInvestigatorId());
        protocolPerson.setPersonName(developmentProposal.getPrincipalInvestigatorName());
        protocolPerson.setProtocolPersonRoleId("PI");
        ProtocolPersonnelService protocolPersonnelService = this.getProtocolPersonnelService();
        protocolPersonnelService.addProtocolPerson(protocol, protocolPerson);
    }

    public boolean isAuthorizedCreateProtocol(SpecialReviewHelper specialReviewHelper) {
        SpecialReview specialReview = specialReviewHelper.getNewSpecialReview();
        boolean canCreateProposal = false;
        if ("1".equals(specialReview.getSpecialReviewTypeCode())) {
            canCreateProposal = specialReviewHelper.isCanCreateIrbProtocol();
        } else if ("2".equals(specialReview.getSpecialReviewTypeCode())) {
            canCreateProposal = specialReviewHelper.isCanCreateIacucProtocol();
        }
        return canCreateProposal;
    }

    private ProtocolFundingSourceService getProtocolFundingSourceService() {
        return this.getProtocolFundingSourceServiceHook();
    }

    public void populateProtocolFundingSource(DevelopmentProposal developmentProposal, ProtocolDocumentBase protocolDocument) {
        ProtocolBase protocol = protocolDocument.getProtocol();
        List protocolFundingSources = protocol.getProtocolFundingSources();
        ProtocolFundingSourceService protocolFundingSourceService = this.getProtocolFundingSourceService();
        ProtocolFundingSourceBase protocolFundingSource = protocolFundingSourceService.updateProtocolFundingSource("1", developmentProposal.getSponsorCode(), developmentProposal.getSponsorName());
        protocolFundingSource.setProtocol(protocolDocument.getProtocol());
        protocolFundingSources.add(protocolFundingSource);
    }

    protected ProtocolPersonnelService getProtocolPersonnelService() {
        return this.getProtocolPersonnelServiceHook();
    }

    protected abstract ProtocolDocumentBase getProtocolDocumentNewInstanceHook(DocumentService var1) throws WorkflowException;

    protected abstract String getProtocolActionProtocolCreatedCodeHook();

    protected abstract String getProtocolTypeCodeHook();

    protected abstract void populateProtocolSpecificFieldsHook(ProtocolBase var1);

    protected abstract ProtocolNumberServiceBase getProtocolNumberServiceHook();

    protected abstract ProtocolActionBase getProtocolActionNewInstanceHook(ProtocolBase var1, ProtocolSubmissionBase var2, String var3);

    protected abstract String getProtocolAggregatorHook();

    protected abstract String getProtocolApproverHook();

    protected abstract String getProtocolRoleTypeHook();

    protected abstract String getProtocolNameSpaceHook();

    protected abstract String getSequenceNumberNameHook();

    protected abstract ProtocolPersonBase getProtocolPersonNewInstanceHook();

    protected abstract String getProtocolCreatedHook();

    protected abstract ProtocolPersonnelService getProtocolPersonnelServiceHook();

    protected abstract ProtocolFundingSourceService getProtocolFundingSourceServiceHook();
}

