/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.funding.impl;

import java.sql.Date;
import java.util.Calendar;
import java.util.List;
import org.kuali.kra.bo.PersonEditableInterface;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.ProposalDevelopmentUtils;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.service.KeyPersonnelService;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.service.impl.KeyPersonnelServiceImpl;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.ProtocolFormBase;
import org.kuali.kra.protocol.protocol.ProtocolHelperBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.protocol.protocol.funding.ProtocolProposalDevelopmentDocumentService;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.PersonEditableService;
import org.kuali.rice.krad.bo.DocumentHeader;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class ProtocolProposalDevelopmentDocumentServiceImplBase
implements ProtocolProposalDevelopmentDocumentService {
    public ProposalDevelopmentDocument createProposalDevelopmentDocument(ProtocolFormBase protocolForm) throws Exception {
        ProposalDevelopmentDocument proposalDevelopmentDocument = null;
        ProtocolBase protocol = protocolForm.getProtocolDocument().getProtocol();
        if (this.isAuthorizedCreateProposal(protocolForm.getProtocolHelper())) {
            DocumentService docService = KRADServiceLocatorWeb.getDocumentService();
            proposalDevelopmentDocument = (ProposalDevelopmentDocument)docService.getNewDocument(ProposalDevelopmentDocument.class);
            ProposalDevelopmentService proposalDevelopmentService = (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class);
            this.populateDocumentOverview(protocol, proposalDevelopmentDocument);
            this.populateRequiredFields(protocol, proposalDevelopmentDocument);
            proposalDevelopmentService.initializeUnitOrganizationLocation(proposalDevelopmentDocument);
            proposalDevelopmentService.initializeProposalSiteNumbers(proposalDevelopmentDocument);
            this.populateProposalPerson_Investigator(protocol, proposalDevelopmentDocument);
            this.populateProposalSpecialReview(protocol, proposalDevelopmentDocument);
            docService.saveDocument((Document)proposalDevelopmentDocument);
            this.initializeAuthorization(proposalDevelopmentDocument);
        }
        return proposalDevelopmentDocument;
    }

    public void populateDocumentOverview(ProtocolBase protocol, ProposalDevelopmentDocument proposalDocument) {
        ProtocolDocumentBase protocolDocument = protocol.getProtocolDocument();
        DocumentHeader proposalDocumentHeader = proposalDocument.getDocumentHeader();
        DocumentHeader protocolDocumentHeader = protocolDocument.getDocumentHeader();
        proposalDocumentHeader.setDocumentDescription("PD - " + protocolDocumentHeader.getDocumentDescription());
        proposalDocumentHeader.setExplanation("Document created from ProtocolBase - " + protocolDocument.getDocumentNumber());
        proposalDocumentHeader.setOrganizationDocumentNumber(protocolDocumentHeader.getOrganizationDocumentNumber());
    }

    public void populateRequiredFields(ProtocolBase protocol, ProposalDevelopmentDocument proposalDocument) throws Exception {
        DevelopmentProposal developmentProposal = proposalDocument.getDevelopmentProposal();
        developmentProposal.setTitle(protocol.getTitle());
        developmentProposal.setOwnedByUnit(protocol.getLeadUnit().getUnit());
        developmentProposal.setOwnedByUnitNumber(protocol.getLeadUnitNumber());
        developmentProposal.setRequestedStartDateInitial(new Date(System.currentTimeMillis()));
        String projectEndDateParameter = this.getProjectEndDateNumberOfYearsHook();
        int numberOfYears = Integer.parseInt(projectEndDateParameter);
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, numberOfYears);
        calendar.add(5, -1);
        Date projectEndDate = new Date(calendar.getTimeInMillis());
        developmentProposal.setRequestedEndDateInitial(projectEndDate);
        String activityTypeCode = ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter((String)"ACTIVITY_TYPE_CODE_RESEARCH");
        String proposalTypeCode = ProposalDevelopmentUtils.getProposalDevelopmentDocumentParameter((String)"PROPOSAL_TYPE_CODE_NEW");
        developmentProposal.setActivityTypeCode(activityTypeCode);
        developmentProposal.setProposalTypeCode(proposalTypeCode);
        List protocolFundingSources = protocol.getProtocolFundingSources();
        ProtocolFundingSourceBase sponsorProtocolFundingSource = null;
        for (ProtocolFundingSourceBase protocolFundingSource : protocolFundingSources) {
            if (!protocolFundingSource.isSponsorFunding()) continue;
            sponsorProtocolFundingSource = protocolFundingSource;
            break;
        }
        if (sponsorProtocolFundingSource != null) {
            developmentProposal.setSponsorCode(sponsorProtocolFundingSource.getFundingSourceNumber());
        }
    }

    public void initializeAuthorization(ProposalDevelopmentDocument document) {
        String userId = GlobalVariables.getUserSession().getPrincipalId();
        KraAuthorizationService kraAuthService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        kraAuthService.addRole(userId, "Aggregator", (Permissionable)document);
    }

    public void populateProposalPerson_Investigator(ProtocolBase protocol, ProposalDevelopmentDocument proposalDocument) {
        ProposalPerson proposalPerson = new ProposalPerson();
        proposalPerson.setPersonId(protocol.getPrincipalInvestigatorId());
        PersonEditableService personEditableService = (PersonEditableService)KraServiceLocator.getService(PersonEditableService.class);
        personEditableService.populateContactFieldsFromPersonId((PersonEditableInterface)proposalPerson);
        proposalPerson.setProposalPersonRoleId("PI");
        proposalPerson.setDevelopmentProposal(proposalDocument.getDevelopmentProposal());
        proposalPerson.setProposalNumber(proposalDocument.getDevelopmentProposal().getProposalNumber());
        proposalPerson.setProposalPersonNumber(new Integer(1));
        proposalPerson.setOptInUnitStatus("Y");
        proposalPerson.setOptInCertificationStatus("Y");
        proposalDocument.getDevelopmentProposal().getProposalPersons().add(proposalPerson);
        KeyPersonnelServiceImpl keyPersonnelService = (KeyPersonnelServiceImpl)KraServiceLocator.getService(KeyPersonnelService.class);
        keyPersonnelService.populateProposalPerson(proposalPerson, proposalDocument);
        keyPersonnelService.assignLeadUnit(proposalPerson, proposalDocument.getDevelopmentProposal().getOwnedByUnitNumber());
    }

    public void populateProposalSpecialReview(ProtocolBase protocol, ProposalDevelopmentDocument proposalDocument) {
        if (protocol != null) {
            Integer specialReviewNumber = proposalDocument.getDocumentNextValue("SPECIAL_REVIEW_NUMBER");
            ProposalSpecialReview specialReview = new ProposalSpecialReview();
            specialReview.setSpecialReviewNumber(specialReviewNumber);
            specialReview.setSpecialReviewTypeCode(this.getSpecialReviewTypeHook());
            specialReview.setApprovalTypeCode("1");
            specialReview.setProtocolNumber(protocol.getProtocolNumber());
            specialReview.setProposalNumber(proposalDocument.getDevelopmentProposal().getProposalNumber());
            specialReview.setProtocolStatus(protocol.getProtocolStatus().getDescription());
            specialReview.setComments("A Special Review has been inserted.");
            proposalDocument.getDevelopmentProposal().getPropSpecialReviews().add(specialReview);
        }
    }

    public boolean isAuthorizedCreateProposal(ProtocolHelperBase protocolHelper) {
        boolean canCreateProposal = protocolHelper.isCanCreateProposalDevelopment();
        return canCreateProposal;
    }

    protected abstract String getProjectEndDateNumberOfYearsHook();

    protected abstract String getSpecialReviewTypeHook();
}

