/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.protocol.research;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.protocol.research.ProtocolResearchAreaBase;
import org.kuali.kra.rules.ResearchDocumentRuleBase;
import org.kuali.rice.kns.util.AuditCluster;
import org.kuali.rice.kns.util.AuditError;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.rules.rule.DocumentAuditRule;

public abstract class ProtocolResearchAreaAuditRuleBase
extends ResearchDocumentRuleBase
implements DocumentAuditRule {
    private static final String ADDITIONAL_INFORMATION_AUDIT_ERRORS = "additionalInformationAuditErrors";
    private List<AuditError> auditErrors;

    public boolean processRunAuditBusinessRules(Document document) {
        boolean isValid = true;
        ProtocolDocumentBase protocolDocument = (ProtocolDocumentBase)document;
        this.auditErrors = new ArrayList();
        boolean bl = isValid = !protocolDocument.getProtocol().isEmptyProtocolResearchAreas();
        if (!isValid) {
            this.addErrorToAuditErrors();
        }
        this.reportAndCreateAuditCluster();
        return isValid &= this.isEveryResearchAreaActive(protocolDocument);
    }

    protected void addErrorToAuditErrors() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("protocol");
        stringBuilder.append(".");
        stringBuilder.append("Area of Research");
        this.auditErrors.add(new AuditError("document.protocolList[0].newDescription", "error.protocol.researchArea.required", stringBuilder.toString()));
    }

    private boolean isEveryResearchAreaActive(ProtocolDocumentBase document) {
        boolean inactiveFound = false;
        String inactiveResearchAreaCode = "";
        List pras = document.getProtocol().getProtocolResearchAreas();
        if (CollectionUtils.isNotEmpty((Collection)pras)) {
            for (ProtocolResearchAreaBase protocolResearchArea : pras) {
                if (protocolResearchArea.getResearchAreas().isActive()) continue;
                inactiveFound = true;
                if (StringUtils.isBlank((String)inactiveResearchAreaCode)) {
                    inactiveResearchAreaCode = protocolResearchArea.getResearchAreaCode();
                    continue;
                }
                inactiveResearchAreaCode = inactiveResearchAreaCode + ", " + protocolResearchArea.getResearchAreaCode();
            }
        }
        if (inactiveFound) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("protocol");
            stringBuilder.append(".");
            stringBuilder.append("Area of Research");
            this.auditErrors.add(new AuditError("document.protocolList[0].newDescription", "error.protocol.researchArea.notactive", stringBuilder.toString(), new String[]{inactiveResearchAreaCode}));
        }
        return !inactiveFound;
    }

    protected void reportAndCreateAuditCluster() {
        if (this.auditErrors.size() > 0) {
            KNSGlobalVariables.getAuditErrorMap().put(ADDITIONAL_INFORMATION_AUDIT_ERRORS, new AuditCluster("Protocol", this.auditErrors, "Validation Errors"));
        }
    }
}

