/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.specialreview.impl;

import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.common.specialreview.bo.SpecialReview;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.specialreview.ProposalSpecialReview;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.ProtocolFinderDao;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewService;
import org.kuali.rice.krad.service.BusinessObjectService;

public abstract class ProtocolSpecialReviewServiceImplBase
implements ProtocolSpecialReviewService {
    private transient ProtocolFinderDao protocolFinderDao;

    public DevelopmentProposal getPropososalDevelopment(String proposalNumber) {
        String PROPOSAL_NUMBER = "PROPOSAL_NUMBER";
        DevelopmentProposal dp = null;
        if (proposalNumber != null) {
            HashMap<String, String> key = new HashMap<String, String>();
            key.put("PROPOSAL_NUMBER", proposalNumber);
            dp = (DevelopmentProposal)((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class)).findByPrimaryKey(DevelopmentProposal.class, key);
        }
        return dp;
    }

    public void populateSpecialReview(SpecialReview specialReview) {
        String protocolNumber = specialReview.getProtocolNumber();
        if (protocolNumber == null) {
            return;
        }
        String lastApprovedProtocolNumber = protocolNumber;
        if (StringUtils.contains((String)protocolNumber, (String)"A")) {
            lastApprovedProtocolNumber = StringUtils.substringBefore((String)protocolNumber, (String)"A");
        } else if (StringUtils.contains((String)protocolNumber, (String)"R")) {
            lastApprovedProtocolNumber = StringUtils.substringBefore((String)protocolNumber, (String)"R");
        }
        ProtocolBase protocol = this.getProtocolFinderDao().findCurrentProtocolByNumber(lastApprovedProtocolNumber);
        if (protocol != null) {
            this.setSpecialReviewApprovalTypeHook(specialReview);
            if (specialReview.getClass().equals(ProposalSpecialReview.class)) {
                ProposalSpecialReview psr = (ProposalSpecialReview)specialReview;
                DevelopmentProposal dp = this.getPropososalDevelopment(psr.getProposalNumber());
                if (!(dp != null && (StringUtils.equals((String)dp.getProposalStateTypeCode(), (String)"6") || StringUtils.equals((String)dp.getProposalStateTypeCode(), (String)"7") || StringUtils.equals((String)dp.getProposalStateTypeCode(), (String)"8") || StringUtils.equals((String)dp.getProposalStateTypeCode(), (String)"9") || StringUtils.equals((String)dp.getProposalStateTypeCode(), (String)"5")) && specialReview.getProtocolStatus() != null)) {
                    specialReview.setProtocolStatus(protocol.getProtocolStatus().getDescription());
                }
            } else {
                specialReview.setProtocolStatus(protocol.getProtocolStatus().getDescription());
            }
            specialReview.setProtocolNumber(protocol.getProtocolNumber());
            specialReview.setApplicationDate(protocol.getProtocolSubmission().getSubmissionDate());
            specialReview.setApprovalDate(protocol.getLastApprovalDate() == null ? protocol.getApprovalDate() : protocol.getLastApprovalDate());
            specialReview.setExpirationDate(protocol.getExpirationDate());
            this.setProtocolExemptStudiesCheckListItemHook(protocol, specialReview);
        }
    }

    public ProtocolFinderDao getProtocolFinderDao() {
        if (this.protocolFinderDao == null) {
            this.protocolFinderDao = (ProtocolFinderDao)KraServiceLocator.getService(ProtocolFinderDao.class);
        }
        return this.protocolFinderDao;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    protected abstract void setSpecialReviewApprovalTypeHook(SpecialReview var1);

    protected abstract void setProtocolExemptStudiesCheckListItemHook(ProtocolBase var1, SpecialReview var2);
}

