/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.protocol.summary;

import java.io.Serializable;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewExemption;
import org.kuali.kra.protocol.summary.ProtocolSummary;

public class SpecialReviewSummary
implements Serializable {
    private static final long serialVersionUID = -8047038042526446451L;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private String type;
    private String approvalStatus;
    private String protocolNumber;
    private String applicationDate;
    private String approvalDate;
    private String expirationDate;
    private String exemptionNumbers;
    private String comment;
    private boolean typeChanged;
    private boolean approvalStatusChanged;
    private boolean protocolNumberChanged;
    private boolean applicationDateChanged;
    private boolean approvalDateChanged;
    private boolean expirationDateChanged;
    private boolean exemptionNumbersChanged;
    private boolean commentChanged;

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getApprovalStatus() {
        return this.approvalStatus;
    }

    public void setApprovalStatus(String approvalStatus) {
        this.approvalStatus = approvalStatus;
    }

    public String getProtocolNumber() {
        return this.protocolNumber;
    }

    public void setProtocolNumber(String protocolNumber) {
        this.protocolNumber = protocolNumber;
    }

    public String getApplicationDate() {
        return this.applicationDate;
    }

    public void setApplicationDate(Date applicationDate) {
        this.applicationDate = this.formatDate(applicationDate);
    }

    public String getApprovalDate() {
        return this.approvalDate;
    }

    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = this.formatDate(approvalDate);
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = this.formatDate(expirationDate);
    }

    public String getExemptionNumbers() {
        return this.exemptionNumbers;
    }

    public void setExemptionNumbers(List<ProtocolSpecialReviewExemption> exemptions) {
        this.exemptionNumbers = "";
        Collections.sort(exemptions, new /* Unavailable Anonymous Inner Class!! */);
        for (ProtocolSpecialReviewExemption exemption : exemptions) {
            if (!StringUtils.isBlank((String)this.exemptionNumbers)) {
                this.exemptionNumbers = this.exemptionNumbers + ", ";
            }
            if (exemption.getExemptionType() == null) {
                exemption.refreshReferenceObject("exemptionType");
            }
            this.exemptionNumbers = this.exemptionNumbers + exemption.getExemptionType().getDescription();
        }
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    private String formatDate(Date date) {
        return date == null ? "" : this.dateFormat.format(date);
    }

    public boolean isTypeChanged() {
        return this.typeChanged;
    }

    public boolean isApprovalStatusChanged() {
        return this.approvalStatusChanged;
    }

    public boolean isProtocolNumberChanged() {
        return this.protocolNumberChanged;
    }

    public boolean isApplicationDateChanged() {
        return this.applicationDateChanged;
    }

    public boolean isApprovalDateChanged() {
        return this.approvalDateChanged;
    }

    public boolean isExpirationDateChanged() {
        return this.expirationDateChanged;
    }

    public boolean isExemptionNumbersChanged() {
        return this.exemptionNumbersChanged;
    }

    public boolean isCommentChanged() {
        return this.commentChanged;
    }

    public void compare(ProtocolSummary other) {
        SpecialReviewSummary otherSpecialReview = other.findSpecialReview(this.type, this.approvalStatus);
        if (otherSpecialReview == null) {
            this.typeChanged = true;
            this.approvalStatusChanged = true;
            this.protocolNumberChanged = true;
            this.applicationDateChanged = true;
            this.approvalDateChanged = true;
            this.expirationDateChanged = true;
            this.exemptionNumbersChanged = true;
            this.commentChanged = true;
        } else {
            this.typeChanged = !StringUtils.equals((String)this.type, (String)otherSpecialReview.type);
            this.approvalStatusChanged = !StringUtils.equals((String)this.approvalStatus, (String)otherSpecialReview.approvalStatus);
            this.protocolNumberChanged = !StringUtils.equals((String)this.protocolNumber, (String)otherSpecialReview.protocolNumber);
            this.applicationDateChanged = !StringUtils.equals((String)this.applicationDate, (String)otherSpecialReview.applicationDate);
            this.approvalDateChanged = !StringUtils.equals((String)this.approvalDate, (String)otherSpecialReview.approvalDate);
            this.expirationDateChanged = !StringUtils.equals((String)this.expirationDate, (String)otherSpecialReview.expirationDate);
            this.exemptionNumbersChanged = !StringUtils.equals((String)this.exemptionNumbers, (String)otherSpecialReview.exemptionNumbers);
            this.commentChanged = !StringUtils.equals((String)this.comment, (String)otherSpecialReview.comment);
        }
    }
}

