/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireAuthorizationService;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.lookup.HtmlData;
import org.kuali.rice.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.service.DocumentService;

public class QuestionnaireLookupableHelperServiceImpl
extends KualiLookupableHelperServiceImpl {
    private static final long serialVersionUID = 1800678175555048310L;
    private static final String VIEW = "view";
    private static final String DOCHANDLER_LINK = "%s/DocHandler.do?command=displayDocSearchView&docId=%s";
    private static final String MAINTENANCE = "maintenance";
    private static final String NEW_MAINTENANCE = "../maintenanceQn";
    private static final String DOC_ROUTE_STATUS = "docRouteStatus";
    private static final String QUESTIONNAIRE_ID = "questionnaireId";
    private DocumentService documentService;
    private QuestionnaireAuthorizationService questionnaireAuthorizationService;
    private List<MaintenanceDocumentBase> questionnaireMaintenanceDocs;
    private List<MaintenanceDocumentBase> newQuestionnaireDocs;
    private List<String> questionnaireIds;
    private String isActive;

    public List<? extends BusinessObject> getSearchResults(Map<String, String> fieldValues) {
        this.isActive = fieldValues.get("isFinal");
        this.getQuestionnaireDocs();
        List searchResults = super.getSearchResults(fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)searchResults)) {
            Collections.sort(searchResults);
            Collections.reverse(searchResults);
        }
        return this.getCurrentVersionQuestionnaires(searchResults);
    }

    private List<? extends BusinessObject> getCurrentVersionQuestionnaires(List<? extends BusinessObject> searchResults) {
        ArrayList<Questionnaire> questionnaires = new ArrayList<Questionnaire>();
        int qId = 0;
        for (BusinessObject businessObject : searchResults) {
            if (qId == ((Questionnaire)businessObject).getQuestionnaireIdAsInteger()) continue;
            qId = ((Questionnaire)businessObject).getQuestionnaireIdAsInteger();
            if (!this.isCurrent((Questionnaire)businessObject)) continue;
            questionnaires.add((Questionnaire)businessObject);
        }
        for (MaintenanceDocumentBase maintenanceDocumentBase : this.newQuestionnaireDocs) {
            Questionnaire questionnaire = (Questionnaire)maintenanceDocumentBase.getNewMaintainableObject().getDataObject();
            questionnaires.add(questionnaire);
        }
        return questionnaires;
    }

    private boolean isCurrent(Questionnaire questionnaire) {
        Questionnaire currentQnaire = this.getQuestionnaireById(questionnaire.getQuestionnaireId());
        return questionnaire.getQuestionnaireRefId().equals(currentQnaire.getQuestionnaireRefId());
    }

    protected Questionnaire getQuestionnaireById(String questionnaireId) {
        Questionnaire questionnaire = null;
        if (questionnaireId != null) {
            HashMap<String, String> fieldValues = new HashMap<String, String>();
            fieldValues.put(QUESTIONNAIRE_ID, questionnaireId);
            Collection questionnaires = this.getBusinessObjectService().findMatching(Questionnaire.class, fieldValues);
            if (questionnaires.size() > 0) {
                questionnaire = (Questionnaire)Collections.max(questionnaires);
            }
        }
        return questionnaire;
    }

    public List<HtmlData> getCustomActionUrls(BusinessObject businessObject, List pkNames) {
        boolean hasViewPermission;
        ArrayList<HtmlData> htmlDataList = new ArrayList<HtmlData>();
        Questionnaire questionnaire = (Questionnaire)businessObject;
        boolean hasModifyPermission = this.questionnaireAuthorizationService.hasPermission("Modify Questionnaire");
        boolean bl = hasViewPermission = hasModifyPermission || this.questionnaireAuthorizationService.hasPermission("View Questionnaire");
        if (hasModifyPermission && questionnaire.getQuestionnaireId() != null && (CollectionUtils.isEmpty((Collection)this.questionnaireIds) || !this.questionnaireIds.contains(questionnaire.getQuestionnaireId()))) {
            htmlDataList.add((HtmlData)this.getHtmlData(businessObject, "edit", pkNames));
        }
        if (hasModifyPermission && (questionnaire.getQuestionnaireId() == null || !CollectionUtils.isEmpty((Collection)this.questionnaireIds) && this.questionnaireIds.contains(questionnaire.getQuestionnaireId()))) {
            HtmlData.AnchorHtmlData htmlData = this.getHtmlData(businessObject, "edit", pkNames);
            String workflowUrl = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
            htmlData.setHref(String.format(DOCHANDLER_LINK, workflowUrl, this.getDocumentNumber(questionnaire)));
            htmlData.setDisplayText("resume edit");
            htmlDataList.add((HtmlData)htmlData);
        }
        if (hasViewPermission && questionnaire.getQuestionnaireId() != null) {
            htmlDataList.add((HtmlData)this.getViewLink(businessObject, pkNames));
        }
        if (hasModifyPermission && questionnaire.getQuestionnaireId() != null) {
            htmlDataList.add((HtmlData)this.getHtmlData(businessObject, "copy", pkNames));
            htmlDataList.add((HtmlData)this.getHtmlData(businessObject, "delete", pkNames));
        }
        return htmlDataList;
    }

    private String getDocumentNumber(Questionnaire questionnaire) {
        String docNumber = null;
        if (questionnaire.getQuestionnaireId() == null) {
            docNumber = questionnaire.getDocumentNumber();
        } else {
            for (MaintenanceDocumentBase doc : this.questionnaireMaintenanceDocs) {
                if (!((Questionnaire)doc.getNewMaintainableObject().getDataObject()).getQuestionnaireId().equals(questionnaire.getQuestionnaireId())) continue;
                docNumber = doc.getDocumentNumber();
            }
        }
        return docNumber;
    }

    protected HtmlData.AnchorHtmlData getViewLink(BusinessObject businessObject, List pkNames) {
        HtmlData.AnchorHtmlData htmlData = new HtmlData.AnchorHtmlData();
        Questionnaire questionnaire = (Questionnaire)businessObject;
        if (StringUtils.isNotBlank((String)questionnaire.getDocumentNumber())) {
            String workflowUrl = this.getKualiConfigurationService().getPropertyValueAsString("workflow.url");
            htmlData.setHref(String.format(DOCHANDLER_LINK, workflowUrl, questionnaire.getDocumentNumber()).replace("&docId", "&readOnly=true&docId"));
        } else {
            htmlData = this.getUrlData(businessObject, "edit", pkNames);
            htmlData.setHref(htmlData.getHref().replace(MAINTENANCE, NEW_MAINTENANCE) + "&readOnly=true");
        }
        htmlData.setDisplayText(VIEW);
        return htmlData;
    }

    protected HtmlData.AnchorHtmlData getHtmlData(BusinessObject businessObject, String methodToCall, List pkNames) {
        HtmlData.AnchorHtmlData htmlData = this.getUrlData(businessObject, methodToCall, pkNames);
        htmlData.setHref(htmlData.getHref().replace(MAINTENANCE, NEW_MAINTENANCE));
        return htmlData;
    }

    protected void getQuestionnaireDocs() {
        this.questionnaireMaintenanceDocs = new ArrayList();
        this.newQuestionnaireDocs = new ArrayList();
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        this.questionnaireIds = new ArrayList();
        fieldValues.put("name", this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(Questionnaire.class));
        ArrayList<String> docTypeIds = new ArrayList<String>();
        for (DocumentType docType : (List)this.getBusinessObjectService().findMatching(DocumentType.class, fieldValues)) {
            docTypeIds.add(docType.getDocumentTypeId());
        }
        fieldValues.clear();
        fieldValues.put("documentTypeId", docTypeIds);
        fieldValues.put(DOC_ROUTE_STATUS, "S");
        List docHeaders = (List)this.getBusinessObjectService().findMatching(DocumentRouteHeaderValue.class, fieldValues);
        try {
            for (DocumentRouteHeaderValue docHeader : docHeaders) {
                MaintenanceDocumentBase doc = (MaintenanceDocumentBase)this.documentService.getByDocumentHeaderId(docHeader.getDocumentId().toString());
                if (doc.getNewMaintainableObject().getMaintenanceAction().equals("Edit")) {
                    this.questionnaireIds.add(((Questionnaire)doc.getNewMaintainableObject().getDataObject()).getQuestionnaireId());
                    this.questionnaireMaintenanceDocs.add(doc);
                    continue;
                }
                if (!doc.getNewMaintainableObject().getMaintenanceAction().equals("New")) continue;
                Questionnaire questionnaire = (Questionnaire)doc.getNewMaintainableObject().getDataObject();
                if (!StringUtils.isBlank((String)this.isActive) && (!"N".equals(this.isActive) || questionnaire.isActive()) && (!"Y".equals(this.isActive) || !questionnaire.isActive())) continue;
                this.newQuestionnaireDocs.add(doc);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setQuestionnaireAuthorizationService(QuestionnaireAuthorizationService questionnaireAuthorizationService) {
        this.questionnaireAuthorizationService = questionnaireAuthorizationService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

