/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.QuestionnaireAuthorizationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuestionnaireMaintenanceDocumentAuthorizer
extends MaintenanceDocumentAuthorizerBase {
    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActions) {
        super.getDocumentActions(document, user, documentActions);
        return this.getDocumentActions(document);
    }

    protected Set<String> getDocumentActions(Document document) {
        boolean hasViewPermission;
        Set documentActions = new HashSet();
        boolean hasModifyPermission = this.getQuestionnaireAuthorizationService().hasPermission("Modify Questionnaire");
        boolean bl = hasViewPermission = hasModifyPermission || this.getQuestionnaireAuthorizationService().hasPermission("View Questionnaire");
        if (hasModifyPermission) {
            documentActions = this.getDocumentActionsWithModifyPermission(document);
        } else if (hasViewPermission) {
            documentActions = this.getDocumentActionsWithViewPermission(document);
        } else {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Edit/View", "Questionnaire");
        }
        return documentActions;
    }

    private QuestionnaireAuthorizationService getQuestionnaireAuthorizationService() {
        return (QuestionnaireAuthorizationService)KraServiceLocator.getService(QuestionnaireAuthorizationService.class);
    }

    private Set<String> getDocumentActionsWithModifyPermission(Document document) {
        HashSet<String> documentActions = new HashSet<String>();
        if (document.getDocumentHeader().getWorkflowDocument().getStatus().getCode().equals("I") || document.getDocumentHeader().getWorkflowDocument().getStatus().getCode().equals("S")) {
            documentActions.add("canEdit");
            documentActions.add("canEditDocumentOverview");
            documentActions.add("canSave");
            documentActions.add("canClose");
            documentActions.add("canCancel");
            documentActions.add("canBlanketApprove");
            documentActions.add("canRoute");
        } else {
            documentActions.add("canReload");
            documentActions.add("canClose");
        }
        return documentActions;
    }

    private Set<String> getDocumentActionsWithViewPermission(Document document) {
        HashSet<String> documentActions = new HashSet<String>();
        String maintAction = ((MaintenanceDocumentBase)document).getNewMaintainableObject().getMaintenanceAction();
        if (document.getDocumentHeader().getWorkflowDocument().getStatus().getCode().equals("I")) {
            if (maintAction.equals("Copy")) {
                throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Copy", "Questionnaire");
            }
            if (maintAction.equals("New")) {
                throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalName(), "Create", "Questionnaire");
            }
            documentActions.add("canReload");
            documentActions.add("canClose");
        } else {
            documentActions.add("canReload");
            documentActions.add("canClose");
        }
        return documentActions;
    }
}

