/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.answer;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.coi.questionnaire.DisclosureModuleQuestionnaireBean;
import org.kuali.kra.iacuc.questionnaire.IacucProtocolModuleQuestionnaireBean;
import org.kuali.kra.irb.ProtocolFinderDao;
import org.kuali.kra.irb.questionnaire.ProtocolModuleQuestionnaireBean;
import org.kuali.kra.krms.KrmsRulesContext;
import org.kuali.kra.krms.service.KrmsRulesExecutionService;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalDevelopmentModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalDevelopmentS2sModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonModuleQuestionnaireBean;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.QuestionnaireService;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerComparator;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerServiceImpl;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.ObjectUtils;

public class QuestionnaireAnswerServiceImpl
implements QuestionnaireAnswerService {
    private static final String MODULE_ITEM_CODE = "moduleItemCode";
    private static final String MODULE_SUB_ITEM_CODE = "moduleSubItemCode";
    private static final String MODULE_ITEM_KEY = "moduleItemKey";
    private static final String MODULE_SUB_ITEM_KEY = "moduleSubItemKey";
    private static final String QUESTIONNAIRE_AGENDA_NAME = "QUESTIONNAIRE_AGENDA_NAME";
    private BusinessObjectService businessObjectService;
    private ProtocolFinderDao protocolFinderDao;
    private ParameterService parameterService;
    private QuestionnaireService questionnaireService;
    private KrmsRulesExecutionService krmsRulesExecutionService;

    public List<QuestionnaireUsage> getPublishedQuestionnaire(ModuleQuestionnaireBean moduleQuestionnaireBean) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_ITEM_CODE, moduleQuestionnaireBean.getModuleItemCode());
        fieldValues.put(MODULE_SUB_ITEM_CODE, moduleQuestionnaireBean.getModuleSubItemCode());
        ArrayList<QuestionnaireUsage> usages = new ArrayList<QuestionnaireUsage>();
        ArrayList<String> questionnaireIds = new ArrayList<String>();
        List questionnaireUsages = (List)this.businessObjectService.findMatching(QuestionnaireUsage.class, fieldValues);
        if (CollectionUtils.isNotEmpty((Collection)questionnaireUsages)) {
            Collections.sort(questionnaireUsages);
        }
        ArrayList<String> ruleIds = new ArrayList<String>();
        for (QuestionnaireUsage questionnaireUsage : questionnaireUsages) {
            if (!StringUtils.isNotBlank((String)questionnaireUsage.getRuleId())) continue;
            ruleIds.add(questionnaireUsage.getRuleId());
        }
        Map ruleResults = new HashMap();
        if (!ruleIds.isEmpty()) {
            ruleResults = this.runApplicableRules(ruleIds, moduleQuestionnaireBean);
        }
        for (QuestionnaireUsage questionnaireUsage : questionnaireUsages) {
            if (questionnaireIds.contains(questionnaireUsage.getQuestionnaire().getQuestionnaireId())) continue;
            questionnaireIds.add(questionnaireUsage.getQuestionnaire().getQuestionnaireId());
            if (!moduleQuestionnaireBean.isFinalDoc() && (!this.getQuestionnaireService().isCurrentQuestionnaire(questionnaireUsage.getQuestionnaire()) || !questionnaireUsage.getQuestionnaire().isActive())) continue;
            if (StringUtils.isNotBlank((String)questionnaireUsage.getRuleId())) {
                if (!ruleResults.containsKey(questionnaireUsage.getRuleId()) || !((Boolean)ruleResults.get(questionnaireUsage.getRuleId())).booleanValue()) continue;
                usages.add(questionnaireUsage);
                continue;
            }
            usages.add(questionnaireUsage);
        }
        return usages;
    }

    protected List<AnswerHeader> initAnswerHeaders(ModuleQuestionnaireBean moduleQuestionnaireBean, Map<String, AnswerHeader> answerHeaderMap) {
        ArrayList<AnswerHeader> answerHeaders = new ArrayList<AnswerHeader>();
        for (QuestionnaireUsage questionnaireUsage : this.getPublishedQuestionnaire(moduleQuestionnaireBean)) {
            String questionnaireId = questionnaireUsage.getQuestionnaire().getQuestionnaireId();
            if (answerHeaderMap.containsKey(questionnaireId)) {
                answerHeaders.add(answerHeaderMap.get(questionnaireId));
                if (questionnaireUsage.getQuestionnaire().getQuestionnaireRefId().equals(answerHeaderMap.get(questionnaireId).getQuestionnaireRefIdFk())) continue;
                if (questionnaireUsage.getQuestionnaire().isActive()) {
                    answerHeaderMap.get(questionnaireId).setNewerVersionPublished(true);
                    answerHeaderMap.get(questionnaireId).setActiveQuestionnaire(true);
                    continue;
                }
                answerHeaderMap.get(questionnaireId).setActiveQuestionnaire(false);
                continue;
            }
            if (moduleQuestionnaireBean.isFinalDoc() || !this.getQuestionnaireService().isCurrentQuestionnaire(questionnaireUsage.getQuestionnaire()) || !questionnaireUsage.getQuestionnaire().isActive()) continue;
            answerHeaders.add(this.setupAnswerForQuestionnaire(questionnaireUsage.getQuestionnaire(), moduleQuestionnaireBean));
        }
        return answerHeaders;
    }

    public AnswerHeader getNewVersionAnswerHeader(ModuleQuestionnaireBean moduleQuestionnaireBean, Questionnaire questionnaire) {
        AnswerHeader answerHeader = new AnswerHeader();
        List usages = this.getPublishedQuestionnaire(moduleQuestionnaireBean);
        for (QuestionnaireUsage questionnaireUsage : usages) {
            if (!questionnaireUsage.getQuestionnaire().getQuestionnaireId().equals(questionnaire.getQuestionnaireId()) || questionnaireUsage.getQuestionnaire().getSequenceNumber() <= questionnaire.getSequenceNumber()) continue;
            answerHeader = this.setupAnswerForQuestionnaire(questionnaireUsage.getQuestionnaire(), moduleQuestionnaireBean);
        }
        return answerHeader;
    }

    public List<AnswerHeader> versioningQuestionnaireAnswer(ModuleQuestionnaireBean moduleQuestionnaireBean, Integer newSequenceNumber) {
        ArrayList<AnswerHeader> newAnswerHeaders = new ArrayList<AnswerHeader>();
        List questionnaireIds = this.getAssociateedQuestionnaireIds(moduleQuestionnaireBean);
        for (AnswerHeader answerHeader : this.retrieveAnswerHeaders(moduleQuestionnaireBean)) {
            if (!questionnaireIds.contains(answerHeader.getQuestionnaire().getQuestionnaireId())) continue;
            AnswerHeader copiedAnswerHeader = (AnswerHeader)ObjectUtils.deepCopy((Serializable)answerHeader);
            copiedAnswerHeader.setModuleSubItemKey(newSequenceNumber.toString());
            copiedAnswerHeader.setAnswerHeaderId(null);
            for (Answer answer : copiedAnswerHeader.getAnswers()) {
                answer.setId(null);
            }
            newAnswerHeaders.add(copiedAnswerHeader);
        }
        return newAnswerHeaders;
    }

    protected List<AnswerHeader> copyAnswerHeadersToNewModuleQB(ModuleQuestionnaireBean srcModuleQuestionnaireBean, ModuleQuestionnaireBean destModuleQuestionnaireBean) {
        ArrayList<AnswerHeader> newAnswerHeaders = new ArrayList<AnswerHeader>();
        List questionnaireIds = this.getAssociateedQuestionnaireIds(destModuleQuestionnaireBean);
        for (AnswerHeader answerHeader : this.retrieveAnswerHeaders(srcModuleQuestionnaireBean)) {
            if (!questionnaireIds.contains(answerHeader.getQuestionnaire().getQuestionnaireId())) continue;
            AnswerHeader copiedAnswerHeader = (AnswerHeader)ObjectUtils.deepCopy((Serializable)answerHeader);
            copiedAnswerHeader.setNewModuleQuestionnaireBeanReferenceData(destModuleQuestionnaireBean);
            copiedAnswerHeader.setAnswerHeaderId(null);
            for (Answer answer : copiedAnswerHeader.getAnswers()) {
                answer.setId(null);
            }
            newAnswerHeaders.add(copiedAnswerHeader);
        }
        return newAnswerHeaders;
    }

    public List<AnswerHeader> getQuestionnaireAnswer(ModuleQuestionnaireBean moduleQuestionnaireBean) {
        HashMap<String, AnswerHeader> answerHeaderMap = new HashMap<String, AnswerHeader>();
        List answers = this.retrieveAnswerHeaders(moduleQuestionnaireBean);
        if (GlobalVariables.getUserSession() != null) {
            GlobalVariables.getUserSession().removeObject(moduleQuestionnaireBean.getSessionContextKey() + "-rulereferenced");
        }
        for (AnswerHeader answerHeader : answers) {
            if (answerHeaderMap.containsKey(answerHeader.getQuestionnaire().getQuestionnaireId()) && ((AnswerHeader)answerHeaderMap.get(answerHeader.getQuestionnaire().getQuestionnaireId())).getQuestionnaire().getSequenceNumber() >= answerHeader.getQuestionnaire().getSequenceNumber()) continue;
            this.setupChildAnswerIndicator(answerHeader);
            answerHeaderMap.put(answerHeader.getQuestionnaire().getQuestionnaireId(), answerHeader);
        }
        List answerHeaders = this.initAnswerHeaders(moduleQuestionnaireBean, answerHeaderMap);
        for (AnswerHeader answerHeader : answerHeaders) {
            Collections.sort(answerHeader.getAnswers(), new AnswerComparator());
            answerHeader.setCompleted(this.isQuestionnaireAnswerComplete(answerHeader.getAnswers()));
            answerHeader.setHasVisibleQuestion(this.hasVisibleQuestion(answerHeader.getAnswers()));
        }
        return answerHeaders;
    }

    protected List<AnswerHeader> retrieveAnswerHeaders(ModuleQuestionnaireBean moduleQuestionnaireBean) {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_ITEM_CODE, moduleQuestionnaireBean.getModuleItemCode());
        fieldValues.put(MODULE_SUB_ITEM_CODE, moduleQuestionnaireBean.getModuleSubItemCode());
        fieldValues.put(MODULE_ITEM_KEY, moduleQuestionnaireBean.getModuleItemKey());
        fieldValues.put(MODULE_SUB_ITEM_KEY, moduleQuestionnaireBean.getModuleSubItemKey());
        return (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
    }

    protected List<String> getAssociateedQuestionnaireIds(ModuleQuestionnaireBean moduleQuestionnaireBean) {
        ArrayList<String> questionnaireIds = new ArrayList<String>();
        for (QuestionnaireUsage questionnaireUsage : this.getPublishedQuestionnaire(moduleQuestionnaireBean)) {
            questionnaireIds.add(questionnaireUsage.getQuestionnaire().getQuestionnaireId());
        }
        return questionnaireIds;
    }

    protected Questionnaire getLatestQuestionnaireVersion(Integer questionnaireId) {
        Questionnaire latestQnnrInstance = null;
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("questionnaireId", questionnaireId.toString());
        List questionnaires = (List)this.businessObjectService.findMatchingOrderBy(Questionnaire.class, fieldValues, "sequenceNumber", false);
        if (!questionnaires.isEmpty()) {
            latestQnnrInstance = (Questionnaire)questionnaires.get(0);
        }
        return latestQnnrInstance;
    }

    public boolean checkIfQuestionnaireIsActiveForModule(Integer questionnaireId, String moduleItemCode, String moduleSubItemCode) {
        boolean isActive = false;
        Questionnaire latestQnnrInstance = this.getLatestQuestionnaireVersion(questionnaireId);
        if (null != latestQnnrInstance && latestQnnrInstance.isActive()) {
            isActive = latestQnnrInstance.hasUsageFor(moduleItemCode, moduleSubItemCode);
        }
        return isActive;
    }

    public void copyAnswerToNewVersion(AnswerHeader oldAnswerHeader, AnswerHeader newAnswerHeader) {
        List oldParentAnswers = this.setupParentAnswers(oldAnswerHeader.getAnswers());
        List newParentAnswers = this.setupParentAnswers(newAnswerHeader.getAnswers());
        block0: for (Answer oldAnswer : oldAnswerHeader.getAnswers()) {
            if (!StringUtils.isNotBlank((String)oldAnswer.getAnswer())) continue;
            for (Answer newAnswer : newAnswerHeader.getAnswers()) {
                if (!oldAnswer.getQuestion().getQuestionId().equals(newAnswer.getQuestion().getQuestionId()) || !oldAnswer.getQuestion().getQuestionRefId().equals(newAnswer.getQuestion().getQuestionRefId()) || !oldAnswer.getAnswerNumber().equals(newAnswer.getAnswerNumber()) || (oldAnswer.getQuestionnaireQuestion().getParentQuestionNumber() != 0 || newAnswer.getQuestionnaireQuestion().getParentQuestionNumber() != 0) && (oldAnswer.getQuestionnaireQuestion().getParentQuestionNumber() <= 0 || newAnswer.getQuestionnaireQuestion().getParentQuestionNumber() <= 0 || !"Y".equals(((Answer)((List)newParentAnswers.get(newAnswer.getQuestionnaireQuestion().getParentQuestionNumber())).get(0)).getMatchedChild()) || !this.isSameLevel(oldAnswer, oldParentAnswers, newAnswer, newParentAnswers))) continue;
                newAnswer.setAnswer(oldAnswer.getAnswer());
                newAnswer.setMatchedChild("Y");
                continue block0;
            }
        }
        this.setupChildAnswerIndicator(newAnswerHeader);
        for (Answer answer : newAnswerHeader.getAnswers()) {
            if (!StringUtils.isNotBlank((String)answer.getAnswer()) || !"N".equals(answer.getMatchedChild())) continue;
            answer.setAnswer("");
        }
        newAnswerHeader.setCompleted(this.isQuestionnaireAnswerComplete(newAnswerHeader.getAnswers()));
    }

    public List<AnswerHeader> copyAnswerHeaders(ModuleQuestionnaireBean srcModuleQuestionnaireBean, ModuleQuestionnaireBean destModuleQuestionnaireBean) {
        List answerHeaders = this.copyAnswerHeadersToNewModuleQB(srcModuleQuestionnaireBean, destModuleQuestionnaireBean);
        for (AnswerHeader header : answerHeaders) {
            this.businessObjectService.save((PersistableBusinessObject)header);
        }
        return answerHeaders;
    }

    public void preSave(List<AnswerHeader> answerHeaders) {
        for (AnswerHeader answerHeader : answerHeaders) {
            int i = 0;
            for (Answer answer : answerHeader.getAnswers()) {
                if (answer.getQuestion().getMaxAnswers() != null && answer.getQuestion().getMaxAnswers() > 1 && answer.getAnswerNumber() == 1) {
                    this.moveAnswer(answerHeader.getAnswers(), i);
                }
                ++i;
            }
            answerHeader.setCompleted(this.isQuestionnaireAnswerComplete(answerHeader.getAnswers()));
        }
    }

    protected void moveAnswer(List<Answer> answers, int index) {
        block0: for (int i = 0; i < answers.get(index).getQuestion().getMaxAnswers() - 1; ++i) {
            if (!StringUtils.isBlank((String)answers.get(index + i).getAnswer())) continue;
            for (int j = i + 1; j < answers.get(index).getQuestion().getMaxAnswers(); ++j) {
                if (!StringUtils.isNotBlank((String)answers.get(index + j).getAnswer())) continue;
                answers.get(index + i).setAnswer(answers.get(index + j).getAnswer());
                answers.get(index + j).setAnswer("");
                continue block0;
            }
        }
    }

    protected boolean isSameLevel(Answer oldAnswer, List<List<Answer>> oldParentAnswers, Answer newAnswer, List<List<Answer>> newParentAnswers) {
        boolean questionHierarchyMatched = true;
        Answer oAnswer = oldAnswer;
        Answer nAnswer = newAnswer;
        while (questionHierarchyMatched && oAnswer.getQuestionnaireQuestion().getParentQuestionNumber() > 0 && nAnswer.getQuestionnaireQuestion().getParentQuestionNumber() > 0) {
            if (!oAnswer.getQuestionRefIdFk().equals(nAnswer.getQuestionRefIdFk())) {
                questionHierarchyMatched = false;
            }
            oAnswer = oldParentAnswers.get(oAnswer.getQuestionnaireQuestion().getParentQuestionNumber()).get(0);
            nAnswer = newParentAnswers.get(nAnswer.getQuestionnaireQuestion().getParentQuestionNumber()).get(0);
        }
        return questionHierarchyMatched && oAnswer.getQuestionnaireQuestion().getParentQuestionNumber() == 0 && nAnswer.getQuestionnaireQuestion().getParentQuestionNumber() == 0;
    }

    protected List<List<Answer>> setupParentAnswers(List<Answer> answers) {
        List parentAnswers = this.initParentAnswers(answers);
        for (Answer answer : answers) {
            ((List)parentAnswers.get(answer.getQuestionNumber())).add(answer);
        }
        return parentAnswers;
    }

    protected List<List<Answer>> initParentAnswers(List<Answer> answers) {
        int maxQuestionNumber = 0;
        ArrayList<List<Answer>> parentAnswers = new ArrayList<List<Answer>>();
        for (Answer answer : answers) {
            if (answer.getQuestionNumber() <= maxQuestionNumber) continue;
            while (maxQuestionNumber < answer.getQuestionNumber()) {
                parentAnswers.add(new ArrayList());
                ++maxQuestionNumber;
            }
        }
        parentAnswers.add(new ArrayList());
        return parentAnswers;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    protected AnswerHeader setupAnswerForQuestionnaire(Questionnaire questionnaire, ModuleQuestionnaireBean moduleQuestionnaireBean) {
        AnswerHeader answerHeader = new AnswerHeader(moduleQuestionnaireBean, questionnaire.getQuestionnaireRefIdAsLong());
        answerHeader.setQuestionnaire(questionnaire);
        ArrayList answers = new ArrayList();
        for (QuestionnaireQuestion question : questionnaire.getQuestionnaireQuestions()) {
            if (question.getParentQuestionNumber() != 0) continue;
            answers.addAll(this.setupAnswersForQuestion(question));
            answers.addAll(this.getChildQuestions(questionnaire, question));
        }
        for (Answer answer : answers) {
            answer.setAnswerHeader(answerHeader);
        }
        answerHeader.setAnswers(answers);
        this.setupChildAnswerIndicator(answerHeader);
        return answerHeader;
    }

    protected List<Answer> getChildQuestions(Questionnaire questionnaire, QuestionnaireQuestion question) {
        ArrayList<Answer> answers = new ArrayList<Answer>();
        for (QuestionnaireQuestion questionnaireQuestion : questionnaire.getQuestionnaireQuestions()) {
            if (questionnaireQuestion.getParentQuestionNumber() == 0 || !questionnaireQuestion.getParentQuestionNumber().equals(question.getQuestionNumber())) continue;
            answers.addAll(this.setupAnswersForQuestion(questionnaireQuestion));
            answers.addAll(this.getChildQuestions(questionnaire, questionnaireQuestion));
        }
        return answers;
    }

    protected List<Answer> setupAnswersForQuestion(QuestionnaireQuestion questionnaireQuestion) {
        ArrayList<Answer> answers = new ArrayList<Answer>();
        int maxAnswers = 1;
        if (questionnaireQuestion.getQuestion().getMaxAnswers() != null) {
            maxAnswers = questionnaireQuestion.getQuestion().getMaxAnswers();
        }
        for (int i = 0; i < maxAnswers; ++i) {
            Answer answer = new Answer();
            answer.setQuestion(questionnaireQuestion.getQuestion());
            answer.setQuestionNumber(questionnaireQuestion.getQuestionNumber());
            answer.setQuestionRefIdFk(questionnaireQuestion.getQuestion().getQuestionRefId());
            answer.setQuestionnaireQuestionsIdFk(questionnaireQuestion.getQuestionnaireQuestionsId());
            answer.setQuestionnaireQuestion(questionnaireQuestion);
            answer.setAnswerNumber(Integer.valueOf(i + 1));
            answers.add(answer);
        }
        return answers;
    }

    public void setupChildAnswerIndicator(AnswerHeader answerHeader) {
        List answers = answerHeader.getAnswers();
        List parentAnswers = this.setupParentAnswers(answers);
        ArrayList<String> ruleIds = new ArrayList<String>();
        for (Answer answer : answers) {
            if (answer.getQuestionnaireQuestion().getParentQuestionNumber() > 0) {
                answer.setParentAnswer((List)parentAnswers.get(answer.getQuestionnaireQuestion().getParentQuestionNumber()));
            }
            if (StringUtils.isNotBlank((String)answer.getQuestionnaireQuestion().getRuleId())) {
                ruleIds.add(answer.getQuestionnaireQuestion().getRuleId());
            }
            if (!ConditionType.RULE_EVALUATION.getCondition().equals(answer.getQuestionnaireQuestion().getCondition())) continue;
            ruleIds.add(answer.getQuestionnaireQuestion().getConditionValue());
        }
        Collections.sort(answers, new AnswerComparator());
        Map ruleResults = new HashMap();
        if (!ruleIds.isEmpty()) {
            ruleResults = this.runApplicableRules(ruleIds, this.getModuleSpecificBean(answerHeader));
        }
        for (Answer answer : answers) {
            String ruleId;
            QuestionnaireQuestion questionnaireQuestion = answer.getQuestionnaireQuestion();
            if (questionnaireQuestion.getParentQuestionNumber() == 0) {
                ruleId = questionnaireQuestion.getRuleId();
                if (StringUtils.isNotBlank((String)ruleId)) {
                    if (ruleResults.containsKey(ruleId) && ((Boolean)ruleResults.get(ruleId)).booleanValue()) {
                        answer.setMatchedChild("Y");
                        answer.setRuleMatched(true);
                        continue;
                    }
                    answer.setMatchedChild("N");
                    answer.setRuleMatched(false);
                    continue;
                }
                answer.setMatchedChild("Y");
                continue;
            }
            answer.setParentAnswer((List)parentAnswers.get(questionnaireQuestion.getParentQuestionNumber()));
            if (StringUtils.isBlank((String)questionnaireQuestion.getCondition())) {
                if (this.isParentNotDisplayed((List)parentAnswers.get(questionnaireQuestion.getParentQuestionNumber()))) {
                    answer.setMatchedChild("N");
                    continue;
                }
                answer.setMatchedChild("Y");
                continue;
            }
            if (this.isParentNotDisplayed((List)parentAnswers.get(questionnaireQuestion.getParentQuestionNumber()))) {
                answer.setMatchedChild("N");
                if (!ConditionType.RULE_EVALUATION.getCondition().equals(questionnaireQuestion.getCondition())) continue;
                ruleId = questionnaireQuestion.getConditionValue();
                if (ruleResults.containsKey(ruleId) && ((Boolean)ruleResults.get(ruleId)).booleanValue()) {
                    answer.setRuleMatched(true);
                    continue;
                }
                answer.setRuleMatched(false);
                continue;
            }
            if (ConditionType.RULE_EVALUATION.getCondition().equals(questionnaireQuestion.getCondition()) && ruleResults.containsKey(questionnaireQuestion.getConditionValue()) && ((Boolean)ruleResults.get(questionnaireQuestion.getConditionValue())).booleanValue() || this.isAnyAnswerMatched(questionnaireQuestion.getCondition(), (List)parentAnswers.get(questionnaireQuestion.getParentQuestionNumber()), questionnaireQuestion.getConditionValue())) {
                answer.setMatchedChild("Y");
                continue;
            }
            answer.setMatchedChild("N");
        }
    }

    public boolean isQuestionnaireAnswerComplete(List<Answer> answers) {
        boolean isComplete = true;
        for (Answer answer : answers) {
            if (!"Y".equals(answer.getMatchedChild()) || !StringUtils.isBlank((String)answer.getAnswer()) || answer.getAnswerNumber() != 1) continue;
            isComplete = false;
            break;
        }
        return isComplete;
    }

    public boolean hasVisibleQuestion(List<Answer> answers) {
        boolean isVisible = false;
        for (Answer answer : answers) {
            if (!StringUtils.equals((String)"Y", (String)answer.getMatchedChild())) continue;
            isVisible = true;
            break;
        }
        return isVisible;
    }

    protected boolean isParentNotDisplayed(List<Answer> parentAnswers) {
        boolean valid = true;
        for (Answer answer : parentAnswers) {
            if ("N".equals(answer.getMatchedChild())) {
                valid = true;
                break;
            }
            if ("Y".equals(answer.getMatchedChild())) {
                valid = false;
                break;
            }
            if (valid = valid && StringUtils.isBlank((String)answer.getAnswer())) continue;
            break;
        }
        return valid;
    }

    protected boolean isAnyAnswerMatched(String condition, List<Answer> parentAnswers, String conditionValue) {
        boolean valid = false;
        for (Answer answer : parentAnswers) {
            if (StringUtils.isNotBlank((String)answer.getAnswer())) {
                valid = this.isAnswerMatched(condition, answer.getAnswer(), conditionValue);
            }
            if (!valid) continue;
            break;
        }
        return valid;
    }

    protected boolean isAnswerMatched(String condition, String parentAnswer, String conditionValue) {
        boolean valid = false;
        if (ConditionType.CONTAINS_TEXT.getCondition().equals(condition)) {
            valid = StringUtils.containsIgnoreCase((String)parentAnswer, (String)conditionValue);
        } else if (ConditionType.BEGINS_WITH_TEXT.getCondition().equals(condition)) {
            valid = StringUtils.startsWithIgnoreCase((String)parentAnswer, (String)conditionValue);
        } else if (ConditionType.ENDS_WITH_TEXT.getCondition().equals(condition)) {
            valid = StringUtils.endsWithIgnoreCase((String)parentAnswer, (String)conditionValue);
        } else if (ConditionType.MATCH_TEXT.getCondition().equals(condition)) {
            valid = parentAnswer.equalsIgnoreCase(conditionValue);
        } else if (Integer.parseInt(condition) >= 5 && Integer.parseInt(condition) <= 10) {
            valid = ConditionType.LESS_THAN_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) < Integer.parseInt(conditionValue) || ConditionType.LESS_THAN_OR_EQUALS_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) <= Integer.parseInt(conditionValue) || ConditionType.EQUALS_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) == Integer.parseInt(conditionValue) || ConditionType.NOT_EQUAL_TO_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) != Integer.parseInt(conditionValue) || ConditionType.GREATER_THAN_OR_EQUALS_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) >= Integer.parseInt(conditionValue) || ConditionType.GREATER_THAN_NUMBER.getCondition().equals(condition) && Integer.parseInt(parentAnswer) > Integer.parseInt(conditionValue);
        } else if (Integer.parseInt(condition) == 11 || Integer.parseInt(condition) == 12) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
            try {
                Date date1 = new Date(dateFormat.parse(parentAnswer).getTime());
                Date date2 = new Date(dateFormat.parse(conditionValue).getTime());
                valid = ConditionType.BEFORE_DATE.getCondition().equals(condition) && date1.before(date2) || ConditionType.AFTER_DATE.getCondition().equals(condition) && date1.after(date2);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return valid;
    }

    public void setProtocolFinderDao(ProtocolFinderDao protocolFinderDao) {
        this.protocolFinderDao = protocolFinderDao;
    }

    public List<AnswerHeader> getAnswerHeadersForProtocol(ModuleQuestionnaireBean moduleQuestionnaireBean, String protocolNumber) {
        boolean isAmendmentOrRenewal = protocolNumber.contains("A") || protocolNumber.contains("R");
        String originalProtocolNumber = protocolNumber;
        if (isAmendmentOrRenewal) {
            originalProtocolNumber = protocolNumber.substring(0, 10);
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put(MODULE_ITEM_CODE, moduleQuestionnaireBean.getModuleItemCode());
        fieldValues.put(MODULE_ITEM_KEY, protocolNumber);
        List answerHeaders = (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
        if (isAmendmentOrRenewal) {
            ArrayList<AnswerHeader> headers = new ArrayList<AnswerHeader>();
            for (AnswerHeader answerHeader : answerHeaders) {
                if ("2".equals(answerHeader.getModuleSubItemCode()) && answerHeader.getModuleItemKey().equals(originalProtocolNumber) || !answerHeader.getModuleItemKey().equals(protocolNumber)) continue;
                headers.add(answerHeader);
            }
            return headers;
        }
        return answerHeaders;
    }

    public List<AnswerHeader> getAnswerHeadersForProtocol(String protocolNumber) {
        boolean isAmendmentOrRenewal = protocolNumber.contains("A") || protocolNumber.contains("R");
        String originalProtocolNumber = protocolNumber;
        if (isAmendmentOrRenewal) {
            originalProtocolNumber = protocolNumber.substring(0, 10);
        }
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put(MODULE_ITEM_CODE, "7");
        fieldValues.put(MODULE_ITEM_KEY, this.getProtocolNumbers(originalProtocolNumber));
        List answerHeaders = (List)this.businessObjectService.findMatching(AnswerHeader.class, fieldValues);
        if (isAmendmentOrRenewal) {
            ArrayList<AnswerHeader> headers = new ArrayList<AnswerHeader>();
            for (AnswerHeader answerHeader : answerHeaders) {
                if ("2".equals(answerHeader.getModuleSubItemCode()) && answerHeader.getModuleItemKey().equals(originalProtocolNumber) || !answerHeader.getModuleItemKey().equals(protocolNumber)) continue;
                headers.add(answerHeader);
            }
            return headers;
        }
        return answerHeaders;
    }

    private List<String> getProtocolNumbers(String protocolNumber) {
        ArrayList<String> protocolNumbers = new ArrayList<String>();
        for (ProtocolBase protocol : this.protocolFinderDao.findProtocols(protocolNumber)) {
            if (protocolNumbers.contains(protocol.getProtocolNumber())) continue;
            protocolNumbers.add(protocol.getProtocolNumber());
        }
        return protocolNumbers;
    }

    private Map<String, Boolean> runApplicableRules(List<String> ruleIds, ModuleQuestionnaireBean moduleQuestionnaireBean) {
        KrmsRulesContext rulesContext = moduleQuestionnaireBean.getKrmsRulesContextFromBean();
        HashMap<String, Boolean> ruleResults = new HashMap<String, Boolean>();
        if (rulesContext != null) {
            ruleResults.putAll(this.getKrmsRulesExecutionService().runApplicableRules(ruleIds, rulesContext, "KC1004"));
        }
        GlobalVariables.getUserSession().addObject(moduleQuestionnaireBean.getSessionContextKey() + "-rulereferenced", ruleResults);
        return ruleResults;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ModuleQuestionnaireBean getModuleSpecificBean(AnswerHeader answerHeader) {
        return this.getModuleSpecificBean(answerHeader.getModuleItemCode(), answerHeader.getModuleItemKey(), answerHeader.getModuleSubItemCode(), answerHeader.getModuleSubItemKey(), true);
    }

    public ModuleQuestionnaireBean getModuleSpecificBean(String moduleItemCode, String moduleItemKey, String moduleSubItemCode, String moduleSubItemKey, boolean finalDoc) {
        if ("8".equals(moduleItemCode)) {
            return new DisclosureModuleQuestionnaireBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
        }
        if ("9".equals(moduleItemCode)) {
            return new IacucProtocolModuleQuestionnaireBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
        }
        if ("7".equals(moduleItemCode)) {
            return new ProtocolModuleQuestionnaireBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
        }
        if ("3".equals(moduleItemCode)) {
            if ("3".equals(moduleSubItemCode)) {
                return new ProposalPersonModuleQuestionnaireBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
            }
            if ("2".equals(moduleSubItemCode)) {
                return new ProposalDevelopmentS2sModuleQuestionnaireBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
            }
            return new ProposalDevelopmentModuleQuestionnaireBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, finalDoc);
        }
        throw new IllegalArgumentException("Unrecognized moduleItemCode");
    }

    protected QuestionnaireService getQuestionnaireService() {
        return this.questionnaireService;
    }

    public void setQuestionnaireService(QuestionnaireService questionnaireService) {
        this.questionnaireService = questionnaireService;
    }

    public List<AnswerHeader> getNewVersionOfQuestionnaireAnswer(ModuleQuestionnaireBean moduleQuestionnaireBean) {
        List newAnswerHeaders = this.getQuestionnaireAnswer(moduleQuestionnaireBean);
        for (AnswerHeader answerHeader : newAnswerHeaders) {
            answerHeader.setAnswerHeaderId(null);
            for (Answer answer : answerHeader.getAnswers()) {
                answer.setId(null);
            }
        }
        return newAnswerHeaders;
    }

    public KrmsRulesExecutionService getKrmsRulesExecutionService() {
        return this.krmsRulesExecutionService;
    }

    public void setKrmsRulesExecutionService(KrmsRulesExecutionService krmsRulesExecutionService) {
        this.krmsRulesExecutionService = krmsRulesExecutionService;
    }
}

