/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.answer;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.SaveQuestionnaireAnswerEvent;
import org.kuali.kra.rule.BusinessRuleInterface;
import org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.charlevel.UTF8AnyCharacterValidationPattern;
import org.kuali.rice.kns.datadictionary.validation.fieldlevel.DateValidationPattern;
import org.kuali.rice.krad.datadictionary.validation.ValidationPattern;
import org.kuali.rice.krad.util.GlobalVariables;

public class SaveQuestionnaireAnswerRule
implements BusinessRuleInterface<SaveQuestionnaireAnswerEvent> {
    private static final String QUESTION_TYPE_NUMBER = "3";
    private static final String QUESTION_TYPE_DATE = "4";
    private static final String QUESTION_TYPE_TEXT = "5";
    private static final String ANSWER = "Answer ";
    private static final Map<String, ValidationPattern> VALIDATION_CLASSES;

    public boolean processRules(SaveQuestionnaireAnswerEvent event) {
        boolean valid = true;
        int answerHeaderIndex = 0;
        for (AnswerHeader answerHeader : event.getAnswerHeaders()) {
            int questionIndex = 0;
            for (Answer answer : answerHeader.getAnswers()) {
                String errorKey = event.getFormProperty() + ".answerHeaders[" + answerHeaderIndex + "].answers[" + questionIndex + "].answer";
                if (StringUtils.isNotBlank((String)answer.getAnswer()) && VALIDATION_CLASSES.containsKey(answer.getQuestion().getQuestionTypeId().toString())) {
                    boolean validAttributeFormat = this.validateAttributeFormat(answer, errorKey, questionIndex);
                    if (!validAttributeFormat) {
                        answerHeader.setShowQuestions("Y");
                    }
                    valid &= validAttributeFormat;
                }
                ++questionIndex;
            }
            ++answerHeaderIndex;
        }
        return valid;
    }

    private boolean validateAttributeFormat(Answer answer, String errorKey, int questionIndex) {
        boolean valid = true;
        ValidationPattern validationPattern = (ValidationPattern)VALIDATION_CLASSES.get(answer.getQuestion().getQuestionTypeId().toString());
        Pattern validationExpression = validationPattern.getRegexPattern();
        String validFormat = this.getValidFormat(answer.getQuestion().getQuestionTypeId().toString());
        if (validFormat.equals("String - Any Character") || validFormat.equals("Number - [0-9]")) {
            if (!validationExpression.matcher(answer.getAnswer()).matches()) {
                GlobalVariables.getMessageMap().putError(errorKey, "error.invalidFormat.withFormat", new String[]{ANSWER + (questionIndex + 1), answer.getAnswer(), validFormat});
                valid = false;
            }
        } else if (validFormat.equals("Date - [xx/xx/xxxx]")) {
            try {
                DateFormat dateFormat = DateFormat.getDateInstance(3);
                dateFormat.setLenient(false);
                dateFormat.parse(answer.getAnswer());
            }
            catch (ParseException e) {
                GlobalVariables.getMessageMap().putError(errorKey, "error.invalidFormat", new String[]{ANSWER + (questionIndex + 1), answer.getAnswer(), validFormat});
                valid = false;
            }
        }
        return valid;
    }

    private String getValidFormat(String dataType) {
        String validFormat = "String - Any Character";
        if (dataType.equalsIgnoreCase(QUESTION_TYPE_NUMBER)) {
            validFormat = "Number - [0-9]";
        } else if (dataType.equalsIgnoreCase(QUESTION_TYPE_DATE)) {
            validFormat = "Date - [xx/xx/xxxx]";
        }
        return validFormat;
    }

    static {
        HashMap<String, Object> tempPatterns = new HashMap<String, Object>();
        UTF8AnyCharacterValidationPattern anyCharVal = new UTF8AnyCharacterValidationPattern();
        anyCharVal.setAllowWhitespace(true);
        tempPatterns.put(QUESTION_TYPE_TEXT, anyCharVal);
        tempPatterns.put(QUESTION_TYPE_DATE, new DateValidationPattern());
        tempPatterns.put(QUESTION_TYPE_NUMBER, new NumericValidationPattern());
        VALIDATION_CLASSES = Collections.unmodifiableMap(tempPatterns);
    }
}

