/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.print;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import noNamespace.AnswerHeaderType;
import noNamespace.AnswerInfoType;
import noNamespace.ModuleInfoType;
import noNamespace.ModuleUsageType;
import noNamespace.Person;
import noNamespace.ProposalInfoType;
import noNamespace.ProtocolInfoType;
import noNamespace.QuestionInfoType;
import noNamespace.QuestionnaireDocument;
import noNamespace.QuestionsType;
import noNamespace.UserOptions;
import noNamespace.UserOptionsInfoType;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlbeans.XmlObject;
import org.kuali.kra.bo.CoeusModule;
import org.kuali.kra.bo.CoeusSubModule;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.coi.CoiDisclosure;
import org.kuali.kra.iacuc.IacucProtocol;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.maintenance.KraMaintenanceDocument;
import org.kuali.kra.printing.PrintingException;
import org.kuali.kra.printing.xmlstream.XmlStream;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.QuestionnaireService;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.questionnaire.question.QuestionService;
import org.kuali.kra.service.KcPersonService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.routeheader.service.RouteHeaderService;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.workflow.KualiDocumentXmlMaterializer;

/*
 * Exception performing whole class analysis ignored.
 */
public class QuestionnaireXmlStream
implements XmlStream {
    private DateTimeService dateTimeService;
    private BusinessObjectService businessObjectService;
    private DocumentService documentService;
    private QuestionnaireService questionnaireService;
    private QuestionService questionService;
    private QuestionnaireAnswerService questionnaireAnswerService;
    private KcPersonService kcPersonService;
    private static final Log LOG = LogFactory.getLog(QuestionnaireXmlStream.class);
    List<QuestionnaireQuestion> sortedQuestionnaireQuestions;
    private static final int QUESTION_TYPE_INT = 3;

    public Map<String, XmlObject> generateXmlStream(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> reportParameters) {
        LinkedHashMap<String, XmlObject> xmlObjectList = new LinkedHashMap<String, XmlObject>();
        try {
            xmlObjectList.put("Questionnaire", (XmlObject)this.getQuestionnaireData(printableBusinessObject, reportParameters));
        }
        catch (PrintingException e) {
            LOG.error((Object)e);
        }
        return xmlObjectList;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    private QuestionnaireDocument getQuestionnaireData(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> params) throws PrintingException {
        Boolean questionnaireCompletionFlag;
        QuestionnaireDocument questionnaireDocument = QuestionnaireDocument.Factory.newInstance();
        QuestionnaireDocument.Questionnaire questionnaireType = questionnaireDocument.addNewQuestionnaire();
        String documentNumber = (String)params.get("documentNumber");
        Integer questionnaireId = (Integer)params.get("questionnaireId");
        Questionnaire questionnaire = (Questionnaire)params.get("questionnaire");
        if (questionnaire == null) {
            if (questionnaireId != null) {
                HashMap<String, Integer> qParam = new HashMap<String, Integer>();
                qParam.put("questionnaireId", questionnaireId);
                List questionnaires = (List)this.businessObjectService.findMatchingOrderBy(Questionnaire.class, qParam, "questionnaireRefId", false);
                questionnaire = (Questionnaire)questionnaires.get(0);
                questionnaire.refreshReferenceObject("questionnaireQuestions");
            } else {
                questionnaire = this.findQuestionnaireObject(documentNumber);
            }
        }
        questionnaireCompletionFlag = (questionnaireCompletionFlag = (Boolean)params.get("QUESTIONNAIRE_COMPLETION_FLAG")) == null ? Boolean.FALSE : questionnaireCompletionFlag;
        ModuleQuestionnaireBean moduleQuestionnaireBean = null;
        if (printableBusinessObject != null) {
            moduleQuestionnaireBean = this.getQuestionnaireAnswerHeaderBean(printableBusinessObject, params);
        }
        if (questionnaire != null) {
            Integer questId = questionnaire.getQuestionnaireIdAsInteger();
            if (questId != null) {
                questionnaireType.setQuestionnaireId(questId.intValue());
            }
            questionnaireType.setQuestionnaireName(questionnaire.getName());
            questionnaireType.setQuestionnaireDesc(questionnaire.getDescription());
            this.setQuestionInfoData(questionnaire, moduleQuestionnaireBean, questionnaireType, questionnaireCompletionFlag.booleanValue(), printableBusinessObject);
            this.setUserOption(params, questionnaireType);
            this.setAnswerInfo(printableBusinessObject, moduleQuestionnaireBean, questionnaireType);
            if (moduleQuestionnaireBean != null && moduleQuestionnaireBean.getModuleItemCode() != null) {
                this.setModuleUsage(moduleQuestionnaireBean, questionnaireType);
            } else {
                this.setModuleUsageList(questionnaire, questionnaireType);
            }
            if (moduleQuestionnaireBean != null && moduleQuestionnaireBean.getModuleItemCode() != null) {
                String moduleCode = moduleQuestionnaireBean.getModuleItemCode();
                String moduleSubcode = moduleQuestionnaireBean.getModuleSubItemCode();
                if (moduleCode.equals("3") && "0".equals(moduleSubcode)) {
                    this.setDevProposalInfo((DevelopmentProposal)printableBusinessObject, questionnaireType);
                } else if (moduleCode.equals("3") && "3".equals(moduleSubcode)) {
                    ProposalPerson person = (ProposalPerson)printableBusinessObject;
                    this.setDevProposalInfo(person, questionnaireType);
                } else if (moduleCode.equals("7")) {
                    this.setProtocolInfo((Protocol)printableBusinessObject, questionnaireType);
                }
            }
        }
        return questionnaireDocument;
    }

    private void setProtocolInfo(Protocol protocolInfoBean, QuestionnaireDocument.Questionnaire questionnaireType) {
        ProtocolInfoType protocolInfo = questionnaireType.addNewProtocolInfo();
        if (protocolInfoBean != null) {
            Person personInfo = protocolInfo.addNewInvestigator();
            if (protocolInfoBean.getPrincipalInvestigator() != null) {
                personInfo.setFullname(protocolInfoBean.getPrincipalInvestigator().getPersonName());
            }
            protocolInfo.setTitle(protocolInfoBean.getTitle());
            protocolInfo.setInvestigator(personInfo);
        }
    }

    private void setDevProposalInfo(DevelopmentProposal proposalBean, QuestionnaireDocument.Questionnaire questionnaireType) {
        if (proposalBean != null) {
            ProposalInfoType proposalInfo = questionnaireType.addNewProposalInfo();
            proposalInfo.setTitle(proposalBean.getTitle());
            proposalInfo.setProposalPersonUsed(0);
            String investigatorName = proposalBean.getPrincipalInvestigatorName();
            if (investigatorName != null) {
                Person personInfo = proposalInfo.addNewInvestigator();
                personInfo.setFullname(investigatorName);
            }
        }
    }

    private void setDevProposalInfo(ProposalPerson person, QuestionnaireDocument.Questionnaire questionnaireType) {
        DevelopmentProposal proposalBean = person.getDevelopmentProposal();
        if (proposalBean != null) {
            ProposalInfoType proposalInfo = questionnaireType.addNewProposalInfo();
            proposalInfo.setTitle(proposalBean.getTitle());
            String investigatorName = proposalBean.getPrincipalInvestigatorName();
            if (investigatorName != null) {
                Person personInfo = proposalInfo.addNewInvestigator();
                personInfo.setFullname(investigatorName);
            }
            String personName = person.getFullName();
            String personRole = person.getRole().getDescription();
            proposalInfo.setProposalPersonUsed(1);
            proposalInfo.setProposalPersonName(personName);
            proposalInfo.setProposalPersonRole(personRole);
        }
    }

    private void setAnswerInfo(KraPersistableBusinessObjectBase printableBusinessObject, ModuleQuestionnaireBean moduleQuestionnaireBean, QuestionnaireDocument.Questionnaire questionnaireType) {
        AnswerHeaderType answerHeader = questionnaireType.addNewAnswerHeader();
        if (printableBusinessObject instanceof ProposalPerson) {
            ProposalPerson person = (ProposalPerson)printableBusinessObject;
            answerHeader.setModuleKey(person.getDevelopmentProposal().getProposalNumber());
        } else if (moduleQuestionnaireBean != null) {
            answerHeader.setModuleKey(moduleQuestionnaireBean.getModuleItemKey());
        } else {
            answerHeader.setModuleKey(null);
        }
        if (moduleQuestionnaireBean != null) {
            answerHeader.setSubModuleKey(moduleQuestionnaireBean.getModuleSubItemKey());
        } else {
            answerHeader.setSubModuleKey("0");
        }
    }

    private void setModuleUsage(ModuleQuestionnaireBean moduleQuestionnaireBean, QuestionnaireDocument.Questionnaire questionnaireType) {
        ModuleUsageType moduleUsage = questionnaireType.addNewModuleUsage();
        ModuleInfoType moduleInfo = moduleUsage.addNewModuleInfo();
        String moduleCode = moduleQuestionnaireBean.getModuleItemCode();
        CoeusModule moduleData = this.getQuestionnaireCouesModule(moduleCode);
        String moduleSubItemKey = moduleQuestionnaireBean.getModuleSubItemKey();
        CoeusSubModule subModuleData = this.getQuestionnaireCoeusSubModule(moduleCode, moduleQuestionnaireBean.getModuleSubItemCode());
        if (moduleCode != null) {
            moduleInfo.setModuleCode(Integer.parseInt(moduleCode));
        }
        if (moduleSubItemKey != null) {
            moduleInfo.setSubModuleCode(Integer.parseInt(moduleSubItemKey));
        }
        if (moduleData != null) {
            moduleInfo.setModuleDesc(moduleData.getDescription());
        }
        if (subModuleData != null) {
            moduleInfo.setSubModuleDesc(subModuleData.getDescription());
        }
        moduleUsage.setModuleInfoArray(0, moduleInfo);
    }

    private void setModuleUsageList(Questionnaire questionnaire, QuestionnaireDocument.Questionnaire questionnaireType) {
        ModuleUsageType moduleUsage = questionnaireType.addNewModuleUsage();
        ArrayList<ModuleInfoType> moduleInfoTypeList = new ArrayList<ModuleInfoType>();
        List questionnaireUsageList = questionnaire.getQuestionnaireUsages();
        for (QuestionnaireUsage usage : questionnaireUsageList) {
            ModuleInfoType moduleInfoType = ModuleInfoType.Factory.newInstance();
            String moduleCode = usage.getModuleItemCode();
            CoeusModule moduleData = this.getQuestionnaireCouesModule(moduleCode);
            String moduleSubItemCode = usage.getModuleSubItemCode();
            CoeusSubModule subModuleData = this.getQuestionnaireCoeusSubModule(moduleCode, moduleSubItemCode);
            moduleInfoType.setModuleCode(Integer.parseInt(moduleCode));
            moduleInfoType.setSubModuleCode(Integer.parseInt(moduleSubItemCode));
            moduleInfoType.setModuleDesc(moduleData.getDescription());
            if (subModuleData != null) {
                moduleInfoType.setSubModuleDesc(subModuleData.getDescription());
            }
            moduleInfoTypeList.add(moduleInfoType);
        }
        moduleUsage.setModuleInfoArray(moduleInfoTypeList.toArray(new ModuleInfoType[0]));
    }

    private CoeusSubModule getQuestionnaireCoeusSubModule(String moduleItemCode, String moduleSubItemKey) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("moduleCode", moduleItemCode);
        param.put("subModuleCode", moduleSubItemKey);
        return (CoeusSubModule)this.businessObjectService.findByPrimaryKey(CoeusSubModule.class, param);
    }

    private CoeusModule getQuestionnaireCouesModule(String moduleCode) {
        return (CoeusModule)this.businessObjectService.findBySinglePrimaryKey(CoeusModule.class, (Object)moduleCode);
    }

    private void setUserOption(Map<String, Object> params, QuestionnaireDocument.Questionnaire questionnaireType) {
        UserOptions userOptions = questionnaireType.addNewUserOption();
        UserOptionsInfoType userOptionsInfo = userOptions.addNewUserOptionsInfo();
        Boolean printAnswersFlag = (Boolean)params.get("PRINT_ANSWERS_OPTION");
        Boolean printAnsweredOnlyFlag = (Boolean)params.get("PRINT_ONLY_ANSWERED_OPTION");
        Boolean printAllFlag = (Boolean)params.get("PRINT_ALL_OPTION");
        userOptionsInfo.setPrintAnsweredQuestionsOnly("No");
        userOptionsInfo.setPrintAnswers("Yes");
        if (printAnswersFlag != null && !printAnswersFlag.booleanValue()) {
            userOptionsInfo.setPrintAnswers("No");
        } else if (printAllFlag != null && printAllFlag.booleanValue()) {
            userOptionsInfo.setPrintAnsweredQuestionsOnly("No");
        } else if (printAnsweredOnlyFlag != null && printAnsweredOnlyFlag.booleanValue()) {
            userOptionsInfo.setPrintAnsweredQuestionsOnly("Yes");
        }
        userOptions.setUserOptionsInfo(userOptionsInfo);
    }

    private ModuleQuestionnaireBean getQuestionnaireAnswerHeaderBean(KraPersistableBusinessObjectBase printableBusinessObject, Map<String, Object> params) {
        String moduleItemCode = null;
        String moduleSubItemCode = "0";
        String moduleItemKey = null;
        String moduleSubItemKey = null;
        if (printableBusinessObject instanceof Protocol) {
            Protocol protocol = (Protocol)printableBusinessObject;
            moduleItemCode = "7";
            moduleSubItemCode = this.getProtocolSubItemCode(protocol);
            if (params.get("protocolNumber") != null && params.get("submissionNumber") != null) {
                moduleItemKey = (String)params.get("protocolNumber");
                moduleSubItemKey = (String)params.get("submissionNumber");
                moduleSubItemCode = "2";
            } else {
                moduleItemKey = protocol.getProtocolNumber();
                moduleSubItemKey = protocol.getSequenceNumber().toString();
                if (params.get("moduleSubItemCode") != null) {
                    moduleSubItemCode = (String)params.get("moduleSubItemCode");
                }
            }
        } else if (printableBusinessObject instanceof IacucProtocol) {
            IacucProtocol protocol = (IacucProtocol)printableBusinessObject;
            moduleItemCode = "9";
            moduleSubItemCode = this.getIacucProtocolSubItemCode(protocol);
            if (params.get("protocolNumber") != null && params.get("submissionNumber") != null) {
                moduleItemKey = (String)params.get("protocolNumber");
                moduleSubItemKey = (String)params.get("submissionNumber");
                moduleSubItemCode = "2";
            } else {
                moduleItemKey = protocol.getProtocolNumber();
                moduleSubItemKey = protocol.getSequenceNumber().toString();
                if (params.get("moduleSubItemCode") != null) {
                    moduleSubItemCode = (String)params.get("moduleSubItemCode");
                }
            }
        } else if (printableBusinessObject instanceof DevelopmentProposal) {
            DevelopmentProposal developmentProposal = (DevelopmentProposal)printableBusinessObject;
            moduleItemCode = "3";
            moduleItemKey = developmentProposal.getProposalNumber();
            moduleSubItemCode = (String)params.get("coeusModuleSubItemCode");
            moduleSubItemKey = "0";
        } else if (printableBusinessObject instanceof ProposalPerson) {
            ProposalPerson person = (ProposalPerson)printableBusinessObject;
            moduleItemCode = "3";
            moduleItemKey = person.getUniqueId();
            moduleSubItemCode = "3";
            moduleSubItemKey = "0";
        } else if (printableBusinessObject instanceof CoiDisclosure) {
            CoiDisclosure disclosure = (CoiDisclosure)printableBusinessObject;
            moduleItemCode = "8";
            moduleItemKey = disclosure.getCoiDisclosureNumber();
            moduleSubItemCode = (String)params.get("coeusModuleSubItemCode");
        }
        return this.getQuestionnaireAnswerService().getModuleSpecificBean(moduleItemCode, moduleItemKey, moduleSubItemCode, moduleSubItemKey, false);
    }

    private String getProtocolSubItemCode(Protocol protocol) {
        String subModuleCode = "0";
        if (protocol.isAmendment() || protocol.isRenewal()) {
            subModuleCode = "1";
        }
        return subModuleCode;
    }

    private String getIacucProtocolSubItemCode(IacucProtocol protocol) {
        String subModuleCode = "0";
        if (protocol.isAmendment() || protocol.isRenewal()) {
            subModuleCode = "1";
        }
        return subModuleCode;
    }

    private Questionnaire findQuestionnaireObject(String documentNumber) throws PrintingException {
        HashMap<String, String> qMap = new HashMap<String, String>();
        qMap.put("documentNumber", documentNumber);
        List questionnaires = (List)this.businessObjectService.findMatching(Questionnaire.class, qMap);
        if (questionnaires.isEmpty()) {
            return this.findUnapprovedQuestionnaire(documentNumber);
        }
        return (Questionnaire)questionnaires.get(0);
    }

    private Questionnaire findUnapprovedQuestionnaire(String documentNumber) throws PrintingException {
        Questionnaire questionnaire = null;
        try {
            MaintenanceDocumentBase questionnaireDocument = (MaintenanceDocumentBase)this.documentService.getByDocumentHeaderId(documentNumber);
            if (questionnaireDocument != null) {
                String content = ((RouteHeaderService)KraServiceLocator.getService(RouteHeaderService.class)).getContent(questionnaireDocument.getDocumentHeader().getWorkflowDocument().getDocumentId()).getDocumentContent();
                questionnaire = (Questionnaire)this.getBusinessObjectFromXML(content, KualiDocumentXmlMaterializer.class.getName());
            }
        }
        catch (WorkflowException e) {
            LOG.error((Object)"Problem in deserializing xmldata to Questionnaire", (Throwable)e);
            throw new PrintingException("Problem in deserializing xmldata to Questionnaire", (Throwable)e);
        }
        return questionnaire;
    }

    private PersistableBusinessObject getBusinessObjectFromXML(String xmlDocumentContents, String objectTagName) {
        String beginTag = "<document class=\"org.kuali.kra.maintenance.KraMaintenanceDocument\">";
        String endTag = "</document>";
        String objXml = StringUtils.substringBetween((String)xmlDocumentContents, (String)beginTag, (String)endTag);
        objXml = beginTag + objXml + endTag;
        KraMaintenanceDocument kraMaintenanceDocument = (KraMaintenanceDocument)KRADServiceLocator.getXmlObjectSerializerService().fromXml(objXml);
        PersistableBusinessObject businessObject = kraMaintenanceDocument.getDocumentBusinessObject();
        return businessObject;
    }

    private void allocateQuestionHierarchy(QuestionsType questionsType, QuestionInfoType parentQuestionInfo, boolean questionnaireCompletionFlag, KraPersistableBusinessObjectBase printableBusinessObject, List<AnswerHeader> answerHeaders) {
        boolean answeredFlag = true;
        try {
            for (QuestionnaireQuestion questionnaireQuestion : this.sortedQuestionnaireQuestions) {
                answeredFlag = true;
                if (questionnaireQuestion.getConditionValue() != null) {
                    for (AnswerHeader ansHeader : answerHeaders) {
                        if (!questionnaireQuestion.getQuestionnaireRefIdFk().equals(ansHeader.getQuestionnaireRefIdFk())) continue;
                        for (Answer answer : ansHeader.getAnswers()) {
                            if (!answer.getQuestionnaireQuestion().getQuestionnaireQuestionsId().equals(questionnaireQuestion.getQuestionnaireQuestionsId()) || !answer.getQuestionNumber().equals(questionnaireQuestion.getQuestionNumber()) || !answer.getQuestionRefIdFk().equals(questionnaireQuestion.getQuestionRefIdFk()) || answer.getParentAnswer() == null || ((Answer)answer.getParentAnswer().get(0)).getAnswer() == null) continue;
                            if (((Answer)answer.getParentAnswer().get(0)).getQuestion().getQuestionTypeId() == 3) {
                                if (!((Answer)answer.getParentAnswer().get(0)).getAnswer().equals(questionnaireQuestion.getConditionValue())) continue;
                                answeredFlag = false;
                                continue;
                            }
                            if (((Answer)answer.getParentAnswer().get(0)).getAnswer().equals(questionnaireQuestion.getConditionValue())) continue;
                            answeredFlag = false;
                        }
                    }
                }
                if (!answeredFlag) continue;
                Long questionId = questionnaireQuestion.getQuestionnaireQuestionsId();
                int questionNumber = questionnaireQuestion.getQuestionNumber();
                int parentQuestionNumber = questionnaireQuestion.getParentQuestionNumber();
                int tempParentQuestionNumber = questionsType != null ? 0 : parentQuestionInfo.getQuestionNumber();
                if (!questionnaireQuestion.isAllow() || parentQuestionNumber != tempParentQuestionNumber) continue;
                QuestionInfoType questionInfo = QuestionInfoType.Factory.newInstance();
                questionInfo.setQuestionNumber(questionNumber);
                questionInfo = tempParentQuestionNumber == 0 ? questionsType.addNewQuestionInfo() : parentQuestionInfo.addNewQuestionInfo();
                this.setAnswerInfoDetails(questionnaireQuestion, questionInfo, questionnaireCompletionFlag, printableBusinessObject, questionId, questionNumber, answerHeaders);
                questionnaireQuestion.setAllow(false);
            }
        }
        catch (PrintingException e) {
            LOG.error((Object)"Problem in deserializing xmldata to Questionnaire", (Throwable)e);
        }
        QuestionInfoType[] childQuestionsList = questionsType != null ? questionsType.getQuestionInfoArray() : parentQuestionInfo.getQuestionInfoArray();
        if (childQuestionsList != null && childQuestionsList.length > 0) {
            for (QuestionInfoType questionInfoType : childQuestionsList) {
                QuestionInfoType questionInfoListData = questionsType != null ? questionInfoType : questionInfoType;
                this.allocateQuestionHierarchy(null, questionInfoListData, questionnaireCompletionFlag, printableBusinessObject, answerHeaders);
            }
        }
    }

    private void setAnswerInfoDetails(QuestionnaireQuestion questionnaireQuestion, QuestionInfoType questionInfo, boolean questionnaireCompletionFlag, KraPersistableBusinessObjectBase printableBusinessObject, Long questionId, int questionNumber, List<AnswerHeader> answerHeaders) throws PrintingException {
        boolean isAnswerPresent = false;
        boolean answeredFlag = true;
        if (questionnaireQuestion.getConditionValue() != null) {
            for (AnswerHeader ansHeader : answerHeaders) {
                if (!questionnaireQuestion.getQuestionnaireRefIdFk().equals(ansHeader.getQuestionnaireRefIdFk())) continue;
                for (Answer answer : ansHeader.getAnswers()) {
                    if (!answer.getQuestionnaireQuestion().getQuestionnaireQuestionsId().equals(questionnaireQuestion.getQuestionnaireQuestionsId()) || !answer.getQuestionNumber().equals(questionnaireQuestion.getQuestionNumber()) || !answer.getQuestionRefIdFk().equals(questionnaireQuestion.getQuestionRefIdFk()) || answer.getParentAnswer() == null || ((Answer)answer.getParentAnswer().get(0)).getAnswer() == null) continue;
                    if (((Answer)answer.getParentAnswer().get(0)).getQuestion().getQuestionTypeId() == 3) {
                        if (!((Answer)answer.getParentAnswer().get(0)).getAnswer().equals(questionnaireQuestion.getConditionValue())) continue;
                        answeredFlag = false;
                        continue;
                    }
                    if (((Answer)answer.getParentAnswer().get(0)).getAnswer().equals(questionnaireQuestion.getConditionValue())) continue;
                    answeredFlag = false;
                }
            }
        }
        if (answeredFlag) {
            if (questionId != null) {
                questionInfo.setQuestionId(questionId.intValue());
            }
            questionInfo.setQuestionNumber(questionNumber);
            if (questionnaireQuestion.getQuestion() == null) {
                questionnaireQuestion.refreshReferenceObject("question");
            }
            if (questionnaireQuestion.getQuestion() != null) {
                questionInfo.setQuestion(questionnaireQuestion.getQuestion().getQuestion());
                if (!questionnaireQuestion.getParentQuestionNumber().equals(0)) {
                    questionInfo.setParentQuestionNumber(questionnaireQuestion.getParentQuestionNumber().intValue());
                }
            }
            if (answerHeaders != null && answerHeaders.size() > 0) {
                boolean isAnswerNamePresent = false;
                int selectedAnswer = 0;
                for (AnswerHeader answerHeader : answerHeaders) {
                    String answerName = "";
                    String answerPerson = "";
                    String answerDescription = null;
                    if (questionnaireQuestion.getQuestionnaireRefIdFk().equals(answerHeader.getQuestionnaireRefIdFk())) {
                        List answers = answerHeader.getAnswers();
                        for (Answer answer : answers) {
                            if (!answer.getQuestionnaireQuestion().getQuestionnaireQuestionsId().equals(questionnaireQuestion.getQuestionnaireQuestionsId()) || !answer.getQuestionNumber().equals(questionnaireQuestion.getQuestionNumber()) || !answer.getQuestionRefIdFk().equals(questionnaireQuestion.getQuestionRefIdFk())) continue;
                            boolean updateQuestionDescription = printableBusinessObject instanceof ProposalPerson;
                            if (answer.getAnswer() == null) continue;
                            isAnswerPresent = true;
                            if (isAnswerNamePresent) {
                                answerName = answerName + ", ";
                            }
                            if ((answerName = answerName + answer.getAnswer().trim()) != null) {
                                if (answerName.trim().equalsIgnoreCase("Y")) {
                                    answerDescription = "Yes";
                                    if (updateQuestionDescription) {
                                        questionInfo.setQuestion(questionnaireQuestion.getQuestion().getAffirmativeStatementConversion());
                                    }
                                } else if (answerName.trim().equalsIgnoreCase("N")) {
                                    answerDescription = "No";
                                    if (updateQuestionDescription) {
                                        questionInfo.setQuestion(questionnaireQuestion.getQuestion().getNegativeStatementConversion());
                                    }
                                } else {
                                    answerDescription = answerName.trim().equalsIgnoreCase("X") ? "None" : answerName;
                                }
                            }
                            selectedAnswer = answer.getAnswerNumber();
                            isAnswerNamePresent = true;
                        }
                    }
                    AnswerInfoType answerInfo = questionInfo.addNewAnswerInfo();
                    answerInfo.setAnswerNumber(selectedAnswer);
                    if (questionnaireQuestion.getQuestion().getQuestionTypeId().equals(6) && questionnaireQuestion.getQuestion().getLookupClass().equals("org.kuali.kra.bo.KcPerson") && questionnaireQuestion.getQuestion().getLookupReturn().equals("personId") && answerDescription != null && !answerDescription.equals("")) {
                        String[] personAnswers = answerDescription.split(",");
                        answerDescription = "";
                        for (int personAnswer = 0; personAnswer < personAnswers.length; ++personAnswer) {
                            KcPerson kcPerson = this.kcPersonService.getKcPersonByPersonId(personAnswers[personAnswer].trim());
                            if (kcPerson == null) continue;
                            answerDescription = answerDescription + kcPerson.getFullName() + ",";
                        }
                        answerDescription = answerDescription.substring(0, answerDescription.lastIndexOf(",") - 1);
                    }
                    answerInfo.setAnswer(answerDescription);
                }
            }
        }
    }

    private void setQuestionInfoData(Questionnaire questionnaire, ModuleQuestionnaireBean moduleQuestionnaireBean, QuestionnaireDocument.Questionnaire questionnaireType, boolean questionnaireCompletionFlag, KraPersistableBusinessObjectBase printableBusinessObject) throws PrintingException {
        List answerHeaders = new ArrayList();
        Questionnaire answeredQuestionnaire = null;
        if (moduleQuestionnaireBean != null && !(answerHeaders = this.questionnaireAnswerService.getQuestionnaireAnswer(moduleQuestionnaireBean)).isEmpty()) {
            answeredQuestionnaire = ((AnswerHeader)answerHeaders.get(0)).getQuestionnaire();
            answeredQuestionnaire.refreshReferenceObject("questionnaireQuestions");
        }
        Questionnaire toSortQuestionnaire = null;
        for (AnswerHeader header : answerHeaders) {
            if (!header.getQuestionnaire().getQuestionnaireId().equals(questionnaire.getQuestionnaireId())) continue;
            toSortQuestionnaire = header.getQuestionnaire();
        }
        if (toSortQuestionnaire == null) {
            toSortQuestionnaire = questionnaire;
        }
        this.sortedQuestionnaireQuestions = this.getSortedQuestionnaireQuestions(toSortQuestionnaire);
        if (this.sortedQuestionnaireQuestions != null && this.sortedQuestionnaireQuestions.size() > 0) {
            for (QuestionnaireQuestion questionnaireQuestion : this.sortedQuestionnaireQuestions) {
                questionnaireQuestion.setAllow(true);
            }
            int parentQuestionNumbercheck = 0;
            QuestionsType questionsType = questionnaireType.addNewQuestions();
            QuestionInfoType rootQuestionInfo = QuestionInfoType.Factory.newInstance();
            try {
                rootQuestionInfo.setQuestionNumber(parentQuestionNumbercheck);
                if (this.sortedQuestionnaireQuestions.size() >= 1) {
                    this.allocateQuestionHierarchy(questionsType, rootQuestionInfo, questionnaireCompletionFlag, printableBusinessObject, answerHeaders);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Problem in deserializing xmldata to Questionnaire", (Throwable)e);
            }
        }
    }

    private List<QuestionnaireQuestion> getSortedQuestionnaireQuestions(Questionnaire questionnaire) {
        return QuestionnaireXmlStream.getSortedVector((List)questionnaire.getQuestionnaireQuestions());
    }

    public static List<QuestionnaireQuestion> getSortedVector(List<QuestionnaireQuestion> questions) {
        return QuestionnaireXmlStream.sort(questions);
    }

    private static List<QuestionnaireQuestion> sort(List<QuestionnaireQuestion> questions) {
        List<QuestionnaireQuestion> tempQuestions = questions;
        ArrayList<QuestionnaireQuestion> elements = new ArrayList<QuestionnaireQuestion>();
        QuestionnaireQuestion questionaireQuestion = null;
        for (int i = 0; i < tempQuestions.size(); ++i) {
            questionaireQuestion = questions.get(i);
            if (elements.contains(questionaireQuestion)) continue;
            QuestionnaireXmlStream.findChildrenAndUpdate(elements, tempQuestions, (QuestionnaireQuestion)questionaireQuestion);
            --i;
        }
        return elements;
    }

    private static void findChildrenAndUpdate(List<QuestionnaireQuestion> elements, List<QuestionnaireQuestion> questions, QuestionnaireQuestion parent) {
        elements.add(parent);
        questions.remove(parent);
        List children = QuestionnaireXmlStream.findChildren(questions, (Integer)parent.getQuestionNumber());
        if (children != null && children.size() > 0) {
            for (int index = 0; index < children.size(); ++index) {
                QuestionnaireQuestion childBean = (QuestionnaireQuestion)children.get(index);
                QuestionnaireXmlStream.findChildrenAndUpdate(elements, questions, (QuestionnaireQuestion)childBean);
            }
        }
    }

    private static List<QuestionnaireQuestion> findChildren(List<QuestionnaireQuestion> questionnaireQuestions, Integer parent) {
        ArrayList<QuestionnaireQuestion> list = new ArrayList<QuestionnaireQuestion>();
        if (questionnaireQuestions != null && questionnaireQuestions.size() > 0) {
            for (int index = 0; index < questionnaireQuestions.size(); ++index) {
                QuestionnaireQuestion bean = questionnaireQuestions.get(index);
                if (bean.getParentQuestionNumber() == null || parent == null || bean.getParentQuestionNumber().intValue() != parent.intValue()) continue;
                list.add(bean);
            }
        }
        QuestionnaireQuestion firstChild = null;
        QuestionnaireQuestion secondChild = null;
        QuestionnaireQuestion temp = null;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 1; j <= list.size() - 1; ++j) {
                firstChild = (QuestionnaireQuestion)list.get(j - 1);
                secondChild = (QuestionnaireQuestion)list.get(j);
                if (secondChild.getQuestionSeqNumber() >= firstChild.getQuestionSeqNumber()) continue;
                temp = firstChild;
                list.set(j - 1, secondChild);
                list.set(j, temp);
            }
        }
        return list;
    }

    public QuestionnaireService getQuestionnaireService() {
        return this.questionnaireService;
    }

    public void setQuestionnaireService(QuestionnaireService questionnaireService) {
        this.questionnaireService = questionnaireService;
    }

    public QuestionService getQuestionService() {
        return this.questionService;
    }

    public void setQuestionService(QuestionService questionService) {
        this.questionService = questionService;
    }

    public QuestionnaireAnswerService getQuestionnaireAnswerService() {
        return this.questionnaireAnswerService;
    }

    public void setQuestionnaireAnswerService(QuestionnaireAnswerService questionnaireAnswerService) {
        this.questionnaireAnswerService = questionnaireAnswerService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public KcPersonService getKcPersonService() {
        return this.kcPersonService;
    }

    public void setKcPersonService(KcPersonService kcPersonService) {
        this.kcPersonService = kcPersonService;
    }
}

