/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.question;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.question.QuestionCategory;
import org.kuali.kra.questionnaire.question.QuestionExplanation;
import org.kuali.kra.questionnaire.question.QuestionType;
import org.kuali.rice.kns.datadictionary.BusinessObjectEntry;
import org.kuali.rice.kns.service.DataDictionaryService;
import org.kuali.rice.kns.service.KNSServiceLocator;

public class Question
extends KraPersistableBusinessObjectBase
implements Comparable<Question>,
SequenceOwner<Question> {
    private static final long serialVersionUID = 1L;
    private static final String SEQUENCE_STATUS_CURRENT = "C";
    private String documentNumber;
    private Long questionRefId;
    private String questionId;
    private Integer sequenceNumber;
    private String sequenceStatus;
    private String question;
    private String status;
    private Integer categoryTypeCode;
    private Integer questionTypeId;
    private String lookupClass;
    private String lookupReturn;
    private Integer displayedAnswers;
    private Integer maxAnswers;
    private Integer answerMaxLength;
    private QuestionCategory questionCategory;
    private QuestionType questionType;
    private List<QuestionExplanation> questionExplanations;

    public Question() {
        this.setSequenceNumber(Integer.valueOf(1));
        this.setSequenceStatus(SEQUENCE_STATUS_CURRENT);
        this.setQuestionExplanations(new ArrayList());
    }

    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public Long getQuestionRefId() {
        return this.questionRefId;
    }

    public void setQuestionRefId(Long questionRefId) {
        this.questionRefId = questionRefId;
    }

    public String getQuestionId() {
        return this.questionId;
    }

    public Integer getQuestionIdAsInteger() {
        Integer retVal = null;
        if (this.questionId != null) {
            retVal = Integer.valueOf(this.questionId);
        }
        return retVal;
    }

    public void setQuestionId(String questionId) {
        this.questionId = questionId;
    }

    public void setQuestionIdFromInteger(Integer questionIdAsInteger) {
        this.questionId = questionIdAsInteger != null ? questionIdAsInteger.toString() : null;
    }

    public Integer getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Integer sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getSequenceStatus() {
        return this.sequenceStatus;
    }

    public void setSequenceStatus(String sequenceStatus) {
        this.sequenceStatus = sequenceStatus;
    }

    public String getQuestion() {
        return this.question;
    }

    public void setQuestion(String question) {
        this.question = question;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Integer getCategoryTypeCode() {
        return this.categoryTypeCode;
    }

    public void setCategoryTypeCode(Integer categoryTypeCode) {
        this.categoryTypeCode = categoryTypeCode;
    }

    public Integer getQuestionTypeId() {
        return this.questionTypeId;
    }

    public void setQuestionTypeId(Integer questionTypeId) {
        this.questionTypeId = questionTypeId;
    }

    public String getLookupClass() {
        return this.lookupClass;
    }

    public void setLookupClass(String lookupClass) {
        this.lookupClass = lookupClass;
    }

    public String getLookupClassDescription() {
        if (this.lookupClass != null) {
            DataDictionaryService dataDictionaryService = KNSServiceLocator.getDataDictionaryService();
            BusinessObjectEntry businessObjectEntry = (BusinessObjectEntry)dataDictionaryService.getDataDictionary().getBusinessObjectEntries().get(this.lookupClass);
            return StringUtils.removeEnd((String)businessObjectEntry.getLookupDefinition().getTitle().trim(), (String)" Lookup");
        }
        return "";
    }

    public String getLookupReturn() {
        return this.lookupReturn;
    }

    public void setLookupReturn(String lookupReturn) {
        this.lookupReturn = lookupReturn;
    }

    public String getLookupReturnDescription() {
        if (this.lookupClass != null && this.lookupReturn != null) {
            DataDictionaryService dataDictionaryService = (DataDictionaryService)KraServiceLocator.getService(DataDictionaryService.class);
            return dataDictionaryService.getAttributeLabel(this.lookupClass, this.lookupReturn);
        }
        return "";
    }

    public Integer getDisplayedAnswers() {
        return this.displayedAnswers;
    }

    public void setDisplayedAnswers(Integer displayedAnswers) {
        this.displayedAnswers = displayedAnswers;
    }

    public Integer getMaxAnswers() {
        return this.maxAnswers;
    }

    public void setMaxAnswers(Integer maxAnswers) {
        this.maxAnswers = maxAnswers;
    }

    public Integer getAnswerMaxLength() {
        return this.answerMaxLength;
    }

    public void setAnswerMaxLength(Integer answerMaxLength) {
        this.answerMaxLength = answerMaxLength;
    }

    public QuestionCategory getQuestionCategory() {
        if (this.questionCategory == null) {
            this.refreshReferenceObject("questionCategory");
        }
        return this.questionCategory;
    }

    public void setQuestionCategory(QuestionCategory questionCategory) {
        this.questionCategory = questionCategory;
    }

    public QuestionType getQuestionType() {
        if (this.questionType == null) {
            this.refreshReferenceObject("questionType");
        }
        return this.questionType;
    }

    public void setQuestionType(QuestionType questionType) {
        this.questionType = questionType;
    }

    public List<QuestionExplanation> getQuestionExplanations() {
        return this.questionExplanations;
    }

    public void setQuestionExplanations(List<QuestionExplanation> questionExplanations) {
        this.questionExplanations = questionExplanations;
    }

    public String getExplanation() {
        return this.getExplanation("E");
    }

    public void setExplanation(String explanation) {
        this.setExplanation(explanation, "E");
    }

    public String getPolicy() {
        return this.getExplanation("P");
    }

    public void setPolicy(String policy) {
        this.setExplanation(policy, "P");
    }

    public String getRegulation() {
        return this.getExplanation("R");
    }

    public void setRegulation(String regulation) {
        this.setExplanation(regulation, "R");
    }

    public String getAffirmativeStatementConversion() {
        return this.getExplanation("A");
    }

    public void setAffirmativeStatementConversion(String affirmativeStatementConversion) {
        this.setExplanation(affirmativeStatementConversion, "A");
    }

    public String getNegativeStatementConversion() {
        return this.getExplanation("N");
    }

    public void setNegativeStatementConversion(String negativeStatementConversion) {
        this.setExplanation(negativeStatementConversion, "N");
    }

    private String getExplanation(String explanationType) {
        int index = this.getExplanationObjectIndex(explanationType);
        if (index < 0) {
            return "";
        }
        return ((QuestionExplanation)this.questionExplanations.get(index)).getExplanation();
    }

    private void setExplanation(String explanation, String explanationType) {
        int index = this.getExplanationObjectIndex(explanationType);
        if (index < 0) {
            QuestionExplanation questionExplanation = new QuestionExplanation();
            questionExplanation.setQuestionRefIdFk(this.questionRefId);
            questionExplanation.setExplanationType(explanationType);
            questionExplanation.setExplanation(explanation);
            this.questionExplanations.add(questionExplanation);
        } else {
            ((QuestionExplanation)this.questionExplanations.get(index)).setExplanation(explanation);
        }
    }

    private int getExplanationObjectIndex(String explanationType) {
        if (this.questionExplanations.isEmpty()) {
            this.refreshReferenceObject("questionExplanations");
        }
        for (QuestionExplanation questionExplanation : this.getQuestionExplanations()) {
            if (!questionExplanation.getExplanationType().equals(explanationType)) continue;
            return this.getQuestionExplanations().indexOf(questionExplanation);
        }
        return -1;
    }

    @Override
    public int compareTo(Question argQuestion) {
        if (ObjectUtils.equals((Object)this.getQuestionIdAsInteger(), (Object)argQuestion.getQuestionIdAsInteger())) {
            return this.getSequenceNumber().compareTo(argQuestion.getSequenceNumber());
        }
        return this.getQuestionIdAsInteger().compareTo(argQuestion.getQuestionIdAsInteger());
    }

    public Integer getOwnerSequenceNumber() {
        return null;
    }

    public String getVersionNameField() {
        return "questionId";
    }

    public void incrementSequenceNumber() {
        Integer n = this.sequenceNumber;
        Integer n2 = this.sequenceNumber = Integer.valueOf(this.sequenceNumber + 1);
    }

    public Question getSequenceOwner() {
        return this;
    }

    public void setSequenceOwner(Question newlyVersionedOwner) {
    }

    public void resetPersistenceState() {
        this.questionRefId = null;
    }
}

