/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.question;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kuali.kra.lookup.keyvalue.LookupReturnValuesFinder;
import org.kuali.kra.questionnaire.question.QuestionAuthorizationService;
import org.kuali.rice.kns.lookup.KualiLookupableImpl;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.lookup.LookupUtils;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuestionLookupableImpl
extends KualiLookupableImpl {
    private static final long serialVersionUID = -5431630475561370731L;
    private static final String MAINTENANCE = "maintenance";
    private static final String NEW_MAINTENANCE = "../maintenanceQ";
    private static final String LOOKUP_RETURN = "lookupReturn";
    private static final String LOOKUP_CLASS = "lookupClass";
    private transient QuestionAuthorizationService questionAuthorizationService;

    public String getCreateNewUrl() {
        String url = "";
        if (this.questionAuthorizationService.hasPermission("Modify Question")) {
            url = super.getCreateNewUrl();
            url = url.replace(MAINTENANCE, NEW_MAINTENANCE);
        }
        return url;
    }

    public boolean checkForAdditionalFields(Map fieldValues) {
        String lookupReturnFieldName = (String)fieldValues.get(LOOKUP_RETURN);
        String lookupClassName = (String)fieldValues.get(LOOKUP_CLASS);
        if (StringUtils.isNotBlank((String)lookupClassName)) {
            for (Row row : this.getRows()) {
                for (Field field : row.getFields()) {
                    if (!field.getPropertyName().equals(LOOKUP_RETURN)) continue;
                    GlobalVariables.getUserSession().addObject("lookupClassName", (Object)lookupClassName);
                    LookupReturnValuesFinder finder = new LookupReturnValuesFinder();
                    field.setFieldValidValues(finder.getKeyValues());
                    GlobalVariables.getUserSession().removeObject("lookupReturnFields");
                    GlobalVariables.getUserSession().removeObject("lookupClassName");
                    if (!StringUtils.isNotBlank((String)lookupReturnFieldName)) continue;
                    field.setPropertyValue(lookupReturnFieldName);
                    field.setPropertyValue(LookupUtils.forceUppercase((Class)this.getBusinessObjectClass(), (String)lookupReturnFieldName, (String)field.getPropertyValue()));
                    fieldValues.put(lookupReturnFieldName, field.getPropertyValue());
                }
            }
        }
        return super.checkForAdditionalFields(fieldValues);
    }

    public void setQuestionAuthorizationService(QuestionAuthorizationService questionAuthorizationService) {
        this.questionAuthorizationService = questionAuthorizationService;
    }
}

