/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.question;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kra.SequenceOwner;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.maintenance.QuestionMaintainableImpl;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.questionnaire.question.QuestionAuthorizationService;
import org.kuali.kra.questionnaire.question.QuestionExplanation;
import org.kuali.kra.questionnaire.question.QuestionMaintenanceForm;
import org.kuali.kra.questionnaire.question.QuestionService;
import org.kuali.kra.service.VersionException;
import org.kuali.kra.service.impl.VersioningServiceImpl;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kns.document.MaintenanceDocumentBase;
import org.kuali.rice.kns.web.struts.action.KualiMaintenanceDocumentAction;
import org.kuali.rice.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.rice.kns.web.struts.form.KualiMaintenanceForm;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.KRADServiceLocator;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class QuestionMaintenanceDocumentAction
extends KualiMaintenanceDocumentAction {
    private static final String QUESTION_REF_ID = "questionRefId";
    private static final String EDIT_QUESTION_OF_ACTIVE_QUESTIONNAIRE_QUESTION = "EditQuestionOfActiveQuestionnaire";

    public ActionForward loadQuestionResponse(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        KualiMaintenanceForm maintenanceForm = (KualiMaintenanceForm)form;
        MaintenanceDocumentBase maintenanceDocument = (MaintenanceDocumentBase)maintenanceForm.getDocument();
        Question question = (Question)maintenanceDocument.getNewMaintainableObject().getDataObject();
        question.refreshReferenceObject("questionType");
        return mapping.findForward("basic");
    }

    public ActionForward refreshPulldownOptions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("basic");
    }

    private void specialHandlingOfQuestion(QuestionMaintenanceForm questionMaintenanceForm, HttpServletRequest request) throws VersionException {
        boolean readOnly;
        MaintenanceDocumentBase maintenanceDocumentBase = (MaintenanceDocumentBase)questionMaintenanceForm.getDocument();
        boolean bl = readOnly = !((QuestionAuthorizationService)KraServiceLocator.getService(QuestionAuthorizationService.class)).hasPermission("Modify Question") || ObjectUtils.equals((Object)request.getParameter("readOnly"), (Object)"true");
        if (StringUtils.equals((String)questionMaintenanceForm.getMethodToCall(), (String)"edit")) {
            if (readOnly) {
                questionMaintenanceForm.setReadOnly(true);
            } else {
                this.createNewQuestionVersion(maintenanceDocumentBase, request.getParameter(QUESTION_REF_ID));
            }
        } else if (StringUtils.equals((String)questionMaintenanceForm.getMethodToCall(), (String)"copy")) {
            this.initCopiedQuestion(maintenanceDocumentBase);
        }
    }

    private void createNewQuestionVersion(MaintenanceDocumentBase maintenanceDocumentBase, String oldQuestionRefId) throws VersionException {
        Question approvedQuestion = this.getQuestionService().getQuestionByRefId(oldQuestionRefId);
        VersioningServiceImpl versioningService = new VersioningServiceImpl();
        Question versionedQuestion = (Question)versioningService.createNewVersion((SequenceOwner)approvedQuestion);
        Long newQuestionRefId = ((SequenceAccessorService)KraServiceLocator.getService(SequenceAccessorService.class)).getNextAvailableSequenceNumber("SEQ_QUESTION_ID");
        QuestionMaintainableImpl oldMaintainableObject = (QuestionMaintainableImpl)maintenanceDocumentBase.getOldMaintainableObject();
        Question oldQuestion = (Question)oldMaintainableObject.getBusinessObject();
        oldQuestion.setQuestionRefId(newQuestionRefId);
        QuestionMaintainableImpl newMaintainableObject = (QuestionMaintainableImpl)maintenanceDocumentBase.getNewMaintainableObject();
        versionedQuestion.setQuestionRefId(newQuestionRefId);
        versionedQuestion.setVersionNumber(oldQuestion.getVersionNumber());
        newMaintainableObject.setBusinessObject((PersistableBusinessObject)versionedQuestion);
    }

    private QuestionService getQuestionService() {
        return (QuestionService)KraServiceLocator.getService(QuestionService.class);
    }

    private void initCopiedQuestion(MaintenanceDocumentBase maintenanceDocumentBase) {
        QuestionMaintainableImpl oldMaintainableObject = (QuestionMaintainableImpl)maintenanceDocumentBase.getOldMaintainableObject();
        Question oldQuestion = (Question)oldMaintainableObject.getBusinessObject();
        oldQuestion.setQuestionId(null);
        oldQuestion.setSequenceNumber(null);
        QuestionMaintainableImpl newMaintainableObject = (QuestionMaintainableImpl)maintenanceDocumentBase.getNewMaintainableObject();
        Question newQuestion = (Question)newMaintainableObject.getBusinessObject();
        newQuestion.setQuestionId(null);
        newQuestion.setSequenceNumber(null);
    }

    public ActionForward edit(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward;
        QuestionService questionService = (QuestionService)KraServiceLocator.getService(QuestionService.class);
        QuestionMaintenanceForm questionMaintenanceForm = (QuestionMaintenanceForm)form;
        String question = request.getParameter("questionIndex");
        String questionRefId = request.getParameter(QUESTION_REF_ID);
        if (!questionMaintenanceForm.isReadOnly() && (question != null || questionService.isQuestionUsed(questionService.getQuestionByRefId(questionRefId).getQuestionId()))) {
            if (question == null) {
                super.edit(mapping, form, request, response);
                this.specialHandlingOfQuestion(questionMaintenanceForm, request);
                ConfigurationService kualiConfiguration = KRADServiceLocator.getKualiConfigurationService();
                forward = this.performQuestionWithoutInput(mapping, form, request, response, EDIT_QUESTION_OF_ACTIVE_QUESTIONNAIRE_QUESTION, kualiConfiguration.getPropertyValueAsString("document.question.editQuestionOfActiveQuestionnaire.text"), "confirmationQuestion", "close", "");
            } else {
                String buttonClicked = request.getParameter("buttonClicked");
                forward = EDIT_QUESTION_OF_ACTIVE_QUESTIONNAIRE_QUESTION.equals(question) && "1".equals(buttonClicked) ? this.returnToSender(request, mapping, (KualiDocumentFormBase)questionMaintenanceForm) : mapping.findForward("basic");
            }
        } else {
            forward = super.edit(mapping, form, request, response);
            questionMaintenanceForm.getDocument().getDocumentHeader().setDocumentDescription("question - bootstrap data");
            this.specialHandlingOfQuestion(questionMaintenanceForm, request);
        }
        return forward;
    }

    protected void populateAuthorizationFields(KualiDocumentFormBase formBase) {
        QuestionMaintenanceForm questionMaintenanceForm = (QuestionMaintenanceForm)formBase;
        boolean isReadOnly = questionMaintenanceForm.isReadOnly();
        super.populateAuthorizationFields(formBase);
        if (isReadOnly && StringUtils.equals((String)questionMaintenanceForm.getMethodToCall(), (String)"edit")) {
            questionMaintenanceForm.setReadOnly(isReadOnly);
        }
        if (questionMaintenanceForm.isReadOnly() && formBase.getDocumentActions().containsKey("canClose")) {
            HashMap<String, String> documentActions = new HashMap<String, String>();
            documentActions.put("canClose", "TRUE");
            questionMaintenanceForm.setDocumentActions(documentActions);
        }
    }

    public ActionForward copy(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ActionForward forward = super.copy(mapping, form, request, response);
        MaintenanceDocumentBase maintenanceDocumentBase = (MaintenanceDocumentBase)((QuestionMaintenanceForm)form).getDocument();
        QuestionMaintainableImpl newMaintainableObject = (QuestionMaintainableImpl)maintenanceDocumentBase.getNewMaintainableObject();
        Question newQuestion = (Question)newMaintainableObject.getBusinessObject();
        newQuestion.setQuestionId(null);
        newQuestion.setSequenceNumber(Integer.valueOf(1));
        for (QuestionExplanation questionExplanation : newQuestion.getQuestionExplanations()) {
            questionExplanation.setQuestionExplanationId(null);
            questionExplanation.setQuestionRefIdFk(null);
        }
        return forward;
    }
}

