/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.questionnaire.question;

import java.util.HashSet;
import java.util.Set;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.questionnaire.QuestionnaireAuthorizationService;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kns.document.authorization.MaintenanceDocumentAuthorizerBase;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.exception.AuthorizationException;
import org.kuali.rice.krad.util.GlobalVariables;

public class QuestionMaintenanceDocumentAuthorizer
extends MaintenanceDocumentAuthorizerBase {
    public Set<String> getDocumentActions(Document document, Person user, Set<String> documentActions) {
        return this.getDocumentActions(document);
    }

    protected Set<String> getDocumentActions(Document document) {
        HashSet<String> documentActions = new HashSet<String>();
        if (this.getQuestionnaireAuthorizationService().hasPermission("Modify Question") && (document.getDocumentHeader().getWorkflowDocument().getStatus().getCode().equals("I") || document.getDocumentHeader().getWorkflowDocument().getStatus().getCode().equals("S"))) {
            documentActions.add("canEdit");
            documentActions.add("canEditDocumentOverview");
            documentActions.add("canRoute");
            documentActions.add("canSave");
            if (document.getDocumentHeader().getWorkflowDocument().getStatus().getCode().equals("S")) {
                documentActions.add("canReload");
            }
            documentActions.add("canBlanketApprove");
            documentActions.add("canClose");
            documentActions.add("canCancel");
        } else if (this.getQuestionnaireAuthorizationService().hasPermission("Modify Question") && document.getDocumentHeader().getWorkflowDocument().getStatus().getCode().equals("F")) {
            documentActions.add("canReload");
            documentActions.add("canClose");
        } else if (this.getQuestionnaireAuthorizationService().hasPermission("View Question") || this.getQuestionnaireAuthorizationService().hasPermission("Modify Question")) {
            documentActions.add("canClose");
        } else {
            throw new AuthorizationException(GlobalVariables.getUserSession().getPerson().getPrincipalId(), "Edit/View", "Question");
        }
        return documentActions;
    }

    private QuestionnaireAuthorizationService getQuestionnaireAuthorizationService() {
        return (QuestionnaireAuthorizationService)KraServiceLocator.getService(QuestionnaireAuthorizationService.class);
    }
}

